<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bsTheme
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="container-fluid">
		<div class="container-xl">
			<div class="row">
				<div class="col-12">
					<header class="entry-header">
						<?php if ('post' === get_post_type()) :
						?>
							<div class="entry-meta">
								<?php
								bstheme_posted_on();
								?>
							</div><!-- .entry-meta -->
						<?php endif; ?>
						<?php
						if (is_singular()) :
							the_title('<h1 class="entry-title h-3xl">', '</h1>');
						else :
							the_title('<h2 class="entry-title h-3xl"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>');
						endif;
						?>

					</header><!-- .entry-header -->


					<div class="entry-content">
						<?php
						the_content(
							sprintf(
								wp_kses(
									/* translators: %s: Name of current post. Only visible to screen readers */
									__('Continue reading<span class="screen-reader-text"> "%s"</span>', 'bstheme'),
									array(
										'span' => array(
											'class' => array(),
										),
									)
								),
								wp_kses_post(get_the_title())
							)
						);

						wp_link_pages(
							array(
								'before' => '<div class="page-links">' . esc_html__('Pages:', 'bstheme'),
								'after'  => '</div>',
							)
						);
						?>
					</div><!-- .entry-content -->
				</div>
			</div>
		</div>
	</div>
</article><!-- #post-<?php the_ID(); ?> -->