<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package bsTheme
 */

$post_id = get_the_ID();
$taxonomy = 'services';

// ACF variables
$title = get_field('title');
$description = get_field('description');
$name = get_field('name');
$year = get_field('year');
$branch = get_field('branch');
$website = get_field('website');

$titleOutput = get_the_title();
if (!empty($title)) {
    $titleOutput = $title;
}

$terms = get_the_terms($post_id, $taxonomy);

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('subpage__header'); ?>>
    <header class="entry-header">
        <div class="container-fluid">
            <div class="container-xl">
                <div class="row mb-0 mb-sm-5">
                    <div class="col-12">
                        <?php echo do_shortcode('[go_back_btn url="/arbeiten"]'); ?>
                    </div>
                    <div class="col-12 col-lg-6">
                        <h1 class="h-2xl"><?php echo $titleOutput; ?></h1>
                        <div class="d-flex align-items-center flex-wrap reference__pills_wrapper">
                            <?php
                            if ($terms && !is_wp_error($terms)) {
                                foreach ($terms as $term) {
                                    // Check if the term is a child term
                                    if ($term->parent != 0) {
                                        // Output the child term's name
                                        echo do_shortcode('[ctaBs style="btnOutline"  cta_classes="pillSmall mb-2" title="' . $term->name . '"]');
                                    }
                                }
                            }
                            ?>
                        </div>
                    </div>
                    <div class="col-12 col-lg-6 pt-3 pt-lg-0">
                        <p><?php echo esc_html($description); ?></p>
                    </div>
                </div>
            </div>
        </div>
    </header><!-- .entry-header -->


    <div class="entry-content">
        <?php

        the_content(
            sprintf(
                wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                    __('Continue reading<span class="screen-reader-text"> "%s"</span>', 'bstheme'),
                    array(
                        'span' => array(
                            'class' => array(),
                        ),
                    )
                ),
                wp_kses_post(get_the_title())
            )
        );

        ?>
    </div><!-- .entry-content -->

    <footer class="entry-footer">
        <!-- Meta Data -->
        <div class="container-fluid">
            <div class="container-xl py-xl-5">
                <div class="row py-5 flex-column-reverse flex-xl-row">
                    <div class="col-12 col-xl-6">
                        <?php echo do_shortcode('[brot_salz_social_media]'); ?>
                    </div>
                    <div class="col-12 col-xl-6 d-flex flex-wrap mb-5 mb-xl-0">
                        <?php if (!empty($name)) {  ?>
                            <div class="reference__meta">
                                <div class="bsAccentline__after">Klient</div>
                                <p class="mt-2"><?php echo $name; ?></p>
                            </div>
                        <?php }  ?>
                        <?php if (!empty($year)) {  ?>
                            <div class="reference__meta">
                                <div class="bsAccentline__after">Jahr</div>
                                <p class="mt-2"><?php echo $year; ?></p>
                            </div>
                        <?php }  ?>
                        <?php if (!empty($branch)) {  ?>
                            <div class="reference__meta">
                                <div class="bsAccentline__after">Bereich</div>
                                <p class="mt-2 mb-xl-0"><?php echo $branch; ?></p>
                            </div>
                        <?php }  ?>
                        <?php if (!empty($website)) {  ?>
                            <div class="reference__meta">
                                <div class="bsAccentline__after">Website</div>
                                <p class="mt-2 mb-xl-0">
                                    <a href="<?php echo $website['url']; ?>" target="_blank" rel="noopener noreferrer"><?php echo $website['title']; ?></a>
                                </p>
                            </div>
                        <?php }  ?>


                    </div>
                </div>
            </div>
        </div>
        <!-- Post Navigation -->
        <?php

        $bottom_navigation_posts = '';

        $args = array(
            'post_type' => 'referenzen',
            'posts_per_page' => -1,
            'post_status' => 'publish',
            'post__not_in' => array($post_id), // Exclude the currently viewed post

        );

        $query = new WP_Query($args);
        if ($query->have_posts()) {
            while ($query->have_posts()) {
                $query->the_post();
                $post_id = get_the_ID();

                $post_link = get_post_permalink($post_id);

                $post_title = get_the_title($post_id);
                $post_title_alternative = get_field('title', $post_id);
                if (!empty($post_title_alternative)) {
                    $post_title = $post_title_alternative;
                }

                $post_description = get_field('description', $post_id);
                $post_description = esc_html($post_description);
                $post_description_mobile =  esc_html(mb_substr($post_description, 0, 70) . '...');

                $post_terms = get_the_terms($post_id, $taxonomy);
                $post_terms_output = '';

                if ($post_terms && !is_wp_error($post_terms)) {
                    foreach ($post_terms as $post_term) {
                        // Check if the term is a child term
                        if ($post_term->parent != 0) {
                            // Output the child term's name
                            $post_terms_output .= do_shortcode('[ctaBs style="btnOutline"  cta_classes="pillSmall mb-2" title="' . $post_term->name . '"]');
                        }
                    }
                }

                $bottom_navigation_posts .= '<div class="swiper-slide reference__bottom_navigation_slide">
                                                <div class="reference__bottom_navigation_inner_slider_wrapper d-flex flex-wrap">
                                                    <div class="reference__bottom_navigation_cta py-5">
                                                        <div class="basicbtn__wrapper">
                                                            ' . do_shortcode('[ctaBs style="btnOutline Wrap ArrowRight arrowPill "  type="link" url="' . $post_link . '"  title="Gehe zum Projekt"]') . '
                                                        </div>
                                                    </div>
                                                    <div class="reference__bottom_navigation_left reference__bottom_navigation_sides">
                                                        <h2 class="h-2xl">' .  $post_title . '</h2>
                                                        <div class="d-flex align-items-center flex-wrap">
                                                            ' . $post_terms_output . '
                                                        </div>
                                                    </div>
                                                    <div class="reference__bottom_navigation_right reference__bottom_navigation_sides pt-3 pt-lg-0">
                                                        <div class="d-none d-sm-block">' . $post_description . '</div>
                                                        <div class="d-sm-none">' . $post_description_mobile . '</div>
                                                    </div>
                                                </div>
                                            </div>';
            }
        }

        ?>
        <div class="container-fluid">
            <div class="container-xl">
                <div class="row">
                    <div class="col-12">
                        <hr class="reference__navigation_seperator">
                    </div>
                </div>
                <div class="row pb-5">
                    <div class="col-12">
                        <div id="reference__bottom_navigation_slider" class="swiper reference__bottom_navigation_slider">
                            <div class="swiper-wrapper">
                                <?php echo $bottom_navigation_posts; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <hr class="reference__navigation_seperator lower">
        <div class="container-fluid">
            <div class="container-xl">
                <div class="row">
                    <div class="col-12 d-flex align-items-center justify-content-between py-3">
                        <div class="reference__bottom_navigation w-100 d-flex align-items-center justify-content-between">
                            <div class='reference__bottom_navigation_prev reference__bottom_navigation_button'>
                                <svg xmlns="http://www.w3.org/2000/svg" width="38.492" height="38.492" viewBox="0 0 38.492 38.492">
                                    <path id="Pfad_37758" data-name="Pfad 37758" d="M0,0V4.775H19.067L.222,23.62,3.6,27,22.443,8.152V27.218h4.775V0Z" transform="translate(19.246 38.492) rotate(-135)" fill="var(--cDef)" />
                                </svg>
                            </div>
                            <div class='reference__bottom_navigation_next reference__bottom_navigation_button'>
                                <svg xmlns="http://www.w3.org/2000/svg" width="38.492" height="38.492" viewBox="0 0 38.492 38.492">
                                    <path id="Pfad_139" data-name="Pfad 139" d="M0,0V4.775H19.067L.222,23.62,3.6,27,22.443,8.152V27.218h4.775V0Z" transform="translate(19.246 0) rotate(45)" fill="var(--cDef)" />
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </footer><!-- .entry-footer -->
</article><!-- #post-<?php the_ID(); ?> -->

<script>
    jQuery(function($) {
        $(document).ready(function() {

            const reference__bottom_navigation_slider = new Swiper('#reference__bottom_navigation_slider', {
                slidesPerView: 1,
                spaceBetween: 10,
                loop: true,
                speed: 2000,
                autoHeight: true,
                navigation: {
                    nextEl: '.reference__bottom_navigation_next',
                    prevEl: '.reference__bottom_navigation_prev',
                },
                // autoplay: {
                //     delay: 10000,
                // },
            });

            // Back to button ---------------------------------------------
            $('#back_button').click(function() {
                // Check if the referrer is not empty and is from the same website
                if (document.referrer.indexOf(window.location.host) !== -1) {
                    history.back();
                } else {
                    // Navigate to /arbeiten if no referrer or referrer is from a different website
                    window.location.href = '/arbeiten';
                }
            });

        });
    });
</script>