<?php

/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package bsTheme
 */

$isActive = get_field('is_active', 'options');

?>
<?php if ($isActive) {
?>
	<div class='sideBarQuickAccess'>
		<?php
		$items = get_field('sidebaritems', 'options');
		foreach ($items as $item) {
			if ($item['is_active']) {
				$label = $item['label'];
				$icon = $item['icon'];
				$link = $item['link'];
				$classnames = $item['classnames'];

		?>
				<div class='sidebarItem d-none d-md-block'>
					<a aria-label="<?php echo $label;  ?>" href="<?php echo $link; ?>">
						<div class="sidebarLabel">
							<?php echo $label;  ?>
						</div>
						<div class="sidebarIcon bgGold fCenter">
							<?php echo $icon;  ?>
						</div>
					</a>
				</div>
		<?php

			}
		} ?>
		<?php if (have_rows('sbitems', 'option')) : ?>
			<?php while (have_rows('sbitems', 'option')) : the_row();
				$icon = get_sub_field('icon');
				$label = get_sub_field('label');
				$link = get_sub_field('link');
				$link_target = $link['target'] ? $link['target'] : '_self';
			?>
				<div class='sidebarItem d-none d-md-block'>
					<a aria-label="<?php echo $label;  ?>" href="<?php echo $link['url']; ?>" target="<?php echo $link_target; ?>">
						<div class="sidebarLabel">
							<?php echo $label;  ?>
						</div>
						<div class="sidebarIcon bgGold fCenter">
							<?php echo $icon;  ?>
						</div>
					</a>
				</div>
			<?php endwhile; ?>
		<?php endif; ?>

	<?php
}
	?>
	</div>

	<style>
		.sideBarQuickAccess {
			position: fixed;
			top: 50%;
			right: 0;
			z-index: 8;
			transform: translateY(-50%);
		}

		.sidebarItem a {
			color: #FFF;
			display: flex;
			align-items: center;
			justify-content: flex-end;
		}

		.sidebarIcon {
			width: 4rem;
			height: 5rem;
			background-color: var(--bgSidebar);
		}

		.sidebarIcon svg {
			max-width: 2rem;
			max-height: 3rem;
			width: auto;
			height: 100%;
		}

		.sidebarLabel {
			padding-left: 1rem;
			text-transform: uppercase;
			padding-right: 2rem;
			opacity: 0;
			z-index: -2;
			visibility: hidden;
			width: 0;

		}

		.sideBarQuickAccess:hover .sidebarLabel {
			opacity: 1;
			z-index: 2;
			visibility: visible;
			width: auto;
		}

		.sideBarQuickAccess:hover a {
			background-color: var(--c1);
		}

		@media (max-width: 1640px) {
			.sidebarIcon {
				width: 3rem;
				height: 4rem;
			}

			.sidebarIcon svg {
				max-width: 1.5rem;
				max-height: 2rem;
				width: auto;
				height: 100%;
			}
		}

		@media (max-width: 576px) {
			.sidebarIcon {
				width: 1.5rem;
			}

			.sidebarIcon svg {
				max-width: 1rem;
			}
		}
	</style>