(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define([], factory);
	else if(typeof exports === 'object')
		exports["dashjs"] = factory();
	else
		root["dashjs"] = factory();
})(self, function() {
return /******/ (function() { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./externals/base64.js":
/*!*****************************!*\
  !*** ./externals/base64.js ***!
  \*****************************/
/***/ (function(__unused_webpack_module, exports) {

/* $Date: 2007-06-12 18:02:31 $ */
// from: http://bannister.us/weblog/2007/06/09/simple-base64-encodedecode-javascript/
// Handles encode/decode of ASCII and Unicode strings.
var UTF8 = {};

UTF8.encode = function (s) {
  var u = [];

  for (var i = 0; i < s.length; ++i) {
    var c = s.charCodeAt(i);

    if (c < 0x80) {
      u.push(c);
    } else if (c < 0x800) {
      u.push(0xC0 | c >> 6);
      u.push(0x80 | 63 & c);
    } else if (c < 0x10000) {
      u.push(0xE0 | c >> 12);
      u.push(0x80 | 63 & c >> 6);
      u.push(0x80 | 63 & c);
    } else {
      u.push(0xF0 | c >> 18);
      u.push(0x80 | 63 & c >> 12);
      u.push(0x80 | 63 & c >> 6);
      u.push(0x80 | 63 & c);
    }
  }

  return u;
};

UTF8.decode = function (u) {
  var a = [];
  var i = 0;

  while (i < u.length) {
    var v = u[i++];

    if (v < 0x80) {// no need to mask byte
    } else if (v < 0xE0) {
      v = (31 & v) << 6;
      v |= 63 & u[i++];
    } else if (v < 0xF0) {
      v = (15 & v) << 12;
      v |= (63 & u[i++]) << 6;
      v |= 63 & u[i++];
    } else {
      v = (7 & v) << 18;
      v |= (63 & u[i++]) << 12;
      v |= (63 & u[i++]) << 6;
      v |= 63 & u[i++];
    }

    a.push(String.fromCharCode(v));
  }

  return a.join('');
};

var BASE64 = {};

(function (T) {
  var encodeArray = function encodeArray(u) {
    var i = 0;
    var a = [];
    var n = 0 | u.length / 3;

    while (0 < n--) {
      var v = (u[i] << 16) + (u[i + 1] << 8) + u[i + 2];
      i += 3;
      a.push(T.charAt(63 & v >> 18));
      a.push(T.charAt(63 & v >> 12));
      a.push(T.charAt(63 & v >> 6));
      a.push(T.charAt(63 & v));
    }

    if (2 == u.length - i) {
      var v = (u[i] << 16) + (u[i + 1] << 8);
      a.push(T.charAt(63 & v >> 18));
      a.push(T.charAt(63 & v >> 12));
      a.push(T.charAt(63 & v >> 6));
      a.push('=');
    } else if (1 == u.length - i) {
      var v = u[i] << 16;
      a.push(T.charAt(63 & v >> 18));
      a.push(T.charAt(63 & v >> 12));
      a.push('==');
    }

    return a.join('');
  };

  var R = function () {
    var a = [];

    for (var i = 0; i < T.length; ++i) {
      a[T.charCodeAt(i)] = i;
    }

    a['='.charCodeAt(0)] = 0;
    return a;
  }();

  var decodeArray = function decodeArray(s) {
    var i = 0;
    var u = [];
    var n = 0 | s.length / 4;

    while (0 < n--) {
      var v = (R[s.charCodeAt(i)] << 18) + (R[s.charCodeAt(i + 1)] << 12) + (R[s.charCodeAt(i + 2)] << 6) + R[s.charCodeAt(i + 3)];
      u.push(255 & v >> 16);
      u.push(255 & v >> 8);
      u.push(255 & v);
      i += 4;
    }

    if (u) {
      if ('=' == s.charAt(i - 2)) {
        u.pop();
        u.pop();
      } else if ('=' == s.charAt(i - 1)) {
        u.pop();
      }
    }

    return u;
  };

  var ASCII = {};

  ASCII.encode = function (s) {
    var u = [];

    for (var i = 0; i < s.length; ++i) {
      u.push(s.charCodeAt(i));
    }

    return u;
  };

  ASCII.decode = function (u) {
    for (var i = 0; i < s.length; ++i) {
      a[i] = String.fromCharCode(a[i]);
    }

    return a.join('');
  };

  BASE64.decodeArray = function (s) {
    var u = decodeArray(s);
    return new Uint8Array(u);
  };

  BASE64.encodeASCII = function (s) {
    var u = ASCII.encode(s);
    return encodeArray(u);
  };

  BASE64.decodeASCII = function (s) {
    var a = decodeArray(s);
    return ASCII.decode(a);
  };

  BASE64.encode = function (s) {
    var u = UTF8.encode(s);
    return encodeArray(u);
  };

  BASE64.decode = function (s) {
    var u = decodeArray(s);
    return UTF8.decode(u);
  };
})("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/");
/*The following polyfills are not used in dash.js but have caused multiplayer integration issues.
 Therefore commenting them out.
if (undefined === btoa) {
    var btoa = BASE64.encode;
}
if (undefined === atob) {
    var atob = BASE64.decode;
}
*/


if (true) {
  exports.decode = BASE64.decode;
  exports.decodeArray = BASE64.decodeArray;
  exports.encode = BASE64.encode;
  exports.encodeASCII = BASE64.encodeASCII;
}

/***/ }),

/***/ "./externals/cea608-parser.js":
/*!************************************!*\
  !*** ./externals/cea608-parser.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, exports) {

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2015-2016, DASH Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  1. Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  2. Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
(function (exports) {
  "use strict";
  /**
   *  Exceptions from regular ASCII. CodePoints are mapped to UTF-16 codes
   */

  var specialCea608CharsCodes = {
    0x2a: 0xe1,
    // lowercase a, acute accent
    0x5c: 0xe9,
    // lowercase e, acute accent
    0x5e: 0xed,
    // lowercase i, acute accent
    0x5f: 0xf3,
    // lowercase o, acute accent
    0x60: 0xfa,
    // lowercase u, acute accent
    0x7b: 0xe7,
    // lowercase c with cedilla
    0x7c: 0xf7,
    // division symbol
    0x7d: 0xd1,
    // uppercase N tilde
    0x7e: 0xf1,
    // lowercase n tilde
    0x7f: 0x2588,
    // Full block
    // THIS BLOCK INCLUDES THE 16 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
    // THAT COME FROM HI BYTE=0x11 AND LOW BETWEEN 0x30 AND 0x3F
    // THIS MEANS THAT \x50 MUST BE ADDED TO THE VALUES
    0x80: 0xae,
    // Registered symbol (R)
    0x81: 0xb0,
    // degree sign
    0x82: 0xbd,
    // 1/2 symbol
    0x83: 0xbf,
    // Inverted (open) question mark
    0x84: 0x2122,
    // Trademark symbol (TM)
    0x85: 0xa2,
    // Cents symbol
    0x86: 0xa3,
    // Pounds sterling
    0x87: 0x266a,
    // Music 8'th note
    0x88: 0xe0,
    // lowercase a, grave accent
    0x89: 0x20,
    // transparent space (regular)
    0x8a: 0xe8,
    // lowercase e, grave accent
    0x8b: 0xe2,
    // lowercase a, circumflex accent
    0x8c: 0xea,
    // lowercase e, circumflex accent
    0x8d: 0xee,
    // lowercase i, circumflex accent
    0x8e: 0xf4,
    // lowercase o, circumflex accent
    0x8f: 0xfb,
    // lowercase u, circumflex accent
    // THIS BLOCK INCLUDES THE 32 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
    // THAT COME FROM HI BYTE=0x12 AND LOW BETWEEN 0x20 AND 0x3F
    0x90: 0xc1,
    // capital letter A with acute
    0x91: 0xc9,
    // capital letter E with acute
    0x92: 0xd3,
    // capital letter O with acute
    0x93: 0xda,
    // capital letter U with acute
    0x94: 0xdc,
    // capital letter U with diaresis
    0x95: 0xfc,
    // lowercase letter U with diaeresis
    0x96: 0x2018,
    // opening single quote
    0x97: 0xa1,
    // inverted exclamation mark
    0x98: 0x2a,
    // asterisk
    0x99: 0x2019,
    // closing single quote
    0x9a: 0x2501,
    // box drawings heavy horizontal
    0x9b: 0xa9,
    // copyright sign
    0x9c: 0x2120,
    // Service mark
    0x9d: 0x2022,
    // (round) bullet
    0x9e: 0x201c,
    // Left double quotation mark
    0x9f: 0x201d,
    // Right double quotation mark
    0xa0: 0xc0,
    // uppercase A, grave accent
    0xa1: 0xc2,
    // uppercase A, circumflex
    0xa2: 0xc7,
    // uppercase C with cedilla
    0xa3: 0xc8,
    // uppercase E, grave accent
    0xa4: 0xca,
    // uppercase E, circumflex
    0xa5: 0xcb,
    // capital letter E with diaresis
    0xa6: 0xeb,
    // lowercase letter e with diaresis
    0xa7: 0xce,
    // uppercase I, circumflex
    0xa8: 0xcf,
    // uppercase I, with diaresis
    0xa9: 0xef,
    // lowercase i, with diaresis
    0xaa: 0xd4,
    // uppercase O, circumflex
    0xab: 0xd9,
    // uppercase U, grave accent
    0xac: 0xf9,
    // lowercase u, grave accent
    0xad: 0xdb,
    // uppercase U, circumflex
    0xae: 0xab,
    // left-pointing double angle quotation mark
    0xaf: 0xbb,
    // right-pointing double angle quotation mark
    // THIS BLOCK INCLUDES THE 32 EXTENDED (TWO-BYTE) LINE 21 CHARACTERS
    // THAT COME FROM HI BYTE=0x13 AND LOW BETWEEN 0x20 AND 0x3F
    0xb0: 0xc3,
    // Uppercase A, tilde
    0xb1: 0xe3,
    // Lowercase a, tilde
    0xb2: 0xcd,
    // Uppercase I, acute accent
    0xb3: 0xcc,
    // Uppercase I, grave accent
    0xb4: 0xec,
    // Lowercase i, grave accent
    0xb5: 0xd2,
    // Uppercase O, grave accent
    0xb6: 0xf2,
    // Lowercase o, grave accent
    0xb7: 0xd5,
    // Uppercase O, tilde
    0xb8: 0xf5,
    // Lowercase o, tilde
    0xb9: 0x7b,
    // Open curly brace
    0xba: 0x7d,
    // Closing curly brace
    0xbb: 0x5c,
    // Backslash
    0xbc: 0x5e,
    // Caret
    0xbd: 0x5f,
    // Underscore
    0xbe: 0x7c,
    // Pipe (vertical line)
    0xbf: 0x223c,
    // Tilde operator
    0xc0: 0xc4,
    // Uppercase A, umlaut
    0xc1: 0xe4,
    // Lowercase A, umlaut
    0xc2: 0xd6,
    // Uppercase O, umlaut
    0xc3: 0xf6,
    // Lowercase o, umlaut
    0xc4: 0xdf,
    // Esszett (sharp S)
    0xc5: 0xa5,
    // Yen symbol
    0xc6: 0xa4,
    // Generic currency sign
    0xc7: 0x2503,
    // Box drawings heavy vertical
    0xc8: 0xc5,
    // Uppercase A, ring
    0xc9: 0xe5,
    // Lowercase A, ring
    0xca: 0xd8,
    // Uppercase O, stroke
    0xcb: 0xf8,
    // Lowercase o, strok
    0xcc: 0x250f,
    // Box drawings heavy down and right
    0xcd: 0x2513,
    // Box drawings heavy down and left
    0xce: 0x2517,
    // Box drawings heavy up and right
    0xcf: 0x251b // Box drawings heavy up and left

  };
  /**
   * Get Unicode Character from CEA-608 byte code
   */

  var getCharForByte = function getCharForByte(_byte) {
    var charCode = _byte;

    if (specialCea608CharsCodes.hasOwnProperty(_byte)) {
      charCode = specialCea608CharsCodes[_byte];
    }

    return String.fromCharCode(charCode);
  };

  var NR_ROWS = 15,
      NR_COLS = 32; // Tables to look up row from PAC data

  var rowsLowCh1 = {
    0x11: 1,
    0x12: 3,
    0x15: 5,
    0x16: 7,
    0x17: 9,
    0x10: 11,
    0x13: 12,
    0x14: 14
  };
  var rowsHighCh1 = {
    0x11: 2,
    0x12: 4,
    0x15: 6,
    0x16: 8,
    0x17: 10,
    0x13: 13,
    0x14: 15
  };
  var rowsLowCh2 = {
    0x19: 1,
    0x1A: 3,
    0x1D: 5,
    0x1E: 7,
    0x1F: 9,
    0x18: 11,
    0x1B: 12,
    0x1C: 14
  };
  var rowsHighCh2 = {
    0x19: 2,
    0x1A: 4,
    0x1D: 6,
    0x1E: 8,
    0x1F: 10,
    0x1B: 13,
    0x1C: 15
  };
  var backgroundColors = ['white', 'green', 'blue', 'cyan', 'red', 'yellow', 'magenta', 'black', 'transparent'];
  /**
   * Simple logger class to be able to write with time-stamps and filter on level.
   */

  var logger = {
    verboseFilter: {
      'DATA': 3,
      'DEBUG': 3,
      'INFO': 2,
      'WARNING': 2,
      'TEXT': 1,
      'ERROR': 0
    },
    time: null,
    verboseLevel: 0,
    // Only write errors
    setTime: function setTime(newTime) {
      this.time = newTime;
    },
    log: function log(severity, msg) {
      var minLevel = this.verboseFilter[severity];

      if (this.verboseLevel >= minLevel) {
        console.log(this.time + " [" + severity + "] " + msg);
      }
    }
  };

  var numArrayToHexArray = function numArrayToHexArray(numArray) {
    var hexArray = [];

    for (var j = 0; j < numArray.length; j++) {
      hexArray.push(numArray[j].toString(16));
    }

    return hexArray;
  };
  /**
   * State of CEA-608 pen or character
   * @constructor
   */


  var PenState = function PenState(foreground, underline, italics, background, flash) {
    this.foreground = foreground || "white";
    this.underline = underline || false;
    this.italics = italics || false;
    this.background = background || "black";
    this.flash = flash || false;
  };

  PenState.prototype = {
    reset: function reset() {
      this.foreground = "white";
      this.underline = false;
      this.italics = false;
      this.background = "black";
      this.flash = false;
    },
    setStyles: function setStyles(styles) {
      var attribs = ["foreground", "underline", "italics", "background", "flash"];

      for (var i = 0; i < attribs.length; i++) {
        var style = attribs[i];

        if (styles.hasOwnProperty(style)) {
          this[style] = styles[style];
        }
      }
    },
    isDefault: function isDefault() {
      return this.foreground === "white" && !this.underline && !this.italics && this.background === "black" && !this.flash;
    },
    equals: function equals(other) {
      return this.foreground === other.foreground && this.underline === other.underline && this.italics === other.italics && this.background === other.background && this.flash === other.flash;
    },
    copy: function copy(newPenState) {
      this.foreground = newPenState.foreground;
      this.underline = newPenState.underline;
      this.italics = newPenState.italics;
      this.background = newPenState.background;
      this.flash = newPenState.flash;
    },
    toString: function toString() {
      return "color=" + this.foreground + ", underline=" + this.underline + ", italics=" + this.italics + ", background=" + this.background + ", flash=" + this.flash;
    }
  };
  /**
   * Unicode character with styling and background.
   * @constructor
   */

  var StyledUnicodeChar = function StyledUnicodeChar(uchar, foreground, underline, italics, background, flash) {
    this.uchar = uchar || ' '; // unicode character

    this.penState = new PenState(foreground, underline, italics, background, flash);
  };

  StyledUnicodeChar.prototype = {
    reset: function reset() {
      this.uchar = ' ';
      this.penState.reset();
    },
    setChar: function setChar(uchar, newPenState) {
      this.uchar = uchar;
      this.penState.copy(newPenState);
    },
    setPenState: function setPenState(newPenState) {
      this.penState.copy(newPenState);
    },
    equals: function equals(other) {
      return this.uchar === other.uchar && this.penState.equals(other.penState);
    },
    copy: function copy(newChar) {
      this.uchar = newChar.uchar;
      this.penState.copy(newChar.penState);
    },
    isEmpty: function isEmpty() {
      return this.uchar === ' ' && this.penState.isDefault();
    }
  };
  /**
   * CEA-608 row consisting of NR_COLS instances of StyledUnicodeChar.
   * @constructor
   */

  var Row = function Row() {
    this.chars = [];

    for (var i = 0; i < NR_COLS; i++) {
      this.chars.push(new StyledUnicodeChar());
    }

    this.pos = 0;
    this.currPenState = new PenState();
  };

  Row.prototype = {
    equals: function equals(other) {
      var equal = true;

      for (var i = 0; i < NR_COLS; i++) {
        if (!this.chars[i].equals(other.chars[i])) {
          equal = false;
          break;
        }
      }

      return equal;
    },
    copy: function copy(other) {
      for (var i = 0; i < NR_COLS; i++) {
        this.chars[i].copy(other.chars[i]);
      }
    },
    isEmpty: function isEmpty() {
      var empty = true;

      for (var i = 0; i < NR_COLS; i++) {
        if (!this.chars[i].isEmpty()) {
          empty = false;
          break;
        }
      }

      return empty;
    },

    /**
     *  Set the cursor to a valid column.
     */
    setCursor: function setCursor(absPos) {
      if (this.pos !== absPos) {
        this.pos = absPos;
      }

      if (this.pos < 0) {
        logger.log("ERROR", "Negative cursor position " + this.pos);
        this.pos = 0;
      } else if (this.pos > NR_COLS) {
        logger.log("ERROR", "Too large cursor position " + this.pos);
        this.pos = NR_COLS;
      }
    },

    /** 
     * Move the cursor relative to current position.
     */
    moveCursor: function moveCursor(relPos) {
      var newPos = this.pos + relPos;

      if (relPos > 1) {
        for (var i = this.pos + 1; i < newPos + 1; i++) {
          this.chars[i].setPenState(this.currPenState);
        }
      }

      this.setCursor(newPos);
    },

    /**
     * Backspace, move one step back and clear character.
     */
    backSpace: function backSpace() {
      this.moveCursor(-1);
      this.chars[this.pos].setChar(' ', this.currPenState);
    },
    insertChar: function insertChar(_byte2) {
      if (_byte2 >= 0x90) {
        //Extended char
        this.backSpace();
      }

      var _char = getCharForByte(_byte2);

      if (this.pos >= NR_COLS) {
        logger.log("ERROR", "Cannot insert " + _byte2.toString(16) + " (" + _char + ") at position " + this.pos + ". Skipping it!");
        return;
      }

      this.chars[this.pos].setChar(_char, this.currPenState);
      this.moveCursor(1);
    },
    clearFromPos: function clearFromPos(startPos) {
      var i;

      for (i = startPos; i < NR_COLS; i++) {
        this.chars[i].reset();
      }
    },
    clear: function clear() {
      this.clearFromPos(0);
      this.pos = 0;
      this.currPenState.reset();
    },
    clearToEndOfRow: function clearToEndOfRow() {
      this.clearFromPos(this.pos);
    },
    getTextString: function getTextString() {
      var chars = [];
      var empty = true;

      for (var i = 0; i < NR_COLS; i++) {
        var _char2 = this.chars[i].uchar;

        if (_char2 !== " ") {
          empty = false;
        }

        chars.push(_char2);
      }

      if (empty) {
        return "";
      } else {
        return chars.join("");
      }
    },
    setPenStyles: function setPenStyles(styles) {
      this.currPenState.setStyles(styles);
      var currChar = this.chars[this.pos];
      currChar.setPenState(this.currPenState);
    }
  };
  /**
   * Keep a CEA-608 screen of 32x15 styled characters
   * @constructor
  */

  var CaptionScreen = function CaptionScreen() {
    this.rows = [];

    for (var i = 0; i < NR_ROWS; i++) {
      this.rows.push(new Row()); // Note that we use zero-based numbering (0-14)
    }

    this.currRow = NR_ROWS - 1;
    this.nrRollUpRows = null;
    this.reset();
  };

  CaptionScreen.prototype = {
    reset: function reset() {
      for (var i = 0; i < NR_ROWS; i++) {
        this.rows[i].clear();
      }

      this.currRow = NR_ROWS - 1;
    },
    equals: function equals(other) {
      var equal = true;

      for (var i = 0; i < NR_ROWS; i++) {
        if (!this.rows[i].equals(other.rows[i])) {
          equal = false;
          break;
        }
      }

      return equal;
    },
    copy: function copy(other) {
      for (var i = 0; i < NR_ROWS; i++) {
        this.rows[i].copy(other.rows[i]);
      }
    },
    isEmpty: function isEmpty() {
      var empty = true;

      for (var i = 0; i < NR_ROWS; i++) {
        if (!this.rows[i].isEmpty()) {
          empty = false;
          break;
        }
      }

      return empty;
    },
    backSpace: function backSpace() {
      var row = this.rows[this.currRow];
      row.backSpace();
    },
    clearToEndOfRow: function clearToEndOfRow() {
      var row = this.rows[this.currRow];
      row.clearToEndOfRow();
    },

    /**
     * Insert a character (without styling) in the current row.
     */
    insertChar: function insertChar(_char3) {
      var row = this.rows[this.currRow];
      row.insertChar(_char3);
    },
    setPen: function setPen(styles) {
      var row = this.rows[this.currRow];
      row.setPenStyles(styles);
    },
    moveCursor: function moveCursor(relPos) {
      var row = this.rows[this.currRow];
      row.moveCursor(relPos);
    },
    setCursor: function setCursor(absPos) {
      logger.log("INFO", "setCursor: " + absPos);
      var row = this.rows[this.currRow];
      row.setCursor(absPos);
    },
    setPAC: function setPAC(pacData) {
      logger.log("INFO", "pacData = " + JSON.stringify(pacData));
      var newRow = pacData.row - 1;

      if (this.nrRollUpRows && newRow < this.nrRollUpRows - 1) {
        newRow = this.nrRollUpRows - 1;
      }

      this.currRow = newRow;
      var row = this.rows[this.currRow];

      if (pacData.indent !== null) {
        var indent = pacData.indent;
        var prevPos = Math.max(indent - 1, 0);
        row.setCursor(pacData.indent);
        pacData.color = row.chars[prevPos].penState.foreground;
      }

      var styles = {
        foreground: pacData.color,
        underline: pacData.underline,
        italics: pacData.italics,
        background: 'black',
        flash: false
      };
      this.setPen(styles);
    },

    /**
     * Set background/extra foreground, but first do back_space, and then insert space (backwards compatibility).
     */
    setBkgData: function setBkgData(bkgData) {
      logger.log("INFO", "bkgData = " + JSON.stringify(bkgData));
      this.backSpace();
      this.setPen(bkgData);
      this.insertChar(0x20); //Space
    },
    setRollUpRows: function setRollUpRows(nrRows) {
      this.nrRollUpRows = nrRows;
    },
    rollUp: function rollUp() {
      if (this.nrRollUpRows === null) {
        logger.log("DEBUG", "roll_up but nrRollUpRows not set yet");
        return; //Not properly setup
      }

      logger.log("TEXT", this.getDisplayText());
      var topRowIndex = this.currRow + 1 - this.nrRollUpRows;
      var topRow = this.rows.splice(topRowIndex, 1)[0];
      topRow.clear();
      this.rows.splice(this.currRow, 0, topRow);
      logger.log("INFO", "Rolling up"); //logger.log("TEXT", this.get_display_text())
    },

    /**
     * Get all non-empty rows with as unicode text. 
     */
    getDisplayText: function getDisplayText(asOneRow) {
      asOneRow = asOneRow || false;
      var displayText = [];
      var text = "";
      var rowNr = -1;

      for (var i = 0; i < NR_ROWS; i++) {
        var rowText = this.rows[i].getTextString();

        if (rowText) {
          rowNr = i + 1;

          if (asOneRow) {
            displayText.push("Row " + rowNr + ': "' + rowText + '"');
          } else {
            displayText.push(rowText.trim());
          }
        }
      }

      if (displayText.length > 0) {
        if (asOneRow) {
          text = "[" + displayText.join(" | ") + "]";
        } else {
          text = displayText.join("\n");
        }
      }

      return text;
    },
    getTextAndFormat: function getTextAndFormat() {
      return this.rows;
    }
  };
  /**
   * Handle a CEA-608 channel and send decoded data to outputFilter
   * @constructor
   * @param {Number} channelNumber (1 or 2)
   * @param {CueHandler} outputFilter Output from channel1 newCue(startTime, endTime, captionScreen)
  */

  var Cea608Channel = function Cea608Channel(channelNumber, outputFilter) {
    this.chNr = channelNumber;
    this.outputFilter = outputFilter;
    this.mode = null;
    this.verbose = 0;
    this.displayedMemory = new CaptionScreen();
    this.nonDisplayedMemory = new CaptionScreen();
    this.lastOutputScreen = new CaptionScreen();
    this.currRollUpRow = this.displayedMemory.rows[NR_ROWS - 1];
    this.writeScreen = this.displayedMemory;
    this.mode = null;
    this.cueStartTime = null; // Keeps track of where a cue started.
  };

  Cea608Channel.prototype = {
    modes: ["MODE_ROLL-UP", "MODE_POP-ON", "MODE_PAINT-ON", "MODE_TEXT"],
    reset: function reset() {
      this.mode = null;
      this.displayedMemory.reset();
      this.nonDisplayedMemory.reset();
      this.lastOutputScreen.reset();
      this.currRollUpRow = this.displayedMemory.rows[NR_ROWS - 1];
      this.writeScreen = this.displayedMemory;
      this.mode = null;
      this.cueStartTime = null;
      this.lastCueEndTime = null;
    },
    getHandler: function getHandler() {
      return this.outputFilter;
    },
    setHandler: function setHandler(newHandler) {
      this.outputFilter = newHandler;
    },
    setPAC: function setPAC(pacData) {
      this.writeScreen.setPAC(pacData);
    },
    setBkgData: function setBkgData(bkgData) {
      this.writeScreen.setBkgData(bkgData);
    },
    setMode: function setMode(newMode) {
      if (newMode === this.mode) {
        return;
      }

      this.mode = newMode;
      logger.log("INFO", "MODE=" + newMode);

      if (this.mode == "MODE_POP-ON") {
        this.writeScreen = this.nonDisplayedMemory;
      } else {
        this.writeScreen = this.displayedMemory;
        this.writeScreen.reset();
      }

      if (this.mode !== "MODE_ROLL-UP") {
        this.displayedMemory.nrRollUpRows = null;
        this.nonDisplayedMemory.nrRollUpRows = null;
      }

      this.mode = newMode;
    },
    insertChars: function insertChars(chars) {
      for (var i = 0; i < chars.length; i++) {
        this.writeScreen.insertChar(chars[i]);
      }

      var screen = this.writeScreen === this.displayedMemory ? "DISP" : "NON_DISP";
      logger.log("INFO", screen + ": " + this.writeScreen.getDisplayText(true));

      if (this.mode === "MODE_PAINT-ON" || this.mode === "MODE_ROLL-UP") {
        logger.log("TEXT", "DISPLAYED: " + this.displayedMemory.getDisplayText(true));
        this.outputDataUpdate();
      }
    },
    cc_RCL: function cc_RCL() {
      // Resume Caption Loading (switch mode to Pop On)
      logger.log("INFO", "RCL - Resume Caption Loading");
      this.setMode("MODE_POP-ON");
    },
    cc_BS: function cc_BS() {
      // BackSpace
      logger.log("INFO", "BS - BackSpace");

      if (this.mode === "MODE_TEXT") {
        return;
      }

      this.writeScreen.backSpace();

      if (this.writeScreen === this.displayedMemory) {
        this.outputDataUpdate();
      }
    },
    cc_AOF: function cc_AOF() {
      // Reserved (formerly Alarm Off)
      return;
    },
    cc_AON: function cc_AON() {
      // Reserved (formerly Alarm On)
      return;
    },
    cc_DER: function cc_DER() {
      // Delete to End of Row
      logger.log("INFO", "DER- Delete to End of Row");
      this.writeScreen.clearToEndOfRow();
      this.outputDataUpdate();
    },
    cc_RU: function cc_RU(nrRows) {
      //Roll-Up Captions-2,3,or 4 Rows
      logger.log("INFO", "RU(" + nrRows + ") - Roll Up");
      this.writeScreen = this.displayedMemory;
      this.setMode("MODE_ROLL-UP");
      this.writeScreen.setRollUpRows(nrRows);
    },
    cc_FON: function cc_FON() {
      //Flash On
      logger.log("INFO", "FON - Flash On");
      this.writeScreen.setPen({
        flash: true
      });
    },
    cc_RDC: function cc_RDC() {
      // Resume Direct Captioning (switch mode to PaintOn)
      logger.log("INFO", "RDC - Resume Direct Captioning");
      this.setMode("MODE_PAINT-ON");
    },
    cc_TR: function cc_TR() {
      // Text Restart in text mode (not supported, however)
      logger.log("INFO", "TR");
      this.setMode("MODE_TEXT");
    },
    cc_RTD: function cc_RTD() {
      // Resume Text Display in Text mode (not supported, however)
      logger.log("INFO", "RTD");
      this.setMode("MODE_TEXT");
    },
    cc_EDM: function cc_EDM() {
      // Erase Displayed Memory
      logger.log("INFO", "EDM - Erase Displayed Memory");
      this.displayedMemory.reset();
      this.outputDataUpdate();
    },
    cc_CR: function cc_CR() {
      // Carriage Return
      logger.log("CR - Carriage Return");
      this.writeScreen.rollUp();
      this.outputDataUpdate();
    },
    cc_ENM: function cc_ENM() {
      //Erase Non-Displayed Memory
      logger.log("INFO", "ENM - Erase Non-displayed Memory");
      this.nonDisplayedMemory.reset();
    },
    cc_EOC: function cc_EOC() {
      //End of Caption (Flip Memories)
      logger.log("INFO", "EOC - End Of Caption");

      if (this.mode === "MODE_POP-ON") {
        var tmp = this.displayedMemory;
        this.displayedMemory = this.nonDisplayedMemory;
        this.nonDisplayedMemory = tmp;
        this.writeScreen = this.nonDisplayedMemory;
        logger.log("TEXT", "DISP: " + this.displayedMemory.getDisplayText());
      }

      this.outputDataUpdate();
    },
    cc_TO: function cc_TO(nrCols) {
      // Tab Offset 1,2, or 3 columns
      logger.log("INFO", "TO(" + nrCols + ") - Tab Offset");
      this.writeScreen.moveCursor(nrCols);
    },
    cc_MIDROW: function cc_MIDROW(secondByte) {
      // Parse MIDROW command
      var styles = {
        flash: false
      };
      styles.underline = secondByte % 2 === 1;
      styles.italics = secondByte >= 0x2e;

      if (!styles.italics) {
        var colorIndex = Math.floor(secondByte / 2) - 0x10;
        var colors = ["white", "green", "blue", "cyan", "red", "yellow", "magenta"];
        styles.foreground = colors[colorIndex];
      } else {
        styles.foreground = "white";
      }

      logger.log("INFO", "MIDROW: " + JSON.stringify(styles));
      this.writeScreen.setPen(styles);
    },
    outputDataUpdate: function outputDataUpdate() {
      var t = logger.time;

      if (t === null) {
        return;
      }

      if (this.outputFilter) {
        if (this.outputFilter.updateData) {
          this.outputFilter.updateData(t, this.displayedMemory);
        }

        if (this.cueStartTime === null && !this.displayedMemory.isEmpty()) {
          // Start of a new cue
          this.cueStartTime = t;
        } else {
          if (!this.displayedMemory.equals(this.lastOutputScreen)) {
            if (this.outputFilter.newCue) {
              this.outputFilter.newCue(this.cueStartTime, t, this.lastOutputScreen);
            }

            this.cueStartTime = this.displayedMemory.isEmpty() ? null : t;
          }
        }

        this.lastOutputScreen.copy(this.displayedMemory);
      }
    },
    cueSplitAtTime: function cueSplitAtTime(t) {
      if (this.outputFilter) {
        if (!this.displayedMemory.isEmpty()) {
          if (this.outputFilter.newCue) {
            this.outputFilter.newCue(this.cueStartTime, t, this.displayedMemory);
          }

          this.cueStartTime = t;
        }
      }
    }
  };
  /**
   * Parse CEA-608 data and send decoded data to out1 and out2.
   * @constructor
   * @param {Number} field  CEA-608 field (1 or 2)
   * @param {CueHandler} out1 Output from channel1 newCue(startTime, endTime, captionScreen)
   * @param {CueHandler} out2 Output from channel2 newCue(startTime, endTime, captionScreen)
   */

  var Cea608Parser = function Cea608Parser(field, out1, out2) {
    this.field = field || 1;
    this.outputs = [out1, out2];
    this.channels = [new Cea608Channel(1, out1), new Cea608Channel(2, out2)];
    this.currChNr = -1; // Will be 1 or 2

    this.lastCmdA = null; // First byte of last command

    this.lastCmdB = null; // Second byte of last command

    this.bufferedData = [];
    this.startTime = null;
    this.lastTime = null;
    this.dataCounters = {
      'padding': 0,
      'char': 0,
      'cmd': 0,
      'other': 0
    };
  };

  Cea608Parser.prototype = {
    getHandler: function getHandler(index) {
      return this.channels[index].getHandler();
    },
    setHandler: function setHandler(index, newHandler) {
      this.channels[index].setHandler(newHandler);
    },

    /**
     * Add data for time t in forms of list of bytes (unsigned ints). The bytes are treated as pairs.
     */
    addData: function addData(t, byteList) {
      var cmdFound,
          a,
          b,
          charsFound = false;
      this.lastTime = t;
      logger.setTime(t);

      for (var i = 0; i < byteList.length; i += 2) {
        a = byteList[i] & 0x7f;
        b = byteList[i + 1] & 0x7f;

        if (a >= 0x10 && a <= 0x1f && a === this.lastCmdA && b === this.lastCmdB) {
          this.lastCmdA = null;
          this.lastCmdB = null;
          logger.log("DEBUG", "Repeated command (" + numArrayToHexArray([a, b]) + ") is dropped");
          continue; // Repeated commands are dropped (once)
        }

        if (a === 0 && b === 0) {
          this.dataCounters.padding += 2;
          continue;
        } else {
          logger.log("DATA", "[" + numArrayToHexArray([byteList[i], byteList[i + 1]]) + "] -> (" + numArrayToHexArray([a, b]) + ")");
        }

        cmdFound = this.parseCmd(a, b);

        if (!cmdFound) {
          cmdFound = this.parseMidrow(a, b);
        }

        if (!cmdFound) {
          cmdFound = this.parsePAC(a, b);
        }

        if (!cmdFound) {
          cmdFound = this.parseBackgroundAttributes(a, b);
        }

        if (!cmdFound) {
          charsFound = this.parseChars(a, b);

          if (charsFound) {
            if (this.currChNr && this.currChNr >= 0) {
              var channel = this.channels[this.currChNr - 1];
              channel.insertChars(charsFound);
            } else {
              logger.log("WARNING", "No channel found yet. TEXT-MODE?");
            }
          }
        }

        if (cmdFound) {
          this.dataCounters.cmd += 2;
        } else if (charsFound) {
          this.dataCounters["char"] += 2;
        } else {
          this.dataCounters.other += 2;
          logger.log("WARNING", "Couldn't parse cleaned data " + numArrayToHexArray([a, b]) + " orig: " + numArrayToHexArray([byteList[i], byteList[i + 1]]));
        }
      }
    },

    /**
     * Parse Command.
     * @returns {Boolean} Tells if a command was found
     */
    parseCmd: function parseCmd(a, b) {
      var chNr = null;
      var cond1 = (a === 0x14 || a === 0x15 || a === 0x1C || a === 0x1D) && 0x20 <= b && b <= 0x2F;
      var cond2 = (a === 0x17 || a === 0x1F) && 0x21 <= b && b <= 0x23;

      if (!(cond1 || cond2)) {
        return false;
      }

      if (a === 0x14 || a === 0x15 || a === 0x17) {
        chNr = 1;
      } else {
        chNr = 2; // (a === 0x1C || a === 0x1D || a=== 0x1f)
      }

      var channel = this.channels[chNr - 1];

      if (a === 0x14 || a === 0x15 || a === 0x1C || a === 0x1D) {
        if (b === 0x20) {
          channel.cc_RCL();
        } else if (b === 0x21) {
          channel.cc_BS();
        } else if (b === 0x22) {
          channel.cc_AOF();
        } else if (b === 0x23) {
          channel.cc_AON();
        } else if (b === 0x24) {
          channel.cc_DER();
        } else if (b === 0x25) {
          channel.cc_RU(2);
        } else if (b === 0x26) {
          channel.cc_RU(3);
        } else if (b === 0x27) {
          channel.cc_RU(4);
        } else if (b === 0x28) {
          channel.cc_FON();
        } else if (b === 0x29) {
          channel.cc_RDC();
        } else if (b === 0x2A) {
          channel.cc_TR();
        } else if (b === 0x2B) {
          channel.cc_RTD();
        } else if (b === 0x2C) {
          channel.cc_EDM();
        } else if (b === 0x2D) {
          channel.cc_CR();
        } else if (b === 0x2E) {
          channel.cc_ENM();
        } else if (b === 0x2F) {
          channel.cc_EOC();
        }
      } else {
        //a == 0x17 || a == 0x1F
        channel.cc_TO(b - 0x20);
      }

      this.lastCmdA = a;
      this.lastCmdB = b;
      this.currChNr = chNr;
      return true;
    },

    /**
     * Parse midrow styling command
     * @returns {Boolean}
     */
    parseMidrow: function parseMidrow(a, b) {
      var chNr = null;

      if ((a === 0x11 || a === 0x19) && 0x20 <= b && b <= 0x2f) {
        if (a === 0x11) {
          chNr = 1;
        } else {
          chNr = 2;
        }

        if (chNr !== this.currChNr) {
          logger.log("ERROR", "Mismatch channel in midrow parsing");
          return false;
        }

        var channel = this.channels[chNr - 1]; // cea608 spec says midrow codes should inject a space

        channel.insertChars([0x20]);
        channel.cc_MIDROW(b);
        logger.log("DEBUG", "MIDROW (" + numArrayToHexArray([a, b]) + ")");
        this.lastCmdA = a;
        this.lastCmdB = b;
        return true;
      }

      return false;
    },

    /**
     * Parse Preable Access Codes (Table 53).
     * @returns {Boolean} Tells if PAC found
     */
    parsePAC: function parsePAC(a, b) {
      var chNr = null;
      var row = null;
      var case1 = (0x11 <= a && a <= 0x17 || 0x19 <= a && a <= 0x1F) && 0x40 <= b && b <= 0x7F;
      var case2 = (a === 0x10 || a === 0x18) && 0x40 <= b && b <= 0x5F;

      if (!(case1 || case2)) {
        return false;
      }

      chNr = a <= 0x17 ? 1 : 2;

      if (0x40 <= b && b <= 0x5F) {
        row = chNr === 1 ? rowsLowCh1[a] : rowsLowCh2[a];
      } else {
        // 0x60 <= b <= 0x7F
        row = chNr === 1 ? rowsHighCh1[a] : rowsHighCh2[a];
      }

      var pacData = this.interpretPAC(row, b);
      var channel = this.channels[chNr - 1];
      channel.setPAC(pacData);
      this.lastCmdA = a;
      this.lastCmdB = b;
      this.currChNr = chNr;
      return true;
    },

    /**
     * Interpret the second byte of the pac, and return the information.
     * @returns {Object} pacData with style parameters.
     */
    interpretPAC: function interpretPAC(row, _byte3) {
      var pacIndex = _byte3;
      var pacData = {
        color: null,
        italics: false,
        indent: null,
        underline: false,
        row: row
      };

      if (_byte3 > 0x5F) {
        pacIndex = _byte3 - 0x60;
      } else {
        pacIndex = _byte3 - 0x40;
      }

      pacData.underline = (pacIndex & 1) === 1;

      if (pacIndex <= 0xd) {
        pacData.color = ['white', 'green', 'blue', 'cyan', 'red', 'yellow', 'magenta', 'white'][Math.floor(pacIndex / 2)];
      } else if (pacIndex <= 0xf) {
        pacData.italics = true;
        pacData.color = 'white';
      } else {
        pacData.indent = Math.floor((pacIndex - 0x10) / 2) * 4;
      }

      return pacData; // Note that row has zero offset. The spec uses 1.
    },

    /**
     * Parse characters.
     * @returns An array with 1 to 2 codes corresponding to chars, if found. null otherwise.
     */
    parseChars: function parseChars(a, b) {
      var channelNr = null,
          charCodes = null,
          charCode1 = null,
          charCode2 = null;

      if (a >= 0x19) {
        channelNr = 2;
        charCode1 = a - 8;
      } else {
        channelNr = 1;
        charCode1 = a;
      }

      if (0x11 <= charCode1 && charCode1 <= 0x13) {
        // Special character
        var oneCode = b;

        if (charCode1 === 0x11) {
          oneCode = b + 0x50;
        } else if (charCode1 === 0x12) {
          oneCode = b + 0x70;
        } else {
          oneCode = b + 0x90;
        }

        logger.log("INFO", "Special char '" + getCharForByte(oneCode) + "' in channel " + channelNr);
        charCodes = [oneCode];
        this.lastCmdA = a;
        this.lastCmdB = b;
      } else if (0x20 <= a && a <= 0x7f) {
        charCodes = b === 0 ? [a] : [a, b];
        this.lastCmdA = null;
        this.lastCmdB = null;
      }

      if (charCodes) {
        var hexCodes = numArrayToHexArray(charCodes);
        logger.log("DEBUG", "Char codes =  " + hexCodes.join(","));
      }

      return charCodes;
    },

    /**
    * Parse extended background attributes as well as new foreground color black.
    * @returns{Boolean} Tells if background attributes are found
    */
    parseBackgroundAttributes: function parseBackgroundAttributes(a, b) {
      var bkgData, index, chNr, channel;
      var case1 = (a === 0x10 || a === 0x18) && 0x20 <= b && b <= 0x2f;
      var case2 = (a === 0x17 || a === 0x1f) && 0x2d <= b && b <= 0x2f;

      if (!(case1 || case2)) {
        return false;
      }

      bkgData = {};

      if (a === 0x10 || a === 0x18) {
        index = Math.floor((b - 0x20) / 2);
        bkgData.background = backgroundColors[index];

        if (b % 2 === 1) {
          bkgData.background = bkgData.background + "_semi";
        }
      } else if (b === 0x2d) {
        bkgData.background = "transparent";
      } else {
        bkgData.foreground = "black";

        if (b === 0x2f) {
          bkgData.underline = true;
        }
      }

      chNr = a < 0x18 ? 1 : 2;
      channel = this.channels[chNr - 1];
      channel.setBkgData(bkgData);
      this.lastCmdA = a;
      this.lastCmdB = b;
      return true;
    },

    /**
     * Reset state of parser and its channels.
     */
    reset: function reset() {
      for (var i = 0; i < this.channels.length; i++) {
        if (this.channels[i]) {
          this.channels[i].reset();
        }
      }

      this.lastCmdA = null;
      this.lastCmdB = null;
    },

    /**
     * Trigger the generation of a cue, and the start of a new one if displayScreens are not empty.
     */
    cueSplitAtTime: function cueSplitAtTime(t) {
      for (var i = 0; i < this.channels.length; i++) {
        if (this.channels[i]) {
          this.channels[i].cueSplitAtTime(t);
        }
      }
    }
  };
  /**
   * Find ranges corresponding to SEA CEA-608 NALUS in sizeprepended NALU array.
   * @param {raw} dataView of binary data
   * @param {startPos} start position in raw
   * @param {size} total size of data in raw to consider
   * @returns 
   */

  var findCea608Nalus = function findCea608Nalus(raw, startPos, size) {
    var nalSize = 0,
        cursor = startPos,
        nalType = 0,
        cea608NaluRanges = [],
        // Check SEI data according to ANSI-SCTE 128
    isCEA608SEI = function isCEA608SEI(payloadType, payloadSize, raw, pos) {
      if (payloadType !== 4 || payloadSize < 8) {
        return null;
      }

      var countryCode = raw.getUint8(pos);
      var providerCode = raw.getUint16(pos + 1);
      var userIdentifier = raw.getUint32(pos + 3);
      var userDataTypeCode = raw.getUint8(pos + 7);
      return countryCode == 0xB5 && providerCode == 0x31 && userIdentifier == 0x47413934 && userDataTypeCode == 0x3;
    };

    while (cursor < startPos + size) {
      nalSize = raw.getUint32(cursor);
      nalType = raw.getUint8(cursor + 4) & 0x1F; //console.log(time + "  NAL " + nalType);

      if (nalType === 6) {
        // SEI NAL Unit. The NAL header is the first byte
        //console.log("SEI NALU of size " + nalSize + " at time " + time);
        var pos = cursor + 5;
        var payloadType = -1;

        while (pos < cursor + 4 + nalSize - 1) {
          // The last byte should be rbsp_trailing_bits
          payloadType = 0;
          var b = 0xFF;

          while (b === 0xFF) {
            b = raw.getUint8(pos);
            payloadType += b;
            pos++;
          }

          var payloadSize = 0;
          b = 0xFF;

          while (b === 0xFF) {
            b = raw.getUint8(pos);
            payloadSize += b;
            pos++;
          }

          if (isCEA608SEI(payloadType, payloadSize, raw, pos)) {
            //console.log("CEA608 SEI " + time + " " + payloadSize);
            cea608NaluRanges.push([pos, payloadSize]);
          }

          pos += payloadSize;
        }
      }

      cursor += nalSize + 4;
    }

    return cea608NaluRanges;
  };

  var extractCea608DataFromRange = function extractCea608DataFromRange(raw, cea608Range) {
    var pos = cea608Range[0];
    var fieldData = [[], []];
    pos += 8; // Skip the identifier up to userDataTypeCode

    var ccCount = raw.getUint8(pos) & 0x1f;
    pos += 2; // Advance 1 and skip reserved byte

    for (var i = 0; i < ccCount; i++) {
      var _byte4 = raw.getUint8(pos);

      var ccValid = _byte4 & 0x4;
      var ccType = _byte4 & 0x3;
      pos++;
      var ccData1 = raw.getUint8(pos); // Keep parity bit

      pos++;
      var ccData2 = raw.getUint8(pos); // Keep parity bit

      pos++;

      if (ccValid && (ccData1 & 0x7f) + (ccData2 & 0x7f) !== 0) {
        //Check validity and non-empty data
        if (ccType === 0) {
          fieldData[0].push(ccData1);
          fieldData[0].push(ccData2);
        } else if (ccType === 1) {
          fieldData[1].push(ccData1);
          fieldData[1].push(ccData2);
        }
      }
    }

    return fieldData;
  };

  exports.logger = logger;
  exports.PenState = PenState;
  exports.CaptionScreen = CaptionScreen;
  exports.Cea608Parser = Cea608Parser;
  exports.findCea608Nalus = findCea608Nalus;
  exports.extractCea608DataFromRange = extractCea608DataFromRange;
})( false ? 0 : exports);

/***/ }),

/***/ "./externals/xml2json.js":
/*!*******************************!*\
  !*** ./externals/xml2json.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/*
 Copyright 2011-2013 Abdulla Abdurakhmanov
 Original sources are available at https://code.google.com/p/x2js/

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */

/*
  Further modified for dashjs to:
  - keep track of children nodes in order in attribute __children.
  - add type conversion matchers
  - re-add ignoreRoot
  - allow zero-length attributePrefix
  - don't add white-space text nodes
  - remove explicit RequireJS support
*/
function X2JS(config) {
  'use strict';

  var VERSION = "1.2.0";
  config = config || {};
  initConfigDefaults();
  initRequiredPolyfills();

  function initConfigDefaults() {
    if (config.escapeMode === undefined) {
      config.escapeMode = true;
    }

    if (config.attributePrefix === undefined) {
      config.attributePrefix = "_";
    }

    config.arrayAccessForm = config.arrayAccessForm || "none";
    config.emptyNodeForm = config.emptyNodeForm || "text";

    if (config.enableToStringFunc === undefined) {
      config.enableToStringFunc = true;
    }

    config.arrayAccessFormPaths = config.arrayAccessFormPaths || [];

    if (config.skipEmptyTextNodesForObj === undefined) {
      config.skipEmptyTextNodesForObj = true;
    }

    if (config.stripWhitespaces === undefined) {
      config.stripWhitespaces = true;
    }

    config.datetimeAccessFormPaths = config.datetimeAccessFormPaths || [];

    if (config.useDoubleQuotes === undefined) {
      config.useDoubleQuotes = false;
    }

    config.xmlElementsFilter = config.xmlElementsFilter || [];
    config.jsonPropertiesFilter = config.jsonPropertiesFilter || [];

    if (config.keepCData === undefined) {
      config.keepCData = false;
    }

    if (config.ignoreRoot === undefined) {
      config.ignoreRoot = false;
    }
  }

  var DOMNodeTypes = {
    ELEMENT_NODE: 1,
    TEXT_NODE: 3,
    CDATA_SECTION_NODE: 4,
    COMMENT_NODE: 8,
    DOCUMENT_NODE: 9
  };

  function initRequiredPolyfills() {}

  function getNodeLocalName(node) {
    var nodeLocalName = node.localName;
    if (nodeLocalName == null) // Yeah, this is IE!!
      nodeLocalName = node.baseName;
    if (nodeLocalName == null || nodeLocalName == "") // =="" is IE too
      nodeLocalName = node.nodeName;
    return nodeLocalName;
  }

  function getNodePrefix(node) {
    return node.prefix;
  }

  function escapeXmlChars(str) {
    if (typeof str == "string") return str.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;').replace(/'/g, '&apos;');else return str;
  }

  function unescapeXmlChars(str) {
    return str.replace(/&lt;/g, '<').replace(/&gt;/g, '>').replace(/&quot;/g, '"').replace(/&apos;/g, "'").replace(/&amp;/g, '&');
  }

  function checkInStdFiltersArrayForm(stdFiltersArrayForm, obj, name, path) {
    var idx = 0;

    for (; idx < stdFiltersArrayForm.length; idx++) {
      var filterPath = stdFiltersArrayForm[idx];

      if (typeof filterPath === "string") {
        if (filterPath == path) break;
      } else if (filterPath instanceof RegExp) {
        if (filterPath.test(path)) break;
      } else if (typeof filterPath === "function") {
        if (filterPath(obj, name, path)) break;
      }
    }

    return idx != stdFiltersArrayForm.length;
  }

  function toArrayAccessForm(obj, childName, path) {
    switch (config.arrayAccessForm) {
      case "property":
        if (!(obj[childName] instanceof Array)) obj[childName + "_asArray"] = [obj[childName]];else obj[childName + "_asArray"] = obj[childName];
        break;

      /*case "none":
          break;*/
    }

    if (!(obj[childName] instanceof Array) && config.arrayAccessFormPaths.length > 0) {
      if (checkInStdFiltersArrayForm(config.arrayAccessFormPaths, obj, childName, path)) {
        obj[childName] = [obj[childName]];
      }
    }
  }

  function fromXmlDateTime(prop) {
    // Implementation based up on http://stackoverflow.com/questions/8178598/xml-datetime-to-javascript-date-object
    // Improved to support full spec and optional parts
    var bits = prop.split(/[-T:+Z]/g);
    var d = new Date(bits[0], bits[1] - 1, bits[2]);
    var secondBits = bits[5].split("\.");
    d.setHours(bits[3], bits[4], secondBits[0]);
    if (secondBits.length > 1) d.setMilliseconds(secondBits[1]); // Get supplied time zone offset in minutes

    if (bits[6] && bits[7]) {
      var offsetMinutes = bits[6] * 60 + Number(bits[7]);
      var sign = /\d\d-\d\d:\d\d$/.test(prop) ? '-' : '+'; // Apply the sign

      offsetMinutes = 0 + (sign == '-' ? -1 * offsetMinutes : offsetMinutes); // Apply offset and local timezone

      d.setMinutes(d.getMinutes() - offsetMinutes - d.getTimezoneOffset());
    } else if (prop.indexOf("Z", prop.length - 1) !== -1) {
      d = new Date(Date.UTC(d.getFullYear(), d.getMonth(), d.getDate(), d.getHours(), d.getMinutes(), d.getSeconds(), d.getMilliseconds()));
    } // d is now a local time equivalent to the supplied time


    return d;
  }

  function checkFromXmlDateTimePaths(value, childName, fullPath) {
    if (config.datetimeAccessFormPaths.length > 0) {
      var path = fullPath.split("\.#")[0];

      if (checkInStdFiltersArrayForm(config.datetimeAccessFormPaths, value, childName, path)) {
        return fromXmlDateTime(value);
      } else return value;
    } else return value;
  }

  function checkXmlElementsFilter(obj, childType, childName, childPath) {
    if (childType == DOMNodeTypes.ELEMENT_NODE && config.xmlElementsFilter.length > 0) {
      return checkInStdFiltersArrayForm(config.xmlElementsFilter, obj, childName, childPath);
    } else return true;
  }

  function parseDOMChildren(node, path) {
    if (node.nodeType == DOMNodeTypes.DOCUMENT_NODE) {
      var result = new Object();
      var nodeChildren = node.childNodes; // Alternative for firstElementChild which is not supported in some environments

      for (var cidx = 0; cidx < nodeChildren.length; cidx++) {
        var child = nodeChildren[cidx];

        if (child.nodeType == DOMNodeTypes.ELEMENT_NODE) {
          if (config.ignoreRoot) {
            result = parseDOMChildren(child);
          } else {
            result = {};
            var childName = getNodeLocalName(child);
            result[childName] = parseDOMChildren(child);
          }
        }
      }

      return result;
    } else if (node.nodeType == DOMNodeTypes.ELEMENT_NODE) {
      var result = new Object();
      result.__cnt = 0;
      var children = [];
      var nodeChildren = node.childNodes; // Children nodes

      for (var cidx = 0; cidx < nodeChildren.length; cidx++) {
        var child = nodeChildren[cidx];
        var childName = getNodeLocalName(child);

        if (child.nodeType != DOMNodeTypes.COMMENT_NODE) {
          var childPath = path + "." + childName;

          if (checkXmlElementsFilter(result, child.nodeType, childName, childPath)) {
            result.__cnt++;

            if (result[childName] == null) {
              var c = parseDOMChildren(child, childPath);

              if (childName != "#text" || /[^\s]/.test(c)) {
                var o = {};
                o[childName] = c;
                children.push(o);
              }

              result[childName] = c;
              toArrayAccessForm(result, childName, childPath);
            } else {
              if (result[childName] != null) {
                if (!(result[childName] instanceof Array)) {
                  result[childName] = [result[childName]];
                  toArrayAccessForm(result, childName, childPath);
                }
              }

              var c = parseDOMChildren(child, childPath);

              if (childName != "#text" || /[^\s]/.test(c)) {
                // Don't add white-space text nodes
                var o = {};
                o[childName] = c;
                children.push(o);
              }

              result[childName][result[childName].length] = c;
            }
          }
        }
      }

      result.__children = children; // Attributes

      var nodeLocalName = getNodeLocalName(node);

      for (var aidx = 0; aidx < node.attributes.length; aidx++) {
        var attr = node.attributes[aidx];
        result.__cnt++;
        var value2 = attr.value;

        for (var m = 0, ml = config.matchers.length; m < ml; m++) {
          var matchobj = config.matchers[m];
          if (matchobj.test(attr, nodeLocalName)) value2 = matchobj.converter(attr.value);
        }

        result[config.attributePrefix + attr.name] = value2;
      } // Node namespace prefix


      var nodePrefix = getNodePrefix(node);

      if (nodePrefix != null && nodePrefix != "") {
        result.__cnt++;
        result.__prefix = nodePrefix;
      }

      if (result["#text"] != null) {
        result.__text = result["#text"];

        if (result.__text instanceof Array) {
          result.__text = result.__text.join("\n");
        } //if(config.escapeMode)
        //	result.__text = unescapeXmlChars(result.__text);


        if (config.stripWhitespaces) result.__text = result.__text.trim();
        delete result["#text"];
        if (config.arrayAccessForm == "property") delete result["#text_asArray"];
        result.__text = checkFromXmlDateTimePaths(result.__text, childName, path + "." + childName);
      }

      if (result["#cdata-section"] != null) {
        result.__cdata = result["#cdata-section"];
        delete result["#cdata-section"];
        if (config.arrayAccessForm == "property") delete result["#cdata-section_asArray"];
      }

      if (result.__cnt == 0 && config.emptyNodeForm == "text") {
        result = '';
      } else if (result.__cnt == 1 && result.__text != null) {
        result = result.__text;
      } else if (result.__cnt == 1 && result.__cdata != null && !config.keepCData) {
        result = result.__cdata;
      } else if (result.__cnt > 1 && result.__text != null && config.skipEmptyTextNodesForObj) {
        if (config.stripWhitespaces && result.__text == "" || result.__text.trim() == "") {
          delete result.__text;
        }
      }

      delete result.__cnt;

      if (config.enableToStringFunc && (result.__text != null || result.__cdata != null)) {
        result.toString = function () {
          return (this.__text != null ? this.__text : '') + (this.__cdata != null ? this.__cdata : '');
        };
      }

      return result;
    } else if (node.nodeType == DOMNodeTypes.TEXT_NODE || node.nodeType == DOMNodeTypes.CDATA_SECTION_NODE) {
      return node.nodeValue;
    }
  }

  function startTag(jsonObj, element, attrList, closed) {
    var resultStr = "<" + (jsonObj != null && jsonObj.__prefix != null ? jsonObj.__prefix + ":" : "") + element;

    if (attrList != null) {
      for (var aidx = 0; aidx < attrList.length; aidx++) {
        var attrName = attrList[aidx];
        var attrVal = jsonObj[attrName];
        if (config.escapeMode) attrVal = escapeXmlChars(attrVal);
        resultStr += " " + attrName.substr(config.attributePrefix.length) + "=";
        if (config.useDoubleQuotes) resultStr += '"' + attrVal + '"';else resultStr += "'" + attrVal + "'";
      }
    }

    if (!closed) resultStr += ">";else resultStr += "/>";
    return resultStr;
  }

  function endTag(jsonObj, elementName) {
    return "</" + (jsonObj.__prefix != null ? jsonObj.__prefix + ":" : "") + elementName + ">";
  }

  function endsWith(str, suffix) {
    return str.indexOf(suffix, str.length - suffix.length) !== -1;
  }

  function jsonXmlSpecialElem(jsonObj, jsonObjField) {
    if (config.arrayAccessForm == "property" && endsWith(jsonObjField.toString(), "_asArray") || jsonObjField.toString().indexOf(config.attributePrefix) == 0 || jsonObjField.toString().indexOf("__") == 0 || jsonObj[jsonObjField] instanceof Function) return true;else return false;
  }

  function jsonXmlElemCount(jsonObj) {
    var elementsCnt = 0;

    if (jsonObj instanceof Object) {
      for (var it in jsonObj) {
        if (jsonXmlSpecialElem(jsonObj, it)) continue;
        elementsCnt++;
      }
    }

    return elementsCnt;
  }

  function checkJsonObjPropertiesFilter(jsonObj, propertyName, jsonObjPath) {
    return config.jsonPropertiesFilter.length == 0 || jsonObjPath == "" || checkInStdFiltersArrayForm(config.jsonPropertiesFilter, jsonObj, propertyName, jsonObjPath);
  }

  function parseJSONAttributes(jsonObj) {
    var attrList = [];

    if (jsonObj instanceof Object) {
      for (var ait in jsonObj) {
        if (ait.toString().indexOf("__") == -1 && ait.toString().indexOf(config.attributePrefix) == 0) {
          attrList.push(ait);
        }
      }
    }

    return attrList;
  }

  function parseJSONTextAttrs(jsonTxtObj) {
    var result = "";

    if (jsonTxtObj.__cdata != null) {
      result += "<![CDATA[" + jsonTxtObj.__cdata + "]]>";
    }

    if (jsonTxtObj.__text != null) {
      if (config.escapeMode) result += escapeXmlChars(jsonTxtObj.__text);else result += jsonTxtObj.__text;
    }

    return result;
  }

  function parseJSONTextObject(jsonTxtObj) {
    var result = "";

    if (jsonTxtObj instanceof Object) {
      result += parseJSONTextAttrs(jsonTxtObj);
    } else if (jsonTxtObj != null) {
      if (config.escapeMode) result += escapeXmlChars(jsonTxtObj);else result += jsonTxtObj;
    }

    return result;
  }

  function getJsonPropertyPath(jsonObjPath, jsonPropName) {
    if (jsonObjPath === "") {
      return jsonPropName;
    } else return jsonObjPath + "." + jsonPropName;
  }

  function parseJSONArray(jsonArrRoot, jsonArrObj, attrList, jsonObjPath) {
    var result = "";

    if (jsonArrRoot.length == 0) {
      result += startTag(jsonArrRoot, jsonArrObj, attrList, true);
    } else {
      for (var arIdx = 0; arIdx < jsonArrRoot.length; arIdx++) {
        result += startTag(jsonArrRoot[arIdx], jsonArrObj, parseJSONAttributes(jsonArrRoot[arIdx]), false);
        result += parseJSONObject(jsonArrRoot[arIdx], getJsonPropertyPath(jsonObjPath, jsonArrObj));
        result += endTag(jsonArrRoot[arIdx], jsonArrObj);
      }
    }

    return result;
  }

  function parseJSONObject(jsonObj, jsonObjPath) {
    var result = "";
    var elementsCnt = jsonXmlElemCount(jsonObj);

    if (elementsCnt > 0) {
      for (var it in jsonObj) {
        if (jsonXmlSpecialElem(jsonObj, it) || jsonObjPath != "" && !checkJsonObjPropertiesFilter(jsonObj, it, getJsonPropertyPath(jsonObjPath, it))) continue;
        var subObj = jsonObj[it];
        var attrList = parseJSONAttributes(subObj);

        if (subObj == null || subObj == undefined) {
          result += startTag(subObj, it, attrList, true);
        } else if (subObj instanceof Object) {
          if (subObj instanceof Array) {
            result += parseJSONArray(subObj, it, attrList, jsonObjPath);
          } else if (subObj instanceof Date) {
            result += startTag(subObj, it, attrList, false);
            result += subObj.toISOString();
            result += endTag(subObj, it);
          } else {
            var subObjElementsCnt = jsonXmlElemCount(subObj);

            if (subObjElementsCnt > 0 || subObj.__text != null || subObj.__cdata != null) {
              result += startTag(subObj, it, attrList, false);
              result += parseJSONObject(subObj, getJsonPropertyPath(jsonObjPath, it));
              result += endTag(subObj, it);
            } else {
              result += startTag(subObj, it, attrList, true);
            }
          }
        } else {
          result += startTag(subObj, it, attrList, false);
          result += parseJSONTextObject(subObj);
          result += endTag(subObj, it);
        }
      }
    }

    result += parseJSONTextObject(jsonObj);
    return result;
  }

  this.parseXmlString = function (xmlDocStr) {
    var isIEParser = window.ActiveXObject || "ActiveXObject" in window;

    if (xmlDocStr === undefined) {
      return null;
    }

    var xmlDoc;

    if (window.DOMParser) {
      var parser = new window.DOMParser();
      var parsererrorNS = null;

      try {
        xmlDoc = parser.parseFromString(xmlDocStr, "text/xml");

        if (xmlDoc.getElementsByTagNameNS("*", "parsererror").length > 0) {
          xmlDoc = null;
        }
      } catch (err) {
        xmlDoc = null;
      }
    } else {
      // IE :(
      if (xmlDocStr.indexOf("<?") == 0) {
        xmlDocStr = xmlDocStr.substr(xmlDocStr.indexOf("?>") + 2);
      }

      xmlDoc = new ActiveXObject("Microsoft.XMLDOM");
      xmlDoc.async = "false";
      xmlDoc.loadXML(xmlDocStr);
    }

    return xmlDoc;
  };

  this.asArray = function (prop) {
    if (prop === undefined || prop == null) return [];else if (prop instanceof Array) return prop;else return [prop];
  };

  this.toXmlDateTime = function (dt) {
    if (dt instanceof Date) return dt.toISOString();else if (typeof dt === 'number') return new Date(dt).toISOString();else return null;
  };

  this.asDateTime = function (prop) {
    if (typeof prop == "string") {
      return fromXmlDateTime(prop);
    } else return prop;
  };

  this.xml2json = function (xmlDoc) {
    return parseDOMChildren(xmlDoc);
  };

  this.xml_str2json = function (xmlDocStr) {
    var xmlDoc = this.parseXmlString(xmlDocStr);
    if (xmlDoc != null) return this.xml2json(xmlDoc);else return null;
  };

  this.json2xml_str = function (jsonObj) {
    return parseJSONObject(jsonObj, "");
  };

  this.json2xml = function (jsonObj) {
    var xmlDocStr = this.json2xml_str(jsonObj);
    return this.parseXmlString(xmlDocStr);
  };

  this.getVersion = function () {
    return VERSION;
  };
}

/* harmony default export */ __webpack_exports__["default"] = (X2JS);

/***/ }),

/***/ "./index_mediaplayerOnly.js":
/*!**********************************!*\
  !*** ./index_mediaplayerOnly.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Debug": function() { return /* reexport safe */ _src_core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"]; },
/* harmony export */   "FactoryMaker": function() { return /* reexport safe */ _src_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"]; },
/* harmony export */   "MediaPlayer": function() { return /* reexport safe */ _src_streaming_MediaPlayer__WEBPACK_IMPORTED_MODULE_0__["default"]; }
/* harmony export */ });
/* harmony import */ var _src_streaming_MediaPlayer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./src/streaming/MediaPlayer */ "./src/streaming/MediaPlayer.js");
/* harmony import */ var _src_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./src/core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _src_core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./src/core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _src_core_Version__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./src/core/Version */ "./src/core/Version.js");
/* harmony import */ var es6_promise_auto__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! es6-promise/auto */ "./node_modules/es6-promise/auto.js");
/* harmony import */ var es6_promise_auto__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(es6_promise_auto__WEBPACK_IMPORTED_MODULE_4__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




 // Shove both of these into the global scope

var context = typeof window !== 'undefined' && window || __webpack_require__.g;
var dashjs = context.dashjs;

if (!dashjs) {
  dashjs = context.dashjs = {};
}

dashjs.MediaPlayer = _src_streaming_MediaPlayer__WEBPACK_IMPORTED_MODULE_0__["default"];
dashjs.FactoryMaker = _src_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"];
dashjs.Debug = _src_core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"];
dashjs.Version = (0,_src_core_Version__WEBPACK_IMPORTED_MODULE_3__.getVersionString)();
/* harmony default export */ __webpack_exports__["default"] = (dashjs);


/***/ }),

/***/ "./src/core/Debug.js":
/*!***************************!*\
  !*** ./src/core/Debug.js ***!
  \***************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



var LOG_LEVEL_NONE = 0;
var LOG_LEVEL_FATAL = 1;
var LOG_LEVEL_ERROR = 2;
var LOG_LEVEL_WARNING = 3;
var LOG_LEVEL_INFO = 4;
var LOG_LEVEL_DEBUG = 5;
/**
 * @module Debug
 * @param {object} config
 * @ignore
 */

function Debug(config) {
  config = config || {};
  var context = this.context;
  var eventBus = (0,_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var settings = config.settings;
  var logFn = [];
  var instance, showLogTimestamp, showCalleeName, startTime;

  function setup() {
    showLogTimestamp = true;
    showCalleeName = true;
    startTime = new Date().getTime();

    if (typeof window !== 'undefined' && window.console) {
      logFn[LOG_LEVEL_FATAL] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_ERROR] = getLogFn(window.console.error);
      logFn[LOG_LEVEL_WARNING] = getLogFn(window.console.warn);
      logFn[LOG_LEVEL_INFO] = getLogFn(window.console.info);
      logFn[LOG_LEVEL_DEBUG] = getLogFn(window.console.debug);
    }
  }

  function getLogFn(fn) {
    if (fn && fn.bind) {
      return fn.bind(window.console);
    } // if not define, return the default function for reporting logs


    return window.console.log.bind(window.console);
  }
  /**
   * Retrieves a logger which can be used to write logging information in browser console.
   * @param {object} instance Object for which the logger is created. It is used
   * to include calle object information in log messages.
   * @memberof module:Debug
   * @returns {Logger}
   * @instance
   */


  function getLogger(instance) {
    return {
      fatal: fatal.bind(instance),
      error: error.bind(instance),
      warn: warn.bind(instance),
      info: info.bind(instance),
      debug: debug.bind(instance)
    };
  }
  /**
   * Prepends a timestamp in milliseconds to each log message.
   * @param {boolean} value Set to true if you want to see a timestamp in each log message.
   * @default LOG_LEVEL_WARNING
   * @memberof module:Debug
   * @instance
   */


  function setLogTimestampVisible(value) {
    showLogTimestamp = value;
  }
  /**
   * Prepends the callee object name, and media type if available, to each log message.
   * @param {boolean} value Set to true if you want to see the callee object name and media type in each log message.
   * @default true
   * @memberof module:Debug
   * @instance
   */


  function setCalleeNameVisible(value) {
    showCalleeName = value;
  }

  function fatal() {
    for (var _len = arguments.length, params = new Array(_len), _key = 0; _key < _len; _key++) {
      params[_key] = arguments[_key];
    }

    doLog.apply(void 0, [LOG_LEVEL_FATAL, this].concat(params));
  }

  function error() {
    for (var _len2 = arguments.length, params = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
      params[_key2] = arguments[_key2];
    }

    doLog.apply(void 0, [LOG_LEVEL_ERROR, this].concat(params));
  }

  function warn() {
    for (var _len3 = arguments.length, params = new Array(_len3), _key3 = 0; _key3 < _len3; _key3++) {
      params[_key3] = arguments[_key3];
    }

    doLog.apply(void 0, [LOG_LEVEL_WARNING, this].concat(params));
  }

  function info() {
    for (var _len4 = arguments.length, params = new Array(_len4), _key4 = 0; _key4 < _len4; _key4++) {
      params[_key4] = arguments[_key4];
    }

    doLog.apply(void 0, [LOG_LEVEL_INFO, this].concat(params));
  }

  function debug() {
    for (var _len5 = arguments.length, params = new Array(_len5), _key5 = 0; _key5 < _len5; _key5++) {
      params[_key5] = arguments[_key5];
    }

    doLog.apply(void 0, [LOG_LEVEL_DEBUG, this].concat(params));
  }

  function doLog(level, _this) {
    var message = '';
    var logTime = null;

    if (showLogTimestamp) {
      logTime = new Date().getTime();
      message += '[' + (logTime - startTime) + ']';
    }

    if (showCalleeName && _this && _this.getClassName) {
      message += '[' + _this.getClassName() + ']';

      if (_this.getType) {
        message += '[' + _this.getType() + ']';
      }
    }

    if (message.length > 0) {
      message += ' ';
    }

    for (var _len6 = arguments.length, params = new Array(_len6 > 2 ? _len6 - 2 : 0), _key6 = 2; _key6 < _len6; _key6++) {
      params[_key6 - 2] = arguments[_key6];
    }

    Array.apply(null, params).forEach(function (item) {
      message += item + ' ';
    }); // log to console if the log level is high enough

    if (logFn[level] && settings && settings.get().debug.logLevel >= level) {
      logFn[level](message);
    } // send log event regardless of log level


    if (settings && settings.get().debug.dispatchEvent) {
      eventBus.trigger(_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].LOG, {
        message: message,
        level: level
      });
    }
  }

  instance = {
    getLogger: getLogger,
    setLogTimestampVisible: setLogTimestampVisible,
    setCalleeNameVisible: setCalleeNameVisible
  };
  setup();
  return instance;
}

Debug.__dashjs_factory_name = 'Debug';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(Debug);
factory.LOG_LEVEL_NONE = LOG_LEVEL_NONE;
factory.LOG_LEVEL_FATAL = LOG_LEVEL_FATAL;
factory.LOG_LEVEL_ERROR = LOG_LEVEL_ERROR;
factory.LOG_LEVEL_WARNING = LOG_LEVEL_WARNING;
factory.LOG_LEVEL_INFO = LOG_LEVEL_INFO;
factory.LOG_LEVEL_DEBUG = LOG_LEVEL_DEBUG;
_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].updateSingletonFactory(Debug.__dashjs_factory_name, factory);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/EventBus.js":
/*!******************************!*\
  !*** ./src/core/EventBus.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


var EVENT_PRIORITY_LOW = 0;
var EVENT_PRIORITY_HIGH = 5000;

function EventBus() {
  var handlers = {};

  function on(type, listener, scope) {
    var options = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : {};

    if (!type) {
      throw new Error('event type cannot be null or undefined');
    }

    if (!listener || typeof listener !== 'function') {
      throw new Error('listener must be a function: ' + listener);
    }

    var priority = options.priority || EVENT_PRIORITY_LOW;
    if (getHandlerIdx(type, listener, scope) >= 0) return;
    handlers[type] = handlers[type] || [];
    var handler = {
      callback: listener,
      scope: scope,
      priority: priority
    };

    if (scope && scope.getStreamId) {
      handler.streamId = scope.getStreamId();
    }

    if (scope && scope.getType) {
      handler.mediaType = scope.getType();
    }

    if (options && options.mode) {
      handler.mode = options.mode;
    }

    var inserted = handlers[type].some(function (item, idx) {
      if (item && priority > item.priority) {
        handlers[type].splice(idx, 0, handler);
        return true;
      }
    });

    if (!inserted) {
      handlers[type].push(handler);
    }
  }

  function off(type, listener, scope) {
    if (!type || !listener || !handlers[type]) return;
    var idx = getHandlerIdx(type, listener, scope);
    if (idx < 0) return;
    handlers[type][idx] = null;
  }

  function trigger(type) {
    var payload = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var filters = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
    if (!type || !handlers[type]) return;
    payload = payload || {};
    if (payload.hasOwnProperty('type')) throw new Error('\'type\' is a reserved word for event dispatching');
    payload.type = type;

    if (filters.streamId) {
      payload.streamId = filters.streamId;
    }

    if (filters.mediaType) {
      payload.mediaType = filters.mediaType;
    }

    handlers[type].filter(function (handler) {
      if (!handler) {
        return false;
      }

      if (filters.streamId && handler.streamId && handler.streamId !== filters.streamId) {
        return false;
      }

      if (filters.mediaType && handler.mediaType && handler.mediaType !== filters.mediaType) {
        return false;
      } // This is used for dispatching DASH events. By default we use the onStart mode. Consequently we filter everything that has a non matching mode and the onReceive events for handlers that did not specify a mode.


      if (filters.mode && handler.mode && handler.mode !== filters.mode || !handler.mode && filters.mode && filters.mode === _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_MODE_ON_RECEIVE) {
        return false;
      }

      return true;
    }).forEach(function (handler) {
      return handler && handler.callback.call(handler.scope, payload);
    });
  }

  function getHandlerIdx(type, listener, scope) {
    var idx = -1;
    if (!handlers[type]) return idx;
    handlers[type].some(function (item, index) {
      if (item && item.callback === listener && (!scope || scope === item.scope)) {
        idx = index;
        return true;
      }
    });
    return idx;
  }

  function reset() {
    handlers = {};
  }

  var instance = {
    on: on,
    off: off,
    trigger: trigger,
    reset: reset
  };
  return instance;
}

EventBus.__dashjs_factory_name = 'EventBus';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(EventBus);
factory.EVENT_PRIORITY_LOW = EVENT_PRIORITY_LOW;
factory.EVENT_PRIORITY_HIGH = EVENT_PRIORITY_HIGH;
_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].updateSingletonFactory(EventBus.__dashjs_factory_name, factory);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/FactoryMaker.js":
/*!**********************************!*\
  !*** ./src/core/FactoryMaker.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @module FactoryMaker
 * @ignore
 */
var FactoryMaker = function () {
  var instance;
  var singletonContexts = [];
  var singletonFactories = {};
  var classFactories = {};

  function extend(name, childInstance, override, context) {
    if (!context[name] && childInstance) {
      context[name] = {
        instance: childInstance,
        override: override
      };
    }
  }
  /**
   * Use this method from your extended object.  this.factory is injected into your object.
   * this.factory.getSingletonInstance(this.context, 'VideoModel')
   * will return the video model for use in the extended object.
   *
   * @param {Object} context - injected into extended object as this.context
   * @param {string} className - string name found in all dash.js objects
   * with name __dashjs_factory_name Will be at the bottom. Will be the same as the object's name.
   * @returns {*} Context aware instance of specified singleton name.
   * @memberof module:FactoryMaker
   * @instance
   */


  function getSingletonInstance(context, className) {
    for (var i in singletonContexts) {
      var obj = singletonContexts[i];

      if (obj.context === context && obj.name === className) {
        return obj.instance;
      }
    }

    return null;
  }
  /**
   * Use this method to add an singleton instance to the system.  Useful for unit testing to mock objects etc.
   *
   * @param {Object} context
   * @param {string} className
   * @param {Object} instance
   * @memberof module:FactoryMaker
   * @instance
   */


  function setSingletonInstance(context, className, instance) {
    for (var i in singletonContexts) {
      var obj = singletonContexts[i];

      if (obj.context === context && obj.name === className) {
        singletonContexts[i].instance = instance;
        return;
      }
    }

    singletonContexts.push({
      name: className,
      context: context,
      instance: instance
    });
  }
  /**
   * Use this method to remove all singleton instances associated with a particular context.
   *
   * @param {Object} context
   * @memberof module:FactoryMaker
   * @instance
   */


  function deleteSingletonInstances(context) {
    singletonContexts = singletonContexts.filter(function (x) {
      return x.context !== context;
    });
  }
  /*------------------------------------------------------------------------------------------*/
  // Factories storage Management

  /*------------------------------------------------------------------------------------------*/


  function getFactoryByName(name, factoriesArray) {
    return factoriesArray[name];
  }

  function updateFactory(name, factory, factoriesArray) {
    if (name in factoriesArray) {
      factoriesArray[name] = factory;
    }
  }
  /*------------------------------------------------------------------------------------------*/
  // Class Factories Management

  /*------------------------------------------------------------------------------------------*/


  function updateClassFactory(name, factory) {
    updateFactory(name, factory, classFactories);
  }

  function getClassFactoryByName(name) {
    return getFactoryByName(name, classFactories);
  }

  function getClassFactory(classConstructor) {
    var factory = getFactoryByName(classConstructor.__dashjs_factory_name, classFactories);

    if (!factory) {
      factory = function factory(context) {
        if (context === undefined) {
          context = {};
        }

        return {
          create: function create() {
            return merge(classConstructor, context, arguments);
          }
        };
      };

      classFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }

    return factory;
  }
  /*------------------------------------------------------------------------------------------*/
  // Singleton Factory MAangement

  /*------------------------------------------------------------------------------------------*/


  function updateSingletonFactory(name, factory) {
    updateFactory(name, factory, singletonFactories);
  }

  function getSingletonFactoryByName(name) {
    return getFactoryByName(name, singletonFactories);
  }

  function getSingletonFactory(classConstructor) {
    var factory = getFactoryByName(classConstructor.__dashjs_factory_name, singletonFactories);

    if (!factory) {
      factory = function factory(context) {
        var instance;

        if (context === undefined) {
          context = {};
        }

        return {
          getInstance: function getInstance() {
            // If we don't have an instance yet check for one on the context
            if (!instance) {
              instance = getSingletonInstance(context, classConstructor.__dashjs_factory_name);
            } // If there's no instance on the context then create one


            if (!instance) {
              instance = merge(classConstructor, context, arguments);
              singletonContexts.push({
                name: classConstructor.__dashjs_factory_name,
                context: context,
                instance: instance
              });
            }

            return instance;
          }
        };
      };

      singletonFactories[classConstructor.__dashjs_factory_name] = factory; // store factory
    }

    return factory;
  }

  function merge(classConstructor, context, args) {
    var classInstance;
    var className = classConstructor.__dashjs_factory_name;
    var extensionObject = context[className];

    if (extensionObject) {
      var extension = extensionObject.instance;

      if (extensionObject.override) {
        //Override public methods in parent but keep parent.
        classInstance = classConstructor.apply({
          context: context
        }, args);
        extension = extension.apply({
          context: context,
          factory: instance,
          parent: classInstance
        }, args);

        for (var prop in extension) {
          if (classInstance.hasOwnProperty(prop)) {
            classInstance[prop] = extension[prop];
          }
        }
      } else {
        //replace parent object completely with new object. Same as dijon.
        return extension.apply({
          context: context,
          factory: instance
        }, args);
      }
    } else {
      // Create new instance of the class
      classInstance = classConstructor.apply({
        context: context
      }, args);
    } // Add getClassName function to class instance prototype (used by Debug)


    classInstance.getClassName = function () {
      return className;
    };

    return classInstance;
  }

  instance = {
    extend: extend,
    getSingletonInstance: getSingletonInstance,
    setSingletonInstance: setSingletonInstance,
    deleteSingletonInstances: deleteSingletonInstances,
    getSingletonFactory: getSingletonFactory,
    getSingletonFactoryByName: getSingletonFactoryByName,
    updateSingletonFactory: updateSingletonFactory,
    getClassFactory: getClassFactory,
    getClassFactoryByName: getClassFactoryByName,
    updateClassFactory: updateClassFactory
  };
  return instance;
}();

/* harmony default export */ __webpack_exports__["default"] = (FactoryMaker);

/***/ }),

/***/ "./src/core/Settings.js":
/*!******************************!*\
  !*** ./src/core/Settings.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _Utils_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./Utils.js */ "./src/core/Utils.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _events_Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./events/Events */ "./src/core/events/Events.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */







/** @module Settings
 * @description Define the configuration parameters of Dash.js MediaPlayer.
 * @see {@link module:Settings~PlayerSettings PlayerSettings} for further information about the supported configuration properties.
 */

/**
 * @typedef {Object} PlayerSettings
 * @property {module:Settings~DebugSettings} [debug]
 * Debug related settings.
 * @property {module:Settings~ErrorSettings} [errors]
 * Error related settings
 * @property {module:Settings~StreamingSettings} [streaming]
 * Streaming related settings.
 * @example
 *
 * // Full settings object
 * settings = {
 *        debug: {
 *            logLevel: Debug.LOG_LEVEL_WARNING,
 *            dispatchEvent: false
 *        },
 *        streaming: {
 *            abandonLoadTimeout: 10000,
 *            wallclockTimeUpdateInterval: 100,
 *            manifestUpdateRetryInterval: 100,
 *            liveUpdateTimeThresholdInMilliseconds: 0,
 *            cacheInitSegments: false,
 *            applyServiceDescription: true,
 *            applyProducerReferenceTime: true,
 *            applyContentSteering: true,
 *            eventControllerRefreshDelay: 100,
 *            enableManifestDurationMismatchFix: true,
 *            enableManifestTimescaleMismatchFix: false,
 *            parseInbandPrft: false,
 *            capabilities: {
 *               filterUnsupportedEssentialProperties: true,
 *               useMediaCapabilitiesApi: false
 *            },
 *            timeShiftBuffer: {
 *                calcFromSegmentTimeline: false,
 *                fallbackToSegmentTimeline: true
 *            },
 *            metrics: {
 *              maxListDepth: 100
 *            },
 *            delay: {
 *                liveDelayFragmentCount: NaN,
 *                liveDelay: NaN,
 *                useSuggestedPresentationDelay: true
 *            },
 *            protection: {
 *                keepProtectionMediaKeys: false,
 *                ignoreEmeEncryptedEvent: false,
 *                detectPlayreadyMessageFormat: true,
 *            },
 *            buffer: {
 *                enableSeekDecorrelationFix: false,
 *                fastSwitchEnabled: true,
 *                flushBufferAtTrackSwitch: false,
 *                reuseExistingSourceBuffers: true,
 *                bufferPruningInterval: 10,
 *                bufferToKeep: 20,
 *                bufferTimeAtTopQuality: 30,
 *                bufferTimeAtTopQualityLongForm: 60,
 *                initialBufferLevel: NaN,
 *                stableBufferTime: 12,
 *                longFormContentDurationThreshold: 600,
 *                stallThreshold: 0.3,
 *                useAppendWindow: true,
 *                setStallState: true,
 *                avoidCurrentTimeRangePruning: false,
 *                useChangeTypeForTrackSwitch: true,
 *                mediaSourceDurationInfinity: true,
 *                resetSourceBuffersForTrackSwitch: false
 *            },
 *            gaps: {
 *                jumpGaps: true,
 *                jumpLargeGaps: true,
 *                smallGapLimit: 1.5,
 *                threshold: 0.3,
 *                enableSeekFix: true,
 *                enableStallFix: false,
 *                stallSeek: 0.1
 *            },
 *            utcSynchronization: {
 *                enabled: true,
 *                useManifestDateHeaderTimeSource: true,
 *                backgroundAttempts: 2,
 *                timeBetweenSyncAttempts: 30,
 *                maximumTimeBetweenSyncAttempts: 600,
 *                minimumTimeBetweenSyncAttempts: 2,
 *                timeBetweenSyncAttemptsAdjustmentFactor: 2,
 *                maximumAllowedDrift: 100,
 *                enableBackgroundSyncAfterSegmentDownloadError: true,
 *                defaultTimingSource: {
 *                    scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
 *                    value: 'http://time.akamai.com/?iso&ms'
 *                }
 *            },
 *            scheduling: {
 *                defaultTimeout: 500,
 *                lowLatencyTimeout: 0,
 *                scheduleWhilePaused: true
 *            },
 *            text: {
 *                defaultEnabled: true,
 *                dispatchForManualRendering: false,
 *                extendSegmentedCues: true,
 *                imsc: {
 *                    displayForcedOnlyMode: false,
 *                    enableRollUp: true
 *                },
 *                webvtt: {
 *                    customRenderingEnabled: false
 *                }
 *            },
 *            liveCatchup: {
 *                maxDrift: NaN,
 *                playbackRate: {min: NaN, max: NaN},
 *                playbackBufferMin: 0.5,
 *                enabled: null,
 *                mode: Constants.LIVE_CATCHUP_MODE_DEFAULT
 *            },
 *            lastBitrateCachingInfo: { enabled: true, ttl: 360000 },
 *            lastMediaSettingsCachingInfo: { enabled: true, ttl: 360000 },
 *            saveLastMediaSettingsForCurrentStreamingSession: true,
 *            cacheLoadThresholds: { video: 50, audio: 5 },
 *            trackSwitchMode: {
 *                audio: Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE,
 *                video: Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 *            },
 *            selectionModeForInitialTrack: Constants.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY,
 *            fragmentRequestTimeout: 20000,
 *            fragmentRequestProgressTimeout: -1,
 *            manifestRequestTimeout: 10000,
 *            retryIntervals: {
 *                [HTTPRequest.MPD_TYPE]: 500,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 500,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 1000,
 *                [HTTPRequest.LICENSE]: 1000,
 *                [HTTPRequest.OTHER_TYPE]: 1000,
 *                lowLatencyReductionFactor: 10
 *            },
 *            retryAttempts: {
 *                [HTTPRequest.MPD_TYPE]: 3,
 *                [HTTPRequest.XLINK_EXPANSION_TYPE]: 1,
 *                [HTTPRequest.MEDIA_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INIT_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.INDEX_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE]: 3,
 *                [HTTPRequest.LICENSE]: 3,
 *                [HTTPRequest.OTHER_TYPE]: 3,
 *                lowLatencyMultiplyFactor: 5
 *            },
 *            abr: {
 *                movingAverageMethod: Constants.MOVING_AVERAGE_SLIDING_WINDOW,
 *                ABRStrategy: Constants.ABR_STRATEGY_DYNAMIC,
 *                additionalAbrRules: {
 *                   insufficientBufferRule: true,
 *                   switchHistoryRule: true,
 *                   droppedFramesRule: true,
 *                   abandonRequestsRule: true
 *                },
 *                abrRulesParameters: {
 *                     abandonRequestsRule: {
 *                         graceTimeThreshold: 500,
 *                         abandonMultiplier: 1.8,
 *                         minLengthToAverage: 5
 *                     }
 *                 },
 *                bandwidthSafetyFactor: 0.9,
 *                useDefaultABRRules: true,
 *                useDeadTimeLatency: true,
 *                limitBitrateByPortal: false,
 *                usePixelRatioInLimitBitrateByPortal: false,
 *                maxBitrate: { audio: -1, video: -1 },
 *                minBitrate: { audio: -1, video: -1 },
 *                maxRepresentationRatio: { audio: 1, video: 1 },
 *                initialBitrate: { audio: -1, video: -1 },
 *                initialRepresentationRatio: { audio: -1, video: -1 },
 *                autoSwitchBitrate: { audio: true, video: true },
 *                fetchThroughputCalculationMode: Constants.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA
 *            },
 *            cmcd: {
 *                enabled: false,
 *                sid: null,
 *                cid: null,
 *                rtp: null,
 *                rtpSafetyFactor: 5,
 *                mode: Constants.CMCD_MODE_QUERY,
 *                enabledKeys: ['br', 'd', 'ot', 'tb' , 'bl', 'dl', 'mtp', 'nor', 'nrr', 'su' , 'bs', 'rtp' , 'cid', 'pr', 'sf', 'sid', 'st', 'v']
 *            },
 *            cmsd: {
 *                enabled: false,
 *                abr: {
 *                    applyMb: false,
 *                    etpWeightRatio: 0
 *                }
 *           }
 *          },
 *          errors: {
 *            recoverAttempts: {
 *                mediaErrorDecode: 5
 *             }
 *          }
 * }
 */

/**
 * @typedef {Object} TimeShiftBuffer
 * @property {boolean} [calcFromSegmentTimeline=false]
 * Enable calculation of the DVR window for SegmentTimeline manifests based on the entries in \<SegmentTimeline\>.
 *  * @property {boolean} [fallbackToSegmentTimeline=true]
 * In case the MPD uses \<SegmentTimeline\ and no segment is found within the DVR window the DVR window is calculated based on the entries in \<SegmentTimeline\>.
 */

/**
 * @typedef {Object} LiveDelay
 * @property {number} [liveDelayFragmentCount=NaN]
 * Changing this value will lower or increase live stream latency.
 *
 * The detected segment duration will be multiplied by this value to define a time in seconds to delay a live stream from the live edge.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 * @property {number} [liveDelay=NaN]
 * Equivalent in seconds of setLiveDelayFragmentCount.
 *
 * Lowering this value will lower latency but may decrease the player's ability to build a stable buffer.
 *
 * This value should be less than the manifest duration by a couple of segment durations to avoid playback issues.
 *
 * If set, this parameter will take precedence over setLiveDelayFragmentCount and manifest info.
 * @property {boolean} [useSuggestedPresentationDelay=true]
 * Set to true if you would like to overwrite the default live delay and honor the SuggestedPresentationDelay attribute in by the manifest.
 */

/**
 * @typedef {Object} Buffer
 * @property {boolean} [enableSeekDecorrelationFix=false]
 * Enables a workaround for playback start on some devices, e.g. WebOS 4.9.
 * It is necessary because some browsers do not support setting currentTime on video element to a value that is outside of current buffer.
 *
 * If you experience unexpected seeking triggered by BufferController, you can try setting this value to false.

 * @property {boolean} [fastSwitchEnabled=true]
 * When enabled, after an ABR up-switch in quality, instead of requesting and appending the next fragment at the end of the current buffer range it is requested and appended closer to the current time.
 *
 * When enabled, The maximum time to render a higher quality is current time + (1.5 * fragment duration).
 *
 * Note, When ABR down-switch is detected, we appended the lower quality at the end of the buffer range to preserve the
 * higher quality media for as long as possible.
 *
 * If enabled, it should be noted there are a few cases when the client will not replace inside buffer range but rather just append at the end.
 * 1. When the buffer level is less than one fragment duration.
 * 2. The client is in an Abandonment State due to recent fragment abandonment event.
 *
 * Known issues:
 * 1. In IE11 with auto switching off, if a user switches to a quality they can not download in time the fragment may be appended in the same range as the playhead or even in the past, in IE11 it may cause a stutter or stall in playback.
 * @property {boolean} [flushBufferAtTrackSwitch=false]
 * When enabled, after a track switch and in case buffer is being replaced, the video element is flushed (seek at current playback time) once a segment of the new track is appended in buffer in order to force video decoder to play new track.
 *
 * This can be required on some devices like GoogleCast devices to make track switching functional.
 *
 * Otherwise track switching will be effective only once after previous buffered track is fully consumed.
 * @property {boolean} [reuseExistingSourceBuffers=true]
 * Enable reuse of existing MediaSource Sourcebuffers during period transition.
 * @property {number} [bufferPruningInterval=10]
 * The interval of pruning buffer in seconds.
 * @property {number} [bufferToKeep=20]
 * This value influences the buffer pruning logic.
 *
 * Allows you to modify the buffer that is kept in source buffer in seconds.
 * 0|-----------bufferToPrune-----------|-----bufferToKeep-----|currentTime|
 * @property {number} [bufferTimeAtTopQuality=30]
 * The time that the internal buffer target will be set to once playing the top quality.
 *
 * If there are multiple bitrates in your adaptation, and the media is playing at the highest bitrate, then we try to build a larger buffer at the top quality to increase stability and to maintain media quality.
 * @property {number} [bufferTimeAtTopQualityLongForm=60]
 * The time that the internal buffer target will be set to once playing the top quality for long form content.
 * @property {number} [longFormContentDurationThreshold=600]
 * The threshold which defines if the media is considered long form content.
 *
 * This will directly affect the buffer targets when playing back at the top quality.
 * @property {number} [initialBufferLevel=NaN]
 * Initial buffer level before playback starts
 * @property {number} [stableBufferTime=12]
 * The time that the internal buffer target will be set to post startup/seeks (NOT top quality).
 *
 * When the time is set higher than the default you will have to wait longer to see automatic bitrate switches but will have a larger buffer which will increase stability.
 * @property {number} [stallThreshold=0.3]
 * Stall threshold used in BufferController.js to determine whether a track should still be changed and which buffer range to prune.
 * @property {boolean} [useAppendWindow=true]
 * Specifies if the appendWindow attributes of the MSE SourceBuffers should be set according to content duration from manifest.
 * @property {boolean} [setStallState=true]
 * Specifies if we fire manual waiting events once the stall threshold is reached
 * @property {boolean} [avoidCurrentTimeRangePruning=false]
 * Avoids pruning of the buffered range that contains the current playback time.
 *
 * That buffered range is likely to have been enqueued for playback. Pruning it causes a flush and reenqueue in WPE and WebKitGTK based browsers. This stresses the video decoder and can cause stuttering on embedded platforms.
 * @property {boolean} [useChangeTypeForTrackSwitch=true]
 * If this flag is set to true then dash.js will use the MSE v.2 API call "changeType()" before switching to a different track.
 * Note that some platforms might not implement the changeType functio. dash.js is checking for the availability before trying to call it.
 * @property {boolean} [mediaSourceDurationInfinity=true]
 * If this flag is set to true then dash.js will allow `Infinity` to be set as the MediaSource duration otherwise the duration will be set to `Math.pow(2,32)` instead of `Infinity` to allow appending segments indefinitely.
 * Some platforms such as WebOS 4.x have issues with seeking when duration is set to `Infinity`, setting this flag to false resolve this.
 * @property {boolean} [resetSourceBuffersForTrackSwitch=false]
 * When switching to a track that is not compatible with the currently active MSE SourceBuffers, MSE will be reset. This happens when we switch codecs on a system
 * that does not properly implement "changeType()", such as webOS 4.0 and before.
 */

/**
 * @typedef {Object} module:Settings~AudioVideoSettings
 * @property {number|boolean|string} [audio]
 * Configuration for audio media type of tracks.
 * @property {number|boolean|string} [video]
 * Configuration for video media type of tracks.
 */

/**
 * @typedef {Object} DebugSettings
 * @property {number} [logLevel=dashjs.Debug.LOG_LEVEL_WARNING]
 * Sets up the log level. The levels are cumulative.
 *
 * For example, if you set the log level to dashjs.Debug.LOG_LEVEL_WARNING all warnings, errors and fatals will be logged.
 *
 * Possible values.
 *
 * - dashjs.Debug.LOG_LEVEL_NONE
 * No message is written in the browser console.
 *
 * - dashjs.Debug.LOG_LEVEL_FATAL
 * Log fatal errors.
 * An error is considered fatal when it causes playback to fail completely.
 *
 * - dashjs.Debug.LOG_LEVEL_ERROR
 * Log error messages.
 *
 * - dashjs.Debug.LOG_LEVEL_WARNING
 * Log warning messages.
 *
 * - dashjs.Debug.LOG_LEVEL_INFO
 * Log info messages.
 *
 * - dashjs.Debug.LOG_LEVEL_DEBUG
 * Log debug messages.
 * @property {boolean} [dispatchEvent=false]
 * Enable to trigger a Events.LOG event whenever log output is generated.
 *
 * Note this will be dispatched regardless of log level.
 */

/**
 * @typedef {Object} module:Settings~ErrorSettings
 * @property {object} [recoverAttempts={mediaErrorDecode: 5}]
 * Defines the maximum number of recover attempts for specific media errors.
 *
 * For mediaErrorDecode the player will reset the MSE and skip the blacklisted segment that caused the decode error. The resulting gap will be handled by the GapController.
 */

/**
 * @typedef {Object} CachingInfoSettings
 * @property {boolean} [enable]
 * Enable or disable the caching feature.
 * @property {number} [ttl]
 * Time to live.
 *
 * A value defined in milliseconds representing how log to cache the settings for.
 */

/**
 * @typedef {Object} Gaps
 * @property {boolean} [jumpGaps=true]
 * Sets whether player should jump small gaps (discontinuities) in the buffer.
 * @property {boolean} [jumpLargeGaps=true]
 * Sets whether player should jump large gaps (discontinuities) in the buffer.
 * @property {number} [smallGapLimit=1.5]
 * Time in seconds for a gap to be considered small.
 * @property {number} [threshold=0.3]
 * Threshold at which the gap handling is executed. If currentRangeEnd - currentTime < threshold the gap jump will be triggered.
 * For live stream the jump might be delayed to keep a consistent live edge.
 * Note that the amount of buffer at which platforms automatically stall might differ.
 * @property {boolean} [enableSeekFix=true]
 * Enables the adjustment of the seek target once no valid segment request could be generated for a specific seek time. This can happen if the user seeks to a position for which there is a gap in the timeline.
 * @property {boolean} [enableStallFix=false]
 * If playback stalled in a buffered range this fix will perform a seek by the value defined in stallSeek to trigger playback again.
 * @property {number} [stallSeek=0.1]
 * Value to be used in case enableStallFix is set to true
 */

/**
 * @typedef {Object} UtcSynchronizationSettings
 * @property {boolean} [enabled=true]
 * Enables or disables the UTC clock synchronization
 * @property {boolean} [useManifestDateHeaderTimeSource=true]
 * Allows you to enable the use of the Date Header, if exposed with CORS, as a timing source for live edge detection.
 *
 * The use of the date header will happen only after the other timing source that take precedence fail or are omitted as described.
 * @property {number} [backgroundAttempts=2]
 * Number of synchronization attempts to perform in the background after an initial synchronization request has been done. This is used to verify that the derived client-server offset is correct.
 *
 * The background requests are async and done in parallel to the start of the playback.
 *
 * This value is also used to perform a resync after 404 errors on segments.
 * @property {number} [timeBetweenSyncAttempts=30]
 * The time in seconds between two consecutive sync attempts.
 *
 * Note: This value is used as an initial starting value. The internal value of the TimeSyncController is adjusted during playback based on the drift between two consecutive synchronization attempts.
 *
 * Note: A sync is only performed after an MPD update. In case the @minimumUpdatePeriod is larger than this value the sync will be delayed until the next MPD update.
 * @property {number} [maximumTimeBetweenSyncAttempts=600]
 * The maximum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [minimumTimeBetweenSyncAttempts=2]
 * The minimum time in seconds between two consecutive sync attempts.
 *
 * @property {number} [timeBetweenSyncAttemptsAdjustmentFactor=2]
 * The factor used to multiply or divide the timeBetweenSyncAttempts parameter after a sync. The maximumAllowedDrift defines whether this value is used as a factor or a dividend.
 *
 * @property {number} [maximumAllowedDrift=100]
 * The maximum allowed drift specified in milliseconds between two consecutive synchronization attempts.
 *
 * @property {boolean} [enableBackgroundSyncAfterSegmentDownloadError=true]
 * Enables or disables the background sync after the player ran into a segment download error.
 *
 * @property {object} [defaultTimingSource={scheme:'urn:mpeg:dash:utc:http-xsdate:2014',value: 'http://time.akamai.com/?iso&ms'}]
 * The default timing source to be used. The timing sources in the MPD take precedence over this one.
 */

/**
 * @typedef {Object} Scheduling
 * @property {number} [defaultTimeout=500]
 * Default timeout between two consecutive segment scheduling attempts
 * @property {number} [lowLatencyTimeout=0]
 * Default timeout between two consecutive low-latency segment scheduling attempts
 * @property {boolean} [scheduleWhilePaused=true]
 * Set to true if you would like dash.js to keep downloading fragments in the background when the video element is paused.
 */

/**
 * @typedef {Object} Text
 * @property {boolean} [defaultEnabled=true]
 * Enable/disable subtitle rendering by default.
 * @property {boolean} [dispatchForManualRendering=false]
 * Enable/disable firing of CueEnter/CueExt events. This will disable the display of subtitles and should be used when you want to have full control about rendering them.
 * @property {boolean} [extendSegmentedCues=true]
 * Enable/disable patching of segmented cues in order to merge as a single cue by extending cue end time.
 * @property {boolean} [imsc.displayForcedOnlyMode=false]
 * Enable/disable forced only mode in IMSC captions.
 * When true, only those captions where itts:forcedDisplay="true" will be displayed.
 * @property {boolean} [imsc.enableRollUp=true]
 * Enable/disable rollUp style display of IMSC captions.
 * @property {object} [webvtt.customRenderingEnabled=false]
 * Enables the custom rendering for WebVTT captions. For details refer to the "Subtitles and Captions" sample section of dash.js.
 * Custom WebVTT rendering requires the external library vtt.js that can be found in the contrib folder.
 */

/**
 * @typedef {Object} LiveCatchupSettings
 * @property {number} [maxDrift=NaN]
 * Use this method to set the maximum latency deviation allowed before dash.js to do a seeking to live position.
 *
 * In low latency mode, when the difference between the measured latency and the target one, as an absolute number, is higher than the one sets with this method, then dash.js does a seek to live edge position minus the target live delay.
 *
 * LowLatencyMaxDriftBeforeSeeking should be provided in seconds.
 *
 * If 0, then seeking operations won't be used for fixing latency deviations.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackRate={min: NaN, max: NaN}]
 * Use this parameter to set the minimum and maximum catch up rates, as percentages, for low latency live streams.
 *
 * In low latency mode, when measured latency is higher/lower than the target one, dash.js increases/decreases playback rate respectively up to (+/-) the percentage defined with this method until target is reached.
 *
 * Valid values for min catch up rate are in the range -0.5 to 0 (-50% to 0% playback rate decrease)
 *
 * Valid values for max catch up rate are in the range 0 to 1 (0% to 100% playback rate increase).
 *
 * Set min and max to NaN to turn off live catch up feature.
 *
 * These playback rate limits take precedence over any PlaybackRate values in ServiceDescription elements in an MPD. If only one of the min/max properties is given a value, the property without a value will not fall back to a ServiceDescription value. Its default value of NaN will be used.
 *
 * Note: Catch-up mechanism is only applied when playing low latency live streams.
 * @property {number} [playbackBufferMin=0.5]
 * Use this parameter to specify the minimum buffer which is used for LoL+ based playback rate reduction.
 *
 *
 * @property {boolean} [enabled=null]
 * Use this parameter to enable the catchup mode for non low-latency streams.
 *
 * @property {string} [mode="liveCatchupModeDefault"]
 * Use this parameter to switch between different catchup modes.
 *
 * Options: "liveCatchupModeDefault" or "liveCatchupModeLOLP".
 *
 * Note: Catch-up mechanism is automatically applied when playing low latency live streams.
 */

/**
 * @typedef {Object} RequestTypeSettings
 * @property {number} [MPD]
 * Manifest type of requests.
 * @property {number} [XLinkExpansion]
 * XLink expansion type of requests.
 * @property {number} [InitializationSegment]
 * Request to retrieve an initialization segment.
 * @property {number} [IndexSegment]
 * Request to retrieve an index segment (SegmentBase).
 * @property {number} [MediaSegment]
 * Request to retrieve a media segment (video/audio/image/text chunk).
 * @property {number} [BitstreamSwitchingSegment]
 * Bitrate stream switching type of request.
 * @property {number} [FragmentInfoSegment]
 * Request to retrieve a FragmentInfo segment (specific to Smooth Streaming live streams).
 * @property {number} [other]
 * Other type of request.
 * @property {number} [lowLatencyReductionFactor]
 * For low latency mode, values of type of request are divided by lowLatencyReductionFactor.
 *
 * Note: It's not type of request.
 * @property {number} [lowLatencyMultiplyFactor]
 * For low latency mode, values of type of request are multiplied by lowLatencyMultiplyFactor.
 *
 * Note: It's not type of request.
 */

/**
 * @typedef {Object} Protection
 * @property {boolean} [keepProtectionMediaKeys=false]
 * Set the value for the ProtectionController and MediaKeys life cycle.
 *
 * If true, the ProtectionController and then created MediaKeys and MediaKeySessions will be preserved during the MediaPlayer lifetime.
 * @property {boolean} [ignoreEmeEncryptedEvent=false]
 * If set to true the player will ignore "encrypted" and "needkey" events thrown by the EME.
 *
 * @property {boolean} [detectPlayreadyMessageFormat=true]
 * If set to true the player will use the raw unwrapped message from the Playready CDM
 */

/**
 * @typedef {Object} Capabilities
 * @property {boolean} [filterUnsupportedEssentialProperties=true]
 * Enable to filter all the AdaptationSets and Representations which contain an unsupported \<EssentialProperty\> element.
 * @property {boolean} [useMediaCapabilitiesApi=false]
 * Enable to use the MediaCapabilities API to check whether codecs are supported. If disabled MSE.isTypeSupported will be used instead.
 */

/**
 * @typedef {Object} AbrRulesParameters
 * @property {module:Settings~AbandonRequestRuleParameters} abandonRequestRule
 * Configuration parameters for the AbandonRequestRule
 */

/**
 * @typedef {Object} AbandonRequestRuleParameters
 * @property {number} [graceTimeThreshold=500]
 * Minimum elapsed time in milliseconds that the segment download has to run before the rule considers abandoning the download.
 * @property {number} [abandonMultiplier]
 * This value is multiplied with the segment duration and compared to the estimated time of the download to decide the request should be abandoned.
 * @property {number} [minLengthToAverage]
 * Minimum number of throughput samples required to consider abandoning the download of the segment.
 */

/**
 * @typedef {Object} AbrSettings
 * @property {string} [movingAverageMethod="slidingWindow"]
 * Sets the moving average method used for smoothing throughput estimates.
 *
 * Valid methods are "slidingWindow" and "ewma".
 *
 * The call has no effect if an invalid method is passed.
 *
 * The sliding window moving average method computes the average throughput using the last four segments downloaded.
 *
 * If the stream is live (as opposed to VOD), then only the last three segments are used.
 *
 * If wide variations in throughput are detected, the number of segments can be dynamically increased to avoid oscillations.
 *
 * The exponentially weighted moving average (EWMA) method computes the average using exponential smoothing.
 *
 * Two separate estimates are maintained, a fast one with a three-second half life and a slow one with an eight-second half life.
 *
 * The throughput estimate at any time is the minimum of the fast and slow estimates.
 *
 * This allows a fast reaction to a bandwidth drop and prevents oscillations on bandwidth spikes.
 * @property {string} [ABRStrategy="abrDynamic"]
 * Returns the current ABR strategy being used: "abrDynamic", "abrBola" or "abrThroughput".
 * @property {object} [trackSwitchMode={video: "neverReplace", audio: "alwaysReplace"}]
 * @property {object} [additionalAbrRules={insufficientBufferRule: true,switchHistoryRule: true,droppedFramesRule: true,abandonRequestsRule: true}]
 * Enable/Disable additional ABR rules in case ABRStrategy is set to "abrDynamic", "abrBola" or "abrThroughput".
 * @property {module:Settings~AbrRulesParameters} abrRulesParameters Configuration options for the different ABR rules
 * @property {number} [bandwidthSafetyFactor=0.9]
 * Standard ABR throughput rules multiply the throughput by this value.
 *
 * It should be between 0 and 1, with lower values giving less rebuffering (but also lower quality).
 * @property {boolean} [useDefaultABRRules=true]
 * Should the default ABR rules be used, or the custom ones added.
 * @property {boolean} [useDeadTimeLatency=true]
 * If true, only the download portion will be considered part of the download bitrate and latency will be regarded as static.
 *
 * If false, the reciprocal of the whole transfer time will be used.
 * @property {boolean} [limitBitrateByPortal=false]
 * If true, the size of the video portal will limit the max chosen video resolution.
 * @property {boolean} [usePixelRatioInLimitBitrateByPortal=false]
 * Sets whether to take into account the device's pixel ratio when defining the portal dimensions.
 *
 * Useful on, for example, retina displays.
 * @property {module:Settings~AudioVideoSettings} [maxBitrate={audio: -1, video: -1}]
 * The maximum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [minBitrate={audio: -1, video: -1}]
 * The minimum bitrate that the ABR algorithms will choose. This value is specified in kbps.
 *
 * Use -1 for no limit.
 * @property {module:Settings~AudioVideoSettings} [maxRepresentationRatio={audio: 1, video: 1}]
 * When switching multi-bitrate content (auto or manual mode) this property specifies the maximum representation allowed, as a proportion of the size of the representation set.
 *
 * You can set or remove this cap at anytime before or during playback.
 *
 * To clear this setting you set the value to 1.
 *
 * If both this and maxAllowedBitrate are defined, maxAllowedBitrate is evaluated first, then maxAllowedRepresentation, i.e. the lowest value from executing these rules is used.
 *
 * This feature is typically used to reserve higher representations for playback only when connected over a fast connection.
 * @property {module:Settings~AudioVideoSettings} [initialBitrate={audio: -1, video: -1}]
 * Explicitly set the starting bitrate for audio or video. This value is specified in kbps.
 *
 * Use -1 to let the player decide.
 * @property {module:Settings~AudioVideoSettings} [initialRepresentationRatio={audio: -1, video: -1}]
 * Explicitly set the initial representation ratio.
 *
 * If initalBitrate is specified, this is ignored.
 * @property {module:Settings~AudioVideoSettings} [autoSwitchBitrate={audio: true, video: true}]
 * Indicates whether the player should enable ABR algorithms to switch the bitrate.
 *
 * @property {string} [fetchThroughputCalculationMode="abrFetchThroughputCalculationDownloadedData"]
 * Algorithm to determine the throughput in case the Fetch API is used for low latency streaming.
 *
 * For details please check the samples section and FetchLoader.js.
 */

/**
 * @typedef {Object} module:Settings~CmcdSettings
 * @property {boolean} [enable=false]
 * Enable or disable the CMCD reporting.
 * @property {string} [sid]
 * GUID identifying the current playback session.
 *
 * Should be in UUID format.
 *
 * If not specified a UUID will be automatically generated.
 * @property {string} [cid]
 * A unique string to identify the current content.
 *
 * If not specified it will be a hash of the MPD url.
 * @property {number} [rtp]
 * The requested maximum throughput that the client considers sufficient for delivery of the asset.
 *
 * If not specified this value will be dynamically calculated in the CMCDModel based on the current buffer level.
 * @property {number} [rtpSafetyFactor=5]
 * This value is used as a factor for the rtp value calculation: rtp = minBandwidth * rtpSafetyFactor
 *
 * If not specified this value defaults to 5. Note that this value is only used when no static rtp value is defined.
 * @property {number} [mode="query"]
 * The method to use to attach cmcd metrics to the requests. 'query' to use query parameters, 'header' to use http headers.
 *
 * If not specified this value defaults to 'query'.
 * @property {Array.<string>} [enabledKeys]
 * This value is used to specify the desired CMCD parameters. Parameters not included in this list are not reported.
 */

/**
 * @typedef {Object} module:Settings~CmsdSettings
 * @property {boolean} [enabled=false]
 * Enable or disable the CMSD response headers parsing.
 * @property {module:Settings~CmsdAbrSettings} [abr]
 * Sets additional ABR rules based on CMSD response headers.
 */

/**
 * @typedef {Object} CmsdAbrSettings
 * @property {boolean} [applyMb=false]
 * Set to true if dash.js should apply CMSD maximum suggested bitrate in ABR logic.
 * @property {number} [etpWeightRatio=0]
 * Sets the weight ratio (between 0 and 1) that shall be applied on CMSD estimated throuhgput compared to measured throughput when calculating throughput.
 */

/**
 * @typedef {Object} Metrics
 * @property {number} [metricsMaxListDepth=100]
 * Maximum number of metrics that are persisted per type.
 */

/**
 * @typedef {Object} StreamingSettings
 * @property {number} [abandonLoadTimeout=10000]
 * A timeout value in seconds, which during the ABRController will block switch-up events.
 *
 * This will only take effect after an abandoned fragment event occurs.
 * @property {number} [wallclockTimeUpdateInterval=100]
 * How frequently the wallclockTimeUpdated internal event is triggered (in milliseconds).
 * @property {number} [manifestUpdateRetryInterval=100]
 * For live streams, set the interval-frequency in milliseconds at which dash.js will check if the current manifest is still processed before downloading the next manifest once the minimumUpdatePeriod time has.
 * @property {number} [liveUpdateTimeThresholdInMilliseconds=0]
 * For live streams, postpone syncing time updates until the threshold is passed. Increase if problems occurs during live streams on low end devices.
 * @property {boolean} [cacheInitSegments=false]
 * Enables the caching of init segments to avoid requesting the init segments before each representation switch.
 * @property {boolean} [applyServiceDescription=true]
 * Set to true if dash.js should use the parameters defined in ServiceDescription elements
 * @property {boolean} [applyProducerReferenceTime=true]
 * Set to true if dash.js should use the parameters defined in ProducerReferenceTime elements in combination with ServiceDescription elements.
 * @property {boolean} [applyContentSteering=true]
 * Set to true if dash.js should apply content steering during playback.
 * @property {number} [eventControllerRefreshDelay=100]
 * For multi-period streams, overwrite the manifest mediaPresentationDuration attribute with the sum of period durations if the manifest mediaPresentationDuration is greater than the sum of period durations
 * @property {boolean} [enableManifestDurationMismatchFix=true]
 * Overwrite the manifest segments base information timescale attributes with the timescale set in initialization segments
 * @property {boolean} [enableManifestTimescaleMismatchFix=false]
 * Defines the delay in milliseconds between two consecutive checks for events to be fired.
 * @property {boolean} [parseInbandPrft=false]
 * Set to true if dash.js should parse inband prft boxes (ProducerReferenceTime) and trigger events.
 * @property {module:Settings~Metrics} metrics Metric settings
 * @property {module:Settings~LiveDelay} delay Live Delay settings
 * @property {module:Settings~TimeShiftBuffer} timeShiftBuffer TimeShiftBuffer settings
 * @property {module:Settings~Protection} protection DRM related settings
 * @property {module:Settings~Capabilities} capabilities Capability related settings
 * @property {module:Settings~Buffer}  buffer Buffer related settings
 * @property {module:Settings~Gaps}  gaps Gap related settings
 * @property {module:Settings~UtcSynchronizationSettings} utcSynchronization Settings related to UTC clock synchronization
 * @property {module:Settings~Scheduling} scheduling Settings related to segment scheduling
 * @property {module:Settings~Text} text Settings related to Subtitles and captions
 * @property {module:Settings~LiveCatchupSettings} liveCatchup  Settings related to live catchup.
 * @property {module:Settings~CachingInfoSettings} [lastBitrateCachingInfo={enabled: true, ttl: 360000}]
 * Set to false if you would like to disable the last known bit rate from being stored during playback and used to set the initial bit rate for subsequent playback within the expiration window.
 *
 * The default expiration is one hour, defined in milliseconds.
 *
 * If expired, the default initial bit rate (closest to 1000 kbps) will be used for that session and a new bit rate will be stored during that session.
 * @property {module:Settings~CachingInfoSettings} [lastMediaSettingsCachingInfo={enabled: true, ttl: 360000}]
 * Set to false if you would like to disable the last media settings from being stored to localStorage during playback and used to set the initial track for subsequent playback within the expiration window.
 *
 * The default expiration is one hour, defined in milliseconds.
 * @property {boolean} [saveLastMediaSettingsForCurrentStreamingSession=true]
 * Set to true if dash.js should save media settings from last selected track for incoming track selection during current streaming session.
 * @property {module:Settings~AudioVideoSettings} [cacheLoadThresholds={video: 50, audio: 5}]
 * For a given media type, the threshold which defines if the response to a fragment request is coming from browser cache or not.
 * @property {module:Settings~AudioVideoSettings} [trackSwitchMode={video: "neverReplace", audio: "alwaysReplace"}]
 * For a given media type defines if existing segments in the buffer should be overwritten once the track is switched. For instance if the user switches the audio language the existing segments in the audio buffer will be replaced when setting this value to "alwaysReplace".
 *
 * Possible values
 *
 * - Constants.TRACK_SWITCH_MODE_ALWAYS_REPLACE
 * Replace existing segments in the buffer
 *
 * - Constants.TRACK_SWITCH_MODE_NEVER_REPLACE
 * Do not replace existing segments in the buffer
 *
 * @property {string} [selectionModeForInitialTrack="highestSelectionPriority"]
 * Sets the selection mode for the initial track. This mode defines how the initial track will be selected if no initial media settings are set. If initial media settings are set this parameter will be ignored. Available options are:
 *
 * Possible values
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY
 * This mode makes the player select the track with the highest selectionPriority as defined in the manifest. If not selectionPriority is given we fallback to TRACK_SELECTION_MODE_HIGHEST_BITRATE. This mode is a default mode.
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_BITRATE
 * This mode makes the player select the track with a highest bitrate.
 *
 * - Constants.TRACK_SELECTION_MODE_FIRST_TRACK
 * This mode makes the player select the first track found in the manifest.
 *
 * - Constants.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY
 * This mode makes the player select the track with the lowest bitrate per pixel average.
 *
 * - Constants.TRACK_SELECTION_MODE_WIDEST_RANGE
 * This mode makes the player select the track with a widest range of bitrates.
 *
 *
 * @property {number} [fragmentRequestTimeout=20000]
 * Time in milliseconds before timing out on loading a media fragment.
 *
 * @property {number} [fragmentRequestProgressTimeout=-1]
 * Time in milliseconds before timing out on loading progress of a media fragment.
 *
 * @property {number} [manifestRequestTimeout=10000]
 * Time in milliseconds before timing out on loading a manifest.
 *
 * Fragments that timeout are retried as if they failed.
 * @property {module:Settings~RequestTypeSettings} [retryIntervals]
 * Time in milliseconds of which to reload a failed file load attempt.
 *
 * For low latency mode these values are divided by lowLatencyReductionFactor.
 * @property {module:Settings~RequestTypeSettings} [retryAttempts]
 * Total number of retry attempts that will occur on a file load before it fails.
 *
 * For low latency mode these values are multiplied by lowLatencyMultiplyFactor.
 * @property {module:Settings~AbrSettings} abr
 * Adaptive Bitrate algorithm related settings.
 * @property {module:Settings~CmcdSettings} cmcd
 * Settings related to Common Media Client Data reporting.
 * @property {module:Settings~CmsdSettings} cmsd
 * Settings related to Common Media Server Data parsing.
 */

/**
 * @class
 * @ignore
 */

function Settings() {
  var _retryIntervals, _retryAttempts;

  var instance;
  var context = this.context;
  var eventBus = (0,_EventBus__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  var DISPATCH_KEY_MAP = {
    'streaming.delay.liveDelay': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY,
    'streaming.delay.liveDelayFragmentCount': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT,
    'streaming.liveCatchup.enabled': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_CATCHUP_ENABLED,
    'streaming.liveCatchup.playbackRate.min': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MIN,
    'streaming.liveCatchup.playbackRate.max': _events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SETTING_UPDATED_PLAYBACK_RATE_MAX
  };
  /**
   * @const {PlayerSettings} defaultSettings
   * @ignore
   */

  var defaultSettings = {
    debug: {
      logLevel: _core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"].LOG_LEVEL_WARNING,
      dispatchEvent: false
    },
    streaming: {
      abandonLoadTimeout: 10000,
      wallclockTimeUpdateInterval: 100,
      manifestUpdateRetryInterval: 100,
      liveUpdateTimeThresholdInMilliseconds: 0,
      cacheInitSegments: false,
      applyServiceDescription: true,
      applyProducerReferenceTime: true,
      applyContentSteering: true,
      eventControllerRefreshDelay: 100,
      enableManifestDurationMismatchFix: true,
      parseInbandPrft: false,
      enableManifestTimescaleMismatchFix: false,
      capabilities: {
        filterUnsupportedEssentialProperties: true,
        useMediaCapabilitiesApi: false
      },
      timeShiftBuffer: {
        calcFromSegmentTimeline: false,
        fallbackToSegmentTimeline: true
      },
      metrics: {
        maxListDepth: 100
      },
      delay: {
        liveDelayFragmentCount: NaN,
        liveDelay: NaN,
        useSuggestedPresentationDelay: true
      },
      protection: {
        keepProtectionMediaKeys: false,
        ignoreEmeEncryptedEvent: false,
        detectPlayreadyMessageFormat: true
      },
      buffer: {
        enableSeekDecorrelationFix: false,
        fastSwitchEnabled: true,
        flushBufferAtTrackSwitch: false,
        reuseExistingSourceBuffers: true,
        bufferPruningInterval: 10,
        bufferToKeep: 20,
        bufferTimeAtTopQuality: 30,
        bufferTimeAtTopQualityLongForm: 60,
        initialBufferLevel: NaN,
        stableBufferTime: 12,
        longFormContentDurationThreshold: 600,
        stallThreshold: 0.3,
        useAppendWindow: true,
        setStallState: true,
        avoidCurrentTimeRangePruning: false,
        useChangeTypeForTrackSwitch: true,
        mediaSourceDurationInfinity: true,
        resetSourceBuffersForTrackSwitch: false
      },
      gaps: {
        jumpGaps: true,
        jumpLargeGaps: true,
        smallGapLimit: 1.5,
        threshold: 0.3,
        enableSeekFix: true,
        enableStallFix: false,
        stallSeek: 0.1
      },
      utcSynchronization: {
        enabled: true,
        useManifestDateHeaderTimeSource: true,
        backgroundAttempts: 2,
        timeBetweenSyncAttempts: 30,
        maximumTimeBetweenSyncAttempts: 600,
        minimumTimeBetweenSyncAttempts: 2,
        timeBetweenSyncAttemptsAdjustmentFactor: 2,
        maximumAllowedDrift: 100,
        enableBackgroundSyncAfterSegmentDownloadError: true,
        defaultTimingSource: {
          scheme: 'urn:mpeg:dash:utc:http-xsdate:2014',
          value: 'https://time.akamai.com/?iso&ms'
        }
      },
      scheduling: {
        defaultTimeout: 500,
        lowLatencyTimeout: 0,
        scheduleWhilePaused: true
      },
      text: {
        defaultEnabled: true,
        dispatchForManualRendering: false,
        extendSegmentedCues: true,
        imsc: {
          displayForcedOnlyMode: false,
          enableRollUp: true
        },
        webvtt: {
          customRenderingEnabled: false
        }
      },
      liveCatchup: {
        maxDrift: NaN,
        playbackRate: {
          min: NaN,
          max: NaN
        },
        playbackBufferMin: 0.5,
        enabled: null,
        mode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].LIVE_CATCHUP_MODE_DEFAULT
      },
      lastBitrateCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      lastMediaSettingsCachingInfo: {
        enabled: true,
        ttl: 360000
      },
      saveLastMediaSettingsForCurrentStreamingSession: true,
      cacheLoadThresholds: {
        video: 50,
        audio: 5
      },
      trackSwitchMode: {
        audio: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_ALWAYS_REPLACE,
        video: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH_MODE_NEVER_REPLACE
      },
      selectionModeForInitialTrack: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY,
      fragmentRequestTimeout: 20000,
      fragmentRequestProgressTimeout: -1,
      manifestRequestTimeout: 10000,
      retryIntervals: (_retryIntervals = {}, _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE, 500), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE, 500), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE, 1000), _defineProperty(_retryIntervals, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE, 1000), _defineProperty(_retryIntervals, "lowLatencyReductionFactor", 10), _retryIntervals),
      retryAttempts: (_retryAttempts = {}, _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MPD_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.XLINK_EXPANSION_TYPE, 1), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MEDIA_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INIT_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.BITSTREAM_SWITCHING_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.INDEX_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.MSS_FRAGMENT_INFO_SEGMENT_TYPE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.LICENSE, 3), _defineProperty(_retryAttempts, _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_4__.HTTPRequest.OTHER_TYPE, 3), _defineProperty(_retryAttempts, "lowLatencyMultiplyFactor", 5), _retryAttempts),
      abr: {
        movingAverageMethod: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].MOVING_AVERAGE_SLIDING_WINDOW,
        ABRStrategy: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].ABR_STRATEGY_DYNAMIC,
        additionalAbrRules: {
          insufficientBufferRule: true,
          switchHistoryRule: true,
          droppedFramesRule: true,
          abandonRequestsRule: true
        },
        abrRulesParameters: {
          abandonRequestsRule: {
            graceTimeThreshold: 500,
            abandonMultiplier: 1.8,
            minLengthToAverage: 5
          }
        },
        bandwidthSafetyFactor: 0.9,
        useDefaultABRRules: true,
        useDeadTimeLatency: true,
        limitBitrateByPortal: false,
        usePixelRatioInLimitBitrateByPortal: false,
        maxBitrate: {
          audio: -1,
          video: -1
        },
        minBitrate: {
          audio: -1,
          video: -1
        },
        maxRepresentationRatio: {
          audio: 1,
          video: 1
        },
        initialBitrate: {
          audio: -1,
          video: -1
        },
        initialRepresentationRatio: {
          audio: -1,
          video: -1
        },
        autoSwitchBitrate: {
          audio: true,
          video: true
        },
        fetchThroughputCalculationMode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING
      },
      cmcd: {
        enabled: false,
        sid: null,
        cid: null,
        rtp: null,
        rtpSafetyFactor: 5,
        mode: _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_3__["default"].CMCD_MODE_QUERY,
        enabledKeys: ['br', 'd', 'ot', 'tb', 'bl', 'dl', 'mtp', 'nor', 'nrr', 'su', 'bs', 'rtp', 'cid', 'pr', 'sf', 'sid', 'st', 'v']
      },
      cmsd: {
        enabled: false,
        abr: {
          applyMb: false,
          etpWeightRatio: 0
        }
      }
    },
    errors: {
      recoverAttempts: {
        mediaErrorDecode: 5
      }
    }
  };
  var settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings); //Merge in the settings. If something exists in the new config that doesn't match the schema of the default config,
  //regard it as an error and log it.

  function mixinSettings(source, dest, path) {
    for (var n in source) {
      if (source.hasOwnProperty(n)) {
        if (dest.hasOwnProperty(n)) {
          if (_typeof(source[n]) === 'object' && !(source[n] instanceof Array) && source[n] !== null) {
            mixinSettings(source[n], dest[n], path.slice() + n + '.');
          } else {
            dest[n] = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(source[n]);

            if (DISPATCH_KEY_MAP[path + n]) {
              eventBus.trigger(DISPATCH_KEY_MAP[path + n]);
            }
          }
        } else {
          console.error('Settings parameter ' + path + n + ' is not supported');
        }
      }
    }
  }
  /**
   * Return the settings object. Don't copy/store this object, you won't get updates.
   * @func
   * @instance
   */


  function get() {
    return settings;
  }
  /**
   * @func
   * @instance
   * @param {object} settingsObj - This should be a partial object of the Settings.Schema type. That is, fields defined should match the path (e.g.
   * settingsObj.streaming.abr.autoSwitchBitrate.audio -> defaultSettings.streaming.abr.autoSwitchBitrate.audio). Where an element's path does
   * not match it is ignored, and a warning is logged.
   *
   * Use to change the settings object. Any new values defined will overwrite the settings and anything undefined will not change.
   * Implementers of new settings should add it in an approriate namespace to the defaultSettings object and give it a default value (that is not undefined).
   *
   */


  function update(settingsObj) {
    if (_typeof(settingsObj) === 'object') {
      mixinSettings(settingsObj, settings, '');
    }
  }
  /**
   * Resets the settings object. Everything is set to its default value.
   * @func
   * @instance
   *
   */


  function reset() {
    settings = _Utils_js__WEBPACK_IMPORTED_MODULE_1__["default"].clone(defaultSettings);
  }

  instance = {
    get: get,
    update: update,
    reset: reset
  };
  return instance;
}

Settings.__dashjs_factory_name = 'Settings';
var factory = _FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(Settings);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/core/Utils.js":
/*!***************************!*\
  !*** ./src/core/Utils.js ***!
  \***************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var path_browserify__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! path-browserify */ "./node_modules/path-browserify/index.js");
/* harmony import */ var path_browserify__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(path_browserify__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ua-parser-js */ "./node_modules/ua-parser-js/src/ua-parser.js");
/* harmony import */ var ua_parser_js__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(ua_parser_js__WEBPACK_IMPORTED_MODULE_1__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */



var Utils = /*#__PURE__*/function () {
  function Utils() {
    _classCallCheck(this, Utils);
  }

  _createClass(Utils, null, [{
    key: "mixin",
    value: function mixin(dest, source, copy) {
      var s;
      var empty = {};

      if (dest) {
        for (var name in source) {
          if (source.hasOwnProperty(name)) {
            s = source[name];

            if (!(name in dest) || dest[name] !== s && (!(name in empty) || empty[name] !== s)) {
              if (_typeof(dest[name]) === 'object' && dest[name] !== null) {
                dest[name] = Utils.mixin(dest[name], s, copy);
              } else {
                dest[name] = copy(s);
              }
            }
          }
        }
      }

      return dest;
    }
  }, {
    key: "clone",
    value: function clone(src) {
      if (!src || _typeof(src) !== 'object') {
        return src; // anything
      }

      var r;

      if (src instanceof Array) {
        // array
        r = [];

        for (var i = 0, l = src.length; i < l; ++i) {
          if (i in src) {
            r.push(Utils.clone(src[i]));
          }
        }
      } else {
        r = {};
      }

      return Utils.mixin(r, src, Utils.clone);
    }
  }, {
    key: "addAditionalQueryParameterToUrl",
    value: function addAditionalQueryParameterToUrl(url, params) {
      try {
        if (!params || params.length === 0) {
          return url;
        }

        var modifiedUrl = new URL(url);
        params.forEach(function (param) {
          if (param.key && param.value) {
            modifiedUrl.searchParams.set(param.key, param.value);
          }
        });
        return modifiedUrl.href;
      } catch (e) {
        return url;
      }
    }
  }, {
    key: "parseHttpHeaders",
    value: function parseHttpHeaders(headerStr) {
      var headers = {};

      if (!headerStr) {
        return headers;
      } // Trim headerStr to fix a MS Edge bug with xhr.getAllResponseHeaders method
      // which send a string starting with a "\n" character


      var headerPairs = headerStr.trim().split("\r\n");

      for (var i = 0, ilen = headerPairs.length; i < ilen; i++) {
        var headerPair = headerPairs[i];
        var index = headerPair.indexOf(": ");

        if (index > 0) {
          headers[headerPair.substring(0, index)] = headerPair.substring(index + 2);
        }
      }

      return headers;
    }
  }, {
    key: "generateUuid",
    value: function generateUuid() {
      var dt = new Date().getTime();
      var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
        var r = (dt + Math.random() * 16) % 16 | 0;
        dt = Math.floor(dt / 16);
        return (c == 'x' ? r : r & 0x3 | 0x8).toString(16);
      });
      return uuid;
    }
  }, {
    key: "generateHashCode",
    value: function generateHashCode(string) {
      var hash = 0;

      if (string.length === 0) {
        return hash;
      }

      for (var i = 0; i < string.length; i++) {
        var chr = string.charCodeAt(i);
        hash = (hash << 5) - hash + chr;
        hash |= 0;
      }

      return hash;
    }
    /**
     * Compares both urls and returns a relative url (target relative to original)
     * @param {string} originalUrl
     * @param {string} targetUrl
     * @return {string|*}
     */

  }, {
    key: "getRelativeUrl",
    value: function getRelativeUrl(originalUrl, targetUrl) {
      try {
        var original = new URL(originalUrl);
        var target = new URL(targetUrl); // Unify the protocol to compare the origins

        original.protocol = target.protocol;

        if (original.origin !== target.origin) {
          return targetUrl;
        } // Use the relative path implementation of the path library. We need to cut off the actual filename in the end to get the relative path


        var relativePath = path_browserify__WEBPACK_IMPORTED_MODULE_0___default().relative(original.pathname.substr(0, original.pathname.lastIndexOf('/')), target.pathname.substr(0, target.pathname.lastIndexOf('/'))); // In case the relative path is empty (both path are equal) return the filename only. Otherwise add a slash in front of the filename

        var startIndexOffset = relativePath.length === 0 ? 1 : 0;
        relativePath += target.pathname.substr(target.pathname.lastIndexOf('/') + startIndexOffset, target.pathname.length - 1); // Build the other candidate, e.g. the 'host relative' path that starts with "/", and return the shortest of the two candidates.

        if (target.pathname.length < relativePath.length) {
          return target.pathname;
        }

        return relativePath;
      } catch (e) {
        return targetUrl;
      }
    }
  }, {
    key: "parseUserAgent",
    value: function parseUserAgent() {
      var ua = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;

      try {
        var uaString = ua === null ? typeof navigator !== 'undefined' ? navigator.userAgent.toLowerCase() : '' : '';
        return (0,ua_parser_js__WEBPACK_IMPORTED_MODULE_1__.UAParser)(uaString);
      } catch (e) {
        return {};
      }
    }
    /**
     * Checks for existence of "http" or "https" in a string
     * @param string
     * @returns {boolean}
     */

  }, {
    key: "stringHasProtocol",
    value: function stringHasProtocol(string) {
      return /(http(s?)):\/\//i.test(string);
    }
  }]);

  return Utils;
}();

/* harmony default export */ __webpack_exports__["default"] = (Utils);

/***/ }),

/***/ "./src/core/Version.js":
/*!*****************************!*\
  !*** ./src/core/Version.js ***!
  \*****************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getVersionString": function() { return /* binding */ getVersionString; }
/* harmony export */ });
var VERSION = '4.7.4';
function getVersionString() {
  return VERSION;
}

/***/ }),

/***/ "./src/core/errors/Errors.js":
/*!***********************************!*\
  !*** ./src/core/errors/Errors.js ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _ErrorsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ErrorsBase */ "./src/core/errors/ErrorsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Errors declaration
 * @class
 */

var Errors = /*#__PURE__*/function (_ErrorsBase) {
  _inherits(Errors, _ErrorsBase);

  var _super = _createSuper(Errors);

  function Errors() {
    var _this;

    _classCallCheck(this, Errors);

    _this = _super.call(this);
    /**
     * Error code returned when a manifest parsing error occurs
     */

    _this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE = 10;
    /**
     * Error code returned when a manifest loading error occurs
     */

    _this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE = 11;
    /**
     * Error code returned when a xlink loading error occurs
     */

    _this.XLINK_LOADER_LOADING_FAILURE_ERROR_CODE = 12;
    /**
     * Error code returned when no segment ranges could be determined from the sidx box
     */

    _this.SEGMENT_BASE_LOADER_ERROR_CODE = 15;
    /**
     * Error code returned when the time synchronization failed
     */

    _this.TIME_SYNC_FAILED_ERROR_CODE = 16;
    /**
     * Error code returned when loading a fragment failed
     */

    _this.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE = 17;
    /**
     * Error code returned when the FragmentLoader did not receive a request object
     */

    _this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE = 18;
    /**
     * Error code returned when the BaseUrl resolution failed
     */

    _this.URL_RESOLUTION_FAILED_GENERIC_ERROR_CODE = 19;
    /**
     * Error code returned when the append operation in the SourceBuffer failed
     */

    _this.APPEND_ERROR_CODE = 20;
    /**
     * Error code returned when the remove operation in the SourceBuffer failed
     */

    _this.REMOVE_ERROR_CODE = 21;
    /**
     * Error code returned when updating the internal objects after loading an MPD failed
     */

    _this.DATA_UPDATE_FAILED_ERROR_CODE = 22;
    /**
     * Error code returned when MediaSource is not supported by the browser
     */

    _this.CAPABILITY_MEDIASOURCE_ERROR_CODE = 23;
    /**
     * Error code returned when Protected contents are not supported
     */

    _this.CAPABILITY_MEDIAKEYS_ERROR_CODE = 24;
    /**
     * Error code returned when loading the manifest failed
     */

    _this.DOWNLOAD_ERROR_ID_MANIFEST_CODE = 25;
    /**
     * Error code returned when loading the sidx failed
     */

    _this.DOWNLOAD_ERROR_ID_SIDX_CODE = 26;
    /**
     * Error code returned when loading the media content failed
     */

    _this.DOWNLOAD_ERROR_ID_CONTENT_CODE = 27;
    /**
     * Error code returned when loading the init segment failed
     */

    _this.DOWNLOAD_ERROR_ID_INITIALIZATION_CODE = 28;
    /**
     * Error code returned when loading the XLink content failed
     */

    _this.DOWNLOAD_ERROR_ID_XLINK_CODE = 29;
    /**
     * Error code returned when parsing the MPD resulted in a logical error
     */

    _this.MANIFEST_ERROR_ID_PARSE_CODE = 31;
    /**
     * Error code returned when no stream (period) has been detected in the manifest
     */

    _this.MANIFEST_ERROR_ID_NOSTREAMS_CODE = 32;
    /**
     * Error code returned when something wrong has happened during parsing and appending subtitles (TTML or VTT)
     */

    _this.TIMED_TEXT_ERROR_ID_PARSE_CODE = 33;
    /**
     * Error code returned when a 'muxed' media type has been detected in the manifest. This type is not supported
     */

    _this.MANIFEST_ERROR_ID_MULTIPLEXED_CODE = 34;
    /**
     * Error code returned when a media source type is not supported
     */

    _this.MEDIASOURCE_TYPE_UNSUPPORTED_CODE = 35;
    _this.MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE = 'parsing failed for ';
    _this.MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading manifest: ';
    _this.XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE = 'Failed loading Xlink element: ';
    _this.SEGMENTS_UPDATE_FAILED_ERROR_MESSAGE = 'Segments update failed';
    _this.SEGMENTS_UNAVAILABLE_ERROR_MESSAGE = 'no segments are available yet';
    _this.SEGMENT_BASE_LOADER_ERROR_MESSAGE = 'error loading segment ranges from sidx';
    _this.TIME_SYNC_FAILED_ERROR_MESSAGE = 'Failed to synchronize client and server time';
    _this.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE = 'request is null';
    _this.URL_RESOLUTION_FAILED_GENERIC_ERROR_MESSAGE = 'Failed to resolve a valid URL';
    _this.APPEND_ERROR_MESSAGE = 'chunk is not defined';
    _this.REMOVE_ERROR_MESSAGE = 'Removing data from the SourceBuffer';
    _this.DATA_UPDATE_FAILED_ERROR_MESSAGE = 'Data update failed';
    _this.CAPABILITY_MEDIASOURCE_ERROR_MESSAGE = 'mediasource is not supported';
    _this.CAPABILITY_MEDIAKEYS_ERROR_MESSAGE = 'mediakeys is not supported';
    _this.TIMED_TEXT_ERROR_MESSAGE_PARSE = 'parsing error :';
    _this.MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE = 'Error creating source buffer of type : ';
    return _this;
  }

  return Errors;
}(_ErrorsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var errors = new Errors();
/* harmony default export */ __webpack_exports__["default"] = (errors);

/***/ }),

/***/ "./src/core/errors/ErrorsBase.js":
/*!***************************************!*\
  !*** ./src/core/errors/ErrorsBase.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ErrorsBase = /*#__PURE__*/function () {
  function ErrorsBase() {
    _classCallCheck(this, ErrorsBase);
  }

  _createClass(ErrorsBase, [{
    key: "extend",
    value: function extend(errors, config) {
      if (!errors) return;
      var override = config ? config.override : false;
      var publicOnly = config ? config.publicOnly : false;

      for (var err in errors) {
        if (!errors.hasOwnProperty(err) || this[err] && !override) continue;
        if (publicOnly && errors[err].indexOf('public_') === -1) continue;
        this[err] = errors[err];
      }
    }
  }]);

  return ErrorsBase;
}();

/* harmony default export */ __webpack_exports__["default"] = (ErrorsBase);

/***/ }),

/***/ "./src/core/events/CoreEvents.js":
/*!***************************************!*\
  !*** ./src/core/events/CoreEvents.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * These are internal events that should not be needed at the player level.
 * If you find and event in here that you would like access to from MediaPlayer level
 * please add an issue at https://github.com/Dash-Industry-Forum/dash.js/issues/new
 * @class
 * @ignore
 */

var CoreEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(CoreEvents, _EventsBase);

  var _super = _createSuper(CoreEvents);

  function CoreEvents() {
    var _this;

    _classCallCheck(this, CoreEvents);

    _this = _super.call(this);
    _this.ATTEMPT_BACKGROUND_SYNC = 'attemptBackgroundSync';
    _this.BUFFERING_COMPLETED = 'bufferingCompleted';
    _this.BUFFER_CLEARED = 'bufferCleared';
    _this.BYTES_APPENDED_END_FRAGMENT = 'bytesAppendedEndFragment';
    _this.BUFFER_REPLACEMENT_STARTED = 'bufferReplacementStarted';
    _this.CHECK_FOR_EXISTENCE_COMPLETED = 'checkForExistenceCompleted';
    _this.CMSD_STATIC_HEADER = 'cmsdStaticHeader';
    _this.CURRENT_TRACK_CHANGED = 'currentTrackChanged';
    _this.DATA_UPDATE_COMPLETED = 'dataUpdateCompleted';
    _this.INBAND_EVENTS = 'inbandEvents';
    _this.INITIAL_STREAM_SWITCH = 'initialStreamSwitch';
    _this.INIT_FRAGMENT_LOADED = 'initFragmentLoaded';
    _this.INIT_FRAGMENT_NEEDED = 'initFragmentNeeded';
    _this.INTERNAL_MANIFEST_LOADED = 'internalManifestLoaded';
    _this.ORIGINAL_MANIFEST_LOADED = 'originalManifestLoaded';
    _this.LOADING_COMPLETED = 'loadingCompleted';
    _this.LOADING_PROGRESS = 'loadingProgress';
    _this.LOADING_DATA_PROGRESS = 'loadingDataProgress';
    _this.LOADING_ABANDONED = 'loadingAborted';
    _this.MANIFEST_UPDATED = 'manifestUpdated';
    _this.MEDIA_FRAGMENT_LOADED = 'mediaFragmentLoaded';
    _this.MEDIA_FRAGMENT_NEEDED = 'mediaFragmentNeeded';
    _this.QUOTA_EXCEEDED = 'quotaExceeded';
    _this.SEGMENT_LOCATION_BLACKLIST_ADD = 'segmentLocationBlacklistAdd';
    _this.SEGMENT_LOCATION_BLACKLIST_CHANGED = 'segmentLocationBlacklistChanged';
    _this.SERVICE_LOCATION_BASE_URL_BLACKLIST_ADD = 'serviceLocationBlacklistAdd';
    _this.SERVICE_LOCATION_BASE_URL_BLACKLIST_CHANGED = 'serviceLocationBlacklistChanged';
    _this.SERVICE_LOCATION_LOCATION_BLACKLIST_ADD = 'serviceLocationLocationBlacklistAdd';
    _this.SERVICE_LOCATION_LOCATION_BLACKLIST_CHANGED = 'serviceLocationLocationBlacklistChanged';
    _this.SET_FRAGMENTED_TEXT_AFTER_DISABLED = 'setFragmentedTextAfterDisabled';
    _this.SET_NON_FRAGMENTED_TEXT = 'setNonFragmentedText';
    _this.SOURCE_BUFFER_ERROR = 'sourceBufferError';
    _this.STREAMS_COMPOSED = 'streamsComposed';
    _this.STREAM_BUFFERING_COMPLETED = 'streamBufferingCompleted';
    _this.STREAM_REQUESTING_COMPLETED = 'streamRequestingCompleted';
    _this.TEXT_TRACKS_QUEUE_INITIALIZED = 'textTracksQueueInitialized';
    _this.TIME_SYNCHRONIZATION_COMPLETED = 'timeSynchronizationComplete';
    _this.UPDATE_TIME_SYNC_OFFSET = 'updateTimeSyncOffset';
    _this.URL_RESOLUTION_FAILED = 'urlResolutionFailed';
    _this.VIDEO_CHUNK_RECEIVED = 'videoChunkReceived';
    _this.WALLCLOCK_TIME_UPDATED = 'wallclockTimeUpdated';
    _this.XLINK_ELEMENT_LOADED = 'xlinkElementLoaded';
    _this.XLINK_READY = 'xlinkReady';
    _this.SEEK_TARGET = 'seekTarget';
    _this.SETTING_UPDATED_LIVE_DELAY = 'settingUpdatedLiveDelay';
    _this.SETTING_UPDATED_LIVE_DELAY_FRAGMENT_COUNT = 'settingUpdatedLiveDelayFragmentCount';
    _this.SETTING_UPDATED_CATCHUP_ENABLED = 'settingUpdatedCatchupEnabled';
    _this.SETTING_UPDATED_PLAYBACK_RATE_MIN = 'settingUpdatedPlaybackRateMin';
    _this.SETTING_UPDATED_PLAYBACK_RATE_MAX = 'settingUpdatedPlaybackRateMax';
    return _this;
  }

  return CoreEvents;
}(_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (CoreEvents);

/***/ }),

/***/ "./src/core/events/Events.js":
/*!***********************************!*\
  !*** ./src/core/events/Events.js ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CoreEvents__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CoreEvents */ "./src/core/events/CoreEvents.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var Events = /*#__PURE__*/function (_CoreEvents) {
  _inherits(Events, _CoreEvents);

  var _super = _createSuper(Events);

  function Events() {
    _classCallCheck(this, Events);

    return _super.apply(this, arguments);
  }

  return Events;
}(_CoreEvents__WEBPACK_IMPORTED_MODULE_0__["default"]);

var events = new Events();
/* harmony default export */ __webpack_exports__["default"] = (events);

/***/ }),

/***/ "./src/core/events/EventsBase.js":
/*!***************************************!*\
  !*** ./src/core/events/EventsBase.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var EventsBase = /*#__PURE__*/function () {
  function EventsBase() {
    _classCallCheck(this, EventsBase);
  }

  _createClass(EventsBase, [{
    key: "extend",
    value: function extend(events, config) {
      if (!events) return;
      var override = config ? config.override : false;
      var publicOnly = config ? config.publicOnly : false;

      for (var evt in events) {
        if (!events.hasOwnProperty(evt) || this[evt] && !override) continue;
        if (publicOnly && events[evt].indexOf('public_') === -1) continue;
        this[evt] = events[evt];
      }
    }
  }]);

  return EventsBase;
}();

/* harmony default export */ __webpack_exports__["default"] = (EventsBase);

/***/ }),

/***/ "./src/dash/DashAdapter.js":
/*!*********************************!*\
  !*** ./src/dash/DashAdapter.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _vo_RepresentationInfo__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./vo/RepresentationInfo */ "./src/dash/vo/RepresentationInfo.js");
/* harmony import */ var _vo_MediaInfo__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vo/MediaInfo */ "./src/dash/vo/MediaInfo.js");
/* harmony import */ var _vo_StreamInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vo/StreamInfo */ "./src/dash/vo/StreamInfo.js");
/* harmony import */ var _vo_ManifestInfo__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./vo/ManifestInfo */ "./src/dash/vo/ManifestInfo.js");
/* harmony import */ var _vo_Event__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./vo/Event */ "./src/dash/vo/Event.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _models_DashManifestModel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./models/DashManifestModel */ "./src/dash/models/DashManifestModel.js");
/* harmony import */ var _models_PatchManifestModel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./models/PatchManifestModel */ "./src/dash/models/PatchManifestModel.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! bcp-47-normalize */ "./node_modules/bcp-47-normalize/index.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_9___default = /*#__PURE__*/__webpack_require__.n(bcp_47_normalize__WEBPACK_IMPORTED_MODULE_9__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */










/**
 * @module DashAdapter
 * @description The DashAdapter module can be accessed using the MediaPlayer API getDashAdapter()
 */

function DashAdapter() {
  var instance, dashManifestModel, patchManifestModel, voPeriods, currentMediaInfo, constants, cea608parser;
  var context = this.context;
  var PROFILE_DVB = 'urn:dvb:dash:profile:dvb-dash:2014';

  function setup() {
    dashManifestModel = (0,_models_DashManifestModel__WEBPACK_IMPORTED_MODULE_7__["default"])(context).getInstance();
    patchManifestModel = (0,_models_PatchManifestModel__WEBPACK_IMPORTED_MODULE_8__["default"])(context).getInstance();
    reset();
  } // #region PUBLIC FUNCTIONS
  // --------------------------------------------------


  function setConfig(config) {
    if (!config) return;

    if (config.constants) {
      constants = config.constants;
    }

    if (config.cea608parser) {
      cea608parser = config.cea608parser;
    }

    if (config.errHandler) {
      dashManifestModel.setConfig({
        errHandler: config.errHandler
      });
    }

    if (config.BASE64) {
      dashManifestModel.setConfig({
        BASE64: config.BASE64
      });
    }
  }
  /**
   * Creates an instance of RepresentationInfo based on a representation value object
   * @param {object} voRepresentation
   * @returns {RepresentationInfo|null} representationInfo
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function convertRepresentationToRepresentationInfo(voRepresentation) {
    if (voRepresentation) {
      var representationInfo = new _vo_RepresentationInfo__WEBPACK_IMPORTED_MODULE_1__["default"]();
      var realAdaptation = voRepresentation.adaptation.period.mpd.manifest.Period_asArray[voRepresentation.adaptation.period.index].AdaptationSet_asArray[voRepresentation.adaptation.index];
      var realRepresentation = dashManifestModel.getRepresentationFor(voRepresentation.index, realAdaptation);
      representationInfo.id = voRepresentation.id;
      representationInfo.quality = voRepresentation.index;
      representationInfo.bandwidth = dashManifestModel.getBandwidth(realRepresentation);
      representationInfo.fragmentDuration = voRepresentation.segmentDuration || (voRepresentation.segments && voRepresentation.segments.length > 0 ? voRepresentation.segments[0].duration : NaN);
      representationInfo.MSETimeOffset = voRepresentation.MSETimeOffset;
      representationInfo.mediaInfo = convertAdaptationToMediaInfo(voRepresentation.adaptation);
      return representationInfo;
    } else {
      return null;
    }
  }
  /**
   * Returns a MediaInfo object for a given media type and the corresponding streamInfo.
   * @param {object} streamInfo
   * @param {MediaType }type
   * @returns {null|MediaInfo} mediaInfo
   * @memberOf module:DashAdapter
   * @instance
   */


  function getMediaInfoForType(streamInfo, type) {
    if (voPeriods.length === 0 || !streamInfo) {
      return null;
    }

    var selectedVoPeriod = getPeriodForStreamInfo(streamInfo, voPeriods);
    if (!selectedVoPeriod) return null;
    var voAdaptations = dashManifestModel.getAdaptationsForPeriod(selectedVoPeriod);
    var realAdaptation = getAdaptationForType(streamInfo.index, type, streamInfo);
    if (!realAdaptation) return null;
    var idx = dashManifestModel.getIndexForAdaptation(realAdaptation, voPeriods[0].mpd.manifest, streamInfo.index);
    return convertAdaptationToMediaInfo(voAdaptations[idx]);
  }
  /**
   * Checks if the role of the specified AdaptationSet is set to main
   * @param {object} adaptation
   * @returns {boolean}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getIsMain(adaptation) {
    return dashManifestModel.getRolesForAdaptation(adaptation).filter(function (role) {
      return role.value === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].MAIN;
    })[0];
  }
  /**
   * Returns the AdaptationSet for a given period index and a given mediaType.
   * @param {number} periodIndex
   * @param {MediaType} type
   * @param {object} streamInfo
   * @returns {null|object} adaptation
   * @memberOf module:DashAdapter
   * @instance
   */


  function getAdaptationForType(periodIndex, type, streamInfo) {
    var adaptations = dashManifestModel.getAdaptationsForType(voPeriods[0].mpd.manifest, periodIndex, type);
    if (!adaptations || adaptations.length === 0) return null;

    if (adaptations.length > 1 && streamInfo) {
      var allMediaInfoForType = getAllMediaInfoForType(streamInfo, type);

      if (currentMediaInfo[streamInfo.id] && currentMediaInfo[streamInfo.id][type]) {
        for (var i = 0, ln = adaptations.length; i < ln; i++) {
          if (areMediaInfosEqual(currentMediaInfo[streamInfo.id][type], allMediaInfoForType[i])) {
            return adaptations[i];
          }
        }
      }

      for (var _i = 0, _ln = adaptations.length; _i < _ln; _i++) {
        if (getIsMain(adaptations[_i])) {
          return adaptations[_i];
        }
      }
    }

    return adaptations[0];
  }
  /**
   * Compares two mediaInfo objects
   * @param {MediaInfo} mInfoOne
   * @param {MediaInfo} mInfoTwo
   * @returns {boolean}
   * @memberof module:DashAdapter
   * @instance
   */


  function areMediaInfosEqual(mInfoOne, mInfoTwo) {
    if (!mInfoOne || !mInfoTwo) {
      return false;
    }

    var sameId = mInfoOne.id === mInfoTwo.id;
    var sameCodec = mInfoOne.codec === mInfoTwo.codec;
    var sameViewpoint = mInfoOne.viewpoint === mInfoTwo.viewpoint;
    var sameViewpointWithSchemeIdUri = JSON.stringify(mInfoOne.viewpointsWithSchemeIdUri) === JSON.stringify(mInfoTwo.viewpointsWithSchemeIdUri);
    var sameLang = mInfoOne.lang === mInfoTwo.lang;
    var sameRoles = mInfoOne.roles.toString() === mInfoTwo.roles.toString();
    var sameRolesWithSchemeIdUri = JSON.stringify(mInfoOne.rolesWithSchemeIdUri) === JSON.stringify(mInfoTwo.rolesWithSchemeIdUri);
    var sameAccessibility = mInfoOne.accessibility.toString() === mInfoTwo.accessibility.toString();
    var sameAccessibilityWithSchemeIdUri = JSON.stringify(mInfoOne.accessibilitiesWithSchemeIdUri) === JSON.stringify(mInfoTwo.accessibilitiesWithSchemeIdUri);
    var sameAudioChannelConfiguration = mInfoOne.audioChannelConfiguration.toString() === mInfoTwo.audioChannelConfiguration.toString();
    var sameAudioChannelConfigurationWithSchemeIdUri = JSON.stringify(mInfoOne.audioChannelConfigurationsWithSchemeIdUri) === JSON.stringify(mInfoTwo.audioChannelConfigurationsWithSchemeIdUri);
    return sameId && sameCodec && sameViewpoint && sameViewpointWithSchemeIdUri && sameLang && sameRoles && sameRolesWithSchemeIdUri && sameAccessibility && sameAccessibilityWithSchemeIdUri && sameAudioChannelConfiguration && sameAudioChannelConfigurationWithSchemeIdUri;
  }

  function _getAllMediaInfo(manifest, period, streamInfo, adaptations, type, embeddedText) {
    var mediaArr = [];
    var data, media, idx, i, j, ln;

    if (!adaptations || adaptations.length === 0) {
      return [];
    }

    var voAdaptations = dashManifestModel.getAdaptationsForPeriod(period);

    for (i = 0, ln = adaptations.length; i < ln; i++) {
      data = adaptations[i];
      idx = dashManifestModel.getIndexForAdaptation(data, manifest, streamInfo.index);
      media = convertAdaptationToMediaInfo(voAdaptations[idx]);

      if (embeddedText) {
        var accessibilityLength = media.accessibility.length;

        for (j = 0; j < accessibilityLength; j++) {
          if (!media) {
            continue;
          }

          var accessibility = media.accessibility[j];

          if (accessibility.indexOf('cea-608:') === 0) {
            var value = accessibility.substring(8);
            var parts = value.split(';');

            if (parts[0].substring(0, 2) === 'CC') {
              for (j = 0; j < parts.length; j++) {
                if (!media) {
                  media = convertAdaptationToMediaInfo.call(this, voAdaptations[idx]);
                }

                convertVideoInfoToEmbeddedTextInfo(media, parts[j].substring(0, 3), parts[j].substring(4));
                mediaArr.push(media);
                media = null;
              }
            } else {
              for (j = 0; j < parts.length; j++) {
                // Only languages for CC1, CC2, ...
                if (!media) {
                  media = convertAdaptationToMediaInfo.call(this, voAdaptations[idx]);
                }

                convertVideoInfoToEmbeddedTextInfo(media, 'CC' + (j + 1), parts[j]);
                mediaArr.push(media);
                media = null;
              }
            }
          } else if (accessibility.indexOf('cea-608') === 0) {
            // Nothing known. We interpret it as CC1=eng
            convertVideoInfoToEmbeddedTextInfo(media, constants.CC1, 'eng');
            mediaArr.push(media);
            media = null;
          }
        }
      } else if (type === constants.IMAGE) {
        convertVideoInfoToThumbnailInfo(media);
        mediaArr.push(media);
        media = null;
      } else if (media) {
        mediaArr.push(media);
      }
    }

    return mediaArr;
  }
  /**
   * Returns all the mediaInfos for a given mediaType and the corresponding streamInfo.
   * @param {object} streamInfo
   * @param {MediaType} type
   * @param {object} externalManifest Set to null or undefined if no external manifest is to be used
   * @returns {Array} mediaArr
   * @memberOf module:DashAdapter
   * @instance
   */


  function getAllMediaInfoForType(streamInfo, type, externalManifest) {
    var voLocalPeriods = voPeriods;
    var manifest = externalManifest;
    var mediaArr = [];

    if (manifest) {
      checkConfig();
      voLocalPeriods = getRegularPeriods(manifest);
    } else {
      if (voPeriods.length > 0) {
        manifest = voPeriods[0].mpd.manifest;
      } else {
        return mediaArr;
      }
    }

    var selectedVoPeriod = getPeriodForStreamInfo(streamInfo, voLocalPeriods);
    var adaptationsForType = dashManifestModel.getAdaptationsForType(manifest, streamInfo ? streamInfo.index : null, type);
    mediaArr = _getAllMediaInfo(manifest, selectedVoPeriod, streamInfo, adaptationsForType, type); // Search for embedded text in video track

    if (type === constants.TEXT) {
      adaptationsForType = dashManifestModel.getAdaptationsForType(manifest, streamInfo ? streamInfo.index : null, constants.VIDEO);
      mediaArr = mediaArr.concat(_getAllMediaInfo(manifest, selectedVoPeriod, streamInfo, adaptationsForType, type, true));
    }

    return mediaArr;
  }
  /**
   * Update the internal voPeriods array with the information from the new manifest
   * @param {object} newManifest
   * @returns {*}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function updatePeriods(newManifest) {
    if (!newManifest) return null;
    checkConfig();
    voPeriods = getRegularPeriods(newManifest);
  }
  /**
   * Returns an array of streamInfo objects
   * @param {object} externalManifest
   * @param {number} maxStreamsInfo
   * @returns {Array} streams
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getStreamsInfo(externalManifest, maxStreamsInfo) {
    var streams = [];
    var voLocalPeriods = voPeriods; //if manifest is defined, getStreamsInfo is for an outside manifest, not the current one

    if (externalManifest) {
      checkConfig();
      voLocalPeriods = getRegularPeriods(externalManifest);
    }

    if (voLocalPeriods.length > 0) {
      if (!maxStreamsInfo || maxStreamsInfo > voLocalPeriods.length) {
        maxStreamsInfo = voLocalPeriods.length;
      }

      for (var i = 0; i < maxStreamsInfo; i++) {
        streams.push(convertPeriodToStreamInfo(voLocalPeriods[i]));
      }
    }

    return streams;
  }
  /**
   * Returns the AdaptationSet as saved in the DashManifestModel
   * @param {object} streamInfo
   * @param {object} mediaInfo
   * @returns {object} realAdaptation
   * @memberOf module:DashAdapter
   * @instance
   */


  function getRealAdaptation(streamInfo, mediaInfo) {
    var id, realAdaptation;
    var selectedVoPeriod = getPeriodForStreamInfo(streamInfo, voPeriods);
    id = mediaInfo ? mediaInfo.id : null;

    if (voPeriods.length > 0 && selectedVoPeriod) {
      realAdaptation = id ? dashManifestModel.getAdaptationForId(id, voPeriods[0].mpd.manifest, selectedVoPeriod.index) : dashManifestModel.getAdaptationForIndex(mediaInfo ? mediaInfo.index : null, voPeriods[0].mpd.manifest, selectedVoPeriod.index);
    }

    return realAdaptation;
  }
  /**
   * Returns the ProducerReferenceTimes as saved in the DashManifestModel if present
   * @param {object} streamInfo
   * @param {object} mediaInfo
   * @returns {object} producerReferenceTimes
   * @memberOf module:DashAdapter
   * @instance
   */


  function getProducerReferenceTimes(streamInfo, mediaInfo) {
    var id, realAdaptation;
    var selectedVoPeriod = getPeriodForStreamInfo(streamInfo, voPeriods);
    id = mediaInfo ? mediaInfo.id : null;

    if (voPeriods.length > 0 && selectedVoPeriod) {
      realAdaptation = id ? dashManifestModel.getAdaptationForId(id, voPeriods[0].mpd.manifest, selectedVoPeriod.index) : dashManifestModel.getAdaptationForIndex(mediaInfo ? mediaInfo.index : null, voPeriods[0].mpd.manifest, selectedVoPeriod.index);
    }

    if (!realAdaptation) return [];
    return dashManifestModel.getProducerReferenceTimesForAdaptation(realAdaptation);
  }
  /**
   * Return all EssentialProperties of a Representation
   * @param {object} representation
   * @return {array}
   */


  function getEssentialPropertiesForRepresentation(representation) {
    try {
      return dashManifestModel.getEssentialPropertiesForRepresentation(representation);
    } catch (e) {
      return [];
    }
  }
  /**
   * Returns the period as defined in the DashManifestModel for a given index
   * @param {number} index
   * @return {object}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getRealPeriodByIndex(index) {
    return dashManifestModel.getRealPeriodForIndex(index, voPeriods[0].mpd.manifest);
  }
  /**
   * Returns all voRepresentations for a given mediaInfo
   * @param {object} mediaInfo
   * @returns {Array} voReps
   * @memberOf module:DashAdapter
   * @instance
   */


  function getVoRepresentations(mediaInfo) {
    var voReps;
    var voAdaptation = getAdaptationForMediaInfo(mediaInfo);
    voReps = dashManifestModel.getRepresentationsForAdaptation(voAdaptation);
    return voReps;
  }
  /**
   * Returns the event for the given parameters.
   * @param {object} eventBox
   * @param {object} eventStreams
   * @param {number} mediaStartTime - Specified in seconds
   * @param {object} voRepresentation
   * @returns {null|Event}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getEvent(eventBox, eventStreams, mediaStartTime, voRepresentation) {
    try {
      if (!eventBox || !eventStreams || isNaN(mediaStartTime) || !voRepresentation) {
        return null;
      }

      var schemeIdUri = eventBox.scheme_id_uri;
      var value = eventBox.value;

      if (!eventStreams[schemeIdUri + '/' + value]) {
        return null;
      }

      var event = new _vo_Event__WEBPACK_IMPORTED_MODULE_5__["default"]();
      var timescale = eventBox.timescale || 1;
      var periodStart = voRepresentation.adaptation.period.start;
      var eventStream = eventStreams[schemeIdUri + '/' + value]; // The PTO in voRepresentation is already specified in seconds

      var presentationTimeOffset = !isNaN(voRepresentation.presentationTimeOffset) ? voRepresentation.presentationTimeOffset : !isNaN(eventStream.presentationTimeOffset) ? eventStream.presentationTimeOffset : 0; // In case of version 1 events the presentation_time is parsed as presentation_time_delta

      var presentationTimeDelta = eventBox.presentation_time_delta / timescale;
      var calculatedPresentationTime;

      if (eventBox.version === 0) {
        calculatedPresentationTime = periodStart + mediaStartTime - presentationTimeOffset + presentationTimeDelta;
      } else {
        calculatedPresentationTime = periodStart - presentationTimeOffset + presentationTimeDelta;
      }

      var duration = eventBox.event_duration / timescale;
      var id = eventBox.id;
      var messageData = eventBox.message_data;
      event.eventStream = eventStream;
      event.eventStream.value = value;
      event.eventStream.timescale = timescale;
      event.duration = duration;
      event.id = id;
      event.calculatedPresentationTime = calculatedPresentationTime;
      event.messageData = messageData;
      event.presentationTimeDelta = presentationTimeDelta;
      return event;
    } catch (e) {
      return null;
    }
  }
  /**
   * Returns the events for the given info object. info can either be an instance of StreamInfo, MediaInfo or RepresentationInfo
   * @param {object} info
   * @param {object} voRepresentation
   * @returns {Array}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getEventsFor(info, voRepresentation, streamInfo) {
    var events = [];

    if (voPeriods.length > 0) {
      var manifest = voPeriods[0].mpd.manifest;

      if (info instanceof _vo_StreamInfo__WEBPACK_IMPORTED_MODULE_3__["default"]) {
        var period = getPeriodForStreamInfo(info, voPeriods);
        events = dashManifestModel.getEventsForPeriod(period);
      } else if (info instanceof _vo_MediaInfo__WEBPACK_IMPORTED_MODULE_2__["default"]) {
        var _period = getPeriodForStreamInfo(streamInfo, voPeriods);

        events = dashManifestModel.getEventStreamForAdaptationSet(manifest, getAdaptationForMediaInfo(info), _period);
      } else if (info instanceof _vo_RepresentationInfo__WEBPACK_IMPORTED_MODULE_1__["default"]) {
        var _period2 = getPeriodForStreamInfo(streamInfo, voPeriods);

        events = dashManifestModel.getEventStreamForRepresentation(manifest, voRepresentation, _period2);
      }
    }

    return events;
  }
  /**
   * Sets the current active mediaInfo for a given streamId and a given mediaType
   * @param {number} streamId
   * @param {MediaType} type
   * @param {object} mediaInfo
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function setCurrentMediaInfo(streamId, type, mediaInfo) {
    currentMediaInfo[streamId] = currentMediaInfo[streamId] || {};
    currentMediaInfo[streamId][type] = currentMediaInfo[streamId][type] || {};
    currentMediaInfo[streamId][type] = mediaInfo;
  }
  /**
   * Check if the given type is a text track
   * @param {object} adaptation
   * @returns {boolean}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getIsTextTrack(adaptation) {
    return dashManifestModel.getIsText(adaptation);
  }
  /**
   * Returns the UTC Timing Sources specified in the manifest
   * @returns {Array} utcTimingSources
   * @memberOf module:DashAdapter
   * @instance
   */


  function getUTCTimingSources() {
    var manifest = getManifest();
    return dashManifestModel.getUTCTimingSources(manifest);
  }
  /**
   * Returns the suggestedPresentationDelay as specified in the manifest
   * @returns {String} suggestedPresentationDelay
   * @memberOf module:DashAdapter
   * @instance
   */


  function getSuggestedPresentationDelay() {
    var mpd = voPeriods.length > 0 ? voPeriods[0].mpd : null;
    return dashManifestModel.getSuggestedPresentationDelay(mpd);
  }
  /**
   * Returns the availabilityStartTime as specified in the manifest
   * @param {object} externalManifest Omit this value if no external manifest should be used
   * @returns {number} availabilityStartTime
   * @memberOf module:DashAdapter
   * @instance
   */


  function getAvailabilityStartTime(externalManifest) {
    var mpd = getMpd(externalManifest);
    return dashManifestModel.getAvailabilityStartTime(mpd);
  }
  /**
   * Returns a boolean indicating if the manifest is dynamic or not
   * @param {object} externalManifest Omit this value if no external manifest should be used
   * @returns {boolean}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getIsDynamic(externalManifest) {
    var manifest = getManifest(externalManifest);
    return dashManifestModel.getIsDynamic(manifest);
  }
  /**
   * Returns the duration of the MPD
   * @param {object} externalManifest Omit this value if no external manifest should be used
   * @returns {number} duration
   * @memberOf module:DashAdapter
   * @instance
   */


  function getDuration(externalManifest) {
    var manifest = getManifest(externalManifest);
    return dashManifestModel.getDuration(manifest);
  }
  /**
   * Returns all periods of the MPD
   * @param {object} externalManifest Omit this value if no external manifest should be used
   * @returns {Array} periods
   * @memberOf module:DashAdapter
   * @instance
   */


  function getRegularPeriods(externalManifest) {
    var mpd = getMpd(externalManifest);
    return dashManifestModel.getRegularPeriods(mpd);
  }
  /**
   * Returns an MPD object
   * @param {object} externalManifest Omit this value if no external manifest should be used
   * @returns {object} MPD
   * @memberOf module:DashAdapter
   * @instance
   */


  function getMpd(externalManifest) {
    var manifest = getManifest(externalManifest);
    return dashManifestModel.getMpd(manifest);
  }
  /**
   * Returns the ContentSteering element of the MPD
   * @param {object} manifest
   * @returns {object} contentSteering
   * @memberOf module:DashAdapter
   * @instance
   */


  function getContentSteering(manifest) {
    return dashManifestModel.getContentSteering(manifest);
  }
  /**
   * Returns the location element of the MPD
   * @param {object} manifest
   * @returns {String} location
   * @memberOf module:DashAdapter
   * @instance
   */


  function getLocation(manifest) {
    return dashManifestModel.getLocation(manifest);
  }
  /**
   * Returns the manifest update period used for dynamic manifests
   * @param {object} manifest
   * @param {number} latencyOfLastUpdate
   * @returns {NaN|number} manifestUpdatePeriod
   * @memberOf module:DashAdapter
   * @instance
   */


  function getManifestUpdatePeriod(manifest) {
    var latencyOfLastUpdate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    return dashManifestModel.getManifestUpdatePeriod(manifest, latencyOfLastUpdate);
  }
  /**
   * Returns the publish time from the manifest
   * @param {object} manifest
   * @returns {Date|null} publishTime
   * @memberOf module:DashAdapter
   * @instance
   */


  function getPublishTime(manifest) {
    return dashManifestModel.getPublishTime(manifest);
  }
  /**
   * Returns the patch locations of the MPD if existing and if they are still valid
   * @param {object} manifest
   * @returns {PatchLocation[]} patch location
   * @memberOf module:DashAdapter
   * @instance
   */


  function getPatchLocation(manifest) {
    var patchLocations = dashManifestModel.getPatchLocation(manifest);
    var publishTime = dashManifestModel.getPublishTime(manifest); // short-circuit when no patch location or publish time exists

    if (!patchLocations || patchLocations.length === 0 || !publishTime) {
      return [];
    }

    return patchLocations.filter(function (patchLocation) {
      // check if the patch location has expired, if so do not consider it
      return isNaN(patchLocation.ttl) || publishTime.getTime() + patchLocation.ttl > new Date().getTime();
    });
  }
  /**
   * Checks if the manifest has a DVB profile
   * @param {object} manifest
   * @returns {boolean}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getIsDVB(manifest) {
    return dashManifestModel.hasProfile(manifest, PROFILE_DVB);
  }
  /**
   * Checks if the manifest is actually just a patch manifest
   * @param  {object} manifest
   * @return {boolean}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getIsPatch(manifest) {
    return patchManifestModel.getIsPatch(manifest);
  }
  /**
   * Returns the base urls for a given element
   * @param {object} node
   * @returns {BaseURL[]}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getBaseURLsFromElement(node) {
    return dashManifestModel.getBaseURLsFromElement(node);
  }
  /**
   * Returns the function to sort the Representations
   * @returns {function}
   * @memberOf module:DashAdapter
   * @instance
   * @ignore
   */


  function getRepresentationSortFunction() {
    return dashManifestModel.getRepresentationSortFunction();
  }
  /**
   * Returns the codec for a given adaptation set and a given representation id.
   * @param {object} adaptation
   * @param {number} representationId
   * @param {boolean} addResolutionInfo Defines whether to include resolution information in the output
   * @returns {String} codec
   * @memberOf module:DashAdapter
   * @instance
   */


  function getCodec(adaptation, representationId, addResolutionInfo) {
    return dashManifestModel.getCodec(adaptation, representationId, addResolutionInfo);
  }
  /**
   * Returns the bandwidth for a given representation id and the corresponding period index
   * @param {number} representationId
   * @param {number} periodIdx
   * @returns {number} bandwidth
   * @memberOf module:DashAdapter
   * @instance
   */


  function getBandwidthForRepresentation(representationId, periodIdx) {
    var representation;
    var period = getPeriod(periodIdx);
    representation = findRepresentation(period, representationId);
    return representation ? representation.bandwidth : null;
  }
  /**
   * Returns the index for a given representation id
   * @param {string} representationId
   * @param {number} periodIdx
   * @returns {number} index
   * @memberOf module:DashAdapter
   * @instance
   */


  function getIndexForRepresentation(representationId, periodIdx) {
    var period = getPeriod(periodIdx);
    return findRepresentationIndex(period, representationId);
  }
  /**
   * This method returns the current max index based on what is defined in the MPD.
   * @param {string} bufferType - String 'audio' or 'video',
   * @param {number} periodIdx - Make sure this is the period index not id
   * @return {number}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getMaxIndexForBufferType(bufferType, periodIdx) {
    var period = getPeriod(periodIdx);
    return findMaxBufferIndex(period, bufferType);
  }
  /**
   * Returns the voPeriod object for a given id
   * @param {String} id
   * @returns {object|null}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getPeriodById(id) {
    if (!id || voPeriods.length === 0) {
      return null;
    }

    var periods = voPeriods.filter(function (p) {
      return p.id === id;
    });

    if (periods && periods.length > 0) {
      return periods[0];
    }

    return null;
  }
  /**
   * Checks if the given AdaptationSet is from the given media type
   * @param {object} adaptation
   * @param {string} type
   * @return {boolean}
   * @memberOf module:DashAdapter
   * @instance
   */


  function getIsTypeOf(adaptation, type) {
    return dashManifestModel.getIsTypeOf(adaptation, type);
  }

  function reset() {
    voPeriods = [];
    currentMediaInfo = {};
  }
  /**
   * Checks if the supplied manifest is compatible for application of the supplied patch
   * @param  {object}  manifest
   * @param  {object}  patch
   * @return {boolean}
   * @memberOf module:DashAdapter
   * @instance
   */


  function isPatchValid(manifest, patch) {
    var manifestId = dashManifestModel.getId(manifest);
    var patchManifestId = patchManifestModel.getMpdId(patch);
    var manifestPublishTime = dashManifestModel.getPublishTime(manifest);
    var patchPublishTime = patchManifestModel.getPublishTime(patch);
    var originalManifestPublishTime = patchManifestModel.getOriginalPublishTime(patch); // Patches are considered compatible if the following are true
    // - MPD@id == Patch@mpdId
    // - MPD@publishTime == Patch@originalPublishTime
    // - MPD@publishTime < Patch@publishTime
    // - All values in comparison exist

    return !!(manifestId && patchManifestId && manifestId == patchManifestId && manifestPublishTime && originalManifestPublishTime && manifestPublishTime.getTime() == originalManifestPublishTime.getTime() && patchPublishTime && manifestPublishTime.getTime() < patchPublishTime.getTime());
  }
  /**
   * Takes a given patch and applies it to the provided manifest, assumes patch is valid for manifest
   * @param  {object} manifest
   * @param  {object} patch
   * @memberOf module:DashAdapter
   * @instance
   */


  function applyPatchToManifest(manifest, patch) {
    // get all operations from the patch and apply them in document order
    patchManifestModel.getPatchOperations(patch).forEach(function (operation) {
      var result = operation.getMpdTarget(manifest); // operation supplies a path that doesn't match mpd, skip

      if (result === null) {
        return;
      }

      var name = result.name,
          target = result.target,
          leaf = result.leaf; // short circuit for attribute selectors and text replacement

      if (operation.xpath.findsAttribute() || name === '__text') {
        switch (operation.action) {
          case 'add':
          case 'replace':
            // add and replace are just setting the value
            target[name] = operation.value;
            break;

          case 'remove':
            // remove is deleting the value
            delete target[name];
            break;
        }

        return;
      } // determine the relative insert position prior to possible removal


      var relativePosition = (target[name + '_asArray'] || []).indexOf(leaf);
      var insertBefore = operation.position === 'prepend' || operation.position === 'before'; // perform removal operation first, we have already capture the appropriate relative position

      if (operation.action === 'remove' || operation.action === 'replace') {
        // note that we ignore the 'ws' attribute of patch operations as it does not effect parsed mpd operations
        // purge the directly named entity
        delete target[name]; // if we did have a positional reference we need to purge from array set and restore X2JS proper semantics

        if (relativePosition != -1) {
          var targetArray = target[name + '_asArray'];
          targetArray.splice(relativePosition, 1);

          if (targetArray.length > 1) {
            target[name] = targetArray;
          } else if (targetArray.length == 1) {
            // xml parsing semantics, singular asArray must be non-array in the unsuffixed key
            target[name] = targetArray[0];
          } else {
            // all nodes of this type deleted, remove entry
            delete target[name + '_asArray'];
          }
        }
      } // Perform any add/replace operations now, technically RFC5261 only allows a single element to take the
      // place of a replaced element while the add case allows an arbitrary number of children.
      // Due to the both operations requiring the same insertion logic they have been combined here and we will
      // not enforce single child operations for replace, assertions should be made at patch parse time if necessary


      if (operation.action === 'add' || operation.action === 'replace') {
        // value will be an object with element name keys pointing to arrays of objects
        Object.keys(operation.value).forEach(function (insert) {
          var insertNodes = operation.value[insert];
          var updatedNodes = target[insert + '_asArray'] || [];

          if (updatedNodes.length === 0 && target[insert]) {
            updatedNodes.push(target[insert]);
          }

          if (updatedNodes.length === 0) {
            // no original nodes for this element type
            updatedNodes = insertNodes;
          } else {
            // compute the position we need to insert at, default to end of set
            var position = updatedNodes.length;

            if (insert == name && relativePosition != -1) {
              // if the inserted element matches the operation target (not leaf) and there is a relative position we
              // want the inserted position to be set such that our insertion is relative to original position
              // since replace has modified the array length we reduce the insert point by 1
              position = relativePosition + (insertBefore ? 0 : 1) + (operation.action == 'replace' ? -1 : 0);
            } else {
              // otherwise we are in an add append/prepend case or replace case that removed the target name completely
              position = insertBefore ? 0 : updatedNodes.length;
            } // we dont have to perform element removal for the replace case as that was done above


            updatedNodes.splice.apply(updatedNodes, [position, 0].concat(insertNodes));
          } // now we properly reset the element keys on the target to match parsing semantics


          target[insert + '_asArray'] = updatedNodes;
          target[insert] = updatedNodes.length == 1 ? updatedNodes[0] : updatedNodes;
        });
      }
    });
  } // #endregion PUBLIC FUNCTIONS
  // #region PRIVATE FUNCTIONS
  // --------------------------------------------------


  function getManifest(externalManifest) {
    return externalManifest ? externalManifest : voPeriods.length > 0 ? voPeriods[0].mpd.manifest : null;
  }

  function getAdaptationForMediaInfo(mediaInfo) {
    try {
      var selectedVoPeriod = getPeriodForStreamInfo(mediaInfo.streamInfo, voPeriods);
      var voAdaptations = dashManifestModel.getAdaptationsForPeriod(selectedVoPeriod);
      if (!mediaInfo || !mediaInfo.streamInfo || mediaInfo.streamInfo.id === undefined || !voAdaptations) return null;
      return voAdaptations[mediaInfo.index];
    } catch (e) {
      return null;
    }
  }

  function getPeriodForStreamInfo(streamInfo, voPeriodsArray) {
    var ln = voPeriodsArray.length;

    for (var i = 0; i < ln; i++) {
      var voPeriod = voPeriodsArray[i];
      if (streamInfo && streamInfo.id === voPeriod.id) return voPeriod;
    }

    return null;
  }

  function convertAdaptationToMediaInfo(adaptation) {
    if (!adaptation) {
      return null;
    }

    var mediaInfo = new _vo_MediaInfo__WEBPACK_IMPORTED_MODULE_2__["default"]();
    var realAdaptation = adaptation.period.mpd.manifest.Period_asArray[adaptation.period.index].AdaptationSet_asArray[adaptation.index];
    var viewpoint, acc, acc_rep, roles, accessibility;
    mediaInfo.id = adaptation.id;
    mediaInfo.index = adaptation.index;
    mediaInfo.type = adaptation.type;
    mediaInfo.streamInfo = convertPeriodToStreamInfo(adaptation.period);
    mediaInfo.representationCount = dashManifestModel.getRepresentationCount(realAdaptation);
    mediaInfo.labels = dashManifestModel.getLabelsForAdaptation(realAdaptation);
    mediaInfo.lang = dashManifestModel.getLanguageForAdaptation(realAdaptation);
    mediaInfo.segmentAlignment = dashManifestModel.getSegmentAlignment(realAdaptation);
    mediaInfo.subSegmentAlignment = dashManifestModel.getSubSegmentAlignment(realAdaptation);
    viewpoint = dashManifestModel.getViewpointForAdaptation(realAdaptation);
    mediaInfo.viewpoint = viewpoint.length ? viewpoint[0].value : undefined;
    mediaInfo.viewpointsWithSchemeIdUri = viewpoint;
    accessibility = dashManifestModel.getAccessibilityForAdaptation(realAdaptation);
    mediaInfo.accessibility = accessibility.map(function (accessibility) {
      var accessibilityValue = accessibility.value;
      var accessibilityData = accessibilityValue;

      if (accessibility.schemeIdUri && accessibility.schemeIdUri.search('cea-608') >= 0 && typeof cea608parser !== 'undefined') {
        if (accessibilityValue) {
          accessibilityData = 'cea-608:' + accessibilityValue;
        } else {
          accessibilityData = 'cea-608';
        }

        mediaInfo.embeddedCaptions = true;
      }

      return accessibilityData;
    });
    mediaInfo.accessibilitiesWithSchemeIdUri = accessibility;
    acc = dashManifestModel.getAudioChannelConfigurationForAdaptation(realAdaptation);
    mediaInfo.audioChannelConfiguration = acc.map(function (audioChannelConfiguration) {
      return audioChannelConfiguration.value;
    });
    mediaInfo.audioChannelConfigurationsWithSchemeIdUri = acc;

    if (mediaInfo.audioChannelConfiguration.length === 0 && Array.isArray(realAdaptation.Representation_asArray) && realAdaptation.Representation_asArray.length > 0) {
      acc_rep = dashManifestModel.getAudioChannelConfigurationForRepresentation(realAdaptation.Representation_asArray[0]);
      mediaInfo.audioChannelConfiguration = acc_rep.map(function (audioChannelConfiguration) {
        return audioChannelConfiguration.value;
      });
      mediaInfo.audioChannelConfigurationsWithSchemeIdUri = acc_rep;
    }

    roles = dashManifestModel.getRolesForAdaptation(realAdaptation);
    mediaInfo.roles = roles.map(function (role) {
      return role.value;
    });
    mediaInfo.rolesWithSchemeIdUri = roles;
    mediaInfo.codec = dashManifestModel.getCodec(realAdaptation);
    mediaInfo.mimeType = dashManifestModel.getMimeType(realAdaptation);
    mediaInfo.contentProtection = dashManifestModel.getContentProtectionData(realAdaptation);
    mediaInfo.bitrateList = dashManifestModel.getBitrateListForAdaptation(realAdaptation);
    mediaInfo.selectionPriority = dashManifestModel.getSelectionPriority(realAdaptation);

    if (mediaInfo.contentProtection) {
      // Get the default key ID and apply it to all key systems
      var keyIds = mediaInfo.contentProtection.map(function (cp) {
        return dashManifestModel.getKID(cp);
      }).filter(function (kid) {
        return kid !== null;
      });

      if (keyIds.length) {
        var keyId = keyIds[0];
        mediaInfo.contentProtection.forEach(function (cp) {
          cp.keyId = keyId;
        });
      }
    }

    mediaInfo.isText = dashManifestModel.getIsText(realAdaptation);
    mediaInfo.supplementalProperties = dashManifestModel.getSupplementalPropertiesForAdaptation(realAdaptation);

    if ((!mediaInfo.supplementalProperties || Object.keys(mediaInfo.supplementalProperties).length === 0) && Array.isArray(realAdaptation.Representation_asArray) && realAdaptation.Representation_asArray.length > 0) {
      var arr = realAdaptation.Representation_asArray.map(function (repr) {
        return dashManifestModel.getSupplementalPropertiesForRepresentation(repr);
      });

      if (arr.every(function (v) {
        return JSON.stringify(v) === JSON.stringify(arr[0]);
      })) {
        // only output Representation.supplementalProperties to mediaInfo, if they are present on all Representations
        mediaInfo.supplementalProperties = arr[0];
      }
    }

    mediaInfo.supplementalPropertiesAsArray = dashManifestModel.getSupplementalPropertiesAsArrayForAdaptation(realAdaptation);

    if ((!mediaInfo.supplementalPropertiesAsArray || mediaInfo.supplementalPropertiesAsArray.length === 0) && Array.isArray(realAdaptation.Representation_asArray) && realAdaptation.Representation_asArray.length > 0) {
      var _arr = realAdaptation.Representation_asArray.map(function (repr) {
        return dashManifestModel.getSupplementalPropertiesAsArrayForRepresentation(repr);
      });

      if (_arr.every(function (v) {
        return JSON.stringify(v) === JSON.stringify(_arr[0]);
      })) {
        // only output Representation.supplementalProperties to mediaInfo, if they are present on all Representations
        mediaInfo.supplementalPropertiesAsArray = _arr[0];
      }
    }

    mediaInfo.essentialProperties = dashManifestModel.getEssentialPropertiesForAdaptation(realAdaptation);
    mediaInfo.essentialPropertiesAsArray = dashManifestModel.getEssentialPropertiesAsArrayForAdaptation(realAdaptation);
    mediaInfo.isFragmented = dashManifestModel.getIsFragmented(realAdaptation);
    mediaInfo.isEmbedded = false;
    return mediaInfo;
  }

  function convertVideoInfoToEmbeddedTextInfo(mediaInfo, channel, lang) {
    mediaInfo.id = channel; // CC1, CC2, CC3, or CC4

    mediaInfo.index = 100 + parseInt(channel.substring(2, 3));
    mediaInfo.type = constants.TEXT;
    mediaInfo.codec = 'cea-608-in-SEI';
    mediaInfo.isEmbedded = true;
    mediaInfo.isFragmented = false;
    var normLang = bcp_47_normalize__WEBPACK_IMPORTED_MODULE_9___default()(lang);
    mediaInfo.lang = normLang ? normLang : lang;
    mediaInfo.roles = ['caption'];
    mediaInfo.rolesWithSchemeIdUri = [{
      schemeIdUri: 'urn:mpeg:dash:role:2011',
      value: 'caption'
    }];
  }

  function convertVideoInfoToThumbnailInfo(mediaInfo) {
    mediaInfo.type = constants.IMAGE;
  }

  function convertPeriodToStreamInfo(period) {
    var streamInfo = new _vo_StreamInfo__WEBPACK_IMPORTED_MODULE_3__["default"]();
    var THRESHOLD = 1;
    streamInfo.id = period.id;
    streamInfo.index = period.index;
    streamInfo.start = period.start;
    streamInfo.duration = period.duration;
    streamInfo.manifestInfo = convertMpdToManifestInfo(period.mpd);
    streamInfo.isLast = period.mpd.manifest.Period_asArray.length === 1 || Math.abs(streamInfo.start + streamInfo.duration - streamInfo.manifestInfo.duration) < THRESHOLD;
    return streamInfo;
  }

  function convertMpdToManifestInfo(mpd) {
    var manifestInfo = new _vo_ManifestInfo__WEBPACK_IMPORTED_MODULE_4__["default"]();
    manifestInfo.dvrWindowSize = mpd.timeShiftBufferDepth;
    manifestInfo.loadedTime = mpd.manifest.loadedTime;
    manifestInfo.availableFrom = mpd.availabilityStartTime;
    manifestInfo.minBufferTime = mpd.manifest.minBufferTime;
    manifestInfo.maxFragmentDuration = mpd.maxSegmentDuration;
    manifestInfo.duration = dashManifestModel.getDuration(mpd.manifest);
    manifestInfo.isDynamic = dashManifestModel.getIsDynamic(mpd.manifest);
    manifestInfo.serviceDescriptions = dashManifestModel.getServiceDescriptions(mpd.manifest);
    manifestInfo.protocol = mpd.manifest.protocol;
    return manifestInfo;
  }

  function checkConfig() {
    if (!constants) {
      throw new Error('setConfig function has to be called previously');
    }
  }

  function getPeriod(periodIdx) {
    return voPeriods.length > 0 ? voPeriods[0].mpd.manifest.Period_asArray[periodIdx] : null;
  }

  function findRepresentationIndex(period, representationId) {
    var index = findRepresentation(period, representationId, true);
    return index !== null ? index : -1;
  }

  function findRepresentation(period, representationId, returnIndex) {
    var adaptationSet, adaptationSetArray, representation, representationArray, adaptationSetArrayIndex, representationArrayIndex;

    if (period) {
      adaptationSetArray = period.AdaptationSet_asArray;

      for (adaptationSetArrayIndex = 0; adaptationSetArrayIndex < adaptationSetArray.length; adaptationSetArrayIndex = adaptationSetArrayIndex + 1) {
        adaptationSet = adaptationSetArray[adaptationSetArrayIndex];
        representationArray = adaptationSet.Representation_asArray;

        for (representationArrayIndex = 0; representationArrayIndex < representationArray.length; representationArrayIndex = representationArrayIndex + 1) {
          representation = representationArray[representationArrayIndex];

          if (representationId === representation.id) {
            if (returnIndex) {
              return representationArrayIndex;
            } else {
              return representation;
            }
          }
        }
      }
    }

    return null;
  }

  function findMaxBufferIndex(period, bufferType) {
    var adaptationSet, adaptationSetArray, representationArray, adaptationSetArrayIndex;
    if (!period || !bufferType) return -1;
    adaptationSetArray = period.AdaptationSet_asArray;

    for (adaptationSetArrayIndex = 0; adaptationSetArrayIndex < adaptationSetArray.length; adaptationSetArrayIndex = adaptationSetArrayIndex + 1) {
      adaptationSet = adaptationSetArray[adaptationSetArrayIndex];
      representationArray = adaptationSet.Representation_asArray;

      if (dashManifestModel.getIsTypeOf(adaptationSet, bufferType)) {
        return representationArray.length;
      }
    }

    return -1;
  } // #endregion PRIVATE FUNCTIONS


  instance = {
    getBandwidthForRepresentation: getBandwidthForRepresentation,
    getIndexForRepresentation: getIndexForRepresentation,
    getMaxIndexForBufferType: getMaxIndexForBufferType,
    convertRepresentationToRepresentationInfo: convertRepresentationToRepresentationInfo,
    getStreamsInfo: getStreamsInfo,
    getMediaInfoForType: getMediaInfoForType,
    getAllMediaInfoForType: getAllMediaInfoForType,
    getAdaptationForType: getAdaptationForType,
    getRealAdaptation: getRealAdaptation,
    getProducerReferenceTimes: getProducerReferenceTimes,
    getRealPeriodByIndex: getRealPeriodByIndex,
    getEssentialPropertiesForRepresentation: getEssentialPropertiesForRepresentation,
    getVoRepresentations: getVoRepresentations,
    getEventsFor: getEventsFor,
    getEvent: getEvent,
    getMpd: getMpd,
    setConfig: setConfig,
    updatePeriods: updatePeriods,
    getIsTextTrack: getIsTextTrack,
    getUTCTimingSources: getUTCTimingSources,
    getSuggestedPresentationDelay: getSuggestedPresentationDelay,
    getAvailabilityStartTime: getAvailabilityStartTime,
    getIsTypeOf: getIsTypeOf,
    getIsDynamic: getIsDynamic,
    getDuration: getDuration,
    getRegularPeriods: getRegularPeriods,
    getContentSteering: getContentSteering,
    getLocation: getLocation,
    getPatchLocation: getPatchLocation,
    getManifestUpdatePeriod: getManifestUpdatePeriod,
    getPublishTime: getPublishTime,
    getIsDVB: getIsDVB,
    getIsPatch: getIsPatch,
    getBaseURLsFromElement: getBaseURLsFromElement,
    getRepresentationSortFunction: getRepresentationSortFunction,
    getCodec: getCodec,
    getPeriodById: getPeriodById,
    setCurrentMediaInfo: setCurrentMediaInfo,
    isPatchValid: isPatchValid,
    applyPatchToManifest: applyPatchToManifest,
    areMediaInfosEqual: areMediaInfosEqual,
    reset: reset
  };
  setup();
  return instance;
}

DashAdapter.__dashjs_factory_name = 'DashAdapter';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_6__["default"].getSingletonFactory(DashAdapter));

/***/ }),

/***/ "./src/dash/DashHandler.js":
/*!*********************************!*\
  !*** ./src/dash/DashHandler.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../streaming/vo/FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






var DEFAULT_ADJUST_SEEK_TIME_THRESHOLD = 0.5;
var SEGMENT_START_TIME_DELTA = 0.001;

function DashHandler(config) {
  config = config || {};
  var eventBus = config.eventBus;
  var debug = config.debug;
  var urlUtils = config.urlUtils;
  var type = config.type;
  var streamInfo = config.streamInfo;
  var segmentsController = config.segmentsController;
  var timelineConverter = config.timelineConverter;
  var baseURLController = config.baseURLController;
  var instance, logger, lastSegment, isDynamicManifest, mediaHasFinished;

  function setup() {
    logger = debug.getLogger(instance);
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }

  function initialize(isDynamic) {
    isDynamicManifest = isDynamic;
    mediaHasFinished = false;
    segmentsController.initialize(isDynamic);
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function getStreamInfo() {
    return streamInfo;
  }

  function resetInitialSettings() {
    lastSegment = null;
  }

  function reset() {
    resetInitialSettings();
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_3__["default"].DYNAMIC_TO_STATIC, _onDynamicToStatic, instance);
  }

  function _setRequestUrl(request, destination, representation) {
    var baseURL = baseURLController.resolve(representation.path);
    var url,
        serviceLocation,
        queryParams = {};

    if (!baseURL || destination === baseURL.url || !urlUtils.isRelative(destination)) {
      url = destination;
    } else {
      url = baseURL.url;
      serviceLocation = baseURL.serviceLocation;
      queryParams = baseURL.queryParams;

      if (destination) {
        url = urlUtils.resolve(destination, url);
      }
    }

    if (urlUtils.isRelative(url)) {
      return false;
    }

    request.url = url;
    request.serviceLocation = serviceLocation;
    request.queryParams = queryParams;
    return true;
  }

  function getInitRequest(mediaInfo, representation) {
    if (!representation) return null;
    return _generateInitRequest(mediaInfo, representation, getType());
  }

  function _generateInitRequest(mediaInfo, representation, mediaType) {
    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__["default"]();
    var period = representation.adaptation.period;
    var presentationStartTime = period.start;
    request.mediaType = mediaType;
    request.type = _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.INIT_SEGMENT_TYPE;
    request.range = representation.range;
    request.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationStartTime, representation, isDynamicManifest);
    request.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationStartTime + period.duration, representation, isDynamicManifest);
    request.quality = representation.index;
    request.mediaInfo = mediaInfo;
    request.representationId = representation.id;

    if (_setRequestUrl(request, representation.initialization, representation)) {
      request.url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(request.url, 'Bandwidth', representation.bandwidth);
      return request;
    }
  }

  function _getRequestForSegment(mediaInfo, segment) {
    if (segment === null || segment === undefined) {
      return null;
    }

    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_0__["default"]();
    var representation = segment.representation;
    var bandwidth = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].bandwidth;
    var url = segment.media;
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Number', segment.replacementNumber);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Time', segment.replacementTime);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceTokenForTemplate)(url, 'Bandwidth', bandwidth);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.replaceIDForTemplate)(url, representation.id);
    url = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_4__.unescapeDollarsInTemplate)(url);
    request.mediaType = getType();
    request.type = _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.MEDIA_SEGMENT_TYPE;
    request.range = segment.mediaRange;
    request.startTime = segment.presentationStartTime;
    request.mediaStartTime = segment.mediaStartTime;
    request.duration = segment.duration;
    request.timescale = representation.timescale;
    request.availabilityStartTime = segment.availabilityStartTime;
    request.availabilityEndTime = segment.availabilityEndTime;
    request.availabilityTimeComplete = representation.availabilityTimeComplete;
    request.wallStartTime = segment.wallStartTime;
    request.quality = representation.index;
    request.index = segment.index;
    request.mediaInfo = mediaInfo;
    request.adaptationIndex = representation.adaptation.index;
    request.representationId = representation.id;

    if (_setRequestUrl(request, url, representation)) {
      return request;
    }
  }

  function isLastSegmentRequested(representation, bufferingTime) {
    if (!representation || !lastSegment) {
      return false;
    } // Either transition from dynamic to static was done or no next static segment found


    if (mediaHasFinished) {
      return true;
    } // Period is endless


    if (!isFinite(representation.adaptation.period.duration)) {
      return false;
    } // we are replacing existing stuff in the buffer for instance after a track switch


    if (lastSegment.presentationStartTime + lastSegment.duration > bufferingTime) {
      return false;
    } // Additional segment references may be added to the last period.
    // Additional periods may be added to the end of the MPD.
    // Segment references SHALL NOT be added to any period other than the last period.
    // An MPD update MAY combine adding segment references to the last period with adding of new periods. An MPD update that adds content MAY be combined with an MPD update that removes content.
    // The index of the last requested segment is higher than the number of available segments.
    // For SegmentTimeline and SegmentTemplate the index does not include the startNumber.
    // For SegmentList the index includes the startnumber which is why the numberOfSegments includes this as well


    if (representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.numberOfSegments) && !isNaN(lastSegment.index) && lastSegment.index >= representation.mediaFinishedInformation.numberOfSegments - 1) {
      // For static manifests and Template addressing we can compare the index against the number of available segments
      if (!isDynamicManifest || representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_TEMPLATE) {
        return true;
      } // For SegmentList we need to check if the next period is signaled
      else if (isDynamicManifest && representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_LIST && representation.adaptation.period.nextPeriodId) {
        return true;
      }
    } // For dynamic SegmentTimeline manifests we need to check if the next period is already signaled and the segment we fetched before is the last one that is signaled.
    // We can not simply use the index, as numberOfSegments might have decreased after an MPD update


    return !!(isDynamicManifest && representation.adaptation.period.nextPeriodId && representation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_5__["default"].SEGMENT_TIMELINE && representation.mediaFinishedInformation && !isNaN(representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment) && lastSegment && !isNaN(lastSegment.mediaStartTime) && !isNaN(lastSegment.duration) && lastSegment.mediaStartTime + lastSegment.duration >= representation.mediaFinishedInformation.mediaTimeOfLastSignaledSegment - 0.05);
  }

  function getSegmentRequestForTime(mediaInfo, representation, time) {
    var request = null;

    if (!representation || !representation.segmentInfoType) {
      return request;
    }

    var segment = segmentsController.getSegmentByTime(representation, time);

    if (segment) {
      lastSegment = segment;
      logger.debug('Index for time ' + time + ' is ' + segment.index);
      request = _getRequestForSegment(mediaInfo, segment);
    }

    return request;
  }
  /**
   * This function returns the next segment request without modifying any internal variables. Any class (e.g CMCD Model) that needs information about the upcoming request should use this method.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */


  function getNextSegmentRequestIdempotent(mediaInfo, representation) {
    var request = null;
    var indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    var segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1);
    if (!segment) return null;
    request = _getRequestForSegment(mediaInfo, segment);
    return request;
  }
  /**
   * Main function to get the next segment request.
   * @param {object} mediaInfo
   * @param {object} representation
   * @return {FragmentRequest|null}
   */


  function getNextSegmentRequest(mediaInfo, representation) {
    if (!representation || !representation.segmentInfoType) {
      return null;
    }

    var indexToRequest = lastSegment ? lastSegment.index + 1 : 0;
    return _getRequest(mediaInfo, representation, indexToRequest);
  }

  function repeatSegmentRequest(mediaInfo, representation) {
    if (!representation || !representation.segmentInfoType) {
      return null;
    }

    var indexToRequest = lastSegment ? lastSegment.index : 0;
    return _getRequest(mediaInfo, representation, indexToRequest);
  }

  function _getRequest(mediaInfo, representation, indexToRequest) {
    var request = null;
    var segment = segmentsController.getSegmentByIndex(representation, indexToRequest, lastSegment ? lastSegment.mediaStartTime : -1); // No segment found

    if (!segment) {
      // Dynamic manifest there might be something available in the next iteration
      if (isDynamicManifest && !mediaHasFinished) {
        logger.debug(getType() + ' No segment found at index: ' + indexToRequest + '. Wait for next loop');
        return null;
      } else {
        mediaHasFinished = true;
      }
    } else {
      request = _getRequestForSegment(mediaInfo, segment);
      lastSegment = segment;
    }

    return request;
  }
  /**
   * This function returns a time larger than the current time for which we can generate a request.
   * This is useful in scenarios in which the user seeks into a gap in a dynamic Timeline manifest. We will not find a valid request then and need to adjust the seektime.
   * @param {number} time
   * @param {object} mediaInfo
   * @param {object} representation
   * @param {number} targetThreshold
   * @return {number}
   */


  function getValidTimeAheadOfTargetTime(time, mediaInfo, representation, targetThreshold) {
    try {
      if (isNaN(time) || !mediaInfo || !representation) {
        return NaN;
      }

      if (time < 0) {
        time = 0;
      }

      if (isNaN(targetThreshold)) {
        targetThreshold = DEFAULT_ADJUST_SEEK_TIME_THRESHOLD;
      }

      if (getSegmentRequestForTime(mediaInfo, representation, time)) {
        return time;
      }

      if (representation.adaptation.period.start + representation.adaptation.period.duration < time) {
        return NaN;
      } // If we have a duration look until the end of the duration, otherwise maximum 30 seconds


      var end = isFinite(representation.adaptation.period.duration) ? representation.adaptation.period.start + representation.adaptation.period.duration : time + 30;
      var currentUpperTime = Math.min(time + targetThreshold, end);
      var adjustedTime = NaN;
      var targetRequest = null;

      while (currentUpperTime <= end) {
        var upperRequest = null;

        if (currentUpperTime <= end) {
          upperRequest = getSegmentRequestForTime(mediaInfo, representation, currentUpperTime);
        }

        if (upperRequest) {
          adjustedTime = currentUpperTime;
          targetRequest = upperRequest;
          break;
        }

        currentUpperTime += targetThreshold;
      }

      if (targetRequest) {
        var requestEndTime = targetRequest.startTime + targetRequest.duration; // Keep the original start time in case it is covered by a segment

        if (time > targetRequest.startTime && requestEndTime - time > targetThreshold) {
          return time;
        }

        if (!isNaN(targetRequest.startTime) && time < targetRequest.startTime && adjustedTime > targetRequest.startTime) {
          // Apply delta to segment start time to get around rounding issues
          return targetRequest.startTime + SEGMENT_START_TIME_DELTA;
        }

        return Math.min(requestEndTime - targetThreshold, adjustedTime);
      }

      return adjustedTime;
    } catch (e) {
      return NaN;
    }
  }

  function getCurrentIndex() {
    return lastSegment ? lastSegment.index : -1;
  }

  function _onDynamicToStatic() {
    logger.debug('Dynamic stream complete');
    mediaHasFinished = true;
  }

  instance = {
    getCurrentIndex: getCurrentIndex,
    getInitRequest: getInitRequest,
    getNextSegmentRequest: getNextSegmentRequest,
    getNextSegmentRequestIdempotent: getNextSegmentRequestIdempotent,
    getSegmentRequestForTime: getSegmentRequestForTime,
    getStreamId: getStreamId,
    getStreamInfo: getStreamInfo,
    getType: getType,
    getValidTimeAheadOfTargetTime: getValidTimeAheadOfTargetTime,
    initialize: initialize,
    isLastSegmentRequested: isLastSegmentRequested,
    repeatSegmentRequest: repeatSegmentRequest,
    reset: reset
  };
  setup();
  return instance;
}

DashHandler.__dashjs_factory_name = 'DashHandler';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(DashHandler));

/***/ }),

/***/ "./src/dash/DashMetrics.js":
/*!*********************************!*\
  !*** ./src/dash/DashMetrics.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _utils_Round10__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/Round10 */ "./src/dash/utils/Round10.js");
/* harmony import */ var _streaming_models_MetricsModel__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../streaming/models/MetricsModel */ "./src/streaming/models/MetricsModel.js");
/* harmony import */ var _core_Utils__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/Utils */ "./src/core/Utils.js");
/* harmony import */ var _streaming_vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../streaming/vo/metrics/PlayList */ "./src/streaming/vo/metrics/PlayList.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */








/**
 * @module DashMetrics
 * @description The DashMetrics module can be accessed using the MediaPlayer API getDashMetrics()
 * @param {object} config
 */

function DashMetrics(config) {
  config = config || {};
  var context = this.context;
  var instance, playListTraceMetricsClosed, playListTraceMetrics, playListMetrics;
  var metricsModel = config.metricsModel;

  function setup() {
    metricsModel = metricsModel || (0,_streaming_models_MetricsModel__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance({
      settings: config.settings
    });
    resetInitialSettings();
  }

  function resetInitialSettings() {
    playListTraceMetricsClosed = true;
    playListTraceMetrics = null;
    playListMetrics = null;
  }
  /**
   * Returns the latest Representation switch for a given media type
   * @param {MediaType} mediaType
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentRepresentationSwitch(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);
    return getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].TRACK_SWITCH);
  }
  /**
   * @param {MediaType} mediaType
   * @param {Date} t time of the switch event
   * @param {Date} mt media presentation time
   * @param {string} to id of representation
   * @param {string} lto if present, subrepresentation reference
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addRepresentationSwitch(mediaType, t, mt, to, lto) {
    metricsModel.addRepresentationSwitch(mediaType, t, mt, to, lto);
  }
  /**
   * Returns the current buffer state for a given media type
   * @param {MediaType} mediaType
   * @returns {number}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentBufferState(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);
    return getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].BUFFER_STATE);
  }
  /**
   * Returns the current buffer level for a given media type
   * @param {MediaType} mediaType
   * @returns {number}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentBufferLevel(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);
    var metric = getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].BUFFER_LEVEL);

    if (metric) {
      return _utils_Round10__WEBPACK_IMPORTED_MODULE_4__["default"].round10(metric.level / 1000, -3);
    }

    return 0;
  }
  /**
   * @param {MediaType} mediaType
   * @param {number} t
   * @param {number} level
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addBufferLevel(mediaType, t, level) {
    metricsModel.addBufferLevel(mediaType, t, level);
  }
  /**
   * @param {MediaType} mediaType
   * @param {string} state
   * @param {number} target
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addBufferState(mediaType, state, target) {
    metricsModel.addBufferState(mediaType, state, target);
  }
  /**
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function clearAllCurrentMetrics() {
    metricsModel.clearAllCurrentMetrics();
  }
  /**
   * Returns the latest HTTP request for a given media type
   * @param {MediaType} mediaType
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentHttpRequest(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);

    if (!metrics) {
      return null;
    }

    var httpList = metrics.HttpList;
    var currentHttpList = null;
    var httpListLastIndex;

    if (!httpList || httpList.length <= 0) {
      return null;
    }

    httpListLastIndex = httpList.length - 1;

    while (httpListLastIndex >= 0) {
      if (httpList[httpListLastIndex].responsecode) {
        currentHttpList = httpList[httpListLastIndex];
        break;
      }

      httpListLastIndex--;
    }

    return currentHttpList;
  }
  /**
   * Returns all HTTP requests for a given media type
   * @param {MediaType} mediaType
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getHttpRequests(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);

    if (!metrics) {
      return [];
    }

    return !!metrics.HttpList ? metrics.HttpList : [];
  }
  /**
   * @param {MediaType} mediaType
   * @param {Array} loadingRequests
   * @param {Array} executedRequests
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addRequestsQueue(mediaType, loadingRequests, executedRequests) {
    metricsModel.addRequestsQueue(mediaType, loadingRequests, executedRequests);
  }
  /**
   * Returns the latest metrics for a given metric list and specific metric name
   * @param {MetricsList} metrics
   * @param {string} metricName
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrent(metrics, metricName) {
    if (!metrics) {
      return null;
    }

    var list = metrics[metricName];
    return !list || list.length === 0 ? null : list[list.length - 1];
  }
  /**
   * Returns the number of dropped frames
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentDroppedFrames() {
    var metrics = metricsModel.getMetricsFor(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, true);
    return getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].DROPPED_FRAMES);
  }
  /**
   * @param {number} quality
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addDroppedFrames(quality) {
    metricsModel.addDroppedFrames(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, quality);
  }
  /**
   * Returns the current scheduling info for a given media type
   * @param {MediaType} mediaType
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentSchedulingInfo(mediaType) {
    var metrics = metricsModel.getMetricsFor(mediaType, true);
    return getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].SCHEDULING_INFO);
  }
  /**
   * @param {object} request
   * @param {string} state
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addSchedulingInfo(request, state) {
    metricsModel.addSchedulingInfo(request.mediaType, new Date(), request.type, request.startTime, request.availabilityStartTime, request.duration, request.quality, request.range, state);
  }
  /**
   * Returns the current manifest update information
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentManifestUpdate() {
    var streamMetrics = metricsModel.getMetricsFor(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].STREAM);
    return getCurrent(streamMetrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].MANIFEST_UPDATE);
  }
  /**
   * @param {object} updatedFields fields to be updated
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function updateManifestUpdateInfo(updatedFields) {
    var manifestUpdate = this.getCurrentManifestUpdate();
    metricsModel.updateManifestUpdateInfo(manifestUpdate, updatedFields);
  }
  /**
   * @param {object} streamInfo
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addManifestUpdateStreamInfo(streamInfo) {
    if (streamInfo) {
      var manifestUpdate = this.getCurrentManifestUpdate();
      metricsModel.addManifestUpdateStreamInfo(manifestUpdate, streamInfo.id, streamInfo.index, streamInfo.start, streamInfo.duration);
    }
  }
  /**
   * @param {object} request
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addManifestUpdate(request) {
    metricsModel.addManifestUpdate(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].STREAM, request.type, request.requestStartDate, request.requestEndDate);
  }
  /**
   * @param {object} request
   * @param {string} responseURL
   * @param {number} responseStatus
   * @param {object} responseHeaders
   * @param {object} traces
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addHttpRequest(request, responseURL, responseStatus, responseHeaders, traces, cmsd) {
    metricsModel.addHttpRequest(request.mediaType, null, request.type, request.url, request.quality, responseURL, request.serviceLocation || null, request.range || null, request.requestStartDate, request.firstByteDate, request.requestEndDate, responseStatus, request.duration, responseHeaders, traces, request.fileLoaderType, cmsd);
  }
  /**
   * @param {object} representation
   * @param {MediaType} mediaType
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addManifestUpdateRepresentationInfo(representation, mediaType) {
    if (representation) {
      var manifestUpdateInfo = this.getCurrentManifestUpdate();
      metricsModel.addManifestUpdateRepresentationInfo(manifestUpdateInfo, representation.id, representation.index, representation.streamIndex, mediaType, representation.presentationTimeOffset, representation.startNumber, representation.fragmentInfoType);
    }
  }
  /**
   * Returns the current DVR window
   * @param {MediaType} mediaType
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getCurrentDVRInfo(mediaType) {
    var metrics = mediaType ? metricsModel.getMetricsFor(mediaType, true) : metricsModel.getMetricsFor(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, true) || metricsModel.getMetricsFor(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO, true);
    return getCurrent(metrics, _streaming_constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"].DVR_INFO);
  }
  /**
   * @param {MediaType} mediaType
   * @param {Date} currentTime time of the switch event
   * @param {object} mpd mpd reference
   * @param {object} range range of the dvr info
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addDVRInfo(mediaType, currentTime, mpd, range) {
    metricsModel.addDVRInfo(mediaType, currentTime, mpd, range);
  }
  /**
   * Returns the value for a specific request headers used in the latest MPD request
   * @param {string} id
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getLatestMPDRequestHeaderValueByID(id) {
    if (!id) {
      return null;
    }

    var headers = {};
    var httpRequestList, httpRequest, i;
    httpRequestList = getHttpRequests(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].STREAM);

    for (i = httpRequestList.length - 1; i >= 0; i--) {
      httpRequest = httpRequestList[i];

      if (httpRequest.type === _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_1__.HTTPRequest.MPD_TYPE) {
        headers = _core_Utils__WEBPACK_IMPORTED_MODULE_6__["default"].parseHttpHeaders(httpRequest._responseHeaders);
        break;
      }
    }

    var value = headers[id.toLowerCase()];
    return value === undefined ? null : value;
  }
  /**
   * Returns the value for a specific request headers used in the latest fragment request
   * @param {MediaType} mediaType
   * @param {string} id
   * @returns {*}
   * @memberof module:DashMetrics
   * @instance
   */


  function getLatestFragmentRequestHeaderValueByID(mediaType, id) {
    if (!id) {
      return null;
    }

    var headers = {};
    var httpRequest = getCurrentHttpRequest(mediaType);

    if (httpRequest) {
      headers = _core_Utils__WEBPACK_IMPORTED_MODULE_6__["default"].parseHttpHeaders(httpRequest._responseHeaders);
    }

    var value = headers[id.toLowerCase()];
    return value === undefined ? null : value;
  }
  /**
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addPlayList() {
    if (playListMetrics) {
      metricsModel.addPlayList(playListMetrics);
      playListMetrics = null;
    }
  }
  /**
   * Create a new playlist metric
   * @param {number} mediaStartTime
   * @param {string} startReason
   * @ignore
   */


  function createPlaylistMetrics(mediaStartTime, startReason) {
    playListMetrics = new _streaming_vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_7__.PlayList();
    playListMetrics.start = new Date();
    playListMetrics.mstart = mediaStartTime;
    playListMetrics.starttype = startReason;
  }
  /**
   * Create a playlist trace metric
   * @param {number} representationId
   * @param {number} mediaStartTime
   * @param {number} speed
   * @ignore
   */


  function createPlaylistTraceMetrics(representationId, mediaStartTime, speed) {
    if (playListTraceMetricsClosed === true) {
      playListTraceMetricsClosed = false;
      playListTraceMetrics = new _streaming_vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_7__.PlayListTrace();
      playListTraceMetrics.representationid = representationId;
      playListTraceMetrics.start = new Date();
      playListTraceMetrics.mstart = mediaStartTime;
      playListTraceMetrics.playbackspeed = speed !== null ? speed.toString() : null;
    }
  }
  /**
   * Update existing playlist trace metric
   * @param {object} traceToUpdate
   * @ignore
   */


  function updatePlayListTraceMetrics(traceToUpdate) {
    if (playListTraceMetrics) {
      for (var field in playListTraceMetrics) {
        playListTraceMetrics[field] = traceToUpdate[field];
      }
    }
  }
  /**
   * Push a new playlist trace metric
   * @param endTime
   * @param reason
   * @ignore
   */


  function pushPlayListTraceMetrics(endTime, reason) {
    if (playListTraceMetricsClosed === false && playListMetrics && playListTraceMetrics && playListTraceMetrics.start) {
      var startTime = playListTraceMetrics.start;
      var duration = endTime.getTime() - startTime.getTime();
      playListTraceMetrics.duration = duration;
      playListTraceMetrics.stopreason = reason;
      playListMetrics.trace.push(playListTraceMetrics);
      playListTraceMetricsClosed = true;
    }
  }
  /**
   * @param {object} errors
   * @memberof module:DashMetrics
   * @instance
   * @ignore
   */


  function addDVBErrors(errors) {
    metricsModel.addDVBErrors(errors);
  }

  instance = {
    getCurrentRepresentationSwitch: getCurrentRepresentationSwitch,
    getCurrentBufferState: getCurrentBufferState,
    getCurrentBufferLevel: getCurrentBufferLevel,
    getCurrentHttpRequest: getCurrentHttpRequest,
    getHttpRequests: getHttpRequests,
    getCurrentDroppedFrames: getCurrentDroppedFrames,
    getCurrentSchedulingInfo: getCurrentSchedulingInfo,
    getCurrentDVRInfo: getCurrentDVRInfo,
    getCurrentManifestUpdate: getCurrentManifestUpdate,
    getLatestFragmentRequestHeaderValueByID: getLatestFragmentRequestHeaderValueByID,
    getLatestMPDRequestHeaderValueByID: getLatestMPDRequestHeaderValueByID,
    addRepresentationSwitch: addRepresentationSwitch,
    addDVRInfo: addDVRInfo,
    updateManifestUpdateInfo: updateManifestUpdateInfo,
    addManifestUpdateStreamInfo: addManifestUpdateStreamInfo,
    addManifestUpdateRepresentationInfo: addManifestUpdateRepresentationInfo,
    addManifestUpdate: addManifestUpdate,
    addHttpRequest: addHttpRequest,
    addSchedulingInfo: addSchedulingInfo,
    addRequestsQueue: addRequestsQueue,
    addBufferLevel: addBufferLevel,
    addBufferState: addBufferState,
    addDroppedFrames: addDroppedFrames,
    addPlayList: addPlayList,
    addDVBErrors: addDVBErrors,
    createPlaylistMetrics: createPlaylistMetrics,
    createPlaylistTraceMetrics: createPlaylistTraceMetrics,
    updatePlayListTraceMetrics: updatePlayListTraceMetrics,
    pushPlayListTraceMetrics: pushPlayListTraceMetrics,
    clearAllCurrentMetrics: clearAllCurrentMetrics
  };
  setup();
  return instance;
}

DashMetrics.__dashjs_factory_name = 'DashMetrics';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(DashMetrics));

/***/ }),

/***/ "./src/dash/SegmentBaseLoader.js":
/*!***************************************!*\
  !*** ./src/dash/SegmentBaseLoader.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _vo_Segment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vo/Segment */ "./src/dash/vo/Segment.js");
/* harmony import */ var _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../streaming/vo/FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
/* harmony import */ var _streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/net/URLLoader */ "./src/streaming/net/URLLoader.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function SegmentBaseLoader() {
  var context = this.context;
  var instance, logger, errHandler, boxParser, requestModifier, dashMetrics, mediaPlayerModel, urlLoader, errors, constants, dashConstants, urlUtils, baseURLController;

  function setup() {}

  function initialize() {
    urlLoader = (0,_streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create({
      errHandler: errHandler,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      requestModifier: requestModifier,
      boxParser: boxParser,
      errors: errors,
      urlUtils: urlUtils,
      constants: constants,
      dashConstants: dashConstants
    });
  }

  function setConfig(config) {
    if (config.baseURLController) {
      baseURLController = config.baseURLController;
    }

    if (config.dashMetrics) {
      dashMetrics = config.dashMetrics;
    }

    if (config.mediaPlayerModel) {
      mediaPlayerModel = config.mediaPlayerModel;
    }

    if (config.errHandler) {
      errHandler = config.errHandler;
    }

    if (config.boxParser) {
      boxParser = config.boxParser;
    }

    if (config.debug) {
      logger = config.debug.getLogger(instance);
    }

    if (config.requestModifier) {
      requestModifier = config.requestModifier;
    }

    if (config.errors) {
      errors = config.errors;
    }

    if (config.urlUtils) {
      urlUtils = config.urlUtils;
    }

    if (config.constants) {
      constants = config.constants;
    }

    if (config.dashConstants) {
      dashConstants = config.dashConstants;
    }
  }

  function loadInitialization(representation, mediaType) {
    return new Promise(function (resolve) {
      _loadInitializationRecursively(representation, mediaType, resolve);
    });
  }

  function _loadInitializationRecursively(representation, mediaType, resolve, loadingInfo) {
    var initRange = null;
    var baseUrl = representation ? baseURLController.resolve(representation.path) : null;
    var info = loadingInfo || {
      init: true,
      url: baseUrl ? baseUrl.url : undefined,
      range: {
        start: 0,
        end: 1500
      },
      searching: false,
      bytesLoaded: 0,
      bytesToLoad: 1500,
      mediaType: mediaType
    };
    logger.debug('Start searching for initialization.');
    var request = getFragmentRequest(info);

    var onload = function onload(response) {
      info.bytesLoaded = info.range.end;
      initRange = boxParser.findInitRange(response);

      if (initRange) {
        representation.range = initRange; // note that we don't explicitly set rep.initialization as this
        // will be computed when all BaseURLs are resolved later

        resolve(representation);
      } else {
        info.range.end = info.bytesLoaded + info.bytesToLoad;
        return _loadInitializationRecursively(representation, mediaType, resolve, info);
      }
    };

    var onerror = function onerror() {
      resolve(representation);
    };

    urlLoader.load({
      request: request,
      success: onload,
      error: onerror
    });
    logger.debug('Perform init search: ' + info.url);
  }

  function loadSegments(representation, mediaType, range) {
    return new Promise(function (resolve) {
      _loadSegmentsRecursively(representation, mediaType, range, resolve);
    });
  }

  function _loadSegmentsRecursively(representation, mediaType, range, resolve, callback, loadingInfo) {
    if (range && (range.start === undefined || range.end === undefined)) {
      var parts = range ? range.toString().split('-') : null;
      range = parts ? {
        start: parseFloat(parts[0]),
        end: parseFloat(parts[1])
      } : null;
    }

    callback = !callback ? onLoaded : callback;
    var isoFile = null;
    var sidx = null;
    var hasRange = !!range;
    var baseUrl = representation ? baseURLController.resolve(representation.path) : null;
    var info = {
      init: false,
      url: baseUrl ? baseUrl.url : undefined,
      range: hasRange ? range : {
        start: 0,
        end: 1500
      },
      searching: !hasRange,
      bytesLoaded: loadingInfo ? loadingInfo.bytesLoaded : 0,
      bytesToLoad: 1500,
      mediaType: mediaType
    };
    var request = getFragmentRequest(info);

    var onload = function onload(response) {
      var extraBytes = info.bytesToLoad;
      var loadedLength = response.byteLength;
      info.bytesLoaded = info.range.end - info.range.start;
      isoFile = boxParser.parse(response);
      sidx = isoFile.getBox('sidx');

      if (!sidx || !sidx.isComplete) {
        if (sidx) {
          info.range.start = sidx.offset || info.range.start;
          info.range.end = info.range.start + (sidx.size || extraBytes);
        } else if (loadedLength < info.bytesLoaded) {
          // if we have reached a search limit or if we have reached the end of the file we have to stop trying to find sidx
          callback(null, representation, resolve);
          return;
        } else {
          var lastBox = isoFile.getLastBox();

          if (lastBox && lastBox.size) {
            info.range.start = lastBox.offset + lastBox.size;
            info.range.end = info.range.start + extraBytes;
          } else {
            info.range.end += extraBytes;
          }
        }

        _loadSegmentsRecursively(representation, mediaType, info.range, resolve, null, info);
      } else {
        var ref = sidx.references;
        var loadMultiSidx, segments;

        if (ref !== null && ref !== undefined && ref.length > 0) {
          loadMultiSidx = ref[0].reference_type === 1;
        }

        if (loadMultiSidx) {
          logger.debug('Initiate multiple SIDX load.');
          info.range.end = info.range.start + sidx.size;
          var j, len, ss, se, r;
          var segs = [];
          var count = 0;
          var offset = (sidx.offset || info.range.start) + sidx.size;

          var tmpCallback = function tmpCallback(result) {
            if (result) {
              segs = segs.concat(result);
              count++;

              if (count >= len) {
                // http requests can be processed in a wrong order, so, we have to reorder segments with an ascending start Time order
                segs.sort(function (a, b) {
                  return a.startTime - b.startTime < 0 ? -1 : 0;
                });
                callback(segs, representation, resolve);
              }
            } else {
              callback(null, representation, resolve);
            }
          };

          for (j = 0, len = ref.length; j < len; j++) {
            ss = offset;
            se = offset + ref[j].referenced_size - 1;
            offset = offset + ref[j].referenced_size;
            r = {
              start: ss,
              end: se
            };

            _loadSegmentsRecursively(representation, mediaType, r, resolve, tmpCallback, info);
          }
        } else {
          logger.debug('Parsing segments from SIDX. representation ' + mediaType + ' - id: ' + representation.id + ' for range : ' + info.range.start + ' - ' + info.range.end);
          segments = getSegmentsForSidx(sidx, info);
          callback(segments, representation, resolve);
        }
      }
    };

    var onerror = function onerror() {
      callback(null, representation, resolve);
    };

    urlLoader.load({
      request: request,
      success: onload,
      error: onerror
    });
    logger.debug("Perform SIDX load for type ".concat(mediaType, " : ").concat(info.url, " with range ").concat(info.range.start, " - ").concat(info.range.end));
  }

  function onLoaded(segments, representation, resolve) {
    resolve({
      segments: segments,
      representation: representation,
      error: segments ? undefined : new _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__["default"](errors.SEGMENT_BASE_LOADER_ERROR_CODE, errors.SEGMENT_BASE_LOADER_ERROR_MESSAGE)
    });
  }

  function reset() {
    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  function getSegmentsForSidx(sidx, info) {
    var refs = sidx.references;
    var len = refs.length;
    var timescale = sidx.timescale;
    var time = sidx.earliest_presentation_time;
    var start = info.range.start + sidx.offset + sidx.first_offset + sidx.size;
    var segments = [];
    var segment, end, duration, size;

    for (var i = 0; i < len; i++) {
      duration = refs[i].subsegment_duration;
      size = refs[i].referenced_size;
      segment = new _vo_Segment__WEBPACK_IMPORTED_MODULE_0__["default"](); // note that we don't explicitly set segment.media as this will be
      // computed when all BaseURLs are resolved later

      segment.duration = duration;
      segment.startTime = time;
      segment.timescale = timescale;
      end = start + size - 1;
      segment.mediaRange = start + '-' + end;
      segments.push(segment);
      time += duration;
      start += size;
    }

    return segments;
  }

  function getFragmentRequest(info) {
    if (!info.url) {
      return;
    }

    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_3__["default"]();
    request.setInfo(info);
    return request;
  }

  instance = {
    setConfig: setConfig,
    initialize: initialize,
    loadInitialization: loadInitialization,
    loadSegments: loadSegments,
    reset: reset
  };
  setup();
  return instance;
}

SegmentBaseLoader.__dashjs_factory_name = 'SegmentBaseLoader';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(SegmentBaseLoader));

/***/ }),

/***/ "./src/dash/WebmSegmentBaseLoader.js":
/*!*******************************************!*\
  !*** ./src/dash/WebmSegmentBaseLoader.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_utils_EBMLParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../streaming/utils/EBMLParser */ "./src/streaming/utils/EBMLParser.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_Segment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vo/Segment */ "./src/dash/vo/Segment.js");
/* harmony import */ var _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../streaming/vo/FragmentRequest */ "./src/streaming/vo/FragmentRequest.js");
/* harmony import */ var _streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../streaming/net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../streaming/vo/DashJSError */ "./src/streaming/vo/DashJSError.js");








function WebmSegmentBaseLoader() {
  var context = this.context;
  var instance, logger, WebM, errHandler, requestModifier, dashMetrics, mediaPlayerModel, urlLoader, errors, baseURLController;

  function setup() {
    WebM = {
      EBML: {
        tag: 0x1A45DFA3,
        required: true
      },
      Segment: {
        tag: 0x18538067,
        required: true,
        SeekHead: {
          tag: 0x114D9B74,
          required: true
        },
        Info: {
          tag: 0x1549A966,
          required: true,
          TimecodeScale: {
            tag: 0x2AD7B1,
            required: true,
            parse: 'getMatroskaUint'
          },
          Duration: {
            tag: 0x4489,
            required: true,
            parse: 'getMatroskaFloat'
          }
        },
        Tracks: {
          tag: 0x1654AE6B,
          required: true
        },
        Cues: {
          tag: 0x1C53BB6B,
          required: true,
          CuePoint: {
            tag: 0xBB,
            required: true,
            CueTime: {
              tag: 0xB3,
              required: true,
              parse: 'getMatroskaUint'
            },
            CueTrackPositions: {
              tag: 0xB7,
              required: true,
              CueTrack: {
                tag: 0xF7,
                required: true,
                parse: 'getMatroskaUint'
              },
              CueClusterPosition: {
                tag: 0xF1,
                required: true,
                parse: 'getMatroskaUint'
              }
            }
          }
        }
      },
      Void: {
        tag: 0xEC,
        required: true
      }
    };
  }

  function initialize() {
    urlLoader = (0,_streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_5__["default"])(context).create({
      errHandler: errHandler,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      requestModifier: requestModifier,
      errors: errors
    });
  }

  function setConfig(config) {
    if (!config.baseURLController || !config.dashMetrics || !config.mediaPlayerModel || !config.errHandler) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }

    baseURLController = config.baseURLController;
    dashMetrics = config.dashMetrics;
    mediaPlayerModel = config.mediaPlayerModel;
    errHandler = config.errHandler;
    errors = config.errors;
    logger = config.debug.getLogger(instance);
    requestModifier = config.requestModifier;
  }

  function parseCues(ab) {
    var cues = [];
    var ebmlParser = (0,_streaming_utils_EBMLParser__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
      data: ab
    });
    var cue, cueTrack;
    ebmlParser.consumeTagAndSize(WebM.Segment.Cues);

    while (ebmlParser.moreData() && ebmlParser.consumeTagAndSize(WebM.Segment.Cues.CuePoint, true)) {
      cue = {};
      cue.CueTime = ebmlParser.parseTag(WebM.Segment.Cues.CuePoint.CueTime);
      cue.CueTracks = [];

      while (ebmlParser.moreData() && ebmlParser.consumeTag(WebM.Segment.Cues.CuePoint.CueTrackPositions, true)) {
        var cueTrackPositionSize = ebmlParser.getMatroskaCodedNum();
        var startPos = ebmlParser.getPos();
        cueTrack = {};
        cueTrack.Track = ebmlParser.parseTag(WebM.Segment.Cues.CuePoint.CueTrackPositions.CueTrack);

        if (cueTrack.Track === 0) {
          throw new Error('Cue track cannot be 0');
        }

        cueTrack.ClusterPosition = ebmlParser.parseTag(WebM.Segment.Cues.CuePoint.CueTrackPositions.CueClusterPosition);
        cue.CueTracks.push(cueTrack); // we're not interested any other elements - skip remaining bytes

        ebmlParser.setPos(startPos + cueTrackPositionSize);
      }

      if (cue.CueTracks.length === 0) {
        throw new Error('Mandatory cuetrack not found');
      }

      cues.push(cue);
    }

    if (cues.length === 0) {
      throw new Error('mandatory cuepoint not found');
    }

    return cues;
  }

  function parseSegments(data, segmentStart, segmentEnd, segmentDuration) {
    var duration, parsed, segments, segment, i, len, start, end;
    parsed = parseCues(data);
    segments = []; // we are assuming one cue track per cue point
    // both duration and media range require the i + 1 segment
    // the final segment has to use global segment parameters

    for (i = 0, len = parsed.length; i < len; i += 1) {
      segment = new _vo_Segment__WEBPACK_IMPORTED_MODULE_3__["default"]();
      duration = 0;

      if (i < parsed.length - 1) {
        duration = parsed[i + 1].CueTime - parsed[i].CueTime;
      } else {
        duration = segmentDuration - parsed[i].CueTime;
      } // note that we don't explicitly set segment.media as this will be
      // computed when all BaseURLs are resolved later


      segment.duration = duration;
      segment.startTime = parsed[i].CueTime;
      segment.timescale = 1000; // hardcoded for ms

      start = parsed[i].CueTracks[0].ClusterPosition + segmentStart;

      if (i < parsed.length - 1) {
        end = parsed[i + 1].CueTracks[0].ClusterPosition + segmentStart - 1;
      } else {
        end = segmentEnd - 1;
      }

      segment.mediaRange = start + '-' + end;
      segments.push(segment);
    }

    logger.debug('Parsed cues: ' + segments.length + ' cues.');
    return segments;
  }

  function parseEbmlHeader(data, media, theRange, callback) {
    if (!data || data.byteLength === 0) {
      callback(null);
      return;
    }

    var ebmlParser = (0,_streaming_utils_EBMLParser__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
      data: data
    });
    var duration, segments, segmentEnd, segmentStart;
    var parts = theRange ? theRange.split('-') : null;
    var request = null;
    var info = {
      url: media,
      range: {
        start: parts ? parseFloat(parts[0]) : null,
        end: parts ? parseFloat(parts[1]) : null
      },
      request: request
    };
    logger.debug('Parse EBML header: ' + info.url); // skip over the header itself

    ebmlParser.skipOverElement(WebM.EBML);
    ebmlParser.consumeTag(WebM.Segment); // segments start here

    segmentEnd = ebmlParser.getMatroskaCodedNum();
    segmentEnd += ebmlParser.getPos();
    segmentStart = ebmlParser.getPos(); // skip over any top level elements to get to the segment info

    while (ebmlParser.moreData() && !ebmlParser.consumeTagAndSize(WebM.Segment.Info, true)) {
      if (!(ebmlParser.skipOverElement(WebM.Segment.SeekHead, true) || ebmlParser.skipOverElement(WebM.Segment.Tracks, true) || ebmlParser.skipOverElement(WebM.Segment.Cues, true) || ebmlParser.skipOverElement(WebM.Void, true))) {
        throw new Error('no valid top level element found');
      }
    } // we only need one thing in segment info, duration


    while (duration === undefined) {
      var infoTag = ebmlParser.getMatroskaCodedNum(true);
      var infoElementSize = ebmlParser.getMatroskaCodedNum();

      switch (infoTag) {
        case WebM.Segment.Info.Duration.tag:
          duration = ebmlParser[WebM.Segment.Info.Duration.parse](infoElementSize);
          break;

        default:
          ebmlParser.setPos(ebmlParser.getPos() + infoElementSize);
          break;
      }
    } // once we have what we need from segment info, we jump right to the
    // cues


    request = _getFragmentRequest(info);

    var onload = function onload(response) {
      segments = parseSegments(response, segmentStart, segmentEnd, duration);
      callback(segments);
    };

    var onloadend = function onloadend() {
      logger.error('Download Error: Cues ' + info.url);
      callback(null);
    };

    urlLoader.load({
      request: request,
      success: onload,
      error: onloadend
    });
    logger.debug('Perform cues load: ' + info.url + ' bytes=' + info.range.start + '-' + info.range.end);
  }

  function loadInitialization(representation, mediaType) {
    return new Promise(function (resolve) {
      var request = null;
      var baseUrl = representation ? baseURLController.resolve(representation.path) : null;
      var initRange = representation ? representation.range.split('-') : null;
      var info = {
        range: {
          start: initRange ? parseFloat(initRange[0]) : null,
          end: initRange ? parseFloat(initRange[1]) : null
        },
        request: request,
        url: baseUrl ? baseUrl.url : undefined,
        init: true,
        mediaType: mediaType
      };
      logger.info('Start loading initialization.');
      request = _getFragmentRequest(info);

      var onload = function onload() {
        // note that we don't explicitly set rep.initialization as this
        // will be computed when all BaseURLs are resolved later
        resolve(representation);
      };

      var onloadend = function onloadend() {
        resolve(representation);
      };

      urlLoader.load({
        request: request,
        success: onload,
        error: onloadend
      });
      logger.debug('Perform init load: ' + info.url);
    });
  }

  function loadSegments(representation, mediaType, theRange) {
    return new Promise(function (resolve) {
      var request = null;
      var baseUrl = representation ? baseURLController.resolve(representation.path) : null;
      var media = baseUrl ? baseUrl.url : undefined;
      var bytesToLoad = 8192;
      var info = {
        bytesLoaded: 0,
        bytesToLoad: bytesToLoad,
        range: {
          start: 0,
          end: bytesToLoad
        },
        request: request,
        url: media,
        init: false,
        mediaType: mediaType
      };
      request = _getFragmentRequest(info); // first load the header, but preserve the manifest range so we can
      // load the cues after parsing the header
      // NOTE: we expect segment info to appear in the first 8192 bytes

      logger.debug('Parsing ebml header');

      var onload = function onload(response) {
        parseEbmlHeader(response, media, theRange, function (segments) {
          resolve({
            segments: segments,
            representation: representation,
            error: segments ? undefined : new _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](errors.SEGMENT_BASE_LOADER_ERROR_CODE, errors.SEGMENT_BASE_LOADER_ERROR_MESSAGE)
          });
        });
      };

      var onloadend = function onloadend() {
        resolve({
          representation: representation,
          error: new _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](errors.SEGMENT_BASE_LOADER_ERROR_CODE, errors.SEGMENT_BASE_LOADER_ERROR_MESSAGE)
        });
      };

      urlLoader.load({
        request: request,
        success: onload,
        error: onloadend
      });
    });
  }

  function _getFragmentRequest(info) {
    var request = new _streaming_vo_FragmentRequest__WEBPACK_IMPORTED_MODULE_4__["default"]();
    request.setInfo(info);
    return request;
  }

  function reset() {
    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  instance = {
    setConfig: setConfig,
    initialize: initialize,
    loadInitialization: loadInitialization,
    loadSegments: loadSegments,
    reset: reset
  };
  setup();
  return instance;
}

WebmSegmentBaseLoader.__dashjs_factory_name = 'WebmSegmentBaseLoader';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(WebmSegmentBaseLoader));

/***/ }),

/***/ "./src/dash/constants/DashConstants.js":
/*!*********************************************!*\
  !*** ./src/dash/constants/DashConstants.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Dash constants declaration
 * @class
 * @ignore
 */
var DashConstants = /*#__PURE__*/function () {
  function DashConstants() {
    _classCallCheck(this, DashConstants);

    this.init();
  }

  _createClass(DashConstants, [{
    key: "init",
    value: function init() {
      this.BASE_URL = 'BaseURL';
      this.SEGMENT_BASE = 'SegmentBase';
      this.SEGMENT_TEMPLATE = 'SegmentTemplate';
      this.SEGMENT_LIST = 'SegmentList';
      this.SEGMENT_URL = 'SegmentURL';
      this.SEGMENT_TIMELINE = 'SegmentTimeline';
      this.SEGMENT_PROFILES = 'segmentProfiles';
      this.ADAPTATION_SET = 'AdaptationSet';
      this.REPRESENTATION = 'Representation';
      this.REPRESENTATION_INDEX = 'RepresentationIndex';
      this.SUB_REPRESENTATION = 'SubRepresentation';
      this.INITIALIZATION = 'Initialization';
      this.INITIALIZATION_MINUS = 'initialization';
      this.MPD = 'MPD';
      this.PERIOD = 'Period';
      this.ASSET_IDENTIFIER = 'AssetIdentifier';
      this.EVENT_STREAM = 'EventStream';
      this.ID = 'id';
      this.PROFILES = 'profiles';
      this.SERVICE_LOCATION = 'serviceLocation';
      this.RANGE = 'range';
      this.INDEX = 'index';
      this.MEDIA = 'media';
      this.BYTE_RANGE = 'byteRange';
      this.INDEX_RANGE = 'indexRange';
      this.MEDIA_RANGE = 'mediaRange';
      this.VALUE = 'value';
      this.CONTENT_TYPE = 'contentType';
      this.MIME_TYPE = 'mimeType';
      this.BITSTREAM_SWITCHING = 'BitstreamSwitching';
      this.BITSTREAM_SWITCHING_MINUS = 'bitstreamSwitching';
      this.CODECS = 'codecs';
      this.DEPENDENCY_ID = 'dependencyId';
      this.MEDIA_STREAM_STRUCTURE_ID = 'mediaStreamStructureId';
      this.METRICS = 'Metrics';
      this.METRICS_MINUS = 'metrics';
      this.REPORTING = 'Reporting';
      this.WIDTH = 'width';
      this.HEIGHT = 'height';
      this.SAR = 'sar';
      this.FRAMERATE = 'frameRate';
      this.AUDIO_SAMPLING_RATE = 'audioSamplingRate';
      this.MAXIMUM_SAP_PERIOD = 'maximumSAPPeriod';
      this.START_WITH_SAP = 'startWithSAP';
      this.MAX_PLAYOUT_RATE = 'maxPlayoutRate';
      this.CODING_DEPENDENCY = 'codingDependency';
      this.SCAN_TYPE = 'scanType';
      this.FRAME_PACKING = 'FramePacking';
      this.AUDIO_CHANNEL_CONFIGURATION = 'AudioChannelConfiguration';
      this.CONTENT_PROTECTION = 'ContentProtection';
      this.ESSENTIAL_PROPERTY = 'EssentialProperty';
      this.ESSENTIAL_PROPERTY_ASARRAY = 'EssentialProperty_asArray';
      this.SUPPLEMENTAL_PROPERTY = 'SupplementalProperty';
      this.SUPPLEMENTAL_PROPERTY_ASARRAY = 'SupplementalProperty_asArray';
      this.INBAND_EVENT_STREAM = 'InbandEventStream';
      this.PRODUCER_REFERENCE_TIME = 'ProducerReferenceTime';
      this.INBAND = 'inband';
      this.TYPE = 'type';
      this.ACCESSIBILITY = 'Accessibility';
      this.ROLE = 'Role';
      this.RATING = 'Rating';
      this.CONTENT_COMPONENT = 'ContentComponent';
      this.SUBSET = 'Subset';
      this.LANG = 'lang';
      this.VIEWPOINT = 'Viewpoint';
      this.VIEWPOINT_ASARRAY = 'Viewpoint_asArray';
      this.ROLE_ASARRAY = 'Role_asArray';
      this.REPRESENTATION_ASARRAY = 'Representation_asArray';
      this.PRODUCERREFERENCETIME_ASARRAY = 'ProducerReferenceTime_asArray';
      this.ACCESSIBILITY_ASARRAY = 'Accessibility_asArray';
      this.AUDIOCHANNELCONFIGURATION_ASARRAY = 'AudioChannelConfiguration_asArray';
      this.CONTENTPROTECTION_ASARRAY = 'ContentProtection_asArray';
      this.MAIN = 'main';
      this.DYNAMIC = 'dynamic';
      this.STATIC = 'static';
      this.MEDIA_PRESENTATION_DURATION = 'mediaPresentationDuration';
      this.MINIMUM_UPDATE_PERIOD = 'minimumUpdatePeriod';
      this.CODEC_PRIVATE_DATA = 'codecPrivateData';
      this.BANDWITH = 'bandwidth';
      this.SOURCE_URL = 'sourceURL';
      this.TIMESCALE = 'timescale';
      this.DURATION = 'duration';
      this.START_NUMBER = 'startNumber';
      this.PRESENTATION_TIME_OFFSET = 'presentationTimeOffset';
      this.AVAILABILITY_START_TIME = 'availabilityStartTime';
      this.AVAILABILITY_END_TIME = 'availabilityEndTime';
      this.TIMESHIFT_BUFFER_DEPTH = 'timeShiftBufferDepth';
      this.MAX_SEGMENT_DURATION = 'maxSegmentDuration';
      this.PRESENTATION_TIME = 'presentationTime';
      this.MIN_BUFFER_TIME = 'minBufferTime';
      this.MAX_SUBSEGMENT_DURATION = 'maxSubsegmentDuration';
      this.START = 'start';
      this.AVAILABILITY_TIME_OFFSET = 'availabilityTimeOffset';
      this.AVAILABILITY_TIME_COMPLETE = 'availabilityTimeComplete';
      this.CENC_DEFAULT_KID = 'cenc:default_KID';
      this.DVB_PRIORITY = 'dvb:priority';
      this.DVB_WEIGHT = 'dvb:weight';
      this.DVB_URL = 'dvb:url';
      this.DVB_MIMETYPE = 'dvb:mimeType';
      this.DVB_FONTFAMILY = 'dvb:fontFamily';
      this.SUGGESTED_PRESENTATION_DELAY = 'suggestedPresentationDelay';
      this.SERVICE_DESCRIPTION = 'ServiceDescription';
      this.SERVICE_DESCRIPTION_SCOPE = 'Scope';
      this.SERVICE_DESCRIPTION_LATENCY = 'Latency';
      this.SERVICE_DESCRIPTION_PLAYBACK_RATE = 'PlaybackRate';
      this.SERVICE_DESCRIPTION_OPERATING_QUALITY = 'OperatingQuality';
      this.SERVICE_DESCRIPTION_OPERATING_BANDWIDTH = 'OperatingBandwidth';
      this.PATCH_LOCATION = 'PatchLocation';
      this.PATCH_LOCATION_AS_ARRAY = 'PatchLocation_asArray';
      this.LOCATION = 'Location';
      this.LOCATION_AS_ARRAY = 'Location_asArray';
      this.PUBLISH_TIME = 'publishTime';
      this.ORIGINAL_PUBLISH_TIME = 'originalPublishTime';
      this.ORIGINAL_MPD_ID = 'mpdId';
      this.WALL_CLOCK_TIME = 'wallClockTime';
      this.PRESENTATION_TIME = 'presentationTime';
      this.LABEL = 'Label';
      this.GROUP_LABEL = 'GroupLabel';
      this.CONTENT_STEERING = 'ContentSteering';
      this.CONTENT_STEERING_AS_ARRAY = 'ContentSteering_asArray';
      this.DEFAULT_SERVICE_LOCATION = 'defaultServiceLocation';
      this.QUERY_BEFORE_START = 'queryBeforeStart';
      this.CLIENT_REQUIREMENT = 'clientRequirement';
      this.TTL = 'ttl';
      this.CONTENT_STEERING_RESPONSE = {
        VERSION: 'VERSION',
        TTL: 'TTL',
        RELOAD_URI: 'RELOAD-URI',
        PATHWAY_PRIORITY: 'PATHWAY-PRIORITY',
        PATHWAY_CLONES: 'PATHWAY-CLONES',
        BASE_ID: 'BASE-ID',
        ID: 'ID',
        URI_REPLACEMENT: 'URI-REPLACEMENT',
        HOST: 'HOST',
        PARAMS: 'PARAMS'
      };
      this.PRODUCER_REFERENCE_TIME_TYPE = {
        ENCODER: 'encoder',
        CAPTURED: 'captured',
        APPLICATION: 'application'
      };
      this.SEGMENT_ALIGNMENT = 'segmentAlignment';
      this.SUB_SEGMENT_ALIGNMENT = 'subsegmentAlignment';
    }
  }]);

  return DashConstants;
}();

var constants = new DashConstants();
/* harmony default export */ __webpack_exports__["default"] = (constants);

/***/ }),

/***/ "./src/dash/controllers/ContentSteeringController.js":
/*!***********************************************************!*\
  !*** ./src/dash/controllers/ContentSteeringController.js ***!
  \***********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../streaming/net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _vo_ContentSteeringRequest__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/ContentSteeringRequest */ "./src/dash/vo/ContentSteeringRequest.js");
/* harmony import */ var _vo_ContentSteeringResponse__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vo/ContentSteeringResponse */ "./src/dash/vo/ContentSteeringResponse.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _vo_BaseURL__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vo/BaseURL */ "./src/dash/vo/BaseURL.js");
/* harmony import */ var _vo_MpdLocation__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vo/MpdLocation */ "./src/dash/vo/MpdLocation.js");
/* harmony import */ var _core_Utils_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../core/Utils.js */ "./src/core/Utils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */












var QUERY_PARAMETER_KEYS = {
  THROUGHPUT: '_DASH_throughput',
  PATHWAY: '_DASH_pathway',
  URL: 'url'
};
var THROUGHPUT_SAMPLES = 4;

function ContentSteeringController() {
  var context = this.context;
  var urlUtils = (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_8__["default"])(context).getInstance();
  var instance, logger, currentSteeringResponseData, serviceLocationList, throughputList, nextRequestTimer, urlLoader, errHandler, dashMetrics, mediaPlayerModel, manifestModel, requestModifier, serviceDescriptionController, eventBus, adapter;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance().getLogger(instance);

    _resetInitialSettings();
  }

  function setConfig(config) {
    if (!config) return;

    if (config.adapter) {
      adapter = config.adapter;
    }

    if (config.errHandler) {
      errHandler = config.errHandler;
    }

    if (config.dashMetrics) {
      dashMetrics = config.dashMetrics;
    }

    if (config.mediaPlayerModel) {
      mediaPlayerModel = config.mediaPlayerModel;
    }

    if (config.requestModifier) {
      requestModifier = config.requestModifier;
    }

    if (config.manifestModel) {
      manifestModel = config.manifestModel;
    }

    if (config.serviceDescriptionController) {
      serviceDescriptionController = config.serviceDescriptionController;
    }

    if (config.eventBus) {
      eventBus = config.eventBus;
    }
  }
  /**
   * Initialize the steering controller by instantiating classes and registering observer callback
   */


  function initialize() {
    urlLoader = (0,_streaming_net_URLLoader__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      errHandler: errHandler,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      requestModifier: requestModifier,
      errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__["default"]
    });
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].FRAGMENT_LOADING_STARTED, _onFragmentLoadingStarted, instance);
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].MANIFEST_LOADING_STARTED, _onManifestLoadingStarted, instance);
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].MANIFEST_LOADING_FINISHED, _onManifestLoadingFinished, instance);
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].THROUGHPUT_MEASUREMENT_STORED, _onThroughputMeasurementStored, instance);
  }
  /**
   * When loading of a fragment starts we store its serviceLocation in our list
   * @param {object} e
   * @private
   */


  function _onFragmentLoadingStarted(e) {
    _addToServiceLocationList(e, 'baseUrl');
  }
  /**
   * When loading of a manifest starts we store its serviceLocation in our list
   * @param {object} e
   * @private
   */


  function _onManifestLoadingStarted(e) {
    _addToServiceLocationList(e, 'location');
  }
  /**
   * Basic throughput calculation for manifest requests
   * @param {object} e
   * @private
   */


  function _onManifestLoadingFinished(e) {
    if (!e || !e.request || !e.request.serviceLocation || !e.request.requestStartDate || !e.request.requestEndDate || isNaN(e.request.bytesTotal)) {
      return;
    }

    var serviceLocation = e.request.serviceLocation;
    var elapsedTime = e.request.requestEndDate.getTime() - e.request.requestStartDate.getTime();
    var throughput = parseInt(e.request.bytesTotal * 8 / elapsedTime * 1000); // bit/s

    _storeThroughputForServiceLocation(serviceLocation, throughput);
  }
  /**
   * When a throughput measurement for fragments was stored in ThroughputHistory we save it as well
   * @param {object} e
   * @private
   */


  function _onThroughputMeasurementStored(e) {
    if (!e || !e.httpRequest || !e.httpRequest._serviceLocation || isNaN(e.throughput)) {
      return;
    }

    var serviceLocation = e.httpRequest._serviceLocation;
    var throughput = e.throughput * 1000;

    _storeThroughputForServiceLocation(serviceLocation, throughput);
  }
  /**
   * Helper function to store a throughput value from the corresponding serviceLocation
   * @param {string} serviceLocation
   * @param {number} throughput
   * @private
   */


  function _storeThroughputForServiceLocation(serviceLocation, throughput) {
    if (!throughputList[serviceLocation]) {
      throughputList[serviceLocation] = [];
    }

    throughputList[serviceLocation].push(throughput);

    if (throughputList[serviceLocation].length > THROUGHPUT_SAMPLES) {
      throughputList[serviceLocation].shift();
    }
  }
  /**
   * Adds a new service location entry to our list
   * @param {object} e
   * @param {string} type
   * @private
   */


  function _addToServiceLocationList(e, type) {
    if (e && e.request && e.request.serviceLocation) {
      var serviceLocation = e.request.serviceLocation;

      if (serviceLocationList[type].all.indexOf(serviceLocation) === -1) {
        serviceLocationList[type].all.push(serviceLocation);
      }

      serviceLocationList[type].current = serviceLocation;
    }
  }
  /**
   * Query DashAdapter and Service Description Controller to get the steering information defined in the manifest
   * @returns {object}
   */


  function getSteeringDataFromManifest() {
    var manifest = manifestModel.getValue();
    var contentSteeringData = adapter.getContentSteering(manifest);

    if (!contentSteeringData) {
      contentSteeringData = serviceDescriptionController.getServiceDescriptionSettings().contentSteering;
    }

    return contentSteeringData;
  }
  /**
   * Should query steering server prior to playback start
   * @returns {boolean}
   */


  function shouldQueryBeforeStart() {
    var steeringDataFromManifest = getSteeringDataFromManifest();
    return !!steeringDataFromManifest && steeringDataFromManifest.queryBeforeStart;
  }
  /**
   * Load the steering data from the steering server
   * @returns {Promise}
   */


  function loadSteeringData() {
    return new Promise(function (resolve) {
      try {
        var steeringDataFromManifest = getSteeringDataFromManifest();

        if (!steeringDataFromManifest || !steeringDataFromManifest.serverUrl) {
          resolve();
          return;
        }

        var url = _getSteeringServerUrl(steeringDataFromManifest);

        var request = new _vo_ContentSteeringRequest__WEBPACK_IMPORTED_MODULE_4__["default"](url);
        urlLoader.load({
          request: request,
          success: function success(data) {
            _handleSteeringResponse(data);

            eventBus.trigger(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].CONTENT_STEERING_REQUEST_COMPLETED, {
              currentSteeringResponseData: currentSteeringResponseData,
              url: url
            });
            resolve();
          },
          error: function error(e, _error, statusText, response) {
            _handleSteeringResponseError(e, response);

            resolve(e);
          },
          complete: function complete() {
            // Clear everything except for the current entry
            serviceLocationList.baseUrl.all = _getClearedServiceLocationListAfterSteeringRequest(serviceLocationList.baseUrl);
            serviceLocationList.location.all = _getClearedServiceLocationListAfterSteeringRequest(serviceLocationList.location);
          }
        });
      } catch (e) {
        resolve(e);
      }
    });
  }
  /**
   * Return the cleared data of our serviceLocationList after the steering request was completed
   * @param {object} data
   * @returns {Object[]}
   * @private
   */


  function _getClearedServiceLocationListAfterSteeringRequest(data) {
    if (!data.all || data.all.length === 0 || !data.current) {
      return [];
    }

    return data.all.filter(function (entry) {
      return entry === data.current;
    });
  }
  /**
   * Returns the adjusted steering server url enhanced by pathway and throughput parameter
   * @param {object} steeringDataFromManifest
   * @returns {string}
   * @private
   */


  function _getSteeringServerUrl(steeringDataFromManifest) {
    var url = steeringDataFromManifest.serverUrl;

    if (currentSteeringResponseData && currentSteeringResponseData.reloadUri) {
      if (urlUtils.isRelative(currentSteeringResponseData.reloadUri)) {
        url = urlUtils.resolve(currentSteeringResponseData.reloadUri, steeringDataFromManifest.serverUrl);
      } else {
        url = currentSteeringResponseData.reloadUri;
      }
    }

    var additionalQueryParameter = [];
    var serviceLocations = serviceLocationList.baseUrl.all.concat(serviceLocationList.location.all);

    if (serviceLocations.length > 0) {
      // Derive throughput for each service Location
      var data = serviceLocations.map(function (serviceLocation) {
        var throughput = _calculateThroughputForServiceLocation(serviceLocation);

        return {
          serviceLocation: serviceLocation,
          throughput: throughput
        };
      }); // Sort in descending order to put all elements without throughput (-1) in the end

      data.sort(function (a, b) {
        return b.throughput - a.throughput;
      });
      var pathwayString = '';
      var throughputString = '';
      data.forEach(function (entry, index) {
        if (index !== 0) {
          pathwayString = "".concat(pathwayString, ",");

          if (entry.throughput > -1) {
            throughputString = "".concat(throughputString, ",");
          }
        }

        pathwayString = "".concat(pathwayString).concat(entry.serviceLocation);

        if (entry.throughput > -1) {
          throughputString = "".concat(throughputString).concat(entry.throughput);
        }
      });
      additionalQueryParameter.push({
        key: QUERY_PARAMETER_KEYS.PATHWAY,
        value: "\"".concat(pathwayString, "\"")
      });
      additionalQueryParameter.push({
        key: QUERY_PARAMETER_KEYS.THROUGHPUT,
        value: throughputString
      });
    }

    url = _core_Utils_js__WEBPACK_IMPORTED_MODULE_11__["default"].addAditionalQueryParameterToUrl(url, additionalQueryParameter);
    return url;
  }
  /**
   * Calculate the arithmetic mean of the last throughput samples
   * @param {string} serviceLocation
   * @returns {number}
   * @private
   */


  function _calculateThroughputForServiceLocation(serviceLocation) {
    if (!serviceLocation || !throughputList[serviceLocation] || throughputList[serviceLocation].length === 0) {
      return -1;
    }

    var throughput = throughputList[serviceLocation].reduce(function (acc, curr) {
      return acc + curr;
    }) / throughputList[serviceLocation].length;
    return parseInt(throughput);
  }
  /**
   * Parse the steering response and create instance of model ContentSteeringResponse
   * @param {object} data
   * @private
   */


  function _handleSteeringResponse(data) {
    if (!data || !data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.VERSION] || parseInt(data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.VERSION]) !== 1) {
      return;
    } // Update the data for other classes to use


    currentSteeringResponseData = new _vo_ContentSteeringResponse__WEBPACK_IMPORTED_MODULE_5__["default"]();
    currentSteeringResponseData.version = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.VERSION];

    if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.TTL] && !isNaN(data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.TTL])) {
      currentSteeringResponseData.ttl = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.TTL];
    }

    if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.RELOAD_URI]) {
      currentSteeringResponseData.reloadUri = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.RELOAD_URI];
    }

    if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.PATHWAY_PRIORITY]) {
      currentSteeringResponseData.pathwayPriority = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.PATHWAY_PRIORITY];
    }

    if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.PATHWAY_CLONES]) {
      currentSteeringResponseData.pathwayClones = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.PATHWAY_CLONES];
      currentSteeringResponseData.pathwayClones = currentSteeringResponseData.pathwayClones.filter(function (pathwayClone) {
        return _isValidPathwayClone(pathwayClone);
      });
    }

    _startSteeringRequestTimer();
  }
  /**
   * Checks if object is a valid PathwayClone
   * @param {object} pathwayClone
   * @returns {boolean}
   * @private
   */


  function _isValidPathwayClone(pathwayClone) {
    return pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.BASE_ID] && pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.ID] && pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.URI_REPLACEMENT] && pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.HOST];
  }
  /**
   * Returns synthesized BaseURL elements based on Pathway Cloning
   * @param {BaseURL[]}referenceElements
   * @returns {BaseURL[]}
   */


  function getSynthesizedBaseUrlElements(referenceElements) {
    try {
      var synthesizedElements = _getSynthesizedElements(referenceElements);

      return synthesizedElements.map(function (element) {
        var synthesizedBaseUrl = new _vo_BaseURL__WEBPACK_IMPORTED_MODULE_9__["default"](element.synthesizedUrl, element.serviceLocation);
        synthesizedBaseUrl.queryParams = element.queryParams;
        synthesizedBaseUrl.dvbPriority = element.reference.dvbPriority;
        synthesizedBaseUrl.dvbWeight = element.reference.dvbWeight;
        synthesizedBaseUrl.availabilityTimeOffset = element.reference.availabilityTimeOffset;
        synthesizedBaseUrl.availabilityTimeComplete = element.reference.availabilityTimeComplete;
        return synthesizedBaseUrl;
      });
    } catch (e) {
      logger.error(e);
      return [];
    }
  }
  /**
   * Returns synthesized Location elements based on Pathway Cloning
   * @param {MpdLocation[]} referenceElements
   * @returns {MpdLocation[]}
   */


  function getSynthesizedLocationElements(referenceElements) {
    try {
      var synthesizedElements = _getSynthesizedElements(referenceElements);

      return synthesizedElements.map(function (element) {
        var synthesizedLocation = new _vo_MpdLocation__WEBPACK_IMPORTED_MODULE_10__["default"](element.synthesizedUrl, element.serviceLocation);
        synthesizedLocation.queryParams = element.queryParams;
        return synthesizedLocation;
      });
    } catch (e) {
      logger.error(e);
      return [];
    }
  }
  /**
   * Helper function to synthesize elements
   * @param {array} referenceElements
   * @returns {array}
   * @private
   */


  function _getSynthesizedElements(referenceElements) {
    try {
      var synthesizedElements = [];

      if (!referenceElements || referenceElements.length === 0 || !currentSteeringResponseData || !currentSteeringResponseData.pathwayClones || currentSteeringResponseData.pathwayClones.length === 0) {
        return synthesizedElements;
      }

      currentSteeringResponseData.pathwayClones.forEach(function (pathwayClone) {
        var baseElements = referenceElements.filter(function (source) {
          return pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.BASE_ID] === source.serviceLocation;
        });
        var reference = null;

        if (baseElements && baseElements.length > 0) {
          reference = baseElements[0];
        }

        if (reference) {
          var referenceUrl = new URL(reference.url);
          var host = pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.HOST];
          host = _core_Utils_js__WEBPACK_IMPORTED_MODULE_11__["default"].stringHasProtocol(host) ? host : "".concat(referenceUrl.protocol, "//").concat(host);
          var synthesizedElement = {
            synthesizedUrl: "".concat(host).concat(referenceUrl.pathname),
            serviceLocation: pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.ID],
            queryParams: pathwayClone[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.URI_REPLACEMENT][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].CONTENT_STEERING_RESPONSE.PARAMS],
            reference: reference
          };
          synthesizedElements.push(synthesizedElement);
        }
      });
      return synthesizedElements;
    } catch (e) {
      logger.error(e);
      return [];
    }
  }
  /**
   * Start timeout for next steering request
   * @private
   */


  function _startSteeringRequestTimer() {
    // Start timer for next request
    if (currentSteeringResponseData && currentSteeringResponseData.ttl && !isNaN(currentSteeringResponseData.ttl)) {
      if (nextRequestTimer) {
        clearTimeout(nextRequestTimer);
      }

      nextRequestTimer = setTimeout(function () {
        loadSteeringData();
      }, currentSteeringResponseData.ttl * 1000);
    }
  }
  /**
   * Stop timeout for next steering request
   */


  function stopSteeringRequestTimer() {
    if (nextRequestTimer) {
      clearTimeout(nextRequestTimer);
    }

    nextRequestTimer = null;
  }
  /**
   * Handle errors that occured when querying the steering server
   * @param {object} e
   * @param {object} response
   * @private
   */


  function _handleSteeringResponseError(e, response) {
    try {
      logger.warn("Error fetching data from content steering server", e);
      var statusCode = response.status;

      switch (statusCode) {
        // 410 response code. Stop steering
        case 410:
          break;
        // 429 Too Many Requests. Replace existing TTL value with Retry-After header if present

        case 429:
          var retryAfter = response && response.getResponseHeader ? response.getResponseHeader('retry-after') : null;

          if (retryAfter !== null) {
            if (!currentSteeringResponseData) {
              currentSteeringResponseData = {};
            }

            currentSteeringResponseData.ttl = parseInt(retryAfter);
          }

          _startSteeringRequestTimer();

          break;

        default:
          _startSteeringRequestTimer();

          break;
      }
    } catch (e) {
      logger.error(e);
    }
  }
  /**
   * Returns the currentSteeringResponseData
   * @returns {ContentSteeringResponse}
   */


  function getCurrentSteeringResponseData() {
    return currentSteeringResponseData;
  }

  function reset() {
    _resetInitialSettings();

    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].FRAGMENT_LOADING_STARTED, _onFragmentLoadingStarted, instance);
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].MANIFEST_LOADING_STARTED, _onManifestLoadingStarted, instance);
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].MANIFEST_LOADING_FINISHED, _onManifestLoadingFinished, instance);
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].THROUGHPUT_MEASUREMENT_STORED, _onThroughputMeasurementStored, instance);
  }

  function _resetInitialSettings() {
    currentSteeringResponseData = null;
    throughputList = {};
    serviceLocationList = {
      baseUrl: {
        current: null,
        all: []
      },
      location: {
        current: null,
        all: []
      }
    };
    stopSteeringRequestTimer();
  }

  instance = {
    reset: reset,
    setConfig: setConfig,
    loadSteeringData: loadSteeringData,
    getCurrentSteeringResponseData: getCurrentSteeringResponseData,
    shouldQueryBeforeStart: shouldQueryBeforeStart,
    getSteeringDataFromManifest: getSteeringDataFromManifest,
    stopSteeringRequestTimer: stopSteeringRequestTimer,
    getSynthesizedBaseUrlElements: getSynthesizedBaseUrlElements,
    getSynthesizedLocationElements: getSynthesizedLocationElements,
    initialize: initialize
  };
  setup();
  return instance;
}

ContentSteeringController.__dashjs_factory_name = 'ContentSteeringController';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(ContentSteeringController));

/***/ }),

/***/ "./src/dash/controllers/RepresentationController.js":
/*!**********************************************************!*\
  !*** ./src/dash/controllers/RepresentationController.js ***!
  \**********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */





function RepresentationController(config) {
  config = config || {};
  var eventBus = config.eventBus;
  var events = config.events;
  var abrController = config.abrController;
  var dashMetrics = config.dashMetrics;
  var playbackController = config.playbackController;
  var timelineConverter = config.timelineConverter;
  var type = config.type;
  var streamInfo = config.streamInfo;
  var dashConstants = config.dashConstants;
  var segmentsController = config.segmentsController;
  var isDynamic = config.isDynamic;
  var adapter = config.adapter;
  var instance, realAdaptation, updating, voAvailableRepresentations, currentRepresentationInfo, currentVoRepresentation;

  function setup() {
    resetInitialSettings();
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function checkConfig() {
    if (!abrController || !dashMetrics || !playbackController || !timelineConverter) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getData() {
    return realAdaptation;
  }

  function isUpdating() {
    return updating;
  }

  function getCurrentRepresentation() {
    return currentVoRepresentation;
  }

  function getCurrentRepresentationInfo() {
    return currentRepresentationInfo;
  }

  function resetInitialSettings() {
    realAdaptation = null;
    updating = true;
    voAvailableRepresentations = [];
    currentRepresentationInfo = null;
  }

  function reset() {
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].MANIFEST_VALIDITY_CHANGED, onManifestValidityChanged, instance);
    resetInitialSettings();
  }

  function updateData(newRealAdaptation, availableRepresentations, type, isFragmented, quality) {
    return new Promise(function (resolve, reject) {
      updating = true;
      voAvailableRepresentations = availableRepresentations;
      realAdaptation = newRealAdaptation;
      var rep = getRepresentationForQuality(quality);

      _setCurrentVoRepresentation(rep);

      if (type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO && type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO && (type !== _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || !isFragmented)) {
        endDataUpdate();
        resolve();
        return;
      }

      var promises = [];

      for (var i = 0, ln = voAvailableRepresentations.length; i < ln; i++) {
        var currentRep = voAvailableRepresentations[i];
        promises.push(_updateRepresentation(currentRep));
      }

      Promise.all(promises).then(function () {
        // Update the current representation again as we have now the reference to the segments
        var rep = getRepresentationForQuality(quality);

        _setCurrentVoRepresentation(rep);

        resolve();
      })["catch"](function (e) {
        reject(e);
      });
    });
  }

  function _updateRepresentation(currentRep) {
    return new Promise(function (resolve, reject) {
      var hasInitialization = currentRep.hasInitialization();
      var hasSegments = currentRep.hasSegments(); // If representation has initialization and segments information we are done
      // otherwise, it means that a request has to be made to get initialization and/or segments information

      var promises = [];
      promises.push(segmentsController.updateInitData(currentRep, hasInitialization));
      promises.push(segmentsController.updateSegmentData(currentRep, hasSegments));
      Promise.all(promises).then(function (data) {
        if (data[0] && !data[0].error) {
          currentRep = _onInitLoaded(currentRep, data[0]);
        }

        if (data[1] && !data[1].error) {
          currentRep = _onSegmentsLoaded(currentRep, data[1]);
        }

        _setMediaFinishedInformation(currentRep);

        _onRepresentationUpdated(currentRep);

        resolve();
      })["catch"](function (e) {
        reject(e);
      });
    });
  }

  function _setMediaFinishedInformation(representation) {
    representation.mediaFinishedInformation = segmentsController.getMediaFinishedInformation(representation);
  }

  function _onInitLoaded(representation, e) {
    if (!e || e.error || !e.representation) {
      return representation;
    }

    return e.representation;
  }

  function _onSegmentsLoaded(representation, e) {
    if (!e || e.error) return;
    var fragments = e.segments;
    var segments = [];
    var count = 0;
    var i, len, s, seg;

    for (i = 0, len = fragments ? fragments.length : 0; i < len; i++) {
      s = fragments[i];
      seg = (0,_utils_SegmentsUtils__WEBPACK_IMPORTED_MODULE_3__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, s.startTime, s.duration, s.timescale, s.media, s.mediaRange, count);

      if (seg) {
        segments.push(seg);
        seg = null;
        count++;
      }
    }

    if (segments.length > 0) {
      representation.segments = segments;
    }

    return representation;
  }

  function _addRepresentationSwitch() {
    checkConfig();
    var now = new Date();
    var currentRepresentation = getCurrentRepresentation();
    var currentVideoTimeMs = playbackController.getTime() * 1000;

    if (currentRepresentation) {
      dashMetrics.addRepresentationSwitch(currentRepresentation.adaptation.type, now, currentVideoTimeMs, currentRepresentation.id);
    }

    eventBus.trigger(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].REPRESENTATION_SWITCH, {
      mediaType: type,
      streamId: streamInfo.id,
      currentRepresentation: currentRepresentation,
      numberOfRepresentations: voAvailableRepresentations.length
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function getRepresentationForQuality(quality) {
    return quality === null || quality === undefined || quality >= voAvailableRepresentations.length ? null : voAvailableRepresentations[quality];
  }

  function getQualityForRepresentation(voRepresentation) {
    return voAvailableRepresentations.indexOf(voRepresentation);
  }

  function isAllRepresentationsUpdated() {
    for (var i = 0, ln = voAvailableRepresentations.length; i < ln; i++) {
      var segmentInfoType = voAvailableRepresentations[i].segmentInfoType;

      if (!voAvailableRepresentations[i].hasInitialization() || (segmentInfoType === dashConstants.SEGMENT_BASE || segmentInfoType === dashConstants.BASE_URL) && !voAvailableRepresentations[i].segments) {
        return false;
      }
    }

    return true;
  }

  function endDataUpdate(error) {
    updating = false;
    eventBus.trigger(events.DATA_UPDATE_COMPLETED, {
      data: realAdaptation,
      currentRepresentation: currentVoRepresentation,
      error: error
    }, {
      streamId: streamInfo.id,
      mediaType: type
    });
  }

  function _onRepresentationUpdated(r) {
    if (!isUpdating()) return;
    var manifestUpdateInfo = dashMetrics.getCurrentManifestUpdate();
    var alreadyAdded = false;
    var repInfo, repSwitch;

    if (manifestUpdateInfo) {
      for (var i = 0; i < manifestUpdateInfo.representationInfo.length; i++) {
        repInfo = manifestUpdateInfo.representationInfo[i];

        if (repInfo.index === r.index && repInfo.mediaType === getType()) {
          alreadyAdded = true;
          break;
        }
      }

      if (!alreadyAdded) {
        dashMetrics.addManifestUpdateRepresentationInfo(r, getType());
      }
    }

    if (isAllRepresentationsUpdated()) {
      abrController.setPlaybackQuality(type, streamInfo, getQualityForRepresentation(currentVoRepresentation));
      var dvrInfo = dashMetrics.getCurrentDVRInfo(type);

      if (dvrInfo) {
        dashMetrics.updateManifestUpdateInfo({
          latency: dvrInfo.range.end - playbackController.getTime()
        });
      }

      repSwitch = dashMetrics.getCurrentRepresentationSwitch(getCurrentRepresentation().adaptation.type);

      if (!repSwitch) {
        _addRepresentationSwitch();
      }

      endDataUpdate();
    }
  }

  function prepareQualityChange(newQuality) {
    var newRep = getRepresentationForQuality(newQuality);

    _setCurrentVoRepresentation(newRep);

    _addRepresentationSwitch();
  }

  function _setCurrentVoRepresentation(value) {
    currentVoRepresentation = value;
    currentRepresentationInfo = adapter.convertRepresentationToRepresentationInfo(currentVoRepresentation);
  }

  function onManifestValidityChanged(e) {
    if (e.newDuration) {
      var representation = getCurrentRepresentation();

      if (representation && representation.adaptation.period) {
        var period = representation.adaptation.period;
        period.duration = e.newDuration;
      }
    }
  }

  instance = {
    getStreamId: getStreamId,
    getType: getType,
    getData: getData,
    isUpdating: isUpdating,
    updateData: updateData,
    getCurrentRepresentation: getCurrentRepresentation,
    getCurrentRepresentationInfo: getCurrentRepresentationInfo,
    getRepresentationForQuality: getRepresentationForQuality,
    prepareQualityChange: prepareQualityChange,
    reset: reset
  };
  setup();
  return instance;
}

RepresentationController.__dashjs_factory_name = 'RepresentationController';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(RepresentationController));

/***/ }),

/***/ "./src/dash/controllers/SegmentBaseController.js":
/*!*******************************************************!*\
  !*** ./src/dash/controllers/SegmentBaseController.js ***!
  \*******************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _SegmentBaseLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../SegmentBaseLoader */ "./src/dash/SegmentBaseLoader.js");
/* harmony import */ var _WebmSegmentBaseLoader__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../WebmSegmentBaseLoader */ "./src/dash/WebmSegmentBaseLoader.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function SegmentBaseController(config) {
  config = config || {};
  var context = this.context;
  var eventBus = config.eventBus;
  var events = config.events;
  var dashMetrics = config.dashMetrics;
  var mediaPlayerModel = config.mediaPlayerModel;
  var errHandler = config.errHandler;
  var baseURLController = config.baseURLController;
  var debug = config.debug;
  var boxParser = config.boxParser;
  var requestModifier = config.requestModifier;
  var errors = config.errors;
  var instance, segmentBaseLoader, webmSegmentBaseLoader;

  function setup() {
    segmentBaseLoader = (0,_SegmentBaseLoader__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance();
    webmSegmentBaseLoader = (0,_WebmSegmentBaseLoader__WEBPACK_IMPORTED_MODULE_2__["default"])(context).getInstance();
    segmentBaseLoader.setConfig({
      baseURLController: baseURLController,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      errHandler: errHandler,
      eventBus: eventBus,
      events: events,
      errors: errors,
      debug: debug,
      boxParser: boxParser,
      requestModifier: requestModifier
    });
    webmSegmentBaseLoader.setConfig({
      baseURLController: baseURLController,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      errHandler: errHandler,
      eventBus: eventBus,
      events: events,
      errors: errors,
      debug: debug,
      requestModifier: requestModifier
    });
  }

  function isWebM(mimeType) {
    var type = mimeType ? mimeType.split('/')[1] : '';
    return 'webm' === type.toLowerCase();
  }

  function initialize() {
    segmentBaseLoader.initialize();
    webmSegmentBaseLoader.initialize();
  }

  function getSegmentBaseInitSegment(data) {
    if (isWebM(data.representation.mimeType)) {
      return webmSegmentBaseLoader.loadInitialization(data.representation, data.mediaType);
    } else {
      return segmentBaseLoader.loadInitialization(data.representation, data.mediaType);
    }
  }

  function getSegmentList(e) {
    if (isWebM(e.mimeType)) {
      return webmSegmentBaseLoader.loadSegments(e.representation, e.mediaType, e.representation ? e.representation.indexRange : null);
    } else {
      return segmentBaseLoader.loadSegments(e.representation, e.mediaType, e.representation ? e.representation.indexRange : null);
    }
  }

  function reset() {
    segmentBaseLoader.reset();
    webmSegmentBaseLoader.reset();
  }

  instance = {
    initialize: initialize,
    getSegmentBaseInitSegment: getSegmentBaseInitSegment,
    getSegmentList: getSegmentList,
    reset: reset
  };
  setup();
  return instance;
}

SegmentBaseController.__dashjs_factory_name = 'SegmentBaseController';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(SegmentBaseController);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/controllers/SegmentsController.js":
/*!****************************************************!*\
  !*** ./src/dash/controllers/SegmentsController.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _utils_TimelineSegmentsGetter__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/TimelineSegmentsGetter */ "./src/dash/utils/TimelineSegmentsGetter.js");
/* harmony import */ var _utils_TemplateSegmentsGetter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/TemplateSegmentsGetter */ "./src/dash/utils/TemplateSegmentsGetter.js");
/* harmony import */ var _utils_ListSegmentsGetter__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/ListSegmentsGetter */ "./src/dash/utils/ListSegmentsGetter.js");
/* harmony import */ var _utils_SegmentBaseGetter__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/SegmentBaseGetter */ "./src/dash/utils/SegmentBaseGetter.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function SegmentsController(config) {
  config = config || {};
  var context = this.context;
  var dashConstants = config.dashConstants;
  var type = config.type;
  var segmentBaseController = config.segmentBaseController;
  var instance, getters;

  function setup() {
    getters = {};
  }

  function initialize(isDynamic) {
    getters[dashConstants.SEGMENT_TIMELINE] = (0,_utils_TimelineSegmentsGetter__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_TEMPLATE] = (0,_utils_TemplateSegmentsGetter__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_LIST] = (0,_utils_ListSegmentsGetter__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create(config, isDynamic);
    getters[dashConstants.SEGMENT_BASE] = (0,_utils_SegmentBaseGetter__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create(config, isDynamic);
  }

  function updateInitData(voRepresentation, hasInitialization) {
    if (hasInitialization) {
      return Promise.resolve();
    }

    return segmentBaseController.getSegmentBaseInitSegment({
      representation: voRepresentation,
      mediaType: type
    });
  }

  function updateSegmentData(voRepresentation, hasSegments) {
    if (hasSegments) {
      return Promise.resolve();
    }

    return segmentBaseController.getSegmentList({
      mimeType: voRepresentation.mimeType,
      representation: voRepresentation,
      mediaType: type
    });
  }

  function getSegmentsGetter(representation) {
    return representation ? representation.segments ? getters[dashConstants.SEGMENT_BASE] : getters[representation.segmentInfoType] : null;
  }

  function getSegmentByIndex(representation, index, lastSegmentTime) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByIndex(representation, index, lastSegmentTime) : null;
  }

  function getSegmentByTime(representation, time) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getSegmentByTime(representation, time) : null;
  }

  function getMediaFinishedInformation(representation) {
    var getter = getSegmentsGetter(representation);
    return getter ? getter.getMediaFinishedInformation(representation) : {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
  }

  instance = {
    initialize: initialize,
    updateInitData: updateInitData,
    updateSegmentData: updateSegmentData,
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  setup();
  return instance;
}

SegmentsController.__dashjs_factory_name = 'SegmentsController';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SegmentsController);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/controllers/ServiceDescriptionController.js":
/*!**************************************************************!*\
  !*** ./src/dash/controllers/ServiceDescriptionController.js ***!
  \**************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




var SUPPORTED_SCHEMES = [_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].SERVICE_DESCRIPTION_DVB_LL_SCHEME];
var MEDIA_TYPES = {
  VIDEO: 'video',
  AUDIO: 'audio',
  ANY: 'any',
  ALL: 'all'
};

function ServiceDescriptionController() {
  var context = this.context;
  var instance, serviceDescriptionSettings, prftOffsets, logger, adapter;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_1__["default"])(context).getInstance().getLogger(instance);

    _resetInitialSettings();
  }

  function setConfig(config) {
    if (!config) return;

    if (config.adapter) {
      adapter = config.adapter;
    }
  }

  function reset() {
    _resetInitialSettings();
  }

  function _resetInitialSettings() {
    serviceDescriptionSettings = {
      liveDelay: NaN,
      liveCatchup: {
        maxDrift: NaN,
        playbackRate: {
          min: NaN,
          max: NaN
        }
      },
      minBitrate: {},
      maxBitrate: {},
      initialBitrate: {},
      contentSteering: null
    };
    prftOffsets = [];
  }
  /**
   * Returns the service description settings for latency, catchup and bandwidth
   */


  function getServiceDescriptionSettings() {
    return serviceDescriptionSettings;
  }
  /**
   * Check for potential ServiceDescriptor elements in the MPD and update the settings accordingly
   * @param {object} manifestInfo
   * @private
   */


  function applyServiceDescription(manifestInfo) {
    if (!manifestInfo || !manifestInfo.serviceDescriptions) {
      return;
    }

    var supportedServiceDescriptions = manifestInfo.serviceDescriptions.filter(function (sd) {
      return SUPPORTED_SCHEMES.includes(sd.schemeIdUri);
    });
    var allClientsServiceDescriptions = manifestInfo.serviceDescriptions.filter(function (sd) {
      return sd.schemeIdUri == null;
    });
    var sd = supportedServiceDescriptions.length > 0 ? supportedServiceDescriptions[supportedServiceDescriptions.length - 1] : allClientsServiceDescriptions[allClientsServiceDescriptions.length - 1];
    if (!sd) return;

    if (sd.latency && sd.latency.target > 0) {
      _applyServiceDescriptionLatency(sd);
    }

    if (sd.playbackRate) {
      _applyServiceDescriptionPlaybackRate(sd);
    }

    if (sd.operatingQuality) {
      _applyServiceDescriptionOperatingQuality(sd);
    }

    if (sd.operatingBandwidth) {
      _applyServiceDescriptionOperatingBandwidth(sd);
    }

    if (sd.contentSteering) {
      _applyServiceDescriptionContentSteering(sd);
    }
  }
  /**
   * Adjust the latency targets for the service.
   * @param {object} sd - service description element
   * @private
   */


  function _applyServiceDescriptionLatency(sd) {
    var params;

    if (sd.schemeIdUri === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].SERVICE_DESCRIPTION_DVB_LL_SCHEME) {
      params = _getDvbServiceDescriptionLatencyParameters(sd);
    } else {
      params = _getStandardServiceDescriptionLatencyParameters(sd);
    }

    if (prftOffsets.length > 0) {
      var _calculateTimeOffset2 = _calculateTimeOffset(params),
          to = _calculateTimeOffset2.to,
          id = _calculateTimeOffset2.id; // TS 103 285 Clause 10.20.4. 3) Subtract calculated offset from Latency@target converted from milliseconds
      // liveLatency does not consider ST@availabilityTimeOffset so leave out that step
      // Since maxDrift is a difference rather than absolute it does not need offset applied


      serviceDescriptionSettings.liveDelay = params.liveDelay - to;
      serviceDescriptionSettings.liveCatchup.maxDrift = params.maxDrift;
      logger.debug("\n                Found latency properties coming from service description. Applied time offset of ".concat(to, " from ProducerReferenceTime element with id ").concat(id, ".\n                Live Delay: ").concat(params.liveDelay - to, ", Live catchup max drift: ").concat(params.maxDrift, "\n            "));
    } else {
      serviceDescriptionSettings.liveDelay = params.liveDelay;
      serviceDescriptionSettings.liveCatchup.maxDrift = params.maxDrift;
      logger.debug("Found latency properties coming from service description: Live Delay: ".concat(params.liveDelay, ", Live catchup max drift: ").concat(params.maxDrift));
    }
  }
  /**
   * Get default parameters for liveDelay,maxDrift
   * @param {object} sd
   * @return {{maxDrift: (number|undefined), liveDelay: number, referenceId: (number|undefined)}}
   * @private
   */


  function _getStandardServiceDescriptionLatencyParameters(sd) {
    var liveDelay = sd.latency.target / 1000;
    var maxDrift = !isNaN(sd.latency.max) && sd.latency.max > sd.latency.target ? (sd.latency.max - sd.latency.target + 500) / 1000 : NaN;
    var referenceId = sd.latency.referenceId || NaN;
    return {
      liveDelay: liveDelay,
      maxDrift: maxDrift,
      referenceId: referenceId
    };
  }
  /**
   * Get DVB DASH parameters for liveDelay,maxDrift
   * @param sd
   * @return {{maxDrift: (number|undefined), liveDelay: number, referenceId: (number|undefined)}}
   * @private
   */


  function _getDvbServiceDescriptionLatencyParameters(sd) {
    var liveDelay = sd.latency.target / 1000;
    var maxDrift = !isNaN(sd.latency.max) && sd.latency.max > sd.latency.target ? (sd.latency.max - sd.latency.target + 500) / 1000 : NaN;
    var referenceId = sd.latency.referenceId || NaN;
    return {
      liveDelay: liveDelay,
      maxDrift: maxDrift,
      referenceId: referenceId
    };
  }
  /**
   * Adjust the playback rate targets for the service
   * @param {object} sd
   * @private
   */


  function _applyServiceDescriptionPlaybackRate(sd) {
    // Convert each playback rate into a difference from 1. i.e 0.8 becomes -0.2.
    var min = sd.playbackRate.min ? Math.round((sd.playbackRate.min - 1.0) * 1000) / 1000 : NaN;
    var max = sd.playbackRate.max ? Math.round((sd.playbackRate.max - 1.0) * 1000) / 1000 : NaN;
    serviceDescriptionSettings.liveCatchup.playbackRate.min = min;
    serviceDescriptionSettings.liveCatchup.playbackRate.max = max;
    logger.debug("Found latency properties coming from service description: Live catchup min playback rate: ".concat(min));
    logger.debug("Found latency properties coming from service description: Live catchup max playback rate: ".concat(max));
  }
  /**
   * Used to specify a quality ranking. We do not support this yet.
   * @private
   */


  function _applyServiceDescriptionOperatingQuality() {
    return;
  }
  /**
   * Adjust the operating quality targets for the service
   * @param {object} sd
   * @private
   */


  function _applyServiceDescriptionOperatingBandwidth(sd) {
    // Aggregation of media types is not supported yet
    if (!sd || !sd.operatingBandwidth || !sd.operatingBandwidth.mediaType || sd.operatingBandwidth.mediaType === MEDIA_TYPES.ALL) {
      return;
    }

    var params = {};
    params.minBandwidth = sd.operatingBandwidth.min;
    params.maxBandwidth = sd.operatingBandwidth.max;
    params.targetBandwidth = sd.operatingBandwidth.target;
    var mediaTypesToApply = [];

    if (sd.operatingBandwidth.mediaType === MEDIA_TYPES.VIDEO || sd.operatingBandwidth.mediaType === MEDIA_TYPES.AUDIO) {
      mediaTypesToApply.push(sd.operatingBandwidth.mediaType);
    } else if (sd.operatingBandwidth.mediaType === MEDIA_TYPES.ANY) {
      mediaTypesToApply.push(MEDIA_TYPES.AUDIO);
      mediaTypesToApply.push(MEDIA_TYPES.VIDEO);
    }

    mediaTypesToApply.forEach(function (mediaType) {
      if (!isNaN(params.minBandwidth)) {
        _updateBandwidthSetting('minBitrate', mediaType, params.minBandwidth);
      }

      if (!isNaN(params.maxBandwidth)) {
        _updateBandwidthSetting('maxBitrate', mediaType, params.maxBandwidth);
      }

      if (!isNaN(params.targetBandwidth)) {
        _updateBandwidthSetting('initialBitrate', mediaType, params.targetBandwidth);
      }
    });
  }
  /**
   * Update the bandwidth settings vor a specific field and media type
   * @param {string} field
   * @param {string} mediaType
   * @param {number} value
   * @private
   */


  function _updateBandwidthSetting(field, mediaType, value) {
    try {
      // Service description values are specified in bps. Settings expect the value in kbps
      serviceDescriptionSettings[field][mediaType] = value / 1000;
    } catch (e) {
      logger.error(e);
    }
  }
  /**
   * Add information about content steering element. Handling is up to the ContentSteeringController
   *  @param {object} sd
   *  @private
   */


  function _applyServiceDescriptionContentSteering(sd) {
    serviceDescriptionSettings.contentSteering = sd.contentSteering;
  }
  /**
   * Returns the current calculated time offsets based on ProducerReferenceTime elements
   * @returns {array}
   */


  function getProducerReferenceTimeOffsets() {
    return prftOffsets;
  }
  /**
   * Calculates an array of time offsets each with matching ProducerReferenceTime id.
   * Call before applyServiceDescription if producer reference time elements should be considered.
   * @param {array} streamInfos
   * @returns {array}
   * @private
   */


  function calculateProducerReferenceTimeOffsets(streamInfos) {
    try {
      var timeOffsets = [];

      if (streamInfos && streamInfos.length > 0) {
        var mediaTypes = [_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].VIDEO, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].AUDIO, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_2__["default"].TEXT];
        var astInSeconds = adapter.getAvailabilityStartTime() / 1000;
        streamInfos.forEach(function (streamInfo) {
          var offsets = mediaTypes.reduce(function (acc, mediaType) {
            acc = acc.concat(adapter.getAllMediaInfoForType(streamInfo, mediaType));
            return acc;
          }, []).reduce(function (acc, mediaInfo) {
            var prts = adapter.getProducerReferenceTimes(streamInfo, mediaInfo);
            prts.forEach(function (prt) {
              var voRepresentations = adapter.getVoRepresentations(mediaInfo);

              if (voRepresentations && voRepresentations.length > 0 && voRepresentations[0].adaptation && voRepresentations[0].segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].SEGMENT_TEMPLATE) {
                var voRep = voRepresentations[0];
                var d = new Date(prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].WALL_CLOCK_TIME]);
                var wallClockTime = d.getTime() / 1000; // TS 103 285 Clause 10.20.4
                // 1) Calculate PRT0
                // i) take the PRT@presentationTime and subtract any ST@presentationTimeOffset
                // ii) convert this time to seconds by dividing by ST@timescale
                // iii) Add this to start time of period that contains PRT.
                // N.B presentationTimeOffset is already divided by timescale at this point

                var prt0 = wallClockTime - (prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].PRESENTATION_TIME] / voRep[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].TIMESCALE] - voRep[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].PRESENTATION_TIME_OFFSET] + streamInfo.start); // 2) Calculate TO between PRT at the start of MPD timeline and the AST

                var to = astInSeconds - prt0; // 3) Not applicable as liveLatency does not consider ST@availabilityTimeOffset

                acc.push({
                  id: prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].ID],
                  to: to
                });
              }
            });
            return acc;
          }, []);
          timeOffsets = timeOffsets.concat(offsets);
        });
      }

      prftOffsets = timeOffsets;
    } catch (e) {
      logger.error(e);
      prftOffsets = [];
    }
  }

  ;
  /**
   * Calculates offset to apply to live delay as described in TS 103 285 Clause 10.20.4
   * @param {object} sdLatency - service description latency element
   * @returns {number}
   * @private
   */

  function _calculateTimeOffset(sdLatency) {
    var to = 0,
        id;
    var offset = prftOffsets.filter(function (prt) {
      return prt.id === sdLatency.referenceId;
    }); // If only one ProducerReferenceTime to generate one TO, then use that regardless of matching ids

    if (offset.length === 0) {
      to = prftOffsets.length > 0 ? prftOffsets[0].to : 0;
      id = prftOffsets[0].id || NaN;
    } else {
      // If multiple id matches, use the first but this should be invalid
      to = offset[0].to || 0;
      id = offset[0].id || NaN;
    }

    return {
      to: to,
      id: id
    };
  }

  instance = {
    getServiceDescriptionSettings: getServiceDescriptionSettings,
    getProducerReferenceTimeOffsets: getProducerReferenceTimeOffsets,
    calculateProducerReferenceTimeOffsets: calculateProducerReferenceTimeOffsets,
    applyServiceDescription: applyServiceDescription,
    reset: reset,
    setConfig: setConfig
  };
  setup();
  return instance;
}

ServiceDescriptionController.__dashjs_factory_name = 'ServiceDescriptionController';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getSingletonFactory(ServiceDescriptionController));

/***/ }),

/***/ "./src/dash/models/DashManifestModel.js":
/*!**********************************************!*\
  !*** ./src/dash/models/DashManifestModel.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _vo_Representation__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../vo/Representation */ "./src/dash/vo/Representation.js");
/* harmony import */ var _vo_AdaptationSet__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/AdaptationSet */ "./src/dash/vo/AdaptationSet.js");
/* harmony import */ var _vo_Period__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/Period */ "./src/dash/vo/Period.js");
/* harmony import */ var _vo_Mpd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../vo/Mpd */ "./src/dash/vo/Mpd.js");
/* harmony import */ var _vo_UTCTiming__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../vo/UTCTiming */ "./src/dash/vo/UTCTiming.js");
/* harmony import */ var _vo_Event__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../vo/Event */ "./src/dash/vo/Event.js");
/* harmony import */ var _vo_BaseURL__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../vo/BaseURL */ "./src/dash/vo/BaseURL.js");
/* harmony import */ var _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../vo/EventStream */ "./src/dash/vo/EventStream.js");
/* harmony import */ var _vo_ProducerReferenceTime__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../vo/ProducerReferenceTime */ "./src/dash/vo/ProducerReferenceTime.js");
/* harmony import */ var _vo_ContentSteering__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../vo/ContentSteering */ "./src/dash/vo/ContentSteering.js");
/* harmony import */ var _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../vo/DescriptorType */ "./src/dash/vo/DescriptorType.js");
/* harmony import */ var _streaming_utils_ObjectUtils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../streaming/utils/ObjectUtils */ "./src/streaming/utils/ObjectUtils.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../streaming/vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _streaming_thumbnail_ThumbnailTracks__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../streaming/thumbnail/ThumbnailTracks */ "./src/streaming/thumbnail/ThumbnailTracks.js");
/* harmony import */ var _vo_MpdLocation__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../vo/MpdLocation */ "./src/dash/vo/MpdLocation.js");
/* harmony import */ var _vo_PatchLocation__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../vo/PatchLocation */ "./src/dash/vo/PatchLocation.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _createForOfIteratorHelper(o, allowArrayLike) { var it; if (typeof Symbol === "undefined" || o[Symbol.iterator] == null) { if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") { if (it) o = it; var i = 0; var F = function F() {}; return { s: F, n: function n() { if (i >= o.length) return { done: true }; return { done: false, value: o[i++] }; }, e: function e(_e) { throw _e; }, f: F }; } throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); } var normalCompletion = true, didErr = false, err; return { s: function s() { it = o[Symbol.iterator](); }, n: function n() { var step = it.next(); normalCompletion = step.done; return step; }, e: function e(_e2) { didErr = true; err = _e2; }, f: function f() { try { if (!normalCompletion && it["return"] != null) it["return"](); } finally { if (didErr) throw err; } } }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */























function DashManifestModel() {
  var instance, logger, errHandler, BASE64;
  var context = this.context;
  var urlUtils = (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_14__["default"])(context).getInstance();

  var isInteger = Number.isInteger || function (value) {
    return typeof value === 'number' && isFinite(value) && Math.floor(value) === value;
  };

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance().getLogger(instance);
  }

  function getIsTypeOf(adaptation, type) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }

    if (!type) {
      throw new Error('type is not defined');
    } // Check for thumbnail images


    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length) {
      var essentialProperties = getEssentialPropertiesForRepresentation(adaptation.Representation_asArray[0]);

      if (essentialProperties && essentialProperties.length > 0 && _streaming_thumbnail_ThumbnailTracks__WEBPACK_IMPORTED_MODULE_19__.THUMBNAILS_SCHEME_ID_URIS.indexOf(essentialProperties[0].schemeIdUri) >= 0) {
        return type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE;
      }
    } // Check ContentComponent.contentType


    if (adaptation.ContentComponent_asArray && adaptation.ContentComponent_asArray.length > 0) {
      if (adaptation.ContentComponent_asArray.length > 1) {
        return type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED;
      } else if (adaptation.ContentComponent_asArray[0].contentType === type) {
        return true;
      }
    }

    var mimeTypeRegEx = type === _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT ? new RegExp('(ttml|vtt|wvtt|stpp)') : new RegExp(type); // Check codecs

    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length) {
      var codecs = adaptation.Representation_asArray[0].codecs;

      if (mimeTypeRegEx.test(codecs)) {
        return true;
      }
    } // Check Adaptation's mimeType


    if (adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
      return mimeTypeRegEx.test(adaptation.mimeType);
    } // Check Representation's mimeType


    if (adaptation.Representation_asArray) {
      var representation;

      for (var i = 0; i < adaptation.Representation_asArray.length; i++) {
        representation = adaptation.Representation_asArray[i];

        if (representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
          return mimeTypeRegEx.test(representation.mimeType);
        }
      }
    }

    return false;
  }

  function getIsFragmented(adaptation) {
    if (!adaptation) {
      throw new Error('adaptation is not defined');
    }

    if (adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST) || adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
      return true;
    }

    if (adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0) {
      var representation = adaptation.Representation_asArray[0];

      if (representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST) || representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
        return true;
      }
    }

    return false;
  }

  function getIsAudio(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO);
  }

  function getIsVideo(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO);
  }

  function getIsText(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT);
  }

  function getIsMuxed(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED);
  }

  function getIsImage(adaptation) {
    return getIsTypeOf(adaptation, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE);
  }

  function getProducerReferenceTimesForAdaptation(adaptation) {
    var prtArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY) ? adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY] : []; // ProducerReferenceTime elements can also be contained in Representations

    var representationsArray = adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_ASARRAY) ? adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_ASARRAY] : [];
    representationsArray.forEach(function (rep) {
      if (rep.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY)) {
        prtArray.push.apply(prtArray, _toConsumableArray(rep[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCERREFERENCETIME_ASARRAY]));
      }
    });
    var prtsForAdaptation = []; // Unlikely to have multiple ProducerReferenceTimes.

    prtArray.forEach(function (prt) {
      var entry = new _vo_ProducerReferenceTime__WEBPACK_IMPORTED_MODULE_10__["default"]();

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WALL_CLOCK_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME];
      } else {
        // Ignore. Missing mandatory attribute
        return;
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND] !== 'false';
      }

      if (prt.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE)) {
        entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE] = prt[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TYPE];
      } // Not interested in other attributes for now
      // UTC element contained must be same as that in the MPD


      prtsForAdaptation.push(entry);
    });
    return prtsForAdaptation;
  }

  function getLanguageForAdaptation(adaptation) {
    var lang = '';

    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG)) {
      lang = adaptation.lang;
    }

    return lang;
  }

  function getViewpointForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT_ASARRAY) || !adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT_ASARRAY].length) return [];
    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT_ASARRAY].map(function (viewpoint) {
      var vp = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return vp.init(viewpoint);
    });
  }

  function getRolesForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE_ASARRAY) || !adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE_ASARRAY].length) return [];
    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE_ASARRAY].map(function (role) {
      var r = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return r.init(role);
    });
  }

  function getAccessibilityForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY_ASARRAY) || !adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY_ASARRAY].length) return [];
    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY_ASARRAY].map(function (accessibility) {
      var a = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return a.init(accessibility);
    });
  }

  function getAudioChannelConfigurationForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY) || !adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY].length) return [];
    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY].map(function (audioChanCfg) {
      var acc = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return acc.init(audioChanCfg);
    });
  }

  function getAudioChannelConfigurationForRepresentation(representation) {
    if (!representation || !representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY) || !representation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY].length) return [];
    return representation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIOCHANNELCONFIGURATION_ASARRAY].map(function (audioChanCfg) {
      var acc = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return acc.init(audioChanCfg);
    });
  }

  function getRepresentationSortFunction() {
    return function (a, b) {
      return a.bandwidth - b.bandwidth;
    };
  }

  function processAdaptation(realAdaptation) {
    if (realAdaptation && Array.isArray(realAdaptation.Representation_asArray)) {
      realAdaptation.Representation_asArray.sort(getRepresentationSortFunction());
    }

    return realAdaptation;
  }

  function getRealAdaptations(manifest, periodIndex) {
    return manifest && manifest.Period_asArray && isInteger(periodIndex) ? manifest.Period_asArray[periodIndex] ? manifest.Period_asArray[periodIndex].AdaptationSet_asArray : [] : [];
  }

  function getRealPeriods(manifest) {
    return manifest && manifest.Period_asArray ? manifest.Period_asArray : [];
  }

  function getRealPeriodForIndex(index, manifest) {
    var realPeriods = getRealPeriods(manifest);

    if (realPeriods.length > 0 && isInteger(index)) {
      return realPeriods[index];
    } else {
      return null;
    }
  }

  function getAdaptationForId(id, manifest, periodIndex) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);
    var i, len;

    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (realAdaptations[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) && realAdaptations[i].id === id) {
        return realAdaptations[i];
      }
    }

    return null;
  }

  function getAdaptationForIndex(index, manifest, periodIndex) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);

    if (realAdaptations.length > 0 && isInteger(index)) {
      return realAdaptations[index];
    } else {
      return null;
    }
  }

  function getIndexForAdaptation(realAdaptation, manifest, periodIndex) {
    if (!realAdaptation) {
      return -1;
    }

    var realAdaptations = getRealAdaptations(manifest, periodIndex);

    for (var i = 0; i < realAdaptations.length; i++) {
      var objectUtils = (0,_streaming_utils_ObjectUtils__WEBPACK_IMPORTED_MODULE_13__["default"])(context).getInstance();

      if (objectUtils.areEqual(realAdaptations[i], realAdaptation)) {
        return i;
      }
    }

    return -1;
  }

  function getAdaptationsForType(manifest, periodIndex, type) {
    var realAdaptations = getRealAdaptations(manifest, periodIndex);
    var i, len;
    var adaptations = [];

    for (i = 0, len = realAdaptations.length; i < len; i++) {
      if (getIsTypeOf(realAdaptations[i], type)) {
        adaptations.push(processAdaptation(realAdaptations[i]));
      }
    }

    return adaptations;
  }

  function getCodec(adaptation, representationId, addResolutionInfo) {
    var codec = null;

    if (adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0) {
      var representation = isInteger(representationId) && representationId >= 0 && representationId < adaptation.Representation_asArray.length ? adaptation.Representation_asArray[representationId] : adaptation.Representation_asArray[0];

      if (representation) {
        codec = representation.mimeType + ';codecs="' + representation.codecs + '"';

        if (addResolutionInfo && representation.width !== undefined) {
          codec += ';width="' + representation.width + '";height="' + representation.height + '"';
        }
      }
    } // If the codec contains a profiles parameter we remove it. Otherwise it will cause problems when checking for codec capabilities of the platform


    if (codec) {
      codec = codec.replace(/\sprofiles=[^;]*/g, '');
    }

    return codec;
  }

  function getMimeType(adaptation) {
    return adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0 ? adaptation.Representation_asArray[0].mimeType : null;
  }

  function getSegmentAlignment(adaptation) {
    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_ALIGNMENT)) {
      return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_ALIGNMENT] === 'true';
    }

    return false;
  }

  function getSubSegmentAlignment(adaptation) {
    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_SEGMENT_ALIGNMENT)) {
      return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_SEGMENT_ALIGNMENT] === 'true';
    }

    return false;
  }

  function getKID(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CENC_DEFAULT_KID)) {
      return null;
    }

    return adaptation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CENC_DEFAULT_KID];
  }

  function getLabelsForAdaptation(adaptation) {
    if (!adaptation || !Array.isArray(adaptation.Label_asArray)) {
      return [];
    }

    var labelArray = [];

    for (var i = 0; i < adaptation.Label_asArray.length; i++) {
      labelArray.push({
        lang: adaptation.Label_asArray[i].lang,
        text: adaptation.Label_asArray[i].__text || adaptation.Label_asArray[i]
      });
    }

    return labelArray;
  }

  function getContentProtectionData(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENTPROTECTION_ASARRAY) || adaptation.ContentProtection_asArray.length === 0) {
      return null;
    }

    return adaptation.ContentProtection_asArray;
  }

  function getIsDynamic(manifest) {
    var isDynamic = false;

    if (manifest && manifest.hasOwnProperty('type')) {
      isDynamic = manifest.type === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DYNAMIC;
    }

    return isDynamic;
  }

  function getId(manifest) {
    return manifest && manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID] || null;
  }

  function hasProfile(manifest, profile) {
    var has = false;

    if (manifest && manifest.profiles && manifest.profiles.length > 0) {
      has = manifest.profiles.indexOf(profile) !== -1;
    }

    return has;
  }

  function getDuration(manifest) {
    var mpdDuration; //@mediaPresentationDuration specifies the duration of the entire Media Presentation.
    //If the attribute is not present, the duration of the Media Presentation is unknown.

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_PRESENTATION_DURATION)) {
      mpdDuration = manifest.mediaPresentationDuration;
    } else if (manifest && manifest.type == 'dynamic') {
      mpdDuration = Number.POSITIVE_INFINITY;
    } else {
      mpdDuration = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
    }

    return mpdDuration;
  }

  function getBandwidth(representation) {
    return representation && representation.bandwidth ? representation.bandwidth : NaN;
  }

  function getManifestUpdatePeriod(manifest) {
    var latencyOfLastUpdate = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    var delay = NaN;

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MINIMUM_UPDATE_PERIOD)) {
      delay = manifest.minimumUpdatePeriod;
    }

    return isNaN(delay) ? delay : Math.max(delay - latencyOfLastUpdate, 1);
  }

  function getPublishTime(manifest) {
    return manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME) ? new Date(manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME]) : null;
  }

  function getRepresentationCount(adaptation) {
    return adaptation && Array.isArray(adaptation.Representation_asArray) ? adaptation.Representation_asArray.length : 0;
  }

  function getBitrateListForAdaptation(realAdaptation) {
    var processedRealAdaptation = processAdaptation(realAdaptation);
    var realRepresentations = processedRealAdaptation && Array.isArray(processedRealAdaptation.Representation_asArray) ? processedRealAdaptation.Representation_asArray : [];
    return realRepresentations.map(function (realRepresentation) {
      return {
        bandwidth: realRepresentation.bandwidth,
        width: realRepresentation.width || 0,
        height: realRepresentation.height || 0,
        scanType: realRepresentation.scanType || null,
        id: realRepresentation.id || null
      };
    });
  }

  function getSelectionPriority(realAdaption) {
    try {
      var priority = realAdaption && typeof realAdaption.selectionPriority !== 'undefined' ? parseInt(realAdaption.selectionPriority) : 1;
      return isNaN(priority) ? 1 : priority;
    } catch (e) {
      return 1;
    }
  }

  function getEssentialPropertiesForRepresentation(realRepresentation) {
    if (!realRepresentation || !realRepresentation.EssentialProperty_asArray || !realRepresentation.EssentialProperty_asArray.length) return null;
    return realRepresentation.EssentialProperty_asArray.map(function (prop) {
      return {
        schemeIdUri: prop.schemeIdUri,
        value: prop.value
      };
    });
  }

  function getRepresentationFor(index, adaptation) {
    return adaptation && adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0 && isInteger(index) ? adaptation.Representation_asArray[index] : null;
  }

  function getRealAdaptationFor(voAdaptation) {
    if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
      var periodArray = voAdaptation.period.mpd.manifest.Period_asArray[voAdaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(voAdaptation.index)) {
        return processAdaptation(periodArray.AdaptationSet_asArray[voAdaptation.index]);
      }
    }
  }

  function getRepresentationsForAdaptation(voAdaptation) {
    var voRepresentations = [];
    var processedRealAdaptation = getRealAdaptationFor(voAdaptation);
    var segmentInfo, baseUrl;

    if (processedRealAdaptation && processedRealAdaptation.Representation_asArray) {
      // TODO: TO BE REMOVED. We should get just the baseUrl elements that affects to the representations
      // that we are processing. Making it works properly will require much further changes and given
      // parsing base Urls parameters is needed for our ultra low latency examples, we will
      // keep this "tricky" code until the real (and good) solution comes
      if (voAdaptation && voAdaptation.period && isInteger(voAdaptation.period.index)) {
        var baseUrls = getBaseURLsFromElement(voAdaptation.period.mpd.manifest);

        if (baseUrls) {
          baseUrl = baseUrls[0];
        }
      }

      for (var i = 0, len = processedRealAdaptation.Representation_asArray.length; i < len; ++i) {
        var realRepresentation = processedRealAdaptation.Representation_asArray[i];
        var voRepresentation = new _vo_Representation__WEBPACK_IMPORTED_MODULE_2__["default"]();
        voRepresentation.index = i;
        voRepresentation.adaptation = voAdaptation;

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
          voRepresentation.id = realRepresentation.id;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS)) {
          voRepresentation.codecs = realRepresentation.codecs;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE)) {
          voRepresentation.mimeType = realRepresentation[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE];
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODEC_PRIVATE_DATA)) {
          voRepresentation.codecPrivateData = realRepresentation.codecPrivateData;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BANDWITH)) {
          voRepresentation.bandwidth = realRepresentation.bandwidth;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WIDTH)) {
          voRepresentation.width = realRepresentation.width;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].HEIGHT)) {
          voRepresentation.height = realRepresentation.height;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SCAN_TYPE)) {
          voRepresentation.scanType = realRepresentation.scanType;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_PLAYOUT_RATE)) {
          voRepresentation.maxPlayoutRate = realRepresentation.maxPlayoutRate;
        }

        if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE)) {
          segmentInfo = realRepresentation.SegmentBase;
          voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE;
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST)) {
          segmentInfo = realRepresentation.SegmentList;

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST;
          }
        } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE)) {
          segmentInfo = realRepresentation.SegmentTemplate;

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE;
          } else {
            voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION_MINUS)) {
            voRepresentation.initialization = segmentInfo.initialization.split('$Bandwidth$').join(realRepresentation.bandwidth).split('$RepresentationID$').join(realRepresentation.id);
          }
        } else {
          voRepresentation.segmentInfoType = _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BASE_URL;
        }

        voRepresentation.essentialProperties = getEssentialPropertiesForRepresentation(realRepresentation);

        if (segmentInfo) {
          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION)) {
            var initialization = segmentInfo.Initialization;

            if (initialization.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SOURCE_URL)) {
              voRepresentation.initialization = initialization.sourceURL;
            }

            if (initialization.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE)) {
              voRepresentation.range = initialization.range; // initialization source url will be determined from
              // BaseURL when resolved at load time.
            }
          } else if (getIsText(processedRealAdaptation) && getIsFragmented(processedRealAdaptation) && processedRealAdaptation.mimeType && processedRealAdaptation.mimeType.indexOf('application/mp4') === -1) {
            voRepresentation.range = 0;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
            voRepresentation.timescale = segmentInfo.timescale;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
            // TODO according to the spec @maxSegmentDuration specifies the maximum duration of any Segment in any Representation in the Media Presentation
            // It is also said that for a SegmentTimeline any @d value shall not exceed the value of MPD@maxSegmentDuration, but nothing is said about
            // SegmentTemplate @duration attribute. We need to find out if @maxSegmentDuration should be used instead of calculated duration if the the duration
            // exceeds @maxSegmentDuration
            voRepresentation.segmentDuration = segmentInfo.duration / voRepresentation.timescale;
          } else if (realRepresentation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE)) {
            segmentInfo = realRepresentation.SegmentTemplate;

            if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE)) {
              voRepresentation.segmentDuration = calcSegmentDuration(segmentInfo.SegmentTimeline) / voRepresentation.timescale;
            }
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA)) {
            voRepresentation.media = segmentInfo.media;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START_NUMBER)) {
            voRepresentation.startNumber = segmentInfo.startNumber;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE)) {
            voRepresentation.indexRange = segmentInfo.indexRange;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET)) {
            voRepresentation.presentationTimeOffset = segmentInfo.presentationTimeOffset / voRepresentation.timescale;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET)) {
            voRepresentation.availabilityTimeOffset = segmentInfo.availabilityTimeOffset;
          } else if (baseUrl && baseUrl.availabilityTimeOffset !== undefined) {
            voRepresentation.availabilityTimeOffset = baseUrl.availabilityTimeOffset;
          }

          if (segmentInfo.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE)) {
            voRepresentation.availabilityTimeComplete = segmentInfo.availabilityTimeComplete !== 'false';
          } else if (baseUrl && baseUrl.availabilityTimeComplete !== undefined) {
            voRepresentation.availabilityTimeComplete = baseUrl.availabilityTimeComplete;
          }
        }

        voRepresentation.MSETimeOffset = calcMSETimeOffset(voRepresentation);
        voRepresentation.path = [voAdaptation.period.index, voAdaptation.index, i];
        voRepresentations.push(voRepresentation);
      }
    }

    return voRepresentations;
  }

  function calcSegmentDuration(segmentTimeline) {
    if (!segmentTimeline || !segmentTimeline.S_asArray) {
      return NaN;
    }

    var s0 = segmentTimeline.S_asArray[0];
    var s1 = segmentTimeline.S_asArray[1];
    return s0.hasOwnProperty('d') ? s0.d : s1.t - s0.t;
  }

  function calcMSETimeOffset(representation) {
    // The MSEOffset is offset from AST for media. It is Period@start - presentationTimeOffset
    var presentationOffset = representation.presentationTimeOffset;
    var periodStart = representation.adaptation.period.start;
    return periodStart - presentationOffset;
  }

  function getAdaptationsForPeriod(voPeriod) {
    var realPeriod = voPeriod && isInteger(voPeriod.index) ? voPeriod.mpd.manifest.Period_asArray[voPeriod.index] : null;
    var voAdaptations = [];
    var voAdaptationSet, realAdaptationSet, i;

    if (realPeriod && realPeriod.AdaptationSet_asArray) {
      for (i = 0; i < realPeriod.AdaptationSet_asArray.length; i++) {
        realAdaptationSet = realPeriod.AdaptationSet_asArray[i];
        voAdaptationSet = new _vo_AdaptationSet__WEBPACK_IMPORTED_MODULE_3__["default"]();

        if (realAdaptationSet.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
          voAdaptationSet.id = realAdaptationSet.id;
        }

        voAdaptationSet.index = i;
        voAdaptationSet.period = voPeriod;

        if (getIsMuxed(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED;
        } else if (getIsAudio(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO;
        } else if (getIsVideo(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO;
        } else if (getIsText(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT;
        } else if (getIsImage(realAdaptationSet)) {
          voAdaptationSet.type = _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE;
        } else {
          logger.warn('Unknown Adaptation stream type');
        }

        voAdaptations.push(voAdaptationSet);
      }
    }

    return voAdaptations;
  }

  function getRegularPeriods(mpd) {
    var isDynamic = mpd ? getIsDynamic(mpd.manifest) : false;
    var voPeriods = [];
    var realPreviousPeriod = null;
    var realPeriod = null;
    var voPreviousPeriod = null;
    var voPeriod = null;
    var len, i;

    for (i = 0, len = mpd && mpd.manifest && mpd.manifest.Period_asArray ? mpd.manifest.Period_asArray.length : 0; i < len; i++) {
      realPeriod = mpd.manifest.Period_asArray[i]; // If the attribute @start is present in the Period, then the
      // Period is a regular Period and the PeriodStart is equal
      // to the value of this attribute.

      if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START)) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = realPeriod.start;
      } // If the @start attribute is absent, but the previous Period element contains a @duration attribute then this new Period is also a regular Period. The start time of the new Period PeriodStart is the sum of the start time of the previous Period PeriodStart and the value of the attribute @duration of the previous Period.
      else if (realPreviousPeriod !== null && realPreviousPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION) && voPreviousPeriod !== null) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = parseFloat((voPreviousPeriod.start + voPreviousPeriod.duration).toFixed(5));
      } // If (i) @start attribute is absent, and (ii) the Period element is the first in the MPD, and (iii) the MPD@type is 'static', then the PeriodStart time shall be set to zero.
      else if (i === 0 && !isDynamic) {
        voPeriod = new _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"]();
        voPeriod.start = 0;
      } // The Period extends until the PeriodStart of the next Period.
      // The difference between the PeriodStart time of a Period and
      // the PeriodStart time of the following Period.


      if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
        if (voPeriod !== null) {
          voPreviousPeriod.duration = parseFloat((voPeriod.start - voPreviousPeriod.start).toFixed(5));
        } else {
          logger.warn('First period duration could not be calculated because lack of start and duration period properties. This will cause timing issues during playback');
        }
      }

      if (voPeriod !== null) {
        voPeriod.id = getPeriodId(realPeriod, i);
        voPeriod.index = i;
        voPeriod.mpd = mpd;

        if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
          voPeriod.duration = realPeriod.duration;
        }

        if (voPreviousPeriod) {
          voPreviousPeriod.nextPeriodId = voPeriod.id;
        }

        voPeriods.push(voPeriod);
        realPreviousPeriod = realPeriod;
        voPreviousPeriod = voPeriod;
      }

      realPeriod = null;
      voPeriod = null;
    }

    if (voPeriods.length === 0) {
      return voPeriods;
    } // The last Period extends until the end of the Media Presentation.
    // The difference between the PeriodStart time of the last Period
    // and the mpd duration


    if (voPreviousPeriod !== null && isNaN(voPreviousPeriod.duration)) {
      voPreviousPeriod.duration = parseFloat((getEndTimeForLastPeriod(voPreviousPeriod) - voPreviousPeriod.start).toFixed(5));
    }

    return voPeriods;
  }

  function getPeriodId(realPeriod, i) {
    if (!realPeriod) {
      throw new Error('Period cannot be null or undefined');
    }

    var id = _vo_Period__WEBPACK_IMPORTED_MODULE_4__["default"].DEFAULT_ID + '_' + i;

    if (realPeriod.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) && realPeriod.id.length > 0 && realPeriod.id !== '__proto__') {
      id = realPeriod.id;
    }

    return id;
  }

  function getMpd(manifest) {
    var mpd = new _vo_Mpd__WEBPACK_IMPORTED_MODULE_5__["default"]();

    if (manifest) {
      mpd.manifest = manifest;

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME)) {
        mpd.availabilityStartTime = new Date(manifest.availabilityStartTime.getTime());
      } else {
        if (manifest.loadedTime) {
          mpd.availabilityStartTime = new Date(manifest.loadedTime.getTime());
        }
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_END_TIME)) {
        mpd.availabilityEndTime = new Date(manifest.availabilityEndTime.getTime());
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MINIMUM_UPDATE_PERIOD)) {
        mpd.minimumUpdatePeriod = manifest.minimumUpdatePeriod;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_PRESENTATION_DURATION)) {
        mpd.mediaPresentationDuration = manifest.mediaPresentationDuration;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUGGESTED_PRESENTATION_DELAY)) {
        mpd.suggestedPresentationDelay = manifest.suggestedPresentationDelay;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESHIFT_BUFFER_DEPTH)) {
        mpd.timeShiftBufferDepth = manifest.timeShiftBufferDepth;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_SEGMENT_DURATION)) {
        mpd.maxSegmentDuration = manifest.maxSegmentDuration;
      }

      if (manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PUBLISH_TIME)) {
        mpd.publishTime = new Date(manifest.publishTime);
      }
    }

    return mpd;
  }

  function checkConfig() {
    if (!errHandler || !errHandler.hasOwnProperty('error')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getEndTimeForLastPeriod(voPeriod) {
    checkConfig();
    var isDynamic = getIsDynamic(voPeriod.mpd.manifest);
    var periodEnd;

    if (voPeriod.mpd.manifest.mediaPresentationDuration) {
      periodEnd = voPeriod.mpd.manifest.mediaPresentationDuration;
    } else if (voPeriod.duration) {
      periodEnd = voPeriod.duration;
    } else if (isDynamic) {
      periodEnd = Number.POSITIVE_INFINITY;
    } else {
      errHandler.error(new _streaming_vo_DashJSError__WEBPACK_IMPORTED_MODULE_17__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_18__["default"].MANIFEST_ERROR_ID_PARSE_CODE, 'Must have @mediaPresentationDuration on MPD or an explicit @duration on the last period.', voPeriod));
    }

    return periodEnd;
  }

  function getEventsForPeriod(period) {
    var manifest = period && period.mpd && period.mpd.manifest ? period.mpd.manifest : null;
    var periodArray = manifest ? manifest.Period_asArray : null;
    var eventStreams = periodArray && period && isInteger(period.index) ? periodArray[period.index].EventStream_asArray : null;
    var events = [];
    var i, j;

    if (eventStreams) {
      for (i = 0; i < eventStreams.length; i++) {
        var eventStream = new _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__["default"]();
        eventStream.period = period;
        eventStream.timescale = 1;

        if (eventStreams[i].hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
          eventStream.schemeIdUri = eventStreams[i][_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI];
        } else {
          throw new Error('Invalid EventStream. SchemeIdUri has to be set');
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
          eventStream.timescale = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE];
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
          eventStream.value = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE];
        }

        if (eventStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET)) {
          eventStream.presentationTimeOffset = eventStreams[i][_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME_OFFSET];
        }

        for (j = 0; eventStreams[i].Event_asArray && j < eventStreams[i].Event_asArray.length; j++) {
          var currentMpdEvent = eventStreams[i].Event_asArray[j];
          var event = new _vo_Event__WEBPACK_IMPORTED_MODULE_7__["default"]();
          event.presentationTime = 0;
          event.eventStream = eventStream;

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRESENTATION_TIME)) {
            event.presentationTime = currentMpdEvent.presentationTime;
          }

          var presentationTimeOffset = eventStream.presentationTimeOffset ? eventStream.presentationTimeOffset / eventStream.timescale : 0;
          event.calculatedPresentationTime = event.presentationTime / eventStream.timescale + period.start - presentationTimeOffset;

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DURATION)) {
            event.duration = currentMpdEvent.duration / eventStream.timescale;
          }

          if (currentMpdEvent.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID)) {
            event.id = currentMpdEvent.id;
          } else {
            event.id = null;
          }

          if (currentMpdEvent.Signal && currentMpdEvent.Signal.Binary) {
            // toString is used to manage both regular and namespaced tags
            event.messageData = BASE64.decodeArray(currentMpdEvent.Signal.Binary.toString());
          } else {
            // From Cor.1: 'NOTE: this attribute is an alternative
            // to specifying a complete XML element(s) in the Event.
            // It is useful when an event leans itself to a compact
            // string representation'.
            event.messageData = currentMpdEvent.messageData || currentMpdEvent.__cdata || currentMpdEvent.__text;
          }

          events.push(event);
        }
      }
    }

    return events;
  }

  function getEventStreams(inbandStreams, representation, period) {
    var eventStreams = [];
    var i;
    if (!inbandStreams) return eventStreams;

    for (i = 0; i < inbandStreams.length; i++) {
      var eventStream = new _vo_EventStream__WEBPACK_IMPORTED_MODULE_9__["default"]();
      eventStream.timescale = 1;
      eventStream.representation = representation;

      if (inbandStreams[i].hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
        eventStream.schemeIdUri = inbandStreams[i].schemeIdUri;
      } else {
        throw new Error('Invalid EventStream. SchemeIdUri has to be set');
      }

      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TIMESCALE)) {
        eventStream.timescale = inbandStreams[i].timescale;
      }

      if (inbandStreams[i].hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
        eventStream.value = inbandStreams[i].value;
      }

      eventStreams.push(eventStream);
      eventStream.period = period;
    }

    return eventStreams;
  }

  function getEventStreamForAdaptationSet(manifest, adaptation, period) {
    var inbandStreams, periodArray, adaptationArray;

    if (manifest && manifest.Period_asArray && adaptation && adaptation.period && isInteger(adaptation.period.index)) {
      periodArray = manifest.Period_asArray[adaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet_asArray[adaptation.index];

        if (adaptationArray) {
          inbandStreams = adaptationArray.InbandEventStream_asArray;
        }
      }
    }

    return getEventStreams(inbandStreams, null, period);
  }

  function getEventStreamForRepresentation(manifest, representation, period) {
    var inbandStreams, periodArray, adaptationArray, representationArray;

    if (manifest && manifest.Period_asArray && representation && representation.adaptation && representation.adaptation.period && isInteger(representation.adaptation.period.index)) {
      periodArray = manifest.Period_asArray[representation.adaptation.period.index];

      if (periodArray && periodArray.AdaptationSet_asArray && isInteger(representation.adaptation.index)) {
        adaptationArray = periodArray.AdaptationSet_asArray[representation.adaptation.index];

        if (adaptationArray && adaptationArray.Representation_asArray && isInteger(representation.index)) {
          representationArray = adaptationArray.Representation_asArray[representation.index];

          if (representationArray) {
            inbandStreams = representationArray.InbandEventStream_asArray;
          }
        }
      }
    }

    return getEventStreams(inbandStreams, representation, period);
  }

  function getUTCTimingSources(manifest) {
    var isDynamic = getIsDynamic(manifest);
    var hasAST = manifest ? manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME) : false;
    var utcTimingsArray = manifest ? manifest.UTCTiming_asArray : null;
    var utcTimingEntries = []; // do not bother synchronizing the clock unless MPD is live,
    // or it is static and has availabilityStartTime attribute

    if (isDynamic || hasAST) {
      if (utcTimingsArray) {
        // the order is important here - 23009-1 states that the order
        // in the manifest "indicates relative preference, first having
        // the highest, and the last the lowest priority".
        utcTimingsArray.forEach(function (utcTiming) {
          var entry = new _vo_UTCTiming__WEBPACK_IMPORTED_MODULE_6__["default"]();

          if (utcTiming.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
            entry.schemeIdUri = utcTiming.schemeIdUri;
          } else {
            // entries of type DescriptorType with no schemeIdUri
            // are meaningless. let's just ignore this entry and
            // move on.
            return;
          } // this is (incorrectly) interpreted as a number - schema
          // defines it as a string


          if (utcTiming.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE)) {
            entry.value = utcTiming.value.toString();
          } else {
            // without a value, there's not a lot we can do with
            // this entry. let's just ignore this one and move on
            return;
          } // we're not interested in the optional id or any other
          // attributes which might be attached to the entry


          utcTimingEntries.push(entry);
        });
      }
    }

    return utcTimingEntries;
  }

  function getBaseURLsFromElement(node) {
    var baseUrls = []; // if node.BaseURL_asArray and node.baseUri are undefined entries
    // will be [undefined] which entries.some will just skip

    var entries = node.BaseURL_asArray || [node.baseUri];
    var earlyReturn = false;
    entries.some(function (entry) {
      if (entry) {
        var baseUrl = new _vo_BaseURL__WEBPACK_IMPORTED_MODULE_8__["default"]();
        var text = entry.__text || entry;

        if (urlUtils.isRelative(text)) {
          // it doesn't really make sense to have relative and
          // absolute URLs at the same level, or multiple
          // relative URLs at the same level, so assume we are
          // done from this level of the MPD
          earlyReturn = true; // deal with the specific case where the MPD@BaseURL
          // is specified and is relative. when no MPD@BaseURL
          // entries exist, that case is handled by the
          // [node.baseUri] in the entries definition.

          if (node.baseUri) {
            text = urlUtils.resolve(text, node.baseUri);
          }
        }

        baseUrl.url = text; // serviceLocation is optional, but we need it in order
        // to blacklist correctly. if it's not available, use
        // anything unique since there's no relationship to any
        // other BaseURL and, in theory, the url should be
        // unique so use this instead.

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION) && entry.serviceLocation.length) {
          baseUrl.serviceLocation = entry.serviceLocation;
        } else {
          baseUrl.serviceLocation = text;
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_PRIORITY)) {
          baseUrl.dvbPriority = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_PRIORITY];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_WEIGHT)) {
          baseUrl.dvbWeight = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DVB_WEIGHT];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET)) {
          baseUrl.availabilityTimeOffset = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_OFFSET];
        }

        if (entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE)) {
          baseUrl.availabilityTimeComplete = entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_TIME_COMPLETE] !== 'false';
        }
        /* NOTE: byteRange currently unused
         */


        baseUrls.push(baseUrl);
        return earlyReturn;
      }
    });
    return baseUrls;
  }

  function getContentSteering(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING_AS_ARRAY)) {
      // Only one ContentSteering element is supported on MPD level
      var element = manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING_AS_ARRAY][0];
      return _createContentSteeringInstance(element);
    }

    return undefined;
  }

  function _createContentSteeringInstance(element) {
    var entry = new _vo_ContentSteering__WEBPACK_IMPORTED_MODULE_11__["default"]();
    entry.serverUrl = element.__text;

    if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_SERVICE_LOCATION)) {
      entry.defaultServiceLocation = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULT_SERVICE_LOCATION];
      entry.defaultServiceLocationArray = entry.defaultServiceLocation.split(' ');
    }

    if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].QUERY_BEFORE_START)) {
      entry.queryBeforeStart = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].QUERY_BEFORE_START].toLowerCase() === 'true';
    }

    if (element.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CLIENT_REQUIREMENT)) {
      entry.clientRequirement = element[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CLIENT_REQUIREMENT].toLowerCase() !== 'false';
    }

    return entry;
  }

  function getLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LOCATION_AS_ARRAY)) {
      return manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LOCATION_AS_ARRAY].map(function (entry) {
        var text = entry.__text || entry;
        var serviceLocation = entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION) ? entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION] : null;
        return new _vo_MpdLocation__WEBPACK_IMPORTED_MODULE_20__["default"](text, serviceLocation);
      });
    }

    return [];
  }

  function getPatchLocation(manifest) {
    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PATCH_LOCATION_AS_ARRAY)) {
      return manifest[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PATCH_LOCATION_AS_ARRAY].map(function (entry) {
        var text = entry.__text || entry;
        var serviceLocation = entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION) ? entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION] : null;
        var ttl = entry.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TTL) ? parseFloat(entry[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].TTL]) * 1000 : NaN;
        return new _vo_PatchLocation__WEBPACK_IMPORTED_MODULE_21__["default"](text, serviceLocation, ttl);
      });
    }

    return [];
  }

  function getSuggestedPresentationDelay(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUGGESTED_PRESENTATION_DELAY) ? mpd.suggestedPresentationDelay : null;
  }

  function getAvailabilityStartTime(mpd) {
    return mpd && mpd.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AVAILABILITY_START_TIME) && mpd.availabilityStartTime !== null ? mpd.availabilityStartTime.getTime() : null;
  }

  function getServiceDescriptions(manifest) {
    var serviceDescriptions = [];

    if (manifest && manifest.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION)) {
      var _iterator = _createForOfIteratorHelper(manifest.ServiceDescription_asArray),
          _step;

      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var sd = _step.value;
          // Convert each of the properties defined in
          var id = null,
              schemeIdUri = null,
              latency = null,
              playbackRate = null,
              operatingQuality = null,
              operatingBandwidth = null,
              contentSteering = null;

          for (var prop in sd) {
            if (sd.hasOwnProperty(prop)) {
              if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID) {
                id = sd[prop];
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_SCOPE) {
                schemeIdUri = sd[prop].schemeIdUri;
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_LATENCY) {
                latency = {
                  target: parseInt(sd[prop].target),
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  referenceId: parseInt(sd[prop].referenceId)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_PLAYBACK_RATE) {
                playbackRate = {
                  max: parseFloat(sd[prop].max),
                  min: parseFloat(sd[prop].min)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_OPERATING_QUALITY) {
                operatingQuality = {
                  mediaType: sd[prop].mediaType,
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  target: parseInt(sd[prop].target),
                  type: sd[prop].type,
                  maxQualityDifference: parseInt(sd[prop].maxQualityDifference)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_DESCRIPTION_OPERATING_BANDWIDTH) {
                operatingBandwidth = {
                  mediaType: sd[prop].mediaType,
                  max: parseInt(sd[prop].max),
                  min: parseInt(sd[prop].min),
                  target: parseInt(sd[prop].target)
                };
              } else if (prop === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_STEERING) {
                contentSteering = _createContentSteeringInstance(sd[prop]);
              }
            }
          }

          serviceDescriptions.push({
            id: id,
            schemeIdUri: schemeIdUri,
            latency: latency,
            playbackRate: playbackRate,
            operatingQuality: operatingQuality,
            operatingBandwidth: operatingBandwidth,
            contentSteering: contentSteering
          });
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
    }

    return serviceDescriptions;
  }

  function getSupplementalPropertiesForAdaptation(adaptation) {
    var supplementalProperties = {};

    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY_ASARRAY)) {
      var _iterator2 = _createForOfIteratorHelper(adaptation.SupplementalProperty_asArray),
          _step2;

      try {
        for (_iterator2.s(); !(_step2 = _iterator2.n()).done;) {
          var sp = _step2.value;

          if (sp.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
            // N.B this will only work where there is a single SupplementalProperty descriptor with this SchemeIdUri
            supplementalProperties[sp[_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI]] = _objectSpread({}, sp);
          }
        }
      } catch (err) {
        _iterator2.e(err);
      } finally {
        _iterator2.f();
      }
    }

    return supplementalProperties;
  }

  function getSupplementalPropertiesAsArrayForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY_ASARRAY) || !adaptation.SupplementalProperty_asArray.length) return [];
    return adaptation.SupplementalProperty_asArray.map(function (supp) {
      var s = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return s.init(supp);
    });
  }

  function getSupplementalPropertiesForRepresentation(representation) {
    var supplementalProperties = {};

    if (representation && representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY_ASARRAY)) {
      var _iterator3 = _createForOfIteratorHelper(representation.SupplementalProperty_asArray),
          _step3;

      try {
        for (_iterator3.s(); !(_step3 = _iterator3.n()).done;) {
          var sp = _step3.value;

          if (sp.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
            // N.B this will only work where there is a single SupplementalProperty descriptor with this SchemeIdUri
            supplementalProperties[sp[_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI]] = _objectSpread({}, sp);
          }
        }
      } catch (err) {
        _iterator3.e(err);
      } finally {
        _iterator3.f();
      }
    }

    return supplementalProperties;
  }

  function getSupplementalPropertiesAsArrayForRepresentation(representation) {
    if (!representation || !representation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY_ASARRAY) || !representation.SupplementalProperty_asArray.length) return [];
    return representation.SupplementalProperty_asArray.map(function (supp) {
      var s = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return s.init(supp);
    });
  }

  function getEssentialPropertiesForAdaptation(adaptation) {
    var essentialProperties = {};

    if (adaptation && adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY_ASARRAY)) {
      var _iterator4 = _createForOfIteratorHelper(adaptation.EssentialProperty_asArray),
          _step4;

      try {
        for (_iterator4.s(); !(_step4 = _iterator4.n()).done;) {
          var ep = _step4.value;

          if (ep.hasOwnProperty(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI)) {
            // N.B this will only work where there is a single EssentialProperty descriptor with this SchemeIdUri
            essentialProperties[ep[_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].SCHEME_ID_URI]] = _objectSpread({}, ep);
          }
        }
      } catch (err) {
        _iterator4.e(err);
      } finally {
        _iterator4.f();
      }
    }

    return essentialProperties;
  }

  function getEssentialPropertiesAsArrayForAdaptation(adaptation) {
    if (!adaptation || !adaptation.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY_ASARRAY) || !adaptation.EssentialProperty_asArray.length) return [];
    return adaptation.EssentialProperty_asArray.map(function (ep) {
      var s = new _vo_DescriptorType__WEBPACK_IMPORTED_MODULE_12__["default"]();
      return s.init(ep);
    });
  }

  function setConfig(config) {
    if (!config) return;

    if (config.errHandler) {
      errHandler = config.errHandler;
    }

    if (config.BASE64) {
      BASE64 = config.BASE64;
    }
  }

  instance = {
    getIsTypeOf: getIsTypeOf,
    getIsText: getIsText,
    getIsFragmented: getIsFragmented,
    getProducerReferenceTimesForAdaptation: getProducerReferenceTimesForAdaptation,
    getLanguageForAdaptation: getLanguageForAdaptation,
    getViewpointForAdaptation: getViewpointForAdaptation,
    getRolesForAdaptation: getRolesForAdaptation,
    getAccessibilityForAdaptation: getAccessibilityForAdaptation,
    getAudioChannelConfigurationForAdaptation: getAudioChannelConfigurationForAdaptation,
    getAudioChannelConfigurationForRepresentation: getAudioChannelConfigurationForRepresentation,
    getAdaptationForIndex: getAdaptationForIndex,
    getIndexForAdaptation: getIndexForAdaptation,
    getAdaptationForId: getAdaptationForId,
    getAdaptationsForType: getAdaptationsForType,
    getRealPeriods: getRealPeriods,
    getRealPeriodForIndex: getRealPeriodForIndex,
    getCodec: getCodec,
    getSelectionPriority: getSelectionPriority,
    getMimeType: getMimeType,
    getKID: getKID,
    getLabelsForAdaptation: getLabelsForAdaptation,
    getContentProtectionData: getContentProtectionData,
    getIsDynamic: getIsDynamic,
    getId: getId,
    hasProfile: hasProfile,
    getDuration: getDuration,
    getBandwidth: getBandwidth,
    getManifestUpdatePeriod: getManifestUpdatePeriod,
    getPublishTime: getPublishTime,
    getRepresentationCount: getRepresentationCount,
    getBitrateListForAdaptation: getBitrateListForAdaptation,
    getRepresentationFor: getRepresentationFor,
    getRepresentationsForAdaptation: getRepresentationsForAdaptation,
    getAdaptationsForPeriod: getAdaptationsForPeriod,
    getRegularPeriods: getRegularPeriods,
    getMpd: getMpd,
    getEventsForPeriod: getEventsForPeriod,
    getEssentialPropertiesForAdaptation: getEssentialPropertiesForAdaptation,
    getEssentialPropertiesAsArrayForAdaptation: getEssentialPropertiesAsArrayForAdaptation,
    getEssentialPropertiesForRepresentation: getEssentialPropertiesForRepresentation,
    getEventStreamForAdaptationSet: getEventStreamForAdaptationSet,
    getEventStreamForRepresentation: getEventStreamForRepresentation,
    getUTCTimingSources: getUTCTimingSources,
    getBaseURLsFromElement: getBaseURLsFromElement,
    getRepresentationSortFunction: getRepresentationSortFunction,
    getContentSteering: getContentSteering,
    getLocation: getLocation,
    getPatchLocation: getPatchLocation,
    getSuggestedPresentationDelay: getSuggestedPresentationDelay,
    getAvailabilityStartTime: getAvailabilityStartTime,
    getServiceDescriptions: getServiceDescriptions,
    getSegmentAlignment: getSegmentAlignment,
    getSubSegmentAlignment: getSubSegmentAlignment,
    getSupplementalPropertiesForAdaptation: getSupplementalPropertiesForAdaptation,
    getSupplementalPropertiesAsArrayForAdaptation: getSupplementalPropertiesAsArrayForAdaptation,
    getSupplementalPropertiesForRepresentation: getSupplementalPropertiesForRepresentation,
    getSupplementalPropertiesAsArrayForRepresentation: getSupplementalPropertiesAsArrayForRepresentation,
    setConfig: setConfig
  };
  setup();
  return instance;
}

DashManifestModel.__dashjs_factory_name = 'DashManifestModel';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_15__["default"].getSingletonFactory(DashManifestModel));

/***/ }),

/***/ "./src/dash/models/PatchManifestModel.js":
/*!***********************************************!*\
  !*** ./src/dash/models/PatchManifestModel.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _vo_SimpleXPath__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/SimpleXPath */ "./src/dash/vo/SimpleXPath.js");
/* harmony import */ var _vo_PatchOperation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../vo/PatchOperation */ "./src/dash/vo/PatchOperation.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function PatchManifestModel() {
  var instance, logger;
  var context = this.context;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_2__["default"])(context).getInstance().getLogger(instance);
  }

  function getIsPatch(patch) {
    return patch && patch.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].ORIGINAL_MPD_ID) || false;
  }

  function getPublishTime(patch) {
    return patch && patch.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].PUBLISH_TIME) ? new Date(patch[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].PUBLISH_TIME]) : null;
  }

  function getOriginalPublishTime(patch) {
    return patch && patch.hasOwnProperty(_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].ORIGINAL_PUBLISH_TIME) ? new Date(patch[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].ORIGINAL_PUBLISH_TIME]) : null;
  }

  function getMpdId(patch) {
    return patch && patch[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].ORIGINAL_MPD_ID] || null;
  }

  function getPatchOperations(patch) {
    if (!patch) {
      return [];
    } // Go through the patch operations in order and parse their actions out for usage


    return (patch.__children || []).map(function (nodeContainer) {
      var action = Object.keys(nodeContainer)[0]; // we only look add add/remove/replace actions

      if (action !== 'add' && action !== 'remove' && action !== 'replace') {
        logger.warn("Ignoring node of invalid action: ".concat(action));
        return null;
      }

      var node = nodeContainer[action];
      var selector = node.sel; // add action can have special targeting via the 'type' attribute

      if (action === 'add' && node.type) {
        if (!node.type.startsWith('@')) {
          logger.warn("Ignoring add action for prefixed namespace declaration: ".concat(node.type, "=").concat(node.__text));
          return null;
        } // for our purposes adding/replacing attribute are equivalent and we can normalize
        // our processing logic by appending the attribute to the selector path


        selector = "".concat(selector, "/").concat(node.type);
      }

      var xpath = new _vo_SimpleXPath__WEBPACK_IMPORTED_MODULE_3__["default"](selector);

      if (!xpath.isValid()) {
        logger.warn("Ignoring action with invalid selector: ".concat(action, " - ").concat(selector));
        return null;
      }

      var value = null;

      if (xpath.findsAttribute() || xpath.findsTextReplace()) {
        value = node.__text || '';
      } else if (action !== 'remove') {
        value = node.__children.reduce(function (groups, child) {
          // note that this is informed by xml2js parse structure for the __children array
          // which will be something like this for each child:
          // {
          //     "<node-name>": { <xml2js-node-object> }
          // }
          var key = Object.keys(child)[0]; // we also ignore

          if (key !== '#text') {
            groups[key] = groups[key] || [];
            groups[key].push(child[key]);
          }

          return groups;
        }, {});
      }

      var operation = new _vo_PatchOperation__WEBPACK_IMPORTED_MODULE_4__["default"](action, xpath, value);

      if (action === 'add') {
        operation.position = node.pos;
      }

      return operation;
    }).filter(function (operation) {
      return !!operation;
    });
  }

  instance = {
    getIsPatch: getIsPatch,
    getPublishTime: getPublishTime,
    getOriginalPublishTime: getOriginalPublishTime,
    getMpdId: getMpdId,
    getPatchOperations: getPatchOperations
  };
  setup();
  return instance;
}

PatchManifestModel.__dashjs_factory_name = 'PatchManifestModel';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getSingletonFactory(PatchManifestModel));

/***/ }),

/***/ "./src/dash/parser/DashParser.js":
/*!***************************************!*\
  !*** ./src/dash/parser/DashParser.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _objectiron__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./objectiron */ "./src/dash/parser/objectiron.js");
/* harmony import */ var _externals_xml2json__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../externals/xml2json */ "./externals/xml2json.js");
/* harmony import */ var _matchers_StringMatcher__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./matchers/StringMatcher */ "./src/dash/parser/matchers/StringMatcher.js");
/* harmony import */ var _matchers_DurationMatcher__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./matchers/DurationMatcher */ "./src/dash/parser/matchers/DurationMatcher.js");
/* harmony import */ var _matchers_DateTimeMatcher__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./matchers/DateTimeMatcher */ "./src/dash/parser/matchers/DateTimeMatcher.js");
/* harmony import */ var _matchers_NumericMatcher__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./matchers/NumericMatcher */ "./src/dash/parser/matchers/NumericMatcher.js");
/* harmony import */ var _matchers_LangMatcher__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./matchers/LangMatcher */ "./src/dash/parser/matchers/LangMatcher.js");
/* harmony import */ var _maps_RepresentationBaseValuesMap__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./maps/RepresentationBaseValuesMap */ "./src/dash/parser/maps/RepresentationBaseValuesMap.js");
/* harmony import */ var _maps_SegmentValuesMap__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./maps/SegmentValuesMap */ "./src/dash/parser/maps/SegmentValuesMap.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */











function DashParser(config) {
  config = config || {};
  var context = this.context;
  var debug = config.debug;
  var instance, logger, matchers, converter, objectIron;

  function setup() {
    logger = debug.getLogger(instance);
    matchers = [new _matchers_DurationMatcher__WEBPACK_IMPORTED_MODULE_4__["default"](), new _matchers_DateTimeMatcher__WEBPACK_IMPORTED_MODULE_5__["default"](), new _matchers_NumericMatcher__WEBPACK_IMPORTED_MODULE_6__["default"](), new _matchers_LangMatcher__WEBPACK_IMPORTED_MODULE_7__["default"](), new _matchers_StringMatcher__WEBPACK_IMPORTED_MODULE_3__["default"]() // last in list to take precedence over NumericMatcher
    ];
    converter = new _externals_xml2json__WEBPACK_IMPORTED_MODULE_2__["default"]({
      escapeMode: false,
      attributePrefix: '',
      arrayAccessForm: 'property',
      emptyNodeForm: 'object',
      stripWhitespaces: false,
      enableToStringFunc: true,
      ignoreRoot: false,
      matchers: matchers
    });
    objectIron = (0,_objectiron__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      adaptationset: new _maps_RepresentationBaseValuesMap__WEBPACK_IMPORTED_MODULE_8__["default"](),
      period: new _maps_SegmentValuesMap__WEBPACK_IMPORTED_MODULE_9__["default"]()
    });
  }

  function getMatchers() {
    return matchers;
  }

  function getIron() {
    return objectIron;
  }

  function parse(data) {
    var manifest;
    var startTime = window.performance.now();
    manifest = converter.xml_str2json(data);

    if (!manifest) {
      throw new Error('parsing the manifest failed');
    }

    var jsonTime = window.performance.now(); // handle full MPD and Patch ironing separately

    if (manifest.Patch) {
      manifest = manifest.Patch; // drop root reference
      // apply iron to patch operations individually

      if (manifest.add_asArray) {
        manifest.add_asArray.forEach(function (operand) {
          return objectIron.run(operand);
        });
      }

      if (manifest.replace_asArray) {
        manifest.replace_asArray.forEach(function (operand) {
          return objectIron.run(operand);
        });
      } // note that we don't need to iron remove as they contain no children

    } else {
      manifest = manifest.MPD; // drop root reference

      objectIron.run(manifest);
    }

    var ironedTime = window.performance.now();
    logger.info('Parsing complete: ( xml2json: ' + (jsonTime - startTime).toPrecision(3) + 'ms, objectiron: ' + (ironedTime - jsonTime).toPrecision(3) + 'ms, total: ' + ((ironedTime - startTime) / 1000).toPrecision(3) + 's)');
    manifest.protocol = 'DASH';
    return manifest;
  }

  instance = {
    parse: parse,
    getMatchers: getMatchers,
    getIron: getIron
  };
  setup();
  return instance;
}

DashParser.__dashjs_factory_name = 'DashParser';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(DashParser));

/***/ }),

/***/ "./src/dash/parser/maps/CommonProperty.js":
/*!************************************************!*\
  !*** ./src/dash/parser/maps/CommonProperty.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a property belonging to a MapNode
 * @ignore
 */
var CommonProperty = /*#__PURE__*/function () {
  function CommonProperty(name) {
    _classCallCheck(this, CommonProperty);

    var getDefaultMergeForName = function getDefaultMergeForName(n) {
      return n && n.length && n.charAt(0) === n.charAt(0).toUpperCase();
    };

    this._name = name;
    this._merge = getDefaultMergeForName(name);
  }

  _createClass(CommonProperty, [{
    key: "name",
    get: function get() {
      return this._name;
    }
  }, {
    key: "merge",
    get: function get() {
      return this._merge;
    }
  }]);

  return CommonProperty;
}();

/* harmony default export */ __webpack_exports__["default"] = (CommonProperty);

/***/ }),

/***/ "./src/dash/parser/maps/MapNode.js":
/*!*****************************************!*\
  !*** ./src/dash/parser/maps/MapNode.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _CommonProperty__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./CommonProperty */ "./src/dash/parser/maps/CommonProperty.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a node at some level in a ValueMap
 */


var MapNode = /*#__PURE__*/function () {
  function MapNode(name, properties, children) {
    var _this = this;

    _classCallCheck(this, MapNode);

    this._name = name || '';
    this._properties = [];
    this._children = children || [];

    if (Array.isArray(properties)) {
      properties.forEach(function (p) {
        _this._properties.push(new _CommonProperty__WEBPACK_IMPORTED_MODULE_0__["default"](p));
      });
    }
  }

  _createClass(MapNode, [{
    key: "name",
    get: function get() {
      return this._name;
    }
  }, {
    key: "children",
    get: function get() {
      return this._children;
    }
  }, {
    key: "properties",
    get: function get() {
      return this._properties;
    }
  }]);

  return MapNode;
}();

/* harmony default export */ __webpack_exports__["default"] = (MapNode);

/***/ }),

/***/ "./src/dash/parser/maps/RepresentationBaseValuesMap.js":
/*!*************************************************************!*\
  !*** ./src/dash/parser/maps/RepresentationBaseValuesMap.js ***!
  \*************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MapNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a RepresentationBaseValuesMap type for input to objectiron
 */



var RepresentationBaseValuesMap = /*#__PURE__*/function (_MapNode) {
  _inherits(RepresentationBaseValuesMap, _MapNode);

  var _super = _createSuper(RepresentationBaseValuesMap);

  function RepresentationBaseValuesMap() {
    _classCallCheck(this, RepresentationBaseValuesMap);

    var commonProperties = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].WIDTH, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].HEIGHT, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SAR, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAMERATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_SAMPLING_RATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAXIMUM_SAP_PERIOD, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].START_WITH_SAP, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MAX_PLAYOUT_RATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODING_DEPENDENCY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SCAN_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAME_PACKING, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY + '_asArray', _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM];
    return _super.call(this, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUB_REPRESENTATION, commonProperties)])]);
  }

  return RepresentationBaseValuesMap;
}(_MapNode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (RepresentationBaseValuesMap);

/***/ }),

/***/ "./src/dash/parser/maps/SegmentValuesMap.js":
/*!**************************************************!*\
  !*** ./src/dash/parser/maps/SegmentValuesMap.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MapNode__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MapNode */ "./src/dash/parser/maps/MapNode.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a SegmentValuesMap type for input to objectiron
 */



var SegmentValuesMap = /*#__PURE__*/function (_MapNode) {
  _inherits(SegmentValuesMap, _MapNode);

  var _super = _createSuper(SegmentValuesMap);

  function SegmentValuesMap() {
    _classCallCheck(this, SegmentValuesMap);

    var commonProperties = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST];
    return _super.call(this, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, commonProperties, [new _MapNode__WEBPACK_IMPORTED_MODULE_0__["default"](_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, commonProperties)])]);
  }

  return SegmentValuesMap;
}(_MapNode__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (SegmentValuesMap);

/***/ }),

/***/ "./src/dash/parser/matchers/BaseMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/BaseMatcher.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc a base type for matching and converting types in manifest to
 * something more useful
 * @ignore
 */
var BaseMatcher = /*#__PURE__*/function () {
  function BaseMatcher(test, converter) {
    _classCallCheck(this, BaseMatcher);

    this._test = test;
    this._converter = converter;
  }

  _createClass(BaseMatcher, [{
    key: "test",
    get: function get() {
      return this._test;
    }
  }, {
    key: "converter",
    get: function get() {
      return this._converter;
    }
  }]);

  return BaseMatcher;
}();

/* harmony default export */ __webpack_exports__["default"] = (BaseMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DateTimeMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DateTimeMatcher.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc matches and converts xs:datetime to Date
 */

var SECONDS_IN_MIN = 60;
var MINUTES_IN_HOUR = 60;
var MILLISECONDS_IN_SECONDS = 1000;
var datetimeRegex = /^([0-9]{4})-([0-9]{2})-([0-9]{2})T([0-9]{2}):([0-9]{2})(?::([0-9]*)(\.[0-9]*)?)?(?:([+-])([0-9]{2})(?::?)([0-9]{2}))?/;

var DateTimeMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(DateTimeMatcher, _BaseMatcher);

  var _super = _createSuper(DateTimeMatcher);

  function DateTimeMatcher() {
    _classCallCheck(this, DateTimeMatcher);

    return _super.call(this, function (attr) {
      return datetimeRegex.test(attr.value);
    }, function (str) {
      var match = datetimeRegex.exec(str);
      var utcDate; // If the string does not contain a timezone offset different browsers can interpret it either
      // as UTC or as a local time so we have to parse the string manually to normalize the given date value for
      // all browsers

      utcDate = Date.UTC(parseInt(match[1], 10), parseInt(match[2], 10) - 1, // months start from zero
      parseInt(match[3], 10), parseInt(match[4], 10), parseInt(match[5], 10), match[6] && parseInt(match[6], 10) || 0, match[7] && parseFloat(match[7]) * MILLISECONDS_IN_SECONDS || 0); // If the date has timezone offset take it into account as well

      if (match[9] && match[10]) {
        var timezoneOffset = parseInt(match[9], 10) * MINUTES_IN_HOUR + parseInt(match[10], 10);
        utcDate += (match[8] === '+' ? -1 : +1) * timezoneOffset * SECONDS_IN_MIN * MILLISECONDS_IN_SECONDS;
      }

      return new Date(utcDate);
    });
  }

  return DateTimeMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (DateTimeMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/DurationMatcher.js":
/*!*****************************************************!*\
  !*** ./src/dash/parser/matchers/DurationMatcher.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc matches and converts xs:duration to seconds
 */



var durationRegex = /^([-])?P(([\d.]*)Y)?(([\d.]*)M)?(([\d.]*)D)?T?(([\d.]*)H)?(([\d.]*)M)?(([\d.]*)S)?/;
var SECONDS_IN_YEAR = 365 * 24 * 60 * 60;
var SECONDS_IN_MONTH = 30 * 24 * 60 * 60;
var SECONDS_IN_DAY = 24 * 60 * 60;
var SECONDS_IN_HOUR = 60 * 60;
var SECONDS_IN_MIN = 60;

var DurationMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(DurationMatcher, _BaseMatcher);

  var _super = _createSuper(DurationMatcher);

  function DurationMatcher() {
    _classCallCheck(this, DurationMatcher);

    return _super.call(this, function (attr) {
      var attributeList = [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MIN_BUFFER_TIME, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MEDIA_PRESENTATION_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MINIMUM_UPDATE_PERIOD, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].TIMESHIFT_BUFFER_DEPTH, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SEGMENT_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].MAX_SUBSEGMENT_DURATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].SUGGESTED_PRESENTATION_DELAY, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].START, _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].START_TIME, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"].DURATION];
      var len = attributeList.length;

      for (var i = 0; i < len; i++) {
        if (attr.nodeName === attributeList[i]) {
          return durationRegex.test(attr.value);
        }
      }

      return false;
    }, function (str) {
      //str = "P10Y10M10DT10H10M10.1S";
      var match = durationRegex.exec(str);
      var result = parseFloat(match[3] || 0) * SECONDS_IN_YEAR + parseFloat(match[5] || 0) * SECONDS_IN_MONTH + parseFloat(match[7] || 0) * SECONDS_IN_DAY + parseFloat(match[9] || 0) * SECONDS_IN_HOUR + parseFloat(match[11] || 0) * SECONDS_IN_MIN + parseFloat(match[13] || 0);

      if (match[1] !== undefined) {
        result = -result;
      }

      return result;
    });
  }

  return DurationMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (DurationMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/LangMatcher.js":
/*!*************************************************!*\
  !*** ./src/dash/parser/matchers/LangMatcher.js ***!
  \*************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bcp-47-normalize */ "./node_modules/bcp-47-normalize/index.js");
/* harmony import */ var bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2__);
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts any ISO 639 language tag to BCP-47 language tags
 */




var LangMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(LangMatcher, _BaseMatcher);

  var _super = _createSuper(LangMatcher);

  function LangMatcher() {
    _classCallCheck(this, LangMatcher);

    return _super.call(this, function (attr, nodeName) {
      var _stringAttrsInElement;

      var stringAttrsInElements = (_stringAttrsInElement = {}, _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LABEL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].GROUP_LABEL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].LANG]), _stringAttrsInElement);

      if (stringAttrsInElements.hasOwnProperty(nodeName)) {
        var attrNames = stringAttrsInElements[nodeName];

        if (attrNames !== undefined) {
          return attrNames.indexOf(attr.name) >= 0;
        } else {
          return false;
        }
      }

      return false;
    }, function (str) {
      var lang = bcp_47_normalize__WEBPACK_IMPORTED_MODULE_2___default()(str);

      if (lang) {
        return lang;
      }

      return String(str);
    });
  }

  return LangMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (LangMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/NumericMatcher.js":
/*!****************************************************!*\
  !*** ./src/dash/parser/matchers/NumericMatcher.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts xs:numeric to float
 */

var numericRegex = /^[-+]?[0-9]+[.]?[0-9]*([eE][-+]?[0-9]+)?$/;

var NumericMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(NumericMatcher, _BaseMatcher);

  var _super = _createSuper(NumericMatcher);

  function NumericMatcher() {
    _classCallCheck(this, NumericMatcher);

    return _super.call(this, function (attr) {
      return numericRegex.test(attr.value);
    }, function (str) {
      return parseFloat(str);
    });
  }

  return NumericMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (NumericMatcher);

/***/ }),

/***/ "./src/dash/parser/matchers/StringMatcher.js":
/*!***************************************************!*\
  !*** ./src/dash/parser/matchers/StringMatcher.js ***!
  \***************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _BaseMatcher__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BaseMatcher */ "./src/dash/parser/matchers/BaseMatcher.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @classdesc Matches and converts xs:string to string, but only for specific attributes on specific nodes
 */



var StringMatcher = /*#__PURE__*/function (_BaseMatcher) {
  _inherits(StringMatcher, _BaseMatcher);

  var _super = _createSuper(StringMatcher);

  function StringMatcher() {
    _classCallCheck(this, StringMatcher);

    return _super.call(this, function (attr, nodeName) {
      var _stringAttrsInElement;

      var stringAttrsInElements = (_stringAttrsInElement = {}, _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MPD, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PERIOD, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BASE_URL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SERVICE_LOCATION, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BYTE_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_BASE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION_INDEX, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_LIST, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BITSTREAM_SWITCHING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_URL, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_RANGE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TEMPLATE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX_RANGE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INDEX, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INITIALIZATION_MINUS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].BITSTREAM_SWITCHING_MINUS]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ASSET_IDENTIFIER, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].EVENT_STREAM, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ADAPTATION_SET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MIME_TYPE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_PROFILES, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CODECS, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_TYPE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].FRAME_PACKING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO_CHANNEL_CONFIGURATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_PROTECTION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ESSENTIAL_PROPERTY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUPPLEMENTAL_PROPERTY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].INBAND_EVENT_STREAM, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ACCESSIBILITY, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ROLE, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].RATING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VIEWPOINT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_COMPONENT, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].CONTENT_TYPE]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPRESENTATION, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].DEPENDENCY_ID, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].MEDIA_STREAM_STRUCTURE_ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SUBSET, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].METRICS, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].METRICS_MINUS]), _defineProperty(_stringAttrsInElement, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].REPORTING, [_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].VALUE, _constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].ID]), _stringAttrsInElement);

      if (stringAttrsInElements.hasOwnProperty(nodeName)) {
        var attrNames = stringAttrsInElements[nodeName];

        if (attrNames !== undefined) {
          return attrNames.indexOf(attr.name) >= 0;
        } else {
          return false;
        }
      }

      return false;
    }, function (str) {
      return String(str);
    });
  }

  return StringMatcher;
}(_BaseMatcher__WEBPACK_IMPORTED_MODULE_0__["default"]);

/* harmony default export */ __webpack_exports__["default"] = (StringMatcher);

/***/ }),

/***/ "./src/dash/parser/objectiron.js":
/*!***************************************!*\
  !*** ./src/dash/parser/objectiron.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function ObjectIron(mappers) {
  function mergeValues(parentItem, childItem) {
    for (var name in parentItem) {
      if (!childItem.hasOwnProperty(name)) {
        childItem[name] = parentItem[name];
      }
    }
  }

  function mapProperties(properties, parent, child) {
    for (var i = 0, len = properties.length; i < len; ++i) {
      var property = properties[i];

      if (parent[property.name]) {
        if (child[property.name]) {
          // check to see if we should merge
          if (property.merge) {
            var parentValue = parent[property.name];
            var childValue = child[property.name]; // complex objects; merge properties

            if (_typeof(parentValue) === 'object' && _typeof(childValue) === 'object') {
              mergeValues(parentValue, childValue);
            } // simple objects; merge them together
            else {
              child[property.name] = parentValue + childValue;
            }
          }
        } else {
          // just add the property
          child[property.name] = parent[property.name];
        }
      }
    }
  }

  function mapItem(item, node) {
    for (var i = 0, len = item.children.length; i < len; ++i) {
      var childItem = item.children[i];
      var array = node[childItem.name + '_asArray'];

      if (array) {
        for (var v = 0, len2 = array.length; v < len2; ++v) {
          var childNode = array[v];
          mapProperties(item.properties, node, childNode);
          mapItem(childItem, childNode);
        }
      }
    }
  }

  function run(source) {
    if (source === null || _typeof(source) !== 'object') {
      return source;
    }

    if (source.Period_asArray && 'period' in mappers) {
      var periodMapper = mappers.period;
      var periods = source.Period_asArray;

      for (var i = 0, len = periods.length; i < len; ++i) {
        var period = periods[i];
        mapItem(periodMapper, period);

        if ('adaptationset' in mappers) {
          var adaptationSets = period.AdaptationSet_asArray;

          if (adaptationSets) {
            var adaptationSetMapper = mappers.adaptationset;

            for (var _i = 0, _len = adaptationSets.length; _i < _len; ++_i) {
              mapItem(adaptationSetMapper, adaptationSets[_i]);
            }
          }
        }
      }
    }

    return source;
  }

  return {
    run: run
  };
}

ObjectIron.__dashjs_factory_name = 'ObjectIron';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ObjectIron);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/ListSegmentsGetter.js":
/*!**********************************************!*\
  !*** ./src/dash/utils/ListSegmentsGetter.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function ListSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation) {
      return mediaFinishedInformation;
    }

    var list = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    var offset = Math.max(startNumber - 1, 0);
    mediaFinishedInformation.numberOfSegments = offset + list.SegmentURL_asArray.length;
    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var list = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var len = list.SegmentURL_asArray.length;
    var startNumber = representation && !isNaN(representation.startNumber) ? representation.startNumber : 1;
    var offsetToSubtract = Math.max(startNumber - 1, 0);
    var relativeIndex = Math.max(index - offsetToSubtract, 0);
    var segment = null;

    if (relativeIndex < len) {
      var s = list.SegmentURL_asArray[relativeIndex];
      segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getIndexBasedSegment)(timelineConverter, isDynamic, representation, index);

      if (segment) {
        segment.replacementTime = (startNumber + index - 1) * representation.segmentDuration;
        segment.media = s.media ? s.media : '';
        segment.mediaRange = s.mediaRange;
        segment.indexRange = s.indexRange;
      }
    }

    return segment;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      return null;
    }

    var periodTime = timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation, requestedTime);
    var index = Math.floor(periodTime / duration);
    return getSegmentByIndex(representation, index);
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

ListSegmentsGetter.__dashjs_factory_name = 'ListSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(ListSegmentsGetter);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/Round10.js":
/*!***********************************!*\
  !*** ./src/dash/utils/Round10.js ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": function() { return /* binding */ Round10; }
/* harmony export */ });
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Static methods for rounding decimals
 *
 * Modified version of the CC0-licenced example at:
 * https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Math/round
 *
 * @export
 * @class Round10
 * @ignore
 */
var Round10 = /*#__PURE__*/function () {
  function Round10() {
    _classCallCheck(this, Round10);
  }

  _createClass(Round10, null, [{
    key: "round10",
    value:
    /**
    * Decimal round.
    *
    * @param {Number}  value The number.
    * @param {Integer} exp   The exponent (the 10 logarithm of the adjustment base).
    * @returns {Number} The adjusted value.
    * @ignore
    */
    function round10(value, exp) {
      return _decimalAdjust('round', value, exp);
    }
  }]);

  return Round10;
}();
/**
 * Decimal adjustment of a number.
 *
 * @param {String}  type  The type of adjustment.
 * @param {Number}  value The number.
 * @param {Integer} exp   The exponent (the 10 logarithm of the adjustment base).
 * @returns {Number} The adjusted value.
 * @ignore
 */




function _decimalAdjust(type, value, exp) {
  // If the exp is undefined or zero...
  if (typeof exp === 'undefined' || +exp === 0) {
    return Math[type](value);
  }

  value = +value;
  exp = +exp; // If the value is not a number or the exp is not an integer...

  if (value === null || isNaN(value) || !(typeof exp === 'number' && exp % 1 === 0)) {
    return NaN;
  } // Shift


  value = value.toString().split('e');
  value = Math[type](+(value[0] + 'e' + (value[1] ? +value[1] - exp : -exp))); // Shift back

  value = value.toString().split('e');
  return +(value[0] + 'e' + (value[1] ? +value[1] + exp : exp));
}

/***/ }),

/***/ "./src/dash/utils/SegmentBaseGetter.js":
/*!*********************************************!*\
  !*** ./src/dash/utils/SegmentBaseGetter.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */



function SegmentBaseGetter(config) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation || !representation.segments) {
      return mediaFinishedInformation;
    }

    mediaFinishedInformation.numberOfSegments = representation.segments.length;
    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var len = representation.segments ? representation.segments.length : -1;
    var seg;

    if (index < len) {
      seg = representation.segments[index];

      if (seg && seg.index === index) {
        return seg;
      }
    }

    for (var i = 0; i < len; i++) {
      seg = representation.segments[i];

      if (seg && seg.index === index) {
        return seg;
      }
    }

    return null;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();
    var index = getIndexByTime(representation, requestedTime);
    return getSegmentByIndex(representation, index);
  }

  function getIndexByTime(representation, time) {
    if (!representation) {
      return -1;
    }

    var segments = representation.segments;
    var ln = segments ? segments.length : null;
    var idx = -1;
    var epsilon, seg, ft, fd, i;

    if (segments && ln > 0) {
      for (i = 0; i < ln; i++) {
        seg = segments[i];
        ft = seg.presentationStartTime;
        fd = seg.duration;
        epsilon = fd / 2;

        if (time + epsilon >= ft && time - epsilon < ft + fd) {
          idx = seg.index;
          break;
        }
      }
    }

    return idx;
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

SegmentBaseGetter.__dashjs_factory_name = 'SegmentBaseGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(SegmentBaseGetter);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/SegmentsUtils.js":
/*!*****************************************!*\
  !*** ./src/dash/utils/SegmentsUtils.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "getIndexBasedSegment": function() { return /* binding */ getIndexBasedSegment; },
/* harmony export */   "getTimeBasedSegment": function() { return /* binding */ getTimeBasedSegment; },
/* harmony export */   "replaceIDForTemplate": function() { return /* binding */ replaceIDForTemplate; },
/* harmony export */   "replaceTokenForTemplate": function() { return /* binding */ replaceTokenForTemplate; },
/* harmony export */   "unescapeDollarsInTemplate": function() { return /* binding */ unescapeDollarsInTemplate; }
/* harmony export */ });
/* harmony import */ var _vo_Segment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./../vo/Segment */ "./src/dash/vo/Segment.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


function zeroPadToLength(numStr, minStrLength) {
  while (numStr.length < minStrLength) {
    numStr = '0' + numStr;
  }

  return numStr;
}

function getNumberForSegment(segment, segmentIndex) {
  return segment.representation.startNumber + segmentIndex;
}

function unescapeDollarsInTemplate(url) {
  return url ? url.split('$$').join('$') : url;
}
function replaceIDForTemplate(url, value) {
  if (!value || !url || url.indexOf('$RepresentationID$') === -1) {
    return url;
  }

  var v = value.toString();
  return url.split('$RepresentationID$').join(v);
}
function replaceTokenForTemplate(url, token, value) {
  var formatTag = '%0';
  var startPos, endPos, formatTagPos, specifier, width, paddedValue;
  var tokenLen = token.length;
  var formatTagLen = formatTag.length;

  if (!url) {
    return url;
  } // keep looping round until all instances of <token> have been
  // replaced. once that has happened, startPos below will be -1
  // and the completed url will be returned.


  while (true) {
    // check if there is a valid $<token>...$ identifier
    // if not, return the url as is.
    startPos = url.indexOf('$' + token);

    if (startPos < 0) {
      return url;
    } // the next '$' must be the end of the identifier
    // if there isn't one, return the url as is.


    endPos = url.indexOf('$', startPos + tokenLen);

    if (endPos < 0) {
      return url;
    } // now see if there is an additional format tag suffixed to
    // the identifier within the enclosing '$' characters


    formatTagPos = url.indexOf(formatTag, startPos + tokenLen);

    if (formatTagPos > startPos && formatTagPos < endPos) {
      specifier = url.charAt(endPos - 1);
      width = parseInt(url.substring(formatTagPos + formatTagLen, endPos - 1), 10); // support the minimum specifiers required by IEEE 1003.1
      // (d, i , o, u, x, and X) for completeness

      switch (specifier) {
        // treat all int types as uint,
        // hence deliberate fallthrough
        case 'd':
        case 'i':
        case 'u':
          paddedValue = zeroPadToLength(value.toString(), width);
          break;

        case 'x':
          paddedValue = zeroPadToLength(value.toString(16), width);
          break;

        case 'X':
          paddedValue = zeroPadToLength(value.toString(16), width).toUpperCase();
          break;

        case 'o':
          paddedValue = zeroPadToLength(value.toString(8), width);
          break;

        default:
          return url;
      }
    } else {
      paddedValue = value;
    }

    url = url.substring(0, startPos) + paddedValue + url.substring(endPos + 1);
  }
}

function getSegment(representation, duration, presentationStartTime, mediaStartTime, timelineConverter, presentationEndTime, isDynamic, index) {
  var seg = new _vo_Segment__WEBPACK_IMPORTED_MODULE_0__["default"]();
  seg.representation = representation;
  seg.duration = duration;
  seg.presentationStartTime = presentationStartTime;
  seg.mediaStartTime = mediaStartTime;
  seg.availabilityStartTime = timelineConverter.calcAvailabilityStartTimeFromPresentationTime(presentationEndTime, representation, isDynamic);
  seg.availabilityEndTime = timelineConverter.calcAvailabilityEndTimeFromPresentationTime(presentationEndTime + duration, representation, isDynamic);
  seg.wallStartTime = timelineConverter.calcWallTimeForSegment(seg, isDynamic);
  seg.replacementNumber = getNumberForSegment(seg, index);
  seg.index = index;
  return seg;
}

function isSegmentAvailable(timelineConverter, representation, segment, isDynamic) {
  var voPeriod = representation.adaptation.period; // Avoid requesting segments that overlap the period boundary

  if (isFinite(voPeriod.duration) && voPeriod.start + voPeriod.duration <= segment.presentationStartTime) {
    return false;
  }

  if (isDynamic) {
    if (representation.availabilityTimeOffset === 'INF') {
      return true;
    } // For dynamic manifests we check if the presentation start time + duration is included in the availability window
    // SAST = Period@start + seg@presentationStartTime + seg@duration
    // ASAST = SAST - ATO
    // SAET = SAST + TSBD + seg@duration
    // refTime serves as an anchor time to compare the availability time of the segments against.


    var refTime = timelineConverter.getClientReferenceTime();
    return segment.availabilityStartTime.getTime() <= refTime && (!isFinite(segment.availabilityEndTime) || segment.availabilityEndTime.getTime() >= refTime);
  }

  return true;
}

function getIndexBasedSegment(timelineConverter, isDynamic, representation, index) {
  var duration, presentationStartTime, presentationEndTime;
  duration = representation.segmentDuration;
  /*
   * From spec - If neither @duration attribute nor SegmentTimeline element is present, then the Representation
   * shall contain exactly one Media Segment. The MPD start time is 0 and the MPD duration is obtained
   * in the same way as for the last Media Segment in the Representation.
   */

  if (isNaN(duration)) {
    duration = representation.adaptation.period.duration;
  }

  presentationStartTime = parseFloat((representation.adaptation.period.start + index * duration).toFixed(5));
  presentationEndTime = parseFloat((presentationStartTime + duration).toFixed(5));
  var mediaTime = timelineConverter.calcMediaTimeFromPresentationTime(presentationStartTime, representation);
  var segment = getSegment(representation, duration, presentationStartTime, mediaTime, timelineConverter, presentationEndTime, isDynamic, index);

  if (!isSegmentAvailable(timelineConverter, representation, segment, isDynamic)) {
    return null;
  }

  return segment;
}
function getTimeBasedSegment(timelineConverter, isDynamic, representation, time, duration, fTimescale, url, range, index, tManifest) {
  var scaledTime = time / fTimescale;
  var scaledDuration = duration / fTimescale;
  var presentationStartTime, presentationEndTime, seg;
  presentationStartTime = timelineConverter.calcPresentationTimeFromMediaTime(scaledTime, representation);
  presentationEndTime = presentationStartTime + scaledDuration;
  seg = getSegment(representation, scaledDuration, presentationStartTime, scaledTime, timelineConverter, presentationEndTime, isDynamic, index);

  if (!isSegmentAvailable(timelineConverter, representation, seg, isDynamic)) {
    return null;
  }

  seg.replacementTime = tManifest ? tManifest : time;
  url = replaceTokenForTemplate(url, 'Number', seg.replacementNumber);
  url = replaceTokenForTemplate(url, 'Time', seg.replacementTime);
  seg.media = url;
  seg.mediaRange = range;
  return seg;
}

/***/ }),

/***/ "./src/dash/utils/TemplateSegmentsGetter.js":
/*!**************************************************!*\
  !*** ./src/dash/utils/TemplateSegmentsGetter.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function TemplateSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var instance;

  function checkConfig() {
    if (!timelineConverter || !timelineConverter.hasOwnProperty('calcPeriodRelativeTimeFromMpdRelativeTime')) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    var mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };

    if (!representation) {
      return mediaFinishedInformation;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      mediaFinishedInformation.numberOfSegments = 1;
    } else {
      mediaFinishedInformation.numberOfSegments = Math.ceil(representation.adaptation.period.duration / duration);
    }

    return mediaFinishedInformation;
  }

  function getSegmentByIndex(representation, index) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var template = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate; // This is the index without @startNumber

    index = Math.max(index, 0);
    var seg = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getIndexBasedSegment)(timelineConverter, isDynamic, representation, index);

    if (seg) {
      seg.replacementTime = Math.round((index - 1) * representation.segmentDuration * representation.timescale, 10);
      var url = template.media;
      url = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.replaceTokenForTemplate)(url, 'Number', seg.replacementNumber);
      url = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.replaceTokenForTemplate)(url, 'Time', seg.replacementTime);
      seg.media = url;
    }

    return seg;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var duration = representation.segmentDuration;

    if (isNaN(duration)) {
      return null;
    } // Calculate the relative time for the requested time in this period


    var periodTime = timelineConverter.calcPeriodRelativeTimeFromMpdRelativeTime(representation, requestedTime);
    var index = Math.floor(periodTime / duration);
    return getSegmentByIndex(representation, index);
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

TemplateSegmentsGetter.__dashjs_factory_name = 'TemplateSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(TemplateSegmentsGetter);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/utils/TimelineConverter.js":
/*!*********************************************!*\
  !*** ./src/dash/utils/TimelineConverter.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _models_DashManifestModel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/DashManifestModel */ "./src/dash/models/DashManifestModel.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _streaming_constants_ConformanceViolationConstants__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../streaming/constants/ConformanceViolationConstants */ "./src/streaming/constants/ConformanceViolationConstants.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */










function TimelineConverter() {
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  var instance, dashManifestModel, timelineAnchorAvailabilityOffset, // In case we calculate the TSBD using _calcTimeShiftBufferWindowForDynamicTimelineManifest we use the segments as anchor times. We apply this offset when calculating if a segment is available or not.
  clientServerTimeShift;

  function setup() {
    dashManifestModel = (0,_models_DashManifestModel__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
    reset();
  }

  function initialize() {
    resetInitialSettings();
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].UPDATE_TIME_SYNC_OFFSET, _onUpdateTimeSyncOffset, this);
  }

  function getClientTimeOffset() {
    return clientServerTimeShift;
  }

  function setClientTimeOffset(value) {
    clientServerTimeShift = value;
  }
  /**
   * Returns a "now" reference time for the client to compare the availability time of a segment against.
   * Takes the client/server drift into account
   */


  function getClientReferenceTime() {
    return Date.now() - timelineAnchorAvailabilityOffset * 1000 + clientServerTimeShift * 1000;
  }

  function _calcAvailabilityTimeFromPresentationTime(presentationEndTime, representation, isDynamic, calculateAvailabilityEndTime) {
    var availabilityTime;
    var mpd = representation.adaptation.period.mpd;
    var availabilityStartTime = mpd.availabilityStartTime;

    if (calculateAvailabilityEndTime) {
      //@timeShiftBufferDepth specifies the duration of the time shifting buffer that is guaranteed
      // to be available for a Media Presentation with type 'dynamic'.
      // When not present, the value is infinite.
      if (isDynamic && mpd.timeShiftBufferDepth !== Number.POSITIVE_INFINITY) {
        // SAET = SAST + TSBD + seg@duration
        availabilityTime = new Date(availabilityStartTime.getTime() + (presentationEndTime + mpd.timeShiftBufferDepth) * 1000);
      } else {
        availabilityTime = mpd.availabilityEndTime;
      }
    } else {
      if (isDynamic) {
        // SAST = Period@start + seg@presentationStartTime + seg@duration
        // ASAST = SAST - ATO
        var availabilityTimeOffset = representation.availabilityTimeOffset; // presentationEndTime = Period@start + seg@presentationStartTime + Segment@duration

        availabilityTime = new Date(availabilityStartTime.getTime() + (presentationEndTime - availabilityTimeOffset) * 1000);
      } else {
        // in static mpd, all segments are available at the same time
        availabilityTime = availabilityStartTime;
      }
    }

    return availabilityTime;
  }

  function calcAvailabilityStartTimeFromPresentationTime(presentationEndTime, representation, isDynamic) {
    return _calcAvailabilityTimeFromPresentationTime(presentationEndTime, representation, isDynamic);
  }

  function calcAvailabilityEndTimeFromPresentationTime(presentationEndTime, representation, isDynamic) {
    return _calcAvailabilityTimeFromPresentationTime(presentationEndTime, representation, isDynamic, true);
  }

  function calcPresentationTimeFromWallTime(wallTime, period) {
    return (wallTime.getTime() - period.mpd.availabilityStartTime.getTime() + clientServerTimeShift * 1000) / 1000;
  }

  function calcPresentationTimeFromMediaTime(mediaTime, representation) {
    var periodStart = representation.adaptation.period.start;
    var presentationOffset = representation.presentationTimeOffset;
    return mediaTime + (periodStart - presentationOffset);
  }

  function calcMediaTimeFromPresentationTime(presentationTime, representation) {
    var periodStart = representation.adaptation.period.start;
    var presentationOffset = representation.presentationTimeOffset;
    return presentationTime - periodStart + presentationOffset;
  }

  function calcWallTimeForSegment(segment, isDynamic) {
    var suggestedPresentationDelay, displayStartTime, wallTime;

    if (isDynamic) {
      suggestedPresentationDelay = segment.representation.adaptation.period.mpd.suggestedPresentationDelay;
      displayStartTime = segment.presentationStartTime + suggestedPresentationDelay;
      wallTime = new Date(segment.availabilityStartTime.getTime() + displayStartTime * 1000);
    }

    return wallTime;
  }
  /**
   * Calculates the timeshiftbuffer range. This range might overlap multiple periods and is not limited to period boundaries. However, we make sure that the range is potentially covered by period.
   * @param {Array} streams
   * @param {boolean} isDynamic
   * @return {}
   */


  function calcTimeShiftBufferWindow(streams, isDynamic) {
    // Static manifests. The availability window is equal to the DVR window
    if (!isDynamic) {
      return _calcTimeshiftBufferForStaticManifest(streams);
    } // Specific use case of SegmentTimeline


    if (settings.get().streaming.timeShiftBuffer.calcFromSegmentTimeline) {
      var data = _calcTimeShiftBufferWindowForDynamicTimelineManifest(streams);

      _adjustTimelineAnchorAvailabilityOffset(data.now, data.range);

      return data.range;
    }

    return _calcTimeShiftBufferWindowForDynamicManifest(streams);
  }

  function _calcTimeshiftBufferForStaticManifest(streams) {
    // Static Range Finder. We iterate over all periods and return the total duration
    var range = {
      start: NaN,
      end: NaN
    };
    var duration = 0;
    var start = NaN;
    streams.forEach(function (stream) {
      var streamInfo = stream.getStreamInfo();
      duration += streamInfo.duration;

      if (isNaN(start) || streamInfo.start < start) {
        start = streamInfo.start;
      }
    });
    range.start = start;
    range.end = start + duration;
    return range;
  }

  function _calcTimeShiftBufferWindowForDynamicManifest(streams) {
    var range = {
      start: NaN,
      end: NaN
    };

    if (!streams || streams.length === 0) {
      return range;
    }

    var voPeriod = streams[0].getAdapter().getRegularPeriods()[0];
    var now = calcPresentationTimeFromWallTime(new Date(), voPeriod);
    var timeShiftBufferDepth = voPeriod.mpd.timeShiftBufferDepth;
    var start = !isNaN(timeShiftBufferDepth) ? now - timeShiftBufferDepth : 0; // check if we find a suitable period for that starttime. Otherwise we use the time closest to that

    range.start = _adjustTimeBasedOnPeriodRanges(streams, start);
    range.end = !isNaN(range.start) && now < range.start ? now : _adjustTimeBasedOnPeriodRanges(streams, now, true);

    if (!isNaN(timeShiftBufferDepth) && range.end < now - timeShiftBufferDepth) {
      range.end = NaN;
    } // If we have SegmentTimeline as a reference we can verify that the calculated DVR window is at least partially included in the DVR window exposed by the timeline.
    // If that is not the case we stick to the DVR window defined by SegmentTimeline


    if (settings.get().streaming.timeShiftBuffer.fallbackToSegmentTimeline) {
      var timelineRefData = _calcTimeShiftBufferWindowForDynamicTimelineManifest(streams);

      if (timelineRefData.range.end < range.start) {
        eventBus.trigger(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_7__["default"].CONFORMANCE_VIOLATION, {
          level: _streaming_constants_ConformanceViolationConstants__WEBPACK_IMPORTED_MODULE_8__["default"].LEVELS.WARNING,
          event: _streaming_constants_ConformanceViolationConstants__WEBPACK_IMPORTED_MODULE_8__["default"].EVENTS.INVALID_DVR_WINDOW
        });

        _adjustTimelineAnchorAvailabilityOffset(timelineRefData.now, timelineRefData.range);

        return timelineRefData.range;
      }
    }

    return range;
  }

  function _calcTimeShiftBufferWindowForDynamicTimelineManifest(streams) {
    var range = {
      start: NaN,
      end: NaN
    };
    var voPeriod = streams[0].getAdapter().getRegularPeriods()[0];
    var now = calcPresentationTimeFromWallTime(new Date(), voPeriod);

    if (!streams || streams.length === 0) {
      return {
        range: range,
        now: now
      };
    }

    streams.forEach(function (stream) {
      var adapter = stream.getAdapter();
      var mediaInfo = adapter.getMediaInfoForType(stream.getStreamInfo(), _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].VIDEO) || adapter.getMediaInfoForType(stream.getStreamInfo(), _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_6__["default"].AUDIO);
      var voRepresentations = adapter.getVoRepresentations(mediaInfo);
      var voRepresentation = voRepresentations[0];
      var periodRange = {
        start: NaN,
        end: NaN
      };

      if (voRepresentation) {
        if (voRepresentation.segmentInfoType === _constants_DashConstants__WEBPACK_IMPORTED_MODULE_3__["default"].SEGMENT_TIMELINE) {
          periodRange = _calcRangeForTimeline(voRepresentation);
        } else {
          var currentVoPeriod = voRepresentation.adaptation.period;
          periodRange.start = currentVoPeriod.start;
          periodRange.end = Math.max(now, currentVoPeriod.start + currentVoPeriod.duration);
        }
      }

      if (!isNaN(periodRange.start) && (isNaN(range.start) || range.start > periodRange.start)) {
        range.start = periodRange.start;
      }

      if (!isNaN(periodRange.end) && (isNaN(range.end) || range.end < periodRange.end)) {
        range.end = periodRange.end;
      }
    });
    range.end = Math.min(now, range.end);

    var adjustedEndTime = _adjustTimeBasedOnPeriodRanges(streams, range.end, true); // if range is NaN all periods are in the future. we should return range.start > range.end in this case


    range.end = isNaN(adjustedEndTime) ? range.end : adjustedEndTime;
    range.start = voPeriod && voPeriod.mpd && voPeriod.mpd.timeShiftBufferDepth && !isNaN(voPeriod.mpd.timeShiftBufferDepth) && !isNaN(range.end) ? Math.max(range.end - voPeriod.mpd.timeShiftBufferDepth, range.start) : range.start;
    range.start = _adjustTimeBasedOnPeriodRanges(streams, range.start);
    return {
      range: range,
      now: now
    };
  }

  function _adjustTimelineAnchorAvailabilityOffset(now, range) {
    timelineAnchorAvailabilityOffset = now - range.end;
  }

  function _adjustTimeBasedOnPeriodRanges(streams, time) {
    var isEndOfDvrWindow = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    try {
      var i = 0;
      var found = false;
      var adjustedTime = NaN;

      while (!found && i < streams.length) {
        var streamInfo = streams[i].getStreamInfo(); // We found a period which contains the target time.

        if (streamInfo.start <= time && (!isFinite(streamInfo.duration) || streamInfo.start + streamInfo.duration >= time)) {
          adjustedTime = time;
          found = true;
        } // Adjust the time for the start of the DVR window. The current period starts after the target time. We use the starttime of this period as adjusted time
        else if (!isEndOfDvrWindow && streamInfo.start > time && (isNaN(adjustedTime) || streamInfo.start < adjustedTime)) {
          adjustedTime = streamInfo.start;
        } // Adjust the time for the end of the DVR window. The current period ends before the targettime. We use the end time of this period as the adjusted time
        else if (isEndOfDvrWindow && streamInfo.start + streamInfo.duration < time && (isNaN(adjustedTime) || streamInfo.start + streamInfo.duration > adjustedTime)) {
          adjustedTime = streamInfo.start + streamInfo.duration;
        }

        i += 1;
      }

      return adjustedTime;
    } catch (e) {
      return time;
    }
  }

  function _calcRangeForTimeline(voRepresentation) {
    var adaptation = voRepresentation.adaptation.period.mpd.manifest.Period_asArray[voRepresentation.adaptation.period.index].AdaptationSet_asArray[voRepresentation.adaptation.index];
    var representation = dashManifestModel.getRepresentationFor(voRepresentation.index, adaptation);
    var base = representation.SegmentTemplate || representation.SegmentList;
    var timeline = base.SegmentTimeline;
    var timescale = base.timescale;
    var segments = timeline.S_asArray;
    var range = {
      start: 0,
      end: 0
    };
    var segmentTime = segments[0].t;
    var hasValidSegmentTime = !isNaN(segmentTime);
    var enhancedSegmentTime = hasValidSegmentTime ? segmentTime : 0;
    var d = 0;
    var segment, repeat, i, len;

    if (hasValidSegmentTime) {
      range.start = calcPresentationTimeFromMediaTime(enhancedSegmentTime / timescale, voRepresentation);
    }

    for (i = 0, len = segments.length; i < len; i++) {
      segment = segments[i];
      repeat = 0;

      if (segment.hasOwnProperty('r')) {
        repeat = segment.r;
      }

      d += segment.d * (1 + repeat);
    }

    range.end = calcPresentationTimeFromMediaTime((enhancedSegmentTime + d) / timescale, voRepresentation);
    return range;
  }

  function calcPeriodRelativeTimeFromMpdRelativeTime(representation, mpdRelativeTime) {
    var periodStartTime = representation.adaptation.period.start;
    return mpdRelativeTime - periodStartTime;
  }

  function _onUpdateTimeSyncOffset(e) {
    if (e.offset !== undefined && !isNaN(e.offset)) {
      setClientTimeOffset(e.offset / 1000);
    }
  }

  function resetInitialSettings() {
    clientServerTimeShift = 0;
    timelineAnchorAvailabilityOffset = 0;
  }

  function reset() {
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].UPDATE_TIME_SYNC_OFFSET, _onUpdateTimeSyncOffset, this);
    resetInitialSettings();
  }

  instance = {
    initialize: initialize,
    getClientTimeOffset: getClientTimeOffset,
    setClientTimeOffset: setClientTimeOffset,
    getClientReferenceTime: getClientReferenceTime,
    calcAvailabilityStartTimeFromPresentationTime: calcAvailabilityStartTimeFromPresentationTime,
    calcAvailabilityEndTimeFromPresentationTime: calcAvailabilityEndTimeFromPresentationTime,
    calcPresentationTimeFromWallTime: calcPresentationTimeFromWallTime,
    calcPresentationTimeFromMediaTime: calcPresentationTimeFromMediaTime,
    calcPeriodRelativeTimeFromMpdRelativeTime: calcPeriodRelativeTimeFromMpdRelativeTime,
    calcMediaTimeFromPresentationTime: calcMediaTimeFromPresentationTime,
    calcWallTimeForSegment: calcWallTimeForSegment,
    calcTimeShiftBufferWindow: calcTimeShiftBufferWindow,
    reset: reset
  };
  setup();
  return instance;
}

TimelineConverter.__dashjs_factory_name = 'TimelineConverter';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getSingletonFactory(TimelineConverter));

/***/ }),

/***/ "./src/dash/utils/TimelineSegmentsGetter.js":
/*!**************************************************!*\
  !*** ./src/dash/utils/TimelineSegmentsGetter.js ***!
  \**************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../streaming/constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./SegmentsUtils */ "./src/dash/utils/SegmentsUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */




function TimelineSegmentsGetter(config, isDynamic) {
  config = config || {};
  var timelineConverter = config.timelineConverter;
  var dashMetrics = config.dashMetrics;
  var instance;

  function checkConfig() {
    if (!timelineConverter) {
      throw new Error(_streaming_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }

  function getMediaFinishedInformation(representation) {
    if (!representation) {
      return 0;
    }

    var base = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate || representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var timeline = base.SegmentTimeline;
    var time = 0;
    var scaledTime = 0;
    var availableSegments = 0;
    var fragments, frag, i, len, j, repeat, fTimescale;
    fTimescale = representation.timescale;
    fragments = timeline.S_asArray;
    len = fragments.length;

    for (i = 0; i < len; i++) {
      frag = fragments[i];
      repeat = 0;

      if (frag.hasOwnProperty('r')) {
        repeat = frag.r;
      } // For a repeated S element, t belongs only to the first segment


      if (frag.hasOwnProperty('t')) {
        time = frag.t;
        scaledTime = time / fTimescale;
      } // This is a special case: "A negative value of the @r attribute of the S element indicates that the duration indicated in @d attribute repeats until the start of the next S element, the end of the Period or until the
      // next MPD update."


      if (repeat < 0) {
        var nextFrag = fragments[i + 1];
        repeat = _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, scaledTime);
      }

      for (j = 0; j <= repeat; j++) {
        availableSegments++;
        time += frag.d;
        scaledTime = time / fTimescale;
      }
    } // We need to account for the index of the segments starting at 0. We subtract 1


    return {
      numberOfSegments: availableSegments,
      mediaTimeOfLastSignaledSegment: scaledTime
    };
  }

  function iterateSegments(representation, iterFunc) {
    var base = representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentTemplate || representation.adaptation.period.mpd.manifest.Period_asArray[representation.adaptation.period.index].AdaptationSet_asArray[representation.adaptation.index].Representation_asArray[representation.index].SegmentList;
    var timeline = base.SegmentTimeline;
    var list = base.SegmentURL_asArray;
    var time = 0;
    var relativeIdx = -1;
    var fragments, frag, i, len, j, repeat, fTimescale;
    fTimescale = representation.timescale;
    fragments = timeline.S_asArray;
    var breakIterator = false;

    for (i = 0, len = fragments.length; i < len && !breakIterator; i++) {
      frag = fragments[i];
      repeat = 0;

      if (frag.hasOwnProperty('r')) {
        repeat = frag.r;
      } // For a repeated S element, t belongs only to the first segment


      if (frag.hasOwnProperty('t')) {
        time = frag.t;
      } // This is a special case: "A negative value of the @r attribute of the S element indicates that the duration indicated in @d attribute repeats until the start of the next S element, the end of the Period or until the
      // next MPD update."


      if (repeat < 0) {
        var nextFrag = fragments[i + 1];
        repeat = _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, time / fTimescale);
      }

      for (j = 0; j <= repeat && !breakIterator; j++) {
        relativeIdx++;
        breakIterator = iterFunc(time, base, list, frag, fTimescale, relativeIdx, i);

        if (breakIterator) {
          representation.segmentDuration = frag.d / fTimescale;
        }

        time += frag.d;
      }
    }
  }

  function _calculateRepeatCountForNegativeR(representation, nextFrag, frag, fTimescale, scaledTime) {
    var repeatEndTime;

    if (nextFrag && nextFrag.hasOwnProperty('t')) {
      repeatEndTime = nextFrag.t / fTimescale;
    } else {
      try {
        var availabilityEnd = 0;

        if (!isNaN(representation.adaptation.period.start) && !isNaN(representation.adaptation.period.duration) && isFinite(representation.adaptation.period.duration)) {
          // use end of the Period
          availabilityEnd = representation.adaptation.period.start + representation.adaptation.period.duration;
        } else {
          // use DVR window
          var dvrWindow = dashMetrics.getCurrentDVRInfo();
          availabilityEnd = !isNaN(dvrWindow.end) ? dvrWindow.end : 0;
        }

        repeatEndTime = timelineConverter.calcMediaTimeFromPresentationTime(availabilityEnd, representation);
        representation.segmentDuration = frag.d / fTimescale;
      } catch (e) {
        repeatEndTime = 0;
      }
    }

    return Math.max(Math.ceil((repeatEndTime - scaledTime) / (frag.d / fTimescale)) - 1, 0);
  }

  function getSegmentByIndex(representation, index, lastSegmentTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    var segment = null;
    var found = false;
    iterateSegments(representation, function (time, base, list, frag, fTimescale, relativeIdx, i) {
      if (found || lastSegmentTime < 0) {
        var media = base.media;
        var mediaRange = frag.mediaRange;

        if (list) {
          media = list[i].media || '';
          mediaRange = list[i].mediaRange;
        }

        segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, time, frag.d, fTimescale, media, mediaRange, relativeIdx, frag.tManifest);
        return true;
      } else if (time >= lastSegmentTime * fTimescale - frag.d * 0.5) {
        // same logic, if deviation is
        // 50% of segment duration, segment is found if time is greater than or equal to (startTime of previous segment - half of the previous segment duration)
        found = true;
      }

      return false;
    });
    return segment;
  }

  function getSegmentByTime(representation, requestedTime) {
    checkConfig();

    if (!representation) {
      return null;
    }

    if (requestedTime === undefined) {
      requestedTime = null;
    }

    var segment = null;
    var requiredMediaTime = timelineConverter.calcMediaTimeFromPresentationTime(requestedTime, representation);
    iterateSegments(representation, function (time, base, list, frag, fTimescale, relativeIdx, i) {
      // In some cases when requiredMediaTime = actual end time of the last segment
      // it is possible that this time a bit exceeds the declared end time of the last segment.
      // in this case we still need to include the last segment in the segment list.
      var scaledMediaTime = precisionRound(requiredMediaTime * fTimescale);

      if (scaledMediaTime < time + frag.d && scaledMediaTime >= time) {
        var media = base.media;
        var mediaRange = frag.mediaRange;

        if (list) {
          media = list[i].media || '';
          mediaRange = list[i].mediaRange;
        }

        segment = (0,_SegmentsUtils__WEBPACK_IMPORTED_MODULE_2__.getTimeBasedSegment)(timelineConverter, isDynamic, representation, time, frag.d, fTimescale, media, mediaRange, relativeIdx, frag.tManifest);
        return true;
      }

      return false;
    });
    return segment;
  }

  function precisionRound(number) {
    return parseFloat(number.toPrecision(15));
  }

  instance = {
    getSegmentByIndex: getSegmentByIndex,
    getSegmentByTime: getSegmentByTime,
    getMediaFinishedInformation: getMediaFinishedInformation
  };
  return instance;
}

TimelineSegmentsGetter.__dashjs_factory_name = 'TimelineSegmentsGetter';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_0__["default"].getClassFactory(TimelineSegmentsGetter);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/dash/vo/AdaptationSet.js":
/*!**************************************!*\
  !*** ./src/dash/vo/AdaptationSet.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var AdaptationSet = function AdaptationSet() {
  _classCallCheck(this, AdaptationSet);

  this.period = null;
  this.index = -1;
  this.type = null;
};

/* harmony default export */ __webpack_exports__["default"] = (AdaptationSet);

/***/ }),

/***/ "./src/dash/vo/BaseURL.js":
/*!********************************!*\
  !*** ./src/dash/vo/BaseURL.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var DEFAULT_DVB_PRIORITY = 1;
var DEFAULT_DVB_WEIGHT = 1;

var BaseURL = function BaseURL(url, serviceLocation, priority, weight) {
  _classCallCheck(this, BaseURL);

  this.url = url || '';
  this.serviceLocation = serviceLocation || url || ''; // DVB extensions

  this.dvbPriority = priority || DEFAULT_DVB_PRIORITY;
  this.dvbWeight = weight || DEFAULT_DVB_WEIGHT;
  this.availabilityTimeOffset = 0;
  this.availabilityTimeComplete = true;
  this.queryParams = {}; // This is an attribute that might be set when synthesizing BaseURLs with content steering

  /* currently unused:
   * byteRange,
   */
};

BaseURL.DEFAULT_DVB_PRIORITY = DEFAULT_DVB_PRIORITY;
BaseURL.DEFAULT_DVB_WEIGHT = DEFAULT_DVB_WEIGHT;
/* harmony default export */ __webpack_exports__["default"] = (BaseURL);

/***/ }),

/***/ "./src/dash/vo/ContentSteering.js":
/*!****************************************!*\
  !*** ./src/dash/vo/ContentSteering.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ContentSteering = function ContentSteering() {
  _classCallCheck(this, ContentSteering);

  this.defaultServiceLocation = null;
  this.defaultServiceLocationArray = [];
  this.queryBeforeStart = false;
  this.serverUrl = null;
  this.clientRequirement = true;
};

/* harmony default export */ __webpack_exports__["default"] = (ContentSteering);

/***/ }),

/***/ "./src/dash/vo/ContentSteeringRequest.js":
/*!***********************************************!*\
  !*** ./src/dash/vo/ContentSteeringRequest.js ***!
  \***********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../streaming/vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var ContentSteeringRequest = function ContentSteeringRequest(url) {
  _classCallCheck(this, ContentSteeringRequest);

  this.url = url || null;
  this.type = _streaming_vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_0__.HTTPRequest.CONTENT_STEERING_TYPE;
  this.responseType = 'json';
};

/* harmony default export */ __webpack_exports__["default"] = (ContentSteeringRequest);

/***/ }),

/***/ "./src/dash/vo/ContentSteeringResponse.js":
/*!************************************************!*\
  !*** ./src/dash/vo/ContentSteeringResponse.js ***!
  \************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ContentSteeringResponse = function ContentSteeringResponse() {
  _classCallCheck(this, ContentSteeringResponse);

  this.version = null;
  this.ttl = 300;
  this.reloadUri = null;
  this.pathwayPriority = [];
  this.pathwayClones = [];
};

/* harmony default export */ __webpack_exports__["default"] = (ContentSteeringResponse);

/***/ }),

/***/ "./src/dash/vo/DescriptorType.js":
/*!***************************************!*\
  !*** ./src/dash/vo/DescriptorType.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2023, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var DescriptorType = /*#__PURE__*/function () {
  function DescriptorType() {
    _classCallCheck(this, DescriptorType);

    this.schemeIdUri = null;
    this.value = null;
    this.id = null;
  }

  _createClass(DescriptorType, [{
    key: "init",
    value: function init(data) {
      if (data) {
        this.schemeIdUri = data.schemeIdUri ? data.schemeIdUri : null;
        this.value = data.value ? data.value : null;
        this.id = data.id ? data.id : null; // Only add the DVB extensions if they exist

        if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_URL]) {
          this.dvbUrl = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_URL];
        }

        if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_MIMETYPE]) {
          this.dvbMimeType = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_MIMETYPE];
        }

        if (data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_FONTFAMILY]) {
          this.dvbFontFamily = data[_constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].DVB_FONTFAMILY];
        }
      }

      return this;
    }
  }]);

  return DescriptorType;
}();

/* harmony default export */ __webpack_exports__["default"] = (DescriptorType);

/***/ }),

/***/ "./src/dash/vo/Event.js":
/*!******************************!*\
  !*** ./src/dash/vo/Event.js ***!
  \******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Event = function Event() {
  _classCallCheck(this, Event);

  this.type = '';
  this.duration = NaN;
  this.presentationTime = NaN;
  this.id = NaN;
  this.messageData = '';
  this.eventStream = null;
  this.presentationTimeDelta = NaN; // Specific EMSG Box parameter
};

/* harmony default export */ __webpack_exports__["default"] = (Event);

/***/ }),

/***/ "./src/dash/vo/EventStream.js":
/*!************************************!*\
  !*** ./src/dash/vo/EventStream.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var EventStream = function EventStream() {
  _classCallCheck(this, EventStream);

  this.adaptionSet = null;
  this.representation = null;
  this.period = null;
  this.timescale = 1;
  this.value = '';
  this.schemeIdUri = '';
  this.presentationTimeOffset = 0;
};

/* harmony default export */ __webpack_exports__["default"] = (EventStream);

/***/ }),

/***/ "./src/dash/vo/ManifestInfo.js":
/*!*************************************!*\
  !*** ./src/dash/vo/ManifestInfo.js ***!
  \*************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ManifestInfo = function ManifestInfo() {
  _classCallCheck(this, ManifestInfo);

  this.dvrWindowSize = NaN;
  this.loadedTime = null;
  this.availableFrom = null;
  this.minBufferTime = NaN;
  this.duration = NaN;
  this.isDynamic = false;
  this.maxFragmentDuration = null;
  this.serviceDescriptions = [];
  this.protocol = null;
};

/* harmony default export */ __webpack_exports__["default"] = (ManifestInfo);

/***/ }),

/***/ "./src/dash/vo/MediaInfo.js":
/*!**********************************!*\
  !*** ./src/dash/vo/MediaInfo.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var MediaInfo = function MediaInfo() {
  _classCallCheck(this, MediaInfo);

  this.id = null;
  this.index = null;
  this.type = null;
  this.streamInfo = null;
  this.representationCount = 0;
  this.labels = null;
  this.lang = null;
  this.viewpoint = null;
  this.viewpointsWithSchemeIdUri = null;
  this.accessibility = null;
  this.accessibilitiesWithSchemeIdUri = null;
  this.audioChannelConfiguration = null;
  this.audioChannelConfigurationsWithSchemeIdUri = null;
  this.roles = null;
  this.rolesWithSchemeIdUri = null;
  this.codec = null;
  this.mimeType = null;
  this.contentProtection = null;
  this.isText = false;
  this.KID = null;
  this.bitrateList = null;
  this.isFragmented = null;
  this.isEmbedded = null;
  this.selectionPriority = 1;
  this.supplementalProperties = {};
  this.supplementalPropertiesAsArray = [];
  this.essentialProperties = {};
  this.essentialPropertiesAsArray = [];
  this.segmentAlignment = false;
  this.subSegmentAlignment = false;
};

/* harmony default export */ __webpack_exports__["default"] = (MediaInfo);

/***/ }),

/***/ "./src/dash/vo/Mpd.js":
/*!****************************!*\
  !*** ./src/dash/vo/Mpd.js ***!
  \****************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Mpd = function Mpd() {
  _classCallCheck(this, Mpd);

  this.manifest = null;
  this.suggestedPresentationDelay = 0;
  this.availabilityStartTime = null;
  this.availabilityEndTime = Number.POSITIVE_INFINITY;
  this.timeShiftBufferDepth = Number.POSITIVE_INFINITY;
  this.maxSegmentDuration = Number.POSITIVE_INFINITY;
  this.publishTime = null;
  this.minimumUpdatePeriod = NaN;
  this.mediaPresentationDuration = NaN;
};

/* harmony default export */ __webpack_exports__["default"] = (Mpd);

/***/ }),

/***/ "./src/dash/vo/MpdLocation.js":
/*!************************************!*\
  !*** ./src/dash/vo/MpdLocation.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2023, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var MpdLocation = function MpdLocation(url, serviceLocation) {
  _classCallCheck(this, MpdLocation);

  this.url = url || '';
  this.serviceLocation = serviceLocation || null;
  this.queryParams = {}; // This is an attribute that might be set when synthesizing Locations with content steering
};

/* harmony default export */ __webpack_exports__["default"] = (MpdLocation);

/***/ }),

/***/ "./src/dash/vo/PatchLocation.js":
/*!**************************************!*\
  !*** ./src/dash/vo/PatchLocation.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2023, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var PatchLocation = function PatchLocation(url, serviceLocation, ttl) {
  _classCallCheck(this, PatchLocation);

  this.url = url || '';
  this.serviceLocation = serviceLocation || null;
  this.ttl = ttl || NaN;
  this.queryParams = {}; // This is an attribute that might be set when synthesizing Locations with content steering
};

/* harmony default export */ __webpack_exports__["default"] = (PatchLocation);

/***/ }),

/***/ "./src/dash/vo/PatchOperation.js":
/*!***************************************!*\
  !*** ./src/dash/vo/PatchOperation.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var PatchOperation = /*#__PURE__*/function () {
  function PatchOperation(action, xpath, value) {
    _classCallCheck(this, PatchOperation);

    this.action = action;
    this.xpath = xpath;
    this.value = value;
    this.position = null;
  }

  _createClass(PatchOperation, [{
    key: "getMpdTarget",
    value: function getMpdTarget(root) {
      var isSiblingOperation = this.action === 'remove' || this.action === 'replace' || this.position === 'before' || this.position === 'after';
      return this.xpath.getMpdTarget(root, isSiblingOperation);
    }
  }]);

  return PatchOperation;
}();

/* harmony default export */ __webpack_exports__["default"] = (PatchOperation);

/***/ }),

/***/ "./src/dash/vo/Period.js":
/*!*******************************!*\
  !*** ./src/dash/vo/Period.js ***!
  \*******************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Period = function Period() {
  _classCallCheck(this, Period);

  this.id = null;
  this.index = -1;
  this.duration = NaN;
  this.start = NaN;
  this.mpd = null;
  this.nextPeriodId = null;
};

Period.DEFAULT_ID = 'defaultId';
/* harmony default export */ __webpack_exports__["default"] = (Period);

/***/ }),

/***/ "./src/dash/vo/ProducerReferenceTime.js":
/*!**********************************************!*\
  !*** ./src/dash/vo/ProducerReferenceTime.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var ProducerReferenceTime = function ProducerReferenceTime() {
  _classCallCheck(this, ProducerReferenceTime);

  this.id = null;
  this.inband = false;
  this.type = 'encoder';
  this.applicationScheme = null;
  this.wallClockTime = null;
  this.presentationTime = NaN;
  this.UTCTiming = null;
};

/* harmony default export */ __webpack_exports__["default"] = (ProducerReferenceTime);

/***/ }),

/***/ "./src/dash/vo/Representation.js":
/*!***************************************!*\
  !*** ./src/dash/vo/Representation.js ***!
  \***************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../constants/DashConstants */ "./src/dash/constants/DashConstants.js");
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */


var Representation = /*#__PURE__*/function () {
  function Representation() {
    _classCallCheck(this, Representation);

    this.id = null;
    this.index = -1;
    this.adaptation = null;
    this.segmentInfoType = null;
    this.initialization = null;
    this.codecs = null;
    this.mimeType = null;
    this.codecPrivateData = null;
    this.segmentDuration = NaN;
    this.timescale = 1;
    this.startNumber = 1;
    this.indexRange = null;
    this.range = null;
    this.presentationTimeOffset = 0; // Set the source buffer timeOffset to this

    this.MSETimeOffset = NaN; // The information we need in the DashHandler to determine whether the last segment has been loaded

    this.mediaFinishedInformation = {
      numberOfSegments: 0,
      mediaTimeOfLastSignaledSegment: NaN
    };
    this.bandwidth = NaN;
    this.width = NaN;
    this.height = NaN;
    this.scanType = null;
    this.maxPlayoutRate = NaN;
    this.availabilityTimeOffset = 0;
    this.availabilityTimeComplete = true;
    this.frameRate = null;
  }

  _createClass(Representation, [{
    key: "hasInitialization",
    value: function hasInitialization() {
      return this.initialization !== null || this.range !== null;
    }
  }, {
    key: "hasSegments",
    value: function hasSegments() {
      return this.segmentInfoType !== _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].BASE_URL && this.segmentInfoType !== _constants_DashConstants__WEBPACK_IMPORTED_MODULE_0__["default"].SEGMENT_BASE && !this.indexRange;
    }
  }]);

  return Representation;
}();

/* harmony default export */ __webpack_exports__["default"] = (Representation);

/***/ }),

/***/ "./src/dash/vo/RepresentationInfo.js":
/*!*******************************************!*\
  !*** ./src/dash/vo/RepresentationInfo.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var RepresentationInfo = function RepresentationInfo() {
  _classCallCheck(this, RepresentationInfo);

  this.id = null;
  this.quality = null;
  this.fragmentDuration = null;
  this.mediaInfo = null;
  this.MSETimeOffset = null;
};

/* harmony default export */ __webpack_exports__["default"] = (RepresentationInfo);

/***/ }),

/***/ "./src/dash/vo/Segment.js":
/*!********************************!*\
  !*** ./src/dash/vo/Segment.js ***!
  \********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var Segment = function Segment() {
  _classCallCheck(this, Segment);

  this.indexRange = null; // The index of the segment in the list of segments. We start at 0

  this.index = null;
  this.mediaRange = null;
  this.media = null;
  this.duration = NaN; // this is the time that should be inserted into the media url

  this.replacementTime = null; // this is the number that should be inserted into the media url

  this.replacementNumber = NaN; // This is supposed to match the time encoded in the media Segment

  this.mediaStartTime = NaN; // When the source buffer timeOffset is set to MSETimeOffset this is the
  // time that will match the seekTarget and video.currentTime

  this.presentationStartTime = NaN; // Do not schedule this segment until

  this.availabilityStartTime = NaN; // Ignore and  discard this segment after

  this.availabilityEndTime = NaN; // For dynamic mpd's, this is the wall clock time that the video
  // element currentTime should be presentationStartTime

  this.wallStartTime = NaN;
  this.representation = null;
};

/* harmony default export */ __webpack_exports__["default"] = (Segment);

/***/ }),

/***/ "./src/dash/vo/SimpleXPath.js":
/*!************************************!*\
  !*** ./src/dash/vo/SimpleXPath.js ***!
  \************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var SimpleXPath = /*#__PURE__*/function () {
  function SimpleXPath(selector) {
    var _this = this;

    _classCallCheck(this, SimpleXPath);

    // establish validation of the path, to catch unsupported cases
    this.valid = selector[0] == '/'; // first check, we only support absolute addressing
    // establish parsed path, example:
    // /MPD/Period[@id="foobar"]/AdaptationSet[@id="2"]/SegmentTemplate/SegmentTimeline

    this.path = selector.split('/').filter(function (component) {
      return component.length !== 0;
    }) // remove excess empty components
    .map(function (component) {
      var parsed = {
        name: component
      };
      var qualifierPoint = component.indexOf('[');

      if (qualifierPoint != -1) {
        parsed.name = component.substring(0, qualifierPoint);
        var qualifier = component.substring(qualifierPoint + 1, component.length - 1); // quick sanity check are there additional qualifiers making this invalid

        _this.valid = _this.valid && qualifier.indexOf('[') == -1;
        var equalityPoint = qualifier.indexOf('=');

        if (equalityPoint != -1) {
          parsed.attribute = {
            name: qualifier.substring(1, equalityPoint),
            // skip the @
            value: qualifier.substring(equalityPoint + 1)
          }; // check for single and double quoted attribute values

          if (['\'', '"'].indexOf(parsed.attribute.value[0]) != -1) {
            parsed.attribute.value = parsed.attribute.value.substring(1, parsed.attribute.value.length - 1);
          }
        } else {
          // positional access in xpath is 1-based index
          // internal processes will assume 0-based so we normalize that here
          parsed.position = parseInt(qualifier, 10) - 1;
        }
      }

      return parsed;
    });
  }

  _createClass(SimpleXPath, [{
    key: "isValid",
    value: function isValid() {
      return this.valid;
    }
  }, {
    key: "findsElement",
    value: function findsElement() {
      return !this.findsAttribute();
    }
  }, {
    key: "findsAttribute",
    value: function findsAttribute() {
      return this.path[this.path.length - 1].name.startsWith('@');
    }
  }, {
    key: "findsTextReplace",
    value: function findsTextReplace() {
      return this.path[this.path.length - 1].name === 'text()';
    }
  }, {
    key: "getMpdTarget",
    value: function getMpdTarget(root, isSiblingOperation) {
      var parent = null;
      var leaf = root; // assume root is MPD and we start at next level match

      var level = 1;
      var name = 'MPD';

      while (level < this.path.length && leaf !== null) {
        // set parent to current
        parent = leaf; // select next leaf based on component

        var component = this.path[level];
        name = component.name; // stop one early if this is the last element and an attribute or a text selector

        if (level !== this.path.length - 1 || !name.startsWith('@') && name !== 'text()') {
          var children = parent[name + '_asArray'] || [];

          if (children.length === 0 && parent[name]) {
            children.push(parent[name]);
          }

          if (component.position) {
            leaf = children[component.position] || null;
          } else if (component.attribute) {
            (function () {
              var attr = component.attribute;
              leaf = children.filter(function (elm) {
                return elm[attr.name] == attr.value;
              })[0] || null;
            })();
          } else {
            // default case, select first
            leaf = children[0] || null;
          }
        }

        level++;
      }

      if (leaf === null) {
        // given path not found in root
        return null;
      } // attributes the target is the leaf node, the name is the attribute


      if (name.startsWith('@')) {
        return {
          name: name.substring(1),
          leaf: leaf,
          target: leaf
        };
      } // for replacing a text node the target is the leaf node, the name is __text
      else if (name === 'text()') {
        return {
          name: '__text',
          leaf: leaf,
          target: leaf
        };
      } // otherwise we target the parent for sibling operations and leaf for child operations


      return {
        name: name,
        leaf: leaf,
        target: isSiblingOperation ? parent : leaf
      };
    }
  }]);

  return SimpleXPath;
}();

/* harmony default export */ __webpack_exports__["default"] = (SimpleXPath);

/***/ }),

/***/ "./src/dash/vo/StreamInfo.js":
/*!***********************************!*\
  !*** ./src/dash/vo/StreamInfo.js ***!
  \***********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var StreamInfo = function StreamInfo() {
  _classCallCheck(this, StreamInfo);

  this.id = null;
  this.index = null;
  this.start = NaN;
  this.duration = NaN;
  this.manifestInfo = null;
  this.isLast = true;
};

/* harmony default export */ __webpack_exports__["default"] = (StreamInfo);

/***/ }),

/***/ "./src/dash/vo/UTCTiming.js":
/*!**********************************!*\
  !*** ./src/dash/vo/UTCTiming.js ***!
  \**********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @ignore
 */
var UTCTiming = function UTCTiming() {
  _classCallCheck(this, UTCTiming);

  // UTCTiming is a DescriptorType and doesn't have any additional fields
  this.schemeIdUri = '';
  this.value = '';
};

/* harmony default export */ __webpack_exports__["default"] = (UTCTiming);

/***/ }),

/***/ "./src/streaming/FragmentLoader.js":
/*!*****************************************!*\
  !*** ./src/streaming/FragmentLoader.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _net_URLLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _vo_HeadRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vo/HeadRequest */ "./src/streaming/vo/HeadRequest.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */






function FragmentLoader(config) {
  config = config || {};
  var context = this.context;
  var eventBus = config.eventBus;
  var events = config.events;
  var urlUtils = config.urlUtils;
  var errors = config.errors;
  var streamId = config.streamId;
  var instance, urlLoader;

  function setup() {
    urlLoader = (0,_net_URLLoader__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
      errHandler: config.errHandler,
      errors: errors,
      dashMetrics: config.dashMetrics,
      mediaPlayerModel: config.mediaPlayerModel,
      requestModifier: config.requestModifier,
      urlUtils: urlUtils,
      constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"],
      boxParser: config.boxParser,
      dashConstants: config.dashConstants,
      requestTimeout: config.settings.get().streaming.fragmentRequestTimeout
    });
  }

  function checkForExistence(request) {
    var report = function report(success) {
      eventBus.trigger(events.CHECK_FOR_EXISTENCE_COMPLETED, {
        request: request,
        exists: success
      });
    };

    if (request) {
      var headRequest = new _vo_HeadRequest__WEBPACK_IMPORTED_MODULE_2__["default"](request.url);
      urlLoader.load({
        request: headRequest,
        success: function success() {
          report(true);
        },
        error: function error() {
          report(false);
        }
      });
    } else {
      report(false);
    }
  }

  function load(request) {
    var report = function report(data, error) {
      eventBus.trigger(events.LOADING_COMPLETED, {
        request: request,
        response: data || null,
        error: error || null,
        sender: instance
      });
    };

    if (request) {
      urlLoader.load({
        request: request,
        progress: function progress(event) {
          eventBus.trigger(events.LOADING_PROGRESS, {
            request: request,
            stream: event.stream,
            streamId: streamId
          });

          if (event.data) {
            eventBus.trigger(events.LOADING_DATA_PROGRESS, {
              request: request,
              response: event.data || null,
              error: null,
              sender: instance
            });
          }
        },
        success: function success(data) {
          report(data);
        },
        error: function error(request, statusText, errorText) {
          report(undefined, new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__["default"](errors.FRAGMENT_LOADER_LOADING_FAILURE_ERROR_CODE, errorText, statusText));
        },
        abort: function abort(request) {
          if (request) {
            eventBus.trigger(events.LOADING_ABANDONED, {
              mediaType: request.mediaType,
              request: request,
              sender: instance
            });
          }
        }
      });
    } else {
      report(undefined, new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_3__["default"](errors.FRAGMENT_LOADER_NULL_REQUEST_ERROR_CODE, errors.FRAGMENT_LOADER_NULL_REQUEST_ERROR_MESSAGE));
    }
  }

  function abort() {
    if (urlLoader) {
      urlLoader.abort();
    }
  }

  function reset() {
    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  instance = {
    checkForExistence: checkForExistence,
    load: load,
    abort: abort,
    reset: reset
  };
  setup();
  return instance;
}

FragmentLoader.__dashjs_factory_name = 'FragmentLoader';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_4__["default"].getClassFactory(FragmentLoader));

/***/ }),

/***/ "./src/streaming/ManifestLoader.js":
/*!*****************************************!*\
  !*** ./src/streaming/ManifestLoader.js ***!
  \*****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _controllers_XlinkController__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./controllers/XlinkController */ "./src/streaming/controllers/XlinkController.js");
/* harmony import */ var _net_URLLoader__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _vo_TextRequest__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./vo/TextRequest */ "./src/streaming/vo/TextRequest.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _dash_parser_DashParser__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../dash/parser/DashParser */ "./src/dash/parser/DashParser.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */














function ManifestLoader(config) {
  config = config || {};
  var context = this.context;
  var debug = config.debug;
  var settings = config.settings;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_8__["default"])(context).getInstance();
  var urlUtils = (0,_utils_URLUtils__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var instance, logger, urlLoader, xlinkController, parser;
  var mssHandler = config.mssHandler;
  var errHandler = config.errHandler;

  function setup() {
    logger = debug.getLogger(instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].XLINK_READY, onXlinkReady, instance);
    urlLoader = (0,_net_URLLoader__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create({
      errHandler: config.errHandler,
      dashMetrics: config.dashMetrics,
      mediaPlayerModel: config.mediaPlayerModel,
      requestModifier: config.requestModifier,
      urlUtils: urlUtils,
      constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"],
      dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
      errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"],
      requestTimeout: config.settings.get().streaming.manifestRequestTimeout
    });
    xlinkController = (0,_controllers_XlinkController__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      errHandler: errHandler,
      dashMetrics: config.dashMetrics,
      mediaPlayerModel: config.mediaPlayerModel,
      requestModifier: config.requestModifier,
      settings: config.settings
    });
    parser = null;
  }

  function onXlinkReady(event) {
    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
      manifest: event.manifest
    });
  }

  function createParser(data) {
    var parser = null; // Analyze manifest content to detect protocol and select appropriate parser

    if (data.indexOf('SmoothStreamingMedia') > -1) {
      //do some business to transform it into a Dash Manifest
      if (mssHandler) {
        parser = mssHandler.createMssParser();
        mssHandler.createMssFragmentProcessor();
        mssHandler.registerEvents();
      }

      return parser;
    } else if (data.indexOf('MPD') > -1 || data.indexOf('Patch') > -1) {
      return (0,_dash_parser_DashParser__WEBPACK_IMPORTED_MODULE_12__["default"])(context).create({
        debug: debug
      });
    } else {
      return parser;
    }
  }

  function load(url) {
    var serviceLocation = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    var queryParams = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;
    var requestStartDate = new Date();
    var request = new _vo_TextRequest__WEBPACK_IMPORTED_MODULE_5__["default"](url, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_7__.HTTPRequest.MPD_TYPE);

    if (serviceLocation) {
      request.serviceLocation = serviceLocation;
    }

    if (queryParams) {
      request.queryParams = queryParams;
    }

    if (!request.requestStartDate) {
      request.requestStartDate = requestStartDate;
    }

    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].MANIFEST_LOADING_STARTED, {
      request: request
    });
    urlLoader.load({
      request: request,
      success: function success(data, textStatus, responseURL) {
        // Manage situations in which success is called after calling reset
        if (!xlinkController) return;
        var actualUrl, baseUri, manifest; // Handle redirects for the MPD - as per RFC3986 Section 5.1.3
        // also handily resolves relative MPD URLs to absolute

        if (responseURL && responseURL !== url) {
          baseUri = urlUtils.parseBaseUrl(responseURL);
          actualUrl = responseURL;
        } else {
          // usually this case will be caught and resolved by
          // responseURL above but it is not available for IE11 and Edge/12 and Edge/13
          // baseUri must be absolute for BaseURL resolution later
          if (urlUtils.isRelative(url)) {
            url = urlUtils.resolve(url, window.location.href);
          }

          baseUri = urlUtils.parseBaseUrl(url);
        } // A response of no content implies in-memory is properly up to date


        if (textStatus == 'No Content') {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
            manifest: null
          });
          return;
        } // Create parser according to manifest type


        if (parser === null) {
          parser = createParser(data);
        }

        if (parser === null) {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
            manifest: null,
            error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE + "".concat(url))
          });
          return;
        } // init xlinkcontroller with matchers and iron object from created parser


        xlinkController.setMatchers(parser.getMatchers());
        xlinkController.setIron(parser.getIron());

        try {
          manifest = parser.parse(data);
        } catch (e) {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
            manifest: null,
            error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE + "".concat(url))
          });
          return;
        }

        if (manifest) {
          manifest.url = actualUrl || url; // URL from which the MPD was originally retrieved (MPD updates will not change this value)

          if (!manifest.originalUrl) {
            manifest.originalUrl = manifest.url;
          } // If there is a mismatch between the manifest's specified duration and the total duration of all periods,
          // and the specified duration is greater than the total duration of all periods,
          // overwrite the manifest's duration attribute. This is a patch for if a manifest is generated incorrectly.


          if (settings && settings.get().streaming.enableManifestDurationMismatchFix && manifest.mediaPresentationDuration && manifest.Period_asArray.length > 1) {
            var sumPeriodDurations = manifest.Period_asArray.reduce(function (totalDuration, period) {
              return totalDuration + period.duration;
            }, 0);

            if (!isNaN(sumPeriodDurations) && manifest.mediaPresentationDuration > sumPeriodDurations) {
              logger.warn('Media presentation duration greater than duration of all periods. Setting duration to total period duration');
              manifest.mediaPresentationDuration = sumPeriodDurations;
            }
          }

          manifest.baseUri = baseUri;
          manifest.loadedTime = new Date();
          xlinkController.resolveManifestOnLoad(manifest);
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].ORIGINAL_MANIFEST_LOADED, {
            originalManifest: data
          });
        } else {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
            manifest: null,
            error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_MESSAGE + "".concat(url))
          });
        }
      },
      error: function error(request, statusText, errorText) {
        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].INTERNAL_MANIFEST_LOADED, {
          manifest: null,
          error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_6__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_LOADING_FAILURE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_10__["default"].MANIFEST_LOADER_LOADING_FAILURE_ERROR_MESSAGE + "".concat(url, ", ").concat(errorText))
        });
      }
    });
  }

  function reset() {
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_9__["default"].XLINK_READY, onXlinkReady, instance);

    if (mssHandler) {
      mssHandler.reset();
    }

    if (xlinkController) {
      xlinkController.reset();
      xlinkController = null;
    }

    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  instance = {
    load: load,
    reset: reset
  };
  setup();
  return instance;
}

ManifestLoader.__dashjs_factory_name = 'ManifestLoader';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_11__["default"].getClassFactory(ManifestLoader);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/streaming/ManifestUpdater.js":
/*!******************************************!*\
  !*** ./src/streaming/ManifestUpdater.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../streaming/MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _utils_URLUtils__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _utils_LocationSelector__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils/LocationSelector */ "./src/streaming/utils/LocationSelector.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */










function ManifestUpdater() {
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance();
  var urlUtils = (0,_utils_URLUtils__WEBPACK_IMPORTED_MODULE_7__["default"])(context).getInstance();
  var instance, logger, refreshDelay, refreshTimer, isPaused, isStopped, isUpdating, manifestLoader, manifestModel, locationSelector, adapter, errHandler, contentSteeringController, settings;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance().getLogger(instance);
    locationSelector = (0,_utils_LocationSelector__WEBPACK_IMPORTED_MODULE_8__["default"])(context).create();
  }

  function setConfig(config) {
    if (!config) return;

    if (config.manifestModel) {
      manifestModel = config.manifestModel;
    }

    if (config.adapter) {
      adapter = config.adapter;
    }

    if (config.manifestLoader) {
      manifestLoader = config.manifestLoader;
    }

    if (config.errHandler) {
      errHandler = config.errHandler;
    }

    if (config.locationSelector) {
      locationSelector = config.locationSelector;
    }

    if (config.settings) {
      settings = config.settings;
    }

    if (config.contentSteeringController) {
      contentSteeringController = config.contentSteeringController;
    }
  }

  function initialize() {
    resetInitialSettings();
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].STREAMS_COMPOSED, onStreamsComposed, this);
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].PLAYBACK_STARTED, onPlaybackStarted, this);
    eventBus.on(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].PLAYBACK_PAUSED, onPlaybackPaused, this);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].INTERNAL_MANIFEST_LOADED, onManifestLoaded, this);
  }

  function setManifest(manifest) {
    update(manifest);
  }

  function resetInitialSettings() {
    refreshDelay = NaN;
    isUpdating = false;
    isPaused = true;
    isStopped = false;
    stopManifestRefreshTimer();
  }

  function reset() {
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].PLAYBACK_STARTED, onPlaybackStarted, this);
    eventBus.off(_streaming_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_2__["default"].PLAYBACK_PAUSED, onPlaybackPaused, this);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].STREAMS_COMPOSED, onStreamsComposed, this);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].INTERNAL_MANIFEST_LOADED, onManifestLoaded, this);
    resetInitialSettings();
  }

  function stopManifestRefreshTimer() {
    if (refreshTimer !== null) {
      clearTimeout(refreshTimer);
      refreshTimer = null;
    }
  }

  function startManifestRefreshTimer(delay) {
    stopManifestRefreshTimer();

    if (isStopped) {
      return;
    }

    if (isNaN(delay) && !isNaN(refreshDelay)) {
      delay = refreshDelay * 1000;
    }

    if (!isNaN(delay)) {
      logger.debug('Refresh manifest in ' + delay + ' milliseconds.');
      refreshTimer = setTimeout(onRefreshTimer, delay);
    }
  }

  function refreshManifest() {
    var ignorePatch = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
    isUpdating = true;
    var manifest = manifestModel.getValue(); // default to the original url in the manifest

    var url = manifest.url; // Check for PatchLocation and Location alternatives

    var serviceLocation = null;
    var availablePatchLocations = adapter.getPatchLocation(manifest);
    var patchLocation = locationSelector.select(availablePatchLocations);
    var queryParams = null;

    if (patchLocation && !ignorePatch) {
      url = patchLocation.url;
      serviceLocation = patchLocation.serviceLocation;
      queryParams = patchLocation.queryParams;
    } else {
      var availableMpdLocations = _getAvailableMpdLocations(manifest);

      var mpdLocation = locationSelector.select(availableMpdLocations);

      if (mpdLocation) {
        url = mpdLocation.url;
        serviceLocation = mpdLocation.serviceLocation;
        queryParams = mpdLocation.queryParams;
      }
    } // if one of the alternatives was relative, convert to absolute


    if (urlUtils.isRelative(url)) {
      url = urlUtils.resolve(url, manifest.url);
    }

    manifestLoader.load(url, serviceLocation, queryParams);
  }

  function _getAvailableMpdLocations(manifest) {
    var manifestLocations = adapter.getLocation(manifest);
    var synthesizedElements = contentSteeringController.getSynthesizedLocationElements(manifestLocations);
    return manifestLocations.concat(synthesizedElements);
  }

  function update(manifest) {
    if (!manifest) {
      // successful update with no content implies existing manifest remains valid
      manifest = manifestModel.getValue(); // override load time to avoid invalid latency tracking and ensure update cadence

      manifest.loadedTime = new Date();
    } else if (adapter.getIsPatch(manifest)) {
      // with patches the in-memory manifest is our base
      var patch = manifest;
      manifest = manifestModel.getValue(); // check for patch validity

      var isPatchValid = adapter.isPatchValid(manifest, patch);
      var patchSuccessful = isPatchValid;

      if (isPatchValid) {
        // grab publish time before update
        var publishTime = adapter.getPublishTime(manifest); // apply validated patch to manifest

        patchSuccessful = adapter.applyPatchToManifest(manifest, patch); // get the updated publish time

        var updatedPublishTime = adapter.getPublishTime(manifest); // ensure the patch properly updated the in-memory publish time

        patchSuccessful = publishTime.getTime() != updatedPublishTime.getTime();
      } // if the patch failed to apply, force a full manifest refresh


      if (!patchSuccessful) {
        logger.debug('Patch provided is invalid, performing full manifest refresh');
        refreshManifest(true);
        return;
      } // override load time to avoid invalid latency tracking and ensure update cadence


      manifest.loadedTime = new Date();
    } // See DASH-IF IOP v4.3 section 4.6.4 "Transition Phase between Live and On-Demand"
    // Stop manifest update, ignore static manifest and signal end of dynamic stream to detect end of stream


    if (manifestModel.getValue() && manifestModel.getValue().type === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].DYNAMIC && manifest.type === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_6__["default"].STATIC) {
      eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].DYNAMIC_TO_STATIC);
      isUpdating = false;
      isStopped = true;
      return;
    }

    manifestModel.setValue(manifest);
    var date = new Date();
    var latencyOfLastUpdate = (date.getTime() - manifest.loadedTime.getTime()) / 1000;
    refreshDelay = adapter.getManifestUpdatePeriod(manifest, latencyOfLastUpdate); // setTimeout uses a 32 bit number to store the delay. Any number greater than it
    // will cause event associated with setTimeout to trigger immediately

    if (refreshDelay * 1000 > 0x7FFFFFFF) {
      refreshDelay = 0x7FFFFFFF / 1000;
    }

    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_1__["default"].MANIFEST_UPDATED, {
      manifest: manifest
    });
    logger.info('Manifest has been refreshed at ' + date + '[' + date.getTime() / 1000 + '] ');

    if (!isPaused) {
      startManifestRefreshTimer();
    }
  }

  function onRefreshTimer() {
    if (isPaused) {
      return;
    }

    if (isUpdating) {
      startManifestRefreshTimer(settings.get().streaming.manifestUpdateRetryInterval);
      return;
    }

    refreshManifest();
  }

  function onManifestLoaded(e) {
    if (!e.error) {
      update(e.manifest);
    } else if (e.error.code === _core_errors_Errors__WEBPACK_IMPORTED_MODULE_5__["default"].MANIFEST_LOADER_PARSING_FAILURE_ERROR_CODE) {
      errHandler.error(e.error);
    }
  }

  function onPlaybackStarted() {
    isPaused = false;
    startManifestRefreshTimer();
  }

  function onPlaybackPaused() {
    isPaused = !settings.get().streaming.scheduling.scheduleWhilePaused;

    if (isPaused) {
      stopManifestRefreshTimer();
    }
  }

  function onStreamsComposed() {
    // When streams are ready we can consider manifest update completed. Resolve the update promise.
    isUpdating = false;
  }

  function getIsUpdating() {
    return isUpdating;
  }

  instance = {
    initialize: initialize,
    setManifest: setManifest,
    refreshManifest: refreshManifest,
    getIsUpdating: getIsUpdating,
    setConfig: setConfig,
    reset: reset
  };
  setup();
  return instance;
}

ManifestUpdater.__dashjs_factory_name = 'ManifestUpdater';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_3__["default"].getClassFactory(ManifestUpdater));

/***/ }),

/***/ "./src/streaming/MediaPlayer.js":
/*!**************************************!*\
  !*** ./src/streaming/MediaPlayer.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _externals_cea608_parser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../externals/cea608-parser */ "./externals/cea608-parser.js");
/* harmony import */ var _externals_cea608_parser__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_externals_cea608_parser__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _controllers_PlaybackController__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./controllers/PlaybackController */ "./src/streaming/controllers/PlaybackController.js");
/* harmony import */ var _controllers_StreamController__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./controllers/StreamController */ "./src/streaming/controllers/StreamController.js");
/* harmony import */ var _controllers_GapController__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./controllers/GapController */ "./src/streaming/controllers/GapController.js");
/* harmony import */ var _controllers_CatchupController__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./controllers/CatchupController */ "./src/streaming/controllers/CatchupController.js");
/* harmony import */ var _dash_controllers_ServiceDescriptionController__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../dash/controllers/ServiceDescriptionController */ "./src/dash/controllers/ServiceDescriptionController.js");
/* harmony import */ var _dash_controllers_ContentSteeringController__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../dash/controllers/ContentSteeringController */ "./src/dash/controllers/ContentSteeringController.js");
/* harmony import */ var _controllers_MediaController__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./controllers/MediaController */ "./src/streaming/controllers/MediaController.js");
/* harmony import */ var _controllers_BaseURLController__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./controllers/BaseURLController */ "./src/streaming/controllers/BaseURLController.js");
/* harmony import */ var _ManifestLoader__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./ManifestLoader */ "./src/streaming/ManifestLoader.js");
/* harmony import */ var _utils_ErrorHandler__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./utils/ErrorHandler */ "./src/streaming/utils/ErrorHandler.js");
/* harmony import */ var _utils_Capabilities__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./utils/Capabilities */ "./src/streaming/utils/Capabilities.js");
/* harmony import */ var _utils_CapabilitiesFilter__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./utils/CapabilitiesFilter */ "./src/streaming/utils/CapabilitiesFilter.js");
/* harmony import */ var _utils_RequestModifier__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./utils/RequestModifier */ "./src/streaming/utils/RequestModifier.js");
/* harmony import */ var _models_URIFragmentModel__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./models/URIFragmentModel */ "./src/streaming/models/URIFragmentModel.js");
/* harmony import */ var _models_ManifestModel__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./models/ManifestModel */ "./src/streaming/models/ManifestModel.js");
/* harmony import */ var _models_MediaPlayerModel__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./models/MediaPlayerModel */ "./src/streaming/models/MediaPlayerModel.js");
/* harmony import */ var _controllers_AbrController__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./controllers/AbrController */ "./src/streaming/controllers/AbrController.js");
/* harmony import */ var _net_SchemeLoaderFactory__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./net/SchemeLoaderFactory */ "./src/streaming/net/SchemeLoaderFactory.js");
/* harmony import */ var _models_VideoModel__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./models/VideoModel */ "./src/streaming/models/VideoModel.js");
/* harmony import */ var _models_CmcdModel__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./models/CmcdModel */ "./src/streaming/models/CmcdModel.js");
/* harmony import */ var _models_CmsdModel__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./models/CmsdModel */ "./src/streaming/models/CmsdModel.js");
/* harmony import */ var _utils_DOMStorage__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./utils/DOMStorage */ "./src/streaming/utils/DOMStorage.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _core_Version__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../core/Version */ "./src/core/Version.js");
/* harmony import */ var _dash_controllers_SegmentBaseController__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../dash/controllers/SegmentBaseController */ "./src/dash/controllers/SegmentBaseController.js");
/* harmony import */ var _dash_DashAdapter__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../dash/DashAdapter */ "./src/dash/DashAdapter.js");
/* harmony import */ var _dash_DashMetrics__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../dash/DashMetrics */ "./src/dash/DashMetrics.js");
/* harmony import */ var _dash_utils_TimelineConverter__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../dash/utils/TimelineConverter */ "./src/dash/utils/TimelineConverter.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _externals_base64__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../externals/base64 */ "./externals/base64.js");
/* harmony import */ var codem_isoboxer__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! codem-isoboxer */ "./node_modules/codem-isoboxer/dist/iso_boxer.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./utils/SupervisorTools */ "./src/streaming/utils/SupervisorTools.js");
/* harmony import */ var _ManifestUpdater__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./ManifestUpdater */ "./src/streaming/ManifestUpdater.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _utils_BoxParser__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./utils/BoxParser */ "./src/streaming/utils/BoxParser.js");
/* harmony import */ var _text_TextController__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./text/TextController */ "./src/streaming/text/TextController.js");
/* harmony import */ var _models_CustomParametersModel__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./models/CustomParametersModel */ "./src/streaming/models/CustomParametersModel.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

































 //Dash















/**
 * The media types
 * @typedef {("video" | "audio" | "text" | "image")} MediaType
 */

/**
 * @module MediaPlayer
 * @description The MediaPlayer is the primary dash.js Module and a Facade to build your player around.
 * It will allow you access to all the important dash.js properties/methods via the public API and all the
 * events to build a robust DASH media player.
 */

function MediaPlayer() {
  /**
   * @constant {string} STREAMING_NOT_INITIALIZED_ERROR error string thrown when a function is called before the dash.js has been fully initialized
   * @inner
   */
  var STREAMING_NOT_INITIALIZED_ERROR = 'You must first call initialize() and set a source before calling this method';
  /**
   * @constant {string} PLAYBACK_NOT_INITIALIZED_ERROR error string thrown when a function is called before the dash.js has been fully initialized
   * @inner
   */

  var PLAYBACK_NOT_INITIALIZED_ERROR = 'You must first call initialize() and set a valid source and view before calling this method';
  /**
   * @constant {string} ELEMENT_NOT_ATTACHED_ERROR error string thrown when a function is called before the dash.js has received a reference of an HTML5 video element
   * @inner
   */

  var ELEMENT_NOT_ATTACHED_ERROR = 'You must first call attachView() to set the video element before calling this method';
  /**
   * @constant {string} SOURCE_NOT_ATTACHED_ERROR error string thrown when a function is called before the dash.js has received a valid source stream.
   * @inner
   */

  var SOURCE_NOT_ATTACHED_ERROR = 'You must first call attachSource() with a valid source before calling this method';
  /**
   * @constant {string} MEDIA_PLAYER_NOT_INITIALIZED_ERROR error string thrown when a function is called before the dash.js has been fully initialized.
   * @inner
   */

  var MEDIA_PLAYER_NOT_INITIALIZED_ERROR = 'MediaPlayer not initialized!';
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_28__["default"])(context).getInstance();
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_32__["default"])(context).getInstance();
  var debug = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_26__["default"])(context).getInstance({
    settings: settings
  });
  var instance, logger, source, protectionData, mediaPlayerInitialized, streamingInitialized, playbackInitialized, autoPlay, providedStartTime, abrController, schemeLoaderFactory, timelineConverter, mediaController, protectionController, metricsReportingController, mssHandler, offlineController, adapter, mediaPlayerModel, customParametersModel, errHandler, baseURLController, capabilities, capabilitiesFilter, streamController, textController, gapController, playbackController, serviceDescriptionController, contentSteeringController, catchupController, dashMetrics, manifestModel, cmcdModel, cmsdModel, videoModel, uriFragmentModel, domStorage, segmentBaseController;
  /*
  ---------------------------------------------------------------------------
       INIT FUNCTIONS
   ---------------------------------------------------------------------------
  */

  function setup() {
    logger = debug.getLogger(instance);
    mediaPlayerInitialized = false;
    playbackInitialized = false;
    streamingInitialized = false;
    autoPlay = true;
    providedStartTime = NaN;
    protectionController = null;
    offlineController = null;
    protectionData = null;
    adapter = null;
    segmentBaseController = null;
    _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].extend(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_30__["default"]);
    mediaPlayerModel = (0,_models_MediaPlayerModel__WEBPACK_IMPORTED_MODULE_19__["default"])(context).getInstance();
    customParametersModel = (0,_models_CustomParametersModel__WEBPACK_IMPORTED_MODULE_47__["default"])(context).getInstance();
    videoModel = (0,_models_VideoModel__WEBPACK_IMPORTED_MODULE_22__["default"])(context).getInstance();
    uriFragmentModel = (0,_models_URIFragmentModel__WEBPACK_IMPORTED_MODULE_17__["default"])(context).getInstance();
  }
  /**
   * Configure media player with customs controllers. Helpful for tests
   *
   * @param {object=} config controllers configuration
   * @memberof module:MediaPlayer
   * @instance
   */


  function setConfig(config) {
    if (!config) {
      return;
    }

    if (config.capabilities) {
      capabilities = config.capabilities;
    }

    if (config.capabilitiesFilter) {
      capabilitiesFilter = config.capabilitiesFilter;
    }

    if (config.streamController) {
      streamController = config.streamController;
    }

    if (config.textController) {
      textController = config.textController;
    }

    if (config.gapController) {
      gapController = config.gapController;
    }

    if (config.playbackController) {
      playbackController = config.playbackController;
    }

    if (config.serviceDescriptionController) {
      serviceDescriptionController = config.serviceDescriptionController;
    }

    if (config.contentSteeringController) {
      contentSteeringController = config.contentSteeringController;
    }

    if (config.catchupController) {
      catchupController = config.catchupController;
    }

    if (config.mediaPlayerModel) {
      mediaPlayerModel = config.mediaPlayerModel;
    }

    if (config.customParametersModel) {
      customParametersModel = config.customParametersModel;
    }

    if (config.abrController) {
      abrController = config.abrController;
    }

    if (config.schemeLoaderFactory) {
      schemeLoaderFactory = config.schemeLoaderFactory;
    }

    if (config.mediaController) {
      mediaController = config.mediaController;
    }

    if (config.settings) {
      settings = config.settings;
    }
  }
  /**
   * Upon creating the MediaPlayer you must call initialize before you call anything else.
   * There is one exception to this rule. It is crucial to call {@link module:MediaPlayer#extend extend()}
   * with all your extensions prior to calling initialize.
   *
   * ALL arguments are optional and there are individual methods to set each argument later on.
   * The args in this method are just for convenience and should only be used for a simple player setup.
   *
   * @param {HTML5MediaElement=} view - Optional arg to set the video element. {@link module:MediaPlayer#attachView attachView()}
   * @param {string=} source - Optional arg to set the media source. {@link module:MediaPlayer#attachSource attachSource()}
   * @param {boolean=} autoPlay - Optional arg to set auto play. {@link module:MediaPlayer#setAutoPlay setAutoPlay()}
   * @param {number|string} startTime - For VoD content the start time is relative to the start time of the first period.
   * For live content
   * If the parameter starts from prefix posix: it signifies the absolute time range defined in seconds of Coordinated Universal Time (ITU-R TF.460-6). This is the number of seconds since 01-01-1970 00:00:00 UTC. Fractions of seconds may be optionally specified down to the millisecond level.
   * If no posix prefix is used the starttime is relative to MPD@availabilityStartTime
   * @see {@link module:MediaPlayer#attachSource attachSource()}
   * @see {@link module:MediaPlayer#setAutoPlay setAutoPlay()}
   * @memberof module:MediaPlayer
   * @instance
   */


  function initialize(view, source, autoPlay) {
    var startTime = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : NaN;

    if (!capabilities) {
      capabilities = (0,_utils_Capabilities__WEBPACK_IMPORTED_MODULE_14__["default"])(context).getInstance();
      capabilities.setConfig({
        settings: settings
      });
    }

    if (!errHandler) {
      errHandler = (0,_utils_ErrorHandler__WEBPACK_IMPORTED_MODULE_13__["default"])(context).getInstance();
    }

    if (!capabilities.supportsMediaSource()) {
      errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_41__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"].CAPABILITY_MEDIASOURCE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"].CAPABILITY_MEDIASOURCE_ERROR_MESSAGE));
      return;
    }

    if (!mediaPlayerInitialized) {
      mediaPlayerInitialized = true; // init some controllers and models

      timelineConverter = (0,_dash_utils_TimelineConverter__WEBPACK_IMPORTED_MODULE_37__["default"])(context).getInstance();

      if (!abrController) {
        abrController = (0,_controllers_AbrController__WEBPACK_IMPORTED_MODULE_20__["default"])(context).getInstance();
        abrController.setConfig({
          settings: settings
        });
      }

      if (!schemeLoaderFactory) {
        schemeLoaderFactory = (0,_net_SchemeLoaderFactory__WEBPACK_IMPORTED_MODULE_21__["default"])(context).getInstance();
      }

      if (!playbackController) {
        playbackController = (0,_controllers_PlaybackController__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
      }

      if (!mediaController) {
        mediaController = (0,_controllers_MediaController__WEBPACK_IMPORTED_MODULE_10__["default"])(context).getInstance();
      }

      if (!streamController) {
        streamController = (0,_controllers_StreamController__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
      }

      if (!gapController) {
        gapController = (0,_controllers_GapController__WEBPACK_IMPORTED_MODULE_6__["default"])(context).getInstance();
      }

      if (!catchupController) {
        catchupController = (0,_controllers_CatchupController__WEBPACK_IMPORTED_MODULE_7__["default"])(context).getInstance();
      }

      if (!serviceDescriptionController) {
        serviceDescriptionController = (0,_dash_controllers_ServiceDescriptionController__WEBPACK_IMPORTED_MODULE_8__["default"])(context).getInstance();
      }

      if (!contentSteeringController) {
        contentSteeringController = (0,_dash_controllers_ContentSteeringController__WEBPACK_IMPORTED_MODULE_9__["default"])(context).getInstance();
      }

      if (!capabilitiesFilter) {
        capabilitiesFilter = (0,_utils_CapabilitiesFilter__WEBPACK_IMPORTED_MODULE_15__["default"])(context).getInstance();
      }

      adapter = (0,_dash_DashAdapter__WEBPACK_IMPORTED_MODULE_35__["default"])(context).getInstance();
      manifestModel = (0,_models_ManifestModel__WEBPACK_IMPORTED_MODULE_18__["default"])(context).getInstance();
      cmcdModel = (0,_models_CmcdModel__WEBPACK_IMPORTED_MODULE_23__["default"])(context).getInstance();
      cmsdModel = (0,_models_CmsdModel__WEBPACK_IMPORTED_MODULE_24__["default"])(context).getInstance();
      dashMetrics = (0,_dash_DashMetrics__WEBPACK_IMPORTED_MODULE_36__["default"])(context).getInstance({
        settings: settings
      });
      domStorage = (0,_utils_DOMStorage__WEBPACK_IMPORTED_MODULE_25__["default"])(context).getInstance({
        settings: settings
      });
      adapter.setConfig({
        constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"],
        cea608parser: (_externals_cea608_parser__WEBPACK_IMPORTED_MODULE_0___default()),
        errHandler: errHandler,
        BASE64: _externals_base64__WEBPACK_IMPORTED_MODULE_39__
      });

      if (!baseURLController) {
        baseURLController = (0,_controllers_BaseURLController__WEBPACK_IMPORTED_MODULE_11__["default"])(context).create();
      }

      baseURLController.setConfig({
        adapter: adapter,
        contentSteeringController: contentSteeringController
      });
      serviceDescriptionController.setConfig({
        adapter: adapter
      });

      if (!segmentBaseController) {
        segmentBaseController = (0,_dash_controllers_SegmentBaseController__WEBPACK_IMPORTED_MODULE_34__["default"])(context).getInstance({
          dashMetrics: dashMetrics,
          mediaPlayerModel: mediaPlayerModel,
          errHandler: errHandler,
          baseURLController: baseURLController,
          events: _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"],
          eventBus: eventBus,
          debug: debug,
          boxParser: (0,_utils_BoxParser__WEBPACK_IMPORTED_MODULE_45__["default"])(context).getInstance(),
          requestModifier: (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance(),
          errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"]
        });
      } // configure controllers


      mediaController.setConfig({
        domStorage: domStorage,
        settings: settings,
        customParametersModel: customParametersModel
      });
      mediaPlayerModel.setConfig({
        playbackController: playbackController,
        serviceDescriptionController: serviceDescriptionController
      });
      contentSteeringController.setConfig({
        adapter: adapter,
        errHandler: errHandler,
        dashMetrics: dashMetrics,
        mediaPlayerModel: mediaPlayerModel,
        manifestModel: manifestModel,
        serviceDescriptionController: serviceDescriptionController,
        eventBus: eventBus,
        requestModifier: (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance()
      });
      restoreDefaultUTCTimingSources();
      setAutoPlay(autoPlay !== undefined ? autoPlay : true); // Detect and initialize offline module to support offline contents playback

      _detectOffline();
    }

    if (view) {
      attachView(view);
    }

    if (source) {
      attachSource(source, startTime);
    }

    logger.info('[dash.js ' + getVersion() + '] ' + 'MediaPlayer has been initialized');
  }
  /**
   * Sets the MPD source and the video element to null. You can also reset the MediaPlayer by
   * calling attachSource with a new source file.
   *
   * This call does not destroy the MediaPlayer. To destroy the MediaPlayer and free all of its
   * memory, call destroy().
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function reset() {
    attachSource(null);
    attachView(null);
    protectionData = null;

    if (protectionController) {
      protectionController.reset();
      protectionController = null;
    }

    if (metricsReportingController) {
      metricsReportingController.reset();
      metricsReportingController = null;
    }

    if (customParametersModel) {
      customParametersModel.reset();
    }

    settings.reset();

    if (offlineController) {
      offlineController.reset();
      offlineController = null;
    }
  }
  /**
   * Completely destroys the media player and frees all memory.
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function destroy() {
    reset();
    _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_31__["default"].deleteSingletonInstances(context);
  }
  /**
   * The ready state of the MediaPlayer based on both the video element and MPD source being defined.
   *
   * @returns {boolean} The current ready state of the MediaPlayer
   * @see {@link module:MediaPlayer#attachView attachView()}
   * @see {@link module:MediaPlayer#attachSource attachSource()}
   * @memberof module:MediaPlayer
   * @instance
   */


  function isReady() {
    return !!source && !!videoModel.getElement();
  }
  /**
   * Use the on method to listen for public events found in MediaPlayer.events. {@link MediaPlayerEvents}
   *
   * @param {string} type - {@link MediaPlayerEvents}
   * @param {Function} listener - callback method when the event fires.
   * @param {Object} scope - context of the listener so it can be removed properly.
   * @param {Object} options - object to define various options such as priority and mode
   * @memberof module:MediaPlayer
   * @instance
   */


  function on(type, listener, scope, options) {
    eventBus.on(type, listener, scope, options);
  }
  /**
   * Use the off method to remove listeners for public events found in MediaPlayer.events. {@link MediaPlayerEvents}
   *
   * @param {string} type - {@link MediaPlayerEvents}
   * @param {Function} listener - callback method when the event fires.
   * @param {Object} scope - context of the listener so it can be removed properly.
   * @memberof module:MediaPlayer
   * @instance
   */


  function off(type, listener, scope) {
    eventBus.off(type, listener, scope);
  }
  /**
   * Current version of Dash.js
   * @returns {string} the current dash.js version string.
   * @memberof module:MediaPlayer
   * @instance
   */


  function getVersion() {
    return (0,_core_Version__WEBPACK_IMPORTED_MODULE_33__.getVersionString)();
  }
  /**
   * Use this method to access the dash.js logging class.
   *
   * @returns {Debug}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getDebug() {
    return debug;
  }
  /*
  ---------------------------------------------------------------------------
       PLAYBACK FUNCTIONS
   ---------------------------------------------------------------------------
  */

  /**
   * Causes the player to begin streaming the media as set by the {@link module:MediaPlayer#attachSource attachSource()}
   * method in preparation for playing. It specifically does not require a view to be attached with {@link module:MediaPlayer#attachSource attachView()} to begin preloading.
   * When a view is attached after preloading, the buffered data is transferred to the attached mediaSource buffers.
   *
   * @see {@link module:MediaPlayer#attachSource attachSource()}
   * @see {@link module:MediaPlayer#attachView attachView()}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~SOURCE_NOT_ATTACHED_ERROR SOURCE_NOT_ATTACHED_ERROR} if called before attachSource function
   * @instance
   */


  function preload() {
    if (videoModel.getElement() || streamingInitialized) {
      return;
    }

    if (source) {
      _initializePlayback(providedStartTime);
    } else {
      throw SOURCE_NOT_ATTACHED_ERROR;
    }
  }
  /**
   * The play method initiates playback of the media defined by the {@link module:MediaPlayer#attachSource attachSource()} method.
   * This method will call play on the native Video Element.
   *
   * @see {@link module:MediaPlayer#attachSource attachSource()}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function play() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    if (!autoPlay || isPaused() && playbackInitialized) {
      playbackController.play(true);
    }
  }
  /**
   * This method will call pause on the native Video Element.
   *
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function pause() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    playbackController.pause();
  }
  /**
   * Returns a Boolean that indicates whether the Video Element is paused.
   * @return {boolean}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function isPaused() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return playbackController.isPaused();
  }
  /**
   * Sets the currentTime property of the attached video element.  If it is a live stream with a
   * timeShiftBufferLength, then the DVR window offset will be automatically calculated.
   *
   * @param {number} value - A relative time, in seconds, based on the return value of the {@link module:MediaPlayer#duration duration()} method is expected.
   * For dynamic streams duration() returns DVRWindow.end - DVRWindow.start. Consequently, the value provided to this function should be relative to DVRWindow.start.
   * @see {@link module:MediaPlayer#getDVRSeekOffset getDVRSeekOffset()}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with an invalid argument, not number type or is NaN.
   * @memberof module:MediaPlayer
   * @instance
   */


  function seek(value) {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_42__.checkParameterType)(value, 'number');

    if (isNaN(value)) {
      throw _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].BAD_ARGUMENT_ERROR;
    }

    if (value < 0) {
      value = 0;
    }

    var s = playbackController.getIsDynamic() ? getDVRSeekOffset(value) : value; // For VoD limit the seek to the duration of the content

    var videoElement = getVideoElement();

    if (!playbackController.getIsDynamic() && videoElement.duration) {
      s = Math.min(videoElement.duration, s);
    }

    playbackController.seek(s, false, false, true);
  }
  /**
   * Seeks back to the original live edge (live edge as calculated at playback start). Only applies to live streams, for VoD streams this call will be ignored.
   */


  function seekToOriginalLive() {
    if (!playbackInitialized || !isDynamic()) {
      return;
    }

    playbackController.seekToOriginalLive();
  }
  /**
   * Returns a Boolean that indicates whether the media is in the process of seeking to a new position.
   * @return {boolean}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function isSeeking() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return playbackController.isSeeking();
  }
  /**
   * Returns a Boolean that indicates whether the media is in the process of dynamic.
   * @return {boolean}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function isDynamic() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return playbackController.getIsDynamic();
  }
  /**
   * Returns a boolean that indicates whether the player is operating in low latency mode.
   * @return {boolean}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getLowLatencyModeEnabled() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return playbackController.getLowLatencyModeEnabled();
  }
  /**
   * Use this method to set the native Video Element's playback rate.
   * @param {number} value
   * @memberof module:MediaPlayer
   * @instance
   */


  function setPlaybackRate(value) {
    getVideoElement().playbackRate = value;
  }
  /**
   * Returns the current playback rate.
   * @returns {number}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getPlaybackRate() {
    return getVideoElement().playbackRate;
  }
  /**
   * Use this method to set the native Video Element's muted state. Takes a Boolean that determines whether audio is muted. true if the audio is muted and false otherwise.
   * @param {boolean} value
   * @memberof module:MediaPlayer
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with an invalid argument, not boolean type.
   * @instance
   */


  function setMute(value) {
    (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_42__.checkParameterType)(value, 'boolean');
    getVideoElement().muted = value;
  }
  /**
   * A Boolean that determines whether audio is muted.
   * @returns {boolean}
   * @memberof module:MediaPlayer
   * @instance
   */


  function isMuted() {
    return getVideoElement().muted;
  }
  /**
   * A double indicating the audio volume, from 0.0 (silent) to 1.0 (loudest).
   * @param {number} value
   * @memberof module:MediaPlayer
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with an invalid argument, not number type, or is NaN or not between 0 and 1.
   * @instance
   */


  function setVolume(value) {
    if (typeof value !== 'number' || isNaN(value) || value < 0.0 || value > 1.0) {
      throw _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].BAD_ARGUMENT_ERROR;
    }

    getVideoElement().volume = value;
  }
  /**
   * Returns the current audio volume, from 0.0 (silent) to 1.0 (loudest).
   * @returns {number}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getVolume() {
    return getVideoElement().volume;
  }
  /**
   * The length of the buffer for a given media type, in seconds. Valid media
   * types are "video", "audio" and "text". If no type is passed
   * in, then the minimum of video, audio and text buffer length is
   * returned. NaN is returned if an invalid type is requested, the
   * presentation does not contain that type, or if no arguments are passed
   * and the presentation does not include any adaption sets of valid media
   * type.
   *
   * @param {MediaType} type - 'video', 'audio' or 'text'
   * @returns {number} The length of the buffer for the given media type, in
   *  seconds, or NaN
   * @memberof module:MediaPlayer
   * @instance
   */


  function getBufferLength(type) {
    var types = [_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO, _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO, _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].TEXT];

    if (!type) {
      var buffer = types.map(function (t) {
        return getTracksFor(t).length > 0 ? getDashMetrics().getCurrentBufferLevel(t) : Number.MAX_VALUE;
      }).reduce(function (p, c) {
        return Math.min(p, c);
      });
      return buffer === Number.MAX_VALUE ? NaN : buffer;
    } else {
      if (types.indexOf(type) !== -1) {
        var _buffer = getDashMetrics().getCurrentBufferLevel(type);

        return _buffer ? _buffer : NaN;
      } else {
        logger.warn('getBufferLength requested for invalid type');
        return NaN;
      }
    }
  }
  /**
   * The timeShiftBufferLength (DVR Window), in seconds.
   *
   * @returns {number} The window of allowable play time behind the live point of a live stream as defined in the manifest.
   * @memberof module:MediaPlayer
   * @instance
   */


  function getDVRWindowSize() {
    var type = streamController && streamController.hasVideoTrack() ? _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO : _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO;
    var metric = dashMetrics.getCurrentDVRInfo(type);

    if (!metric) {
      return 0;
    }

    return metric.manifestInfo.dvrWindowSize;
  }
  /**
   * This method should only be used with a live stream that has a valid timeShiftBufferLength (DVR Window).
   * NOTE - If you do not need the raw offset value (i.e. media analytics, tracking, etc) consider using the {@link module:MediaPlayer#seek seek()} method
   * which will calculate this value for you and set the video element's currentTime property all in one simple call.
   *
   * @param {number} value - A relative time, in seconds, based on the return value of the {@link module:MediaPlayer#duration duration()} method is expected.
   * @returns {number} A value that is relative the available range within the timeShiftBufferLength (DVR Window).
   * @see {@link module:MediaPlayer#seek seek()}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getDVRSeekOffset(value) {
    var type = streamController && streamController.hasVideoTrack() ? _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO : _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO;
    var metric = dashMetrics.getCurrentDVRInfo(type);

    if (!metric) {
      return 0;
    }

    var liveDelay = playbackController.getOriginalLiveDelay();
    var val = metric.range.start + value;

    if (val > metric.range.end - liveDelay) {
      val = metric.range.end - liveDelay;
    }

    return val;
  }
  /**
   * Returns the target live delay
   * @returns {number} The target live delay
   * @memberof module:MediaPlayer
   * @instance
   */


  function getTargetLiveDelay() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return playbackController.getOriginalLiveDelay();
  }
  /**
   * Current time of the playhead, in seconds.
   *
   * If called with no arguments then the returned time value is time elapsed since the start point of the first stream, or if it is a live stream, then the time will be based on the return value of the {@link module:MediaPlayer#duration duration()} method.
   * However if a stream ID is supplied then time is relative to the start of that stream, or is null if there is no such stream id in the manifest.
   *
   * @param {string} streamId - The ID of a stream that the returned playhead time must be relative to the start of. If undefined, then playhead time is relative to the first stream.
   * @returns {number} The current playhead time of the media, or null.
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function time(streamId) {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    var t = getVideoElement().currentTime;

    if (streamId !== undefined) {
      t = streamController.getTimeRelativeToStreamId(t, streamId);
    } else if (playbackController.getIsDynamic()) {
      var type = streamController && streamController.hasVideoTrack() ? _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO : _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO;
      var metric = dashMetrics.getCurrentDVRInfo(type);
      t = metric === null || t === 0 ? 0 : Math.max(0, t - metric.range.start);
    }

    return t;
  }
  /**
   * Duration of the media's playback, in seconds.
   *
   * @returns {number} The current duration of the media. For a dynamic stream this will return DVRWindow.end - DVRWindow.start
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function duration() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    var d = getVideoElement().duration;

    if (playbackController.getIsDynamic()) {
      var type = streamController && streamController.hasVideoTrack() ? _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO : _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO;
      var metric = dashMetrics.getCurrentDVRInfo(type);
      d = metric ? metric.range.end - metric.range.start : 0;
    }

    return d;
  }
  /**
   * Use this method to get the current playhead time as an absolute value, the time in seconds since midnight UTC, Jan 1 1970.
   * Note - this property only has meaning for live streams. If called before play() has begun, it will return a value of NaN.
   *
   * @returns {number} The current playhead time as UTC timestamp.
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function timeAsUTC() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    if (time() < 0) {
      return NaN;
    }

    return _getAsUTC(time());
  }
  /**
   * Use this method to get the current duration as an absolute value, the time in seconds since midnight UTC, Jan 1 1970.
   * Note - this property only has meaning for live streams.
   *
   * @returns {number} The current duration as UTC timestamp.
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function durationAsUTC() {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    return _getAsUTC(duration());
  }
  /*
  ---------------------------------------------------------------------------
       AUTO BITRATE
   ---------------------------------------------------------------------------
  */

  /**
   * Gets the top quality BitrateInfo checking portal limit and max allowed.
   * It calls getMaxAllowedIndexFor internally
   *
   * @param {MediaType} type - 'video' or 'audio'
   * @memberof module:MediaPlayer
   * @returns {BitrateInfo | null}
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getTopBitrateInfoFor(type) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    return abrController.getTopBitrateInfoFor(type);
  }
  /**
   * Gets the current download quality for media type video, audio or images. For video and audio types the ABR
   * rules update this value before every new download unless autoSwitchBitrate is set to false. For 'image'
   * type, thumbnails, there is no ABR algorithm and quality is set manually.
   *
   * @param {MediaType} type - 'video', 'audio' or 'image' (thumbnails)
   * @returns {number} the quality index, 0 corresponding to the lowest bitrate
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#setQualityFor setQualityFor()}
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getQualityFor(type) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].IMAGE) {
      var activeStream = getActiveStream();

      if (!activeStream) {
        return -1;
      }

      var thumbnailController = activeStream.getThumbnailController();
      return !thumbnailController ? -1 : thumbnailController.getCurrentTrackIndex();
    }

    return abrController.getQualityFor(type);
  }
  /**
   * Sets the current quality for media type instead of letting the ABR Heuristics automatically selecting it.
   * This value will be overwritten by the ABR rules unless autoSwitchBitrate is set to false.
   *
   * @param {MediaType} type - 'video', 'audio' or 'image'
   * @param {number} value - the quality index, 0 corresponding to the lowest bitrate
   * @param {boolean} forceReplace - true if segments have to be replaced by segments of the new quality
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#getQualityFor getQualityFor()}
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function setQualityFor(type, value) {
    var forceReplace = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].IMAGE) {
      var activeStream = getActiveStream();

      if (!activeStream) {
        return;
      }

      var thumbnailController = activeStream.getThumbnailController();

      if (thumbnailController) {
        thumbnailController.setTrackByIndex(value);
      }
    }

    abrController.setPlaybackQuality(type, streamController.getActiveStreamInfo(), value, {
      forceReplace: forceReplace
    });
  }
  /**
   * Update the video element size variables
   * Should be called on window resize (or any other time player is resized). Fullscreen does trigger a window resize event.
   *
   * Once windowResizeEventCalled = true, abrController.checkPortalSize() will use element size variables rather than querying clientWidth every time.
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function updatePortalSize() {
    abrController.setElementSize();
    abrController.setWindowResizeEventCalled(true);
  }
  /*
  ---------------------------------------------------------------------------
       MEDIA PLAYER CONFIGURATION
   ---------------------------------------------------------------------------
  */

  /**
   * <p>Set to false to prevent stream from auto-playing when the view is attached.</p>
   *
   * @param {boolean} value
   * @default true
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#attachView attachView()}
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with an invalid argument, not boolean type.
   * @instance
   *
   */


  function setAutoPlay(value) {
    (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_42__.checkParameterType)(value, 'boolean');
    autoPlay = value;
  }
  /**
   * @returns {boolean} The current autoPlay state.
   * @memberof module:MediaPlayer
   * @instance
   */


  function getAutoPlay() {
    return autoPlay;
  }
  /**
   * @memberof module:MediaPlayer
   * @instance
   * @returns {number|NaN} Current live stream latency in seconds. It is the difference between now time and time position at the playback head.
   * @throws {@link module:MediaPlayer~MEDIA_PLAYER_NOT_INITIALIZED_ERROR MEDIA_PLAYER_NOT_INITIALIZED_ERROR} if called before initialize function
   */


  function getCurrentLiveLatency() {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    if (!playbackInitialized) {
      return NaN;
    }

    return playbackController.getCurrentLiveLatency();
  }
  /**
   * Add a custom ABR Rule
   * Rule will be apply on next stream if a stream is being played
   *
   * @param {string} type - rule type (one of ['qualitySwitchRules','abandonFragmentRules'])
   * @param {string} rulename - name of rule (used to identify custom rule). If one rule of same name has been added, then existing rule will be updated
   * @param {object} rule - the rule object instance
   * @memberof module:MediaPlayer
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with invalid arguments.
   * @instance
   */


  function addABRCustomRule(type, rulename, rule) {
    customParametersModel.addAbrCustomRule(type, rulename, rule);
  }
  /**
   * Remove a custom ABR Rule
   *
   * @param {string} rulename - name of the rule to be removed
   * @memberof module:MediaPlayer
   * @instance
   */


  function removeABRCustomRule(rulename) {
    customParametersModel.removeAbrCustomRule(rulename);
  }
  /**
   * Remove all ABR custom rules
   * @memberof module:MediaPlayer
   * @instance
   */


  function removeAllABRCustomRule() {
    customParametersModel.removeAllAbrCustomRule();
  }
  /**
   * Returns all ABR custom rules
   * @return {Array}
   */


  function getABRCustomRules() {
    return customParametersModel.getAbrCustomRules();
  }
  /**
   * <p>Allows you to set a scheme and server source for UTC live edge detection for dynamic streams.
   * If UTCTiming is defined in the manifest, it will take precedence over any time source manually added.</p>
   * <p>If you have exposed the Date header, use the method {@link module:MediaPlayer#clearDefaultUTCTimingSources clearDefaultUTCTimingSources()}.
   * This will allow the date header on the manifest to be used instead of a time server</p>
   * @param {string} schemeIdUri - <ul>
   * <li>urn:mpeg:dash:utc:http-head:2014</li>
   * <li>urn:mpeg:dash:utc:http-xsdate:2014</li>
   * <li>urn:mpeg:dash:utc:http-iso:2014</li>
   * <li>urn:mpeg:dash:utc:direct:2014</li>
   * </ul>
   * <p>Some specs referencing early ISO23009-1 drafts incorrectly use
   * 2012 in the URI, rather than 2014. support these for now.</p>
   * <ul>
   * <li>urn:mpeg:dash:utc:http-head:2012</li>
   * <li>urn:mpeg:dash:utc:http-xsdate:2012</li>
   * <li>urn:mpeg:dash:utc:http-iso:2012</li>
   * <li>urn:mpeg:dash:utc:direct:2012</li>
   * </ul>
   * @param {string} value - Path to a time source.
   * @default
   * <ul>
   *     <li>schemeIdUri:urn:mpeg:dash:utc:http-xsdate:2014</li>
   *     <li>value:http://time.akamai.com/?iso&ms/li>
   * </ul>
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#removeUTCTimingSource removeUTCTimingSource()}
   * @instance
   */


  function addUTCTimingSource(schemeIdUri, value) {
    customParametersModel.addUTCTimingSource(schemeIdUri, value);
  }
  /**
   * <p>Allows you to remove a UTC time source. Both schemeIdUri and value need to match the Dash.vo.UTCTiming properties in order for the
   * entry to be removed from the array</p>
   * @param {string} schemeIdUri - see {@link module:MediaPlayer#addUTCTimingSource addUTCTimingSource()}
   * @param {string} value - see {@link module:MediaPlayer#addUTCTimingSource addUTCTimingSource()}
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#clearDefaultUTCTimingSources clearDefaultUTCTimingSources()}
   * @throws {@link Constants#BAD_ARGUMENT_ERROR BAD_ARGUMENT_ERROR} if called with invalid arguments, schemeIdUri and value are not string type.
   * @instance
   */


  function removeUTCTimingSource(schemeIdUri, value) {
    customParametersModel.removeUTCTimingSource(schemeIdUri, value);
  }
  /**
   * <p>Allows you to clear the stored array of time sources.</p>
   * <p>Example use: If you have exposed the Date header, calling this method
   * will allow the date header on the manifest to be used instead of the time server.</p>
   * <p>Example use: Calling this method, assuming there is not an exposed date header on the manifest,  will default back
   * to using a binary search to discover the live edge</p>
   *
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#restoreDefaultUTCTimingSources restoreDefaultUTCTimingSources()}
   * @instance
   */


  function clearDefaultUTCTimingSources() {
    customParametersModel.clearDefaultUTCTimingSources();
  }
  /**
   * <p>Allows you to restore the default time sources after calling {@link module:MediaPlayer#clearDefaultUTCTimingSources clearDefaultUTCTimingSources()}</p>
   *
   * @default
   * <ul>
   *     <li>schemeIdUri:urn:mpeg:dash:utc:http-xsdate:2014</li>
   *     <li>value:http://time.akamai.com/?iso&ms</li>
   * </ul>
   *
   * @memberof module:MediaPlayer
   * @see {@link module:MediaPlayer#addUTCTimingSource addUTCTimingSource()}
   * @instance
   */


  function restoreDefaultUTCTimingSources() {
    customParametersModel.restoreDefaultUTCTimingSources();
  }
  /**
   * Returns the average throughput computed in the ABR logic
   *
   * @param {MediaType} type
   * @return {number} value
   * @memberof module:MediaPlayer
   * @instance
   */


  function getAverageThroughput(type) {
    var throughputHistory = abrController.getThroughputHistory();
    var isDynamic = playbackController.getIsDynamic();
    return throughputHistory ? throughputHistory.getAverageThroughput(type, isDynamic) : 0;
  }
  /**
   * Sets whether withCredentials on XHR requests for a particular request
   * type is true or false
   *
   * @default false
   * @param {string} type - one of HTTPRequest.*_TYPE
   * @param {boolean} value
   * @memberof module:MediaPlayer
   * @instance
   */


  function setXHRWithCredentialsForType(type, value) {
    customParametersModel.setXHRWithCredentialsForType(type, value);
  }
  /**
   * Gets whether withCredentials on XHR requests for a particular request
   * type is true or false
   *
   * @param {string} type - one of HTTPRequest.*_TYPE
   * @return {boolean}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getXHRWithCredentialsForType(type) {
    return customParametersModel.getXHRWithCredentialsForType(type);
  }
  /*
  ---------------------------------------------------------------------------
       OFFLINE
   ---------------------------------------------------------------------------
  */

  /**
   * Detects if Offline is included and returns an instance of OfflineController.js
   * @memberof module:MediaPlayer
   * @instance
   */


  function getOfflineController() {
    return _detectOffline();
  }
  /*
  ---------------------------------------------------------------------------
       METRICS
   ---------------------------------------------------------------------------
  */

  /**
   * Returns the DashMetrics.js Module. You use this Module to get access to all the public metrics
   * stored in dash.js
   *
   * @see {@link module:DashMetrics}
   * @returns {Object}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getDashMetrics() {
    return dashMetrics;
  }
  /*
  ---------------------------------------------------------------------------
       TEXT MANAGEMENT
   ---------------------------------------------------------------------------
  */

  /**
   * Enable/disable text
   * When enabling text, dash will choose the previous selected text track
   *
   * @param {boolean} enable - true to enable text, false otherwise (same as setTextTrack(-1))
   * @memberof module:MediaPlayer
   * @instance
   */


  function enableText(enable) {
    var activeStreamInfo = streamController.getActiveStreamInfo();

    if (!activeStreamInfo || !textController) {
      return false;
    }

    return textController.enableText(activeStreamInfo.id, enable);
  }
  /**
   * Enable/disable text
   * When enabling dash will keep downloading and process fragmented text tracks even if all tracks are in mode "hidden"
   *
   * @param {boolean} enable - true to enable text streaming even if all text tracks are hidden.
   * @memberof module:MediaPlayer
   * @instance
   */


  function enableForcedTextStreaming(enable) {
    var activeStreamInfo = streamController.getActiveStreamInfo();

    if (!activeStreamInfo || !textController) {
      return false;
    }

    return textController.enableForcedTextStreaming(enable);
  }
  /**
   * Return if text is enabled
   *
   * @return {boolean} return true if text is enabled, false otherwise
   * @memberof module:MediaPlayer
   * @instance
   */


  function isTextEnabled() {
    var activeStreamInfo = streamController.getActiveStreamInfo();

    if (!activeStreamInfo || !textController) {
      return false;
    }

    return textController.isTextEnabled(activeStreamInfo);
  }
  /**
   * Use this method to change the current text track for both external time text files and fragmented text tracks. There is no need to
   * set the track mode on the video object to switch a track when using this method.
   * @param {number} idx - Index of track based on the order of the order the tracks are added Use -1 to disable all tracks. (turn captions off).  Use module:MediaPlayer#dashjs.MediaPlayer.events.TEXT_TRACK_ADDED.
   * @see {@link MediaPlayerEvents#event:TEXT_TRACK_ADDED dashjs.MediaPlayer.events.TEXT_TRACK_ADDED}
   * @throws {@link module:MediaPlayer~PLAYBACK_NOT_INITIALIZED_ERROR PLAYBACK_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function setTextTrack(idx) {
    if (!playbackInitialized) {
      throw PLAYBACK_NOT_INITIALIZED_ERROR;
    }

    var activeStreamInfo = streamController.getActiveStreamInfo();

    if (!activeStreamInfo || !textController) {
      return;
    }

    textController.setTextTrack(activeStreamInfo.id, idx);
  }

  function getCurrentTextTrackIndex() {
    var idx = NaN;
    var activeStreamInfo = streamController.getActiveStreamInfo();

    if (!activeStreamInfo || !textController) {
      return;
    }

    idx = textController.getCurrentTrackIdx(activeStreamInfo.id);
    return idx;
  }
  /*
  ---------------------------------------------------------------------------
       VIDEO ELEMENT MANAGEMENT
   ---------------------------------------------------------------------------
  */

  /**
   * Returns instance of Video Element that was attached by calling attachView()
   * @returns {Object}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~ELEMENT_NOT_ATTACHED_ERROR ELEMENT_NOT_ATTACHED_ERROR} if called before attachView function
   * @instance
   */


  function getVideoElement() {
    if (!videoModel.getElement()) {
      throw ELEMENT_NOT_ATTACHED_ERROR;
    }

    return videoModel.getElement();
  }
  /**
   * Use this method to attach an HTML5 VideoElement for dash.js to operate upon.
   *
   * @param {Object} element - An HTMLMediaElement that has already been defined in the DOM (or equivalent stub).
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~MEDIA_PLAYER_NOT_INITIALIZED_ERROR MEDIA_PLAYER_NOT_INITIALIZED_ERROR} if called before initialize function
   * @instance
   */


  function attachView(element) {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    videoModel.setElement(element);

    if (element) {
      _detectProtection();

      _detectMetricsReporting();

      _detectMss();

      if (streamController) {
        streamController.switchToVideoElement(providedStartTime);
      }
    }

    if (playbackInitialized) {
      //Reset if we have been playing before, so this is a new element.
      _resetPlaybackControllers();
    }

    _initializePlayback(providedStartTime);
  }
  /**
   * Returns instance of Div that was attached by calling attachTTMLRenderingDiv()
   * @returns {Object}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getTTMLRenderingDiv() {
    return videoModel ? videoModel.getTTMLRenderingDiv() : null;
  }
  /**
   * Use this method to attach an HTML5 div for dash.js to render rich TTML subtitles.
   *
   * @param {HTMLDivElement} div - An unstyled div placed after the video element. It will be styled to match the video size and overlay z-order.
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~ELEMENT_NOT_ATTACHED_ERROR ELEMENT_NOT_ATTACHED_ERROR} if called before attachView function
   * @instance
   */


  function attachTTMLRenderingDiv(div) {
    if (!videoModel.getElement()) {
      throw ELEMENT_NOT_ATTACHED_ERROR;
    }

    videoModel.setTTMLRenderingDiv(div);
  }

  function attachVttRenderingDiv(div) {
    if (!videoModel.getElement()) {
      throw ELEMENT_NOT_ATTACHED_ERROR;
    }

    videoModel.setVttRenderingDiv(div);
  }
  /*
  ---------------------------------------------------------------------------
       STREAM AND TRACK MANAGEMENT
   ---------------------------------------------------------------------------
  */

  /**
   * @param {MediaType} type
   * @returns {Array}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getBitrateInfoListFor(type) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    var stream = getActiveStream();
    return stream ? stream.getBitrateListFor(type) : [];
  }
  /**
   * This method returns the list of all available streams from a given manifest
   * @param {Object} manifest
   * @returns {Array} list of {@link StreamInfo}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getStreamsFromManifest(manifest) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    return adapter.getStreamsInfo(manifest);
  }
  /**
   * This method returns the list of all available tracks for a given media type
   * @param {MediaType} type
   * @returns {Array} list of {@link MediaInfo}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getTracksFor(type) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    var streamInfo = streamController.getActiveStreamInfo();

    if (!streamInfo) {
      return [];
    }

    return mediaController.getTracksFor(type, streamInfo.id);
  }
  /**
   * This method returns the list of all available tracks for a given media type and streamInfo from a given manifest
   * @param {MediaType} type
   * @param {Object} manifest
   * @param {Object} streamInfo
   * @returns {Array}  list of {@link MediaInfo}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getTracksForTypeFromManifest(type, manifest, streamInfo) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    streamInfo = streamInfo || adapter.getStreamsInfo(manifest, 1)[0];
    return streamInfo ? adapter.getAllMediaInfoForType(streamInfo, type, manifest) : [];
  }
  /**
   * @param {MediaType} type
   * @returns {Object|null} {@link MediaInfo}
   *
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function getCurrentTrackFor(type) {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    var streamInfo = streamController.getActiveStreamInfo();
    return mediaController.getCurrentTrackFor(type, streamInfo.id);
  }
  /**
   * This method allows to set media settings that will be used to pick the initial track. Format of the settings
   * is following: <br />
   * {lang: langValue (can be either a string primitive, a string object, or a RegExp object to match),
   *  index: indexValue,
   *  viewpoint: viewpointValue,
   *  audioChannelConfiguration: audioChannelConfigurationValue,
   *  accessibility: accessibilityValue,
   *  role: roleValue}
   *
   * @param {MediaType} type
   * @param {Object} value
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~MEDIA_PLAYER_NOT_INITIALIZED_ERROR MEDIA_PLAYER_NOT_INITIALIZED_ERROR} if called before initialize function
   * @instance
   */


  function setInitialMediaSettingsFor(type, value) {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    mediaController.setInitialSettings(type, value);
  }
  /**
   * This method returns media settings that is used to pick the initial track. Format of the settings
   * is following:
   * {lang: langValue,
   *  index: indexValue,
   *  viewpoint: viewpointValue,
   *  audioChannelConfiguration: audioChannelConfigurationValue,
   *  accessibility: accessibilityValue,
   *  role: roleValue}
   * @param {MediaType} type
   * @returns {Object}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~MEDIA_PLAYER_NOT_INITIALIZED_ERROR MEDIA_PLAYER_NOT_INITIALIZED_ERROR} if called before initialize function
   * @instance
   */


  function getInitialMediaSettingsFor(type) {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    return mediaController.getInitialSettings(type);
  }
  /**
   * @param {MediaInfo} track - instance of {@link MediaInfo}
   * @param {boolean} [noSettingsSave] - specify if settings from the track must not be saved for incoming track selection
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @instance
   */


  function setCurrentTrack(track) {
    var noSettingsSave = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    mediaController.setTrack(track, noSettingsSave);
  }
  /*
  ---------------------------------------------------------------------------
       Custom filter and callback functions
   ---------------------------------------------------------------------------
  */

  /**
   * Registers a custom capabilities filter. This enables application to filter representations to use.
   * The provided callback function shall return a boolean based on whether or not to use the representation.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the custom capabilities filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function registerCustomCapabilitiesFilter(filter) {
    customParametersModel.registerCustomCapabilitiesFilter(filter);
  }
  /**
   * Unregisters a custom capabilities filter.
   * @param {function} filter - the custom capabilities filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function unregisterCustomCapabilitiesFilter(filter) {
    customParametersModel.unregisterCustomCapabilitiesFilter(filter);
  }
  /**
   * Registers a custom initial track selection function. Only one function is allowed. Calling this method will overwrite a potentially existing function.
   * @param {function} customFunc - the custom function that returns the initial track
   */


  function setCustomInitialTrackSelectionFunction(customFunc) {
    customParametersModel.setCustomInitialTrackSelectionFunction(customFunc);
  }
  /**
   * Resets the custom initial track selection
   */


  function resetCustomInitialTrackSelectionFunction() {
    customParametersModel.resetCustomInitialTrackSelectionFunction(null);
  }
  /**
   * Registers a license request filter. This enables application to manipulate/overwrite any request parameter and/or request data.
   * The provided callback function shall return a promise that shall be resolved once the filter process is completed.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the license request filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function registerLicenseRequestFilter(filter) {
    customParametersModel.registerLicenseRequestFilter(filter);
  }
  /**
   * Registers a license response filter. This enables application to manipulate/overwrite the response data
   * The provided callback function shall return a promise that shall be resolved once the filter process is completed.
   * The filters are applied in the order they are registered.
   * @param {function} filter - the license response filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function registerLicenseResponseFilter(filter) {
    customParametersModel.registerLicenseResponseFilter(filter);
  }
  /**
   * Unregisters a license request filter.
   * @param {function} filter - the license request filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function unregisterLicenseRequestFilter(filter) {
    customParametersModel.unregisterLicenseRequestFilter(filter);
  }
  /**
   * Unregisters a license response filter.
   * @param {function} filter - the license response filter callback
   * @memberof module:MediaPlayer
   * @instance
   */


  function unregisterLicenseResponseFilter(filter) {
    customParametersModel.unregisterLicenseResponseFilter(filter);
  }
  /*
  ---------------------------------------------------------------------------
       PROTECTION MANAGEMENT
   ---------------------------------------------------------------------------
  */

  /**
   * Detects if Protection is included and returns an instance of ProtectionController.js
   * @memberof module:MediaPlayer
   * @instance
   */


  function getProtectionController() {
    return _detectProtection();
  }
  /**
   * Will override dash.js protection controller.
   * @param {ProtectionController} value - valid protection controller instance.
   * @memberof module:MediaPlayer
   * @instance
   */


  function attachProtectionController(value) {
    protectionController = value;
  }
  /**
   * Sets Protection Data required to setup the Protection Module (DRM). Protection Data must
   * be set before initializing MediaPlayer or, once initialized, before PROTECTION_CREATED event is fired.
   * @see {@link module:MediaPlayer#initialize initialize()}
   * @see {@link ProtectionEvents#event:PROTECTION_CREATED dashjs.Protection.events.PROTECTION_CREATED}
   * @param {ProtectionDataSet} value - object containing
   * property names corresponding to key system name strings and associated
   * values being instances of.
   * @memberof module:MediaPlayer
   * @instance
   */


  function setProtectionData(value) {
    protectionData = value; // Propagate changes in case StreamController is already created

    if (streamController) {
      streamController.setProtectionData(protectionData);
    }
  }
  /*
  ---------------------------------------------------------------------------
       THUMBNAILS MANAGEMENT
   ---------------------------------------------------------------------------
  */

  /**
   * Provide the thumbnail at time position. This can be asynchronous, so you must provide a callback ro retrieve thumbnails informations
   * @param {number} time - A relative time, in seconds, based on the return value of the {@link module:MediaPlayer#duration duration()} method is expected
   * @param {function} callback - A Callback function provided when retrieving thumbnail the given time position. Thumbnail object is null in case there are is not a thumbnails representation or
   * if it doesn't contain a thumbnail for the given time position.
   * @memberof module:MediaPlayer
   * @instance
   */


  function provideThumbnail(time, callback) {
    if (typeof callback !== 'function') {
      return;
    }

    if (time < 0) {
      callback(null);
      return;
    }

    var s = playbackController.getIsDynamic() ? getDVRSeekOffset(time) : time;
    var stream = streamController.getStreamForTime(s);

    if (stream === null) {
      callback(null);
      return;
    }

    var thumbnailController = stream.getThumbnailController();

    if (!thumbnailController) {
      callback(null);
      return;
    }

    return thumbnailController.provide(s, callback);
  }
  /*
  ---------------------------------------------------------------------------
       TOOLS AND OTHERS FUNCTIONS
   ---------------------------------------------------------------------------
  */

  /**
   * Allows application to retrieve a manifest.  Manifest loading is asynchronous and requires the app-provided callback function
   *
   * @param {string} url - url the manifest url
   * @param {function} callback - A Callback function provided when retrieving manifests
   * @memberof module:MediaPlayer
   * @instance
   */


  function retrieveManifest(url, callback) {
    var manifestLoader = _createManifestLoader();

    var self = this;

    var handler = function handler(e) {
      if (!e.error) {
        callback(e.manifest);
      } else {
        callback(null, e.error);
      }

      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].INTERNAL_MANIFEST_LOADED, handler, self);
      manifestLoader.reset();
    };

    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].INTERNAL_MANIFEST_LOADED, handler, self);
    uriFragmentModel.initialize(url);
    manifestLoader.load(url);
  }
  /**
   * Returns the source string or manifest that was attached by calling attachSource()
   * @returns {string | manifest}
   * @memberof module:MediaPlayer
   * @throws {@link module:MediaPlayer~SOURCE_NOT_ATTACHED_ERROR SOURCE_NOT_ATTACHED_ERROR} if called before attachSource function
   * @instance
   */


  function getSource() {
    if (!source) {
      throw SOURCE_NOT_ATTACHED_ERROR;
    }

    return source;
  }
  /**
   * Sets the source to a new manifest URL or object without reloading
   * Useful for updating CDN tokens
   * @param urlOrManifest
   */


  function updateSource(urlOrManifest) {
    source = urlOrManifest;
    streamController.load(source);
  }
  /**
   * Use this method to set a source URL to a valid MPD manifest file OR
   * a previously downloaded and parsed manifest object.  Optionally, can
   * also provide protection information
   *
   * @param {string|Object} urlOrManifest - A URL to a valid MPD manifest file, or a
   * parsed manifest object.
   * @param {number|string} startTime - For VoD content the start time is relative to the start time of the first period.
   * For live content
   * If the parameter starts from prefix posix: it signifies the absolute time range defined in seconds of Coordinated Universal Time (ITU-R TF.460-6). This is the number of seconds since 01-01-1970 00:00:00 UTC. Fractions of seconds may be optionally specified down to the millisecond level.
   * If no posix prefix is used the starttime is relative to MPD@availabilityStartTime
   *
   * @throws {@link module:MediaPlayer~MEDIA_PLAYER_NOT_INITIALIZED_ERROR MEDIA_PLAYER_NOT_INITIALIZED_ERROR} if called before initialize function
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function attachSource(urlOrManifest) {
    var startTime = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : NaN;

    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    if (typeof urlOrManifest === 'string') {
      uriFragmentModel.initialize(urlOrManifest);
    }

    if (startTime == null) {
      startTime = NaN;
    }

    if (!isNaN(startTime)) {
      startTime = Math.max(0, startTime);
    }

    providedStartTime = startTime;
    source = urlOrManifest;

    if (streamingInitialized || playbackInitialized) {
      _resetPlaybackControllers();
    }

    if (isReady()) {
      _initializePlayback(providedStartTime);
    }
  }
  /**
   *  Reload the manifest that the player is currently using.
   *
   *  @memberof module:MediaPlayer
   *  @param {function} callback - A Callback function provided when retrieving manifests
   *  @instance
   */


  function refreshManifest(callback) {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    if (!isReady()) {
      return callback(null, SOURCE_NOT_ATTACHED_ERROR);
    }

    var self = this;

    if (typeof callback === 'function') {
      var handler = function handler(e) {
        eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].INTERNAL_MANIFEST_LOADED, handler, self);

        if (e.error) {
          callback(null, e.error);
          return;
        }

        callback(e.manifest);
      };

      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].INTERNAL_MANIFEST_LOADED, handler, self);
    }

    streamController.refreshManifest();
  }
  /**
   * Get the current settings object being used on the player.
   * @returns {PlayerSettings} The settings object being used.
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function getSettings() {
    return settings.get();
  }
  /**
   * @summary Update the current settings object being used on the player. Anything left unspecified is not modified.
   * @param {PlayerSettings} settingsObj - An object corresponding to the settings definition.
   * @description This function does not update the entire object, only properties in the passed in object are updated.
   *
   * This means that updateSettings({a: x}) and updateSettings({b: y}) are functionally equivalent to
   * updateSettings({a: x, b: y}). If the default values are required again, @see{@link resetSettings}.
   * @example
   * player.updateSettings({
   *      streaming: {
   *          lowLatencyEnabled: false,
   *          abr: {
   *              maxBitrate: { audio: 100, video: 1000 }
   *          }
   *      }
   *  });
   * @memberof module:MediaPlayer
   * @instance
   */


  function updateSettings(settingsObj) {
    settings.update(settingsObj);
  }
  /**
   * Resets the settings object back to the default.
   *
   * @memberof module:MediaPlayer
   * @instance
   */


  function resetSettings() {
    settings.reset();
  }
  /**
   * A utility methods which converts UTC timestamp value into a valid time and date string.
   *
   * @param {number} time - UTC timestamp to be converted into date and time.
   * @param {string} locales - a region identifier (i.e. en_US).
   * @param {boolean} hour12 - 12 vs 24 hour. Set to true for 12 hour time formatting.
   * @param {boolean} withDate - default is false. Set to true to append current date to UTC time format.
   * @returns {string} A formatted time and date string.
   * @memberof module:MediaPlayer
   * @instance
   */


  function formatUTC(time, locales, hour12) {
    var withDate = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;
    var dt = new Date(time * 1000);
    var d = dt.toLocaleDateString(locales);
    var t = dt.toLocaleTimeString(locales, {
      hour12: hour12
    });
    return withDate ? t + ' ' + d : t;
  }
  /**
   * A utility method which converts seconds into TimeCode (i.e. 300 --> 05:00).
   *
   * @param {number} value - A number in seconds to be converted into a formatted time code.
   * @returns {string} A formatted time code string.
   * @memberof module:MediaPlayer
   * @instance
   */


  function convertToTimeCode(value) {
    value = Math.max(value, 0);
    var h = Math.floor(value / 3600);
    var m = Math.floor(value % 3600 / 60);
    var s = Math.floor(value % 3600 % 60);
    return (h === 0 ? '' : h < 10 ? '0' + h.toString() + ':' : h.toString() + ':') + (m < 10 ? '0' + m.toString() : m.toString()) + ':' + (s < 10 ? '0' + s.toString() : s.toString());
  }
  /**
   * This method should be used to extend or replace internal dash.js objects.
   * There are two ways to extend dash.js (determined by the override argument):
   * <ol>
   * <li>If you set override to true any public method or property in your custom object will
   * override the dash.js parent object's property(ies) and will be used instead but the
   * dash.js parent module will still be created.</li>
   *
   * <li>If you set override to false your object will completely replace the dash.js object.
   * (Note: This is how it was in 1.x of Dash.js with Dijon).</li>
   * </ol>
   * <b>When you extend you get access to this.context, this.factory and this.parent to operate with in your custom object.</b>
   * <ul>
   * <li><b>this.context</b> - can be used to pass context for singleton access.</li>
   * <li><b>this.factory</b> - can be used to call factory.getSingletonInstance().</li>
   * <li><b>this.parent</b> - is the reference of the parent object to call other public methods. (this.parent is excluded if you extend with override set to false or option 2)</li>
   * </ul>
   * <b>You must call extend before you call initialize</b>
   * @see {@link module:MediaPlayer#initialize initialize()}
   * @param {string} parentNameString - name of parent module
   * @param {Object} childInstance - overriding object
   * @param {boolean} override - replace only some methods (true) or the whole object (false)
   * @memberof module:MediaPlayer
   * @instance
   */


  function extend(parentNameString, childInstance, override) {
    _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_31__["default"].extend(parentNameString, childInstance, override, context);
  }
  /**
   * This method returns the active stream
   *
   * @throws {@link module:MediaPlayer~STREAMING_NOT_INITIALIZED_ERROR STREAMING_NOT_INITIALIZED_ERROR} if called before initializePlayback function
   * @memberof module:MediaPlayer
   * @instance
   */


  function getActiveStream() {
    if (!streamingInitialized) {
      throw STREAMING_NOT_INITIALIZED_ERROR;
    }

    var streamInfo = streamController.getActiveStreamInfo();
    return streamInfo ? streamController.getStreamById(streamInfo.id) : null;
  }
  /**
   * Returns the DashAdapter.js Module.
   *
   * @see {@link module:DashAdapter}
   * @returns {Object}
   * @memberof module:MediaPlayer
   * @instance
   */


  function getDashAdapter() {
    return adapter;
  }
  /**
   * Triggers a request to the content steering server to update the steering information.
   * @return {Promise<any>}
   */


  function triggerSteeringRequest() {
    if (contentSteeringController) {
      return contentSteeringController.loadSteeringData();
    }
  }
  /**
   * Returns the current response data of the content steering server
   * @return {object}
   */


  function getCurrentSteeringResponseData() {
    if (contentSteeringController) {
      return contentSteeringController.getCurrentSteeringResponseData();
    }
  }
  /**
   * Returns all BaseURLs that are available including synthesized elements (e.g by content steering)
   * @returns {BaseURL[]}
   */


  function getAvailableBaseUrls() {
    var manifest = manifestModel.getValue();

    if (!manifest) {
      return [];
    }

    return baseURLController.getBaseUrls(manifest);
  }
  /**
   * Returns the available location elements including synthesized elements (e.g by content steering)
   * @returns {MpdLocation[]}
   */


  function getAvailableLocations() {
    var manifest = manifestModel.getValue();

    if (!manifest) {
      return [];
    }

    var manifestLocations = adapter.getLocation(manifest);
    var synthesizedElements = contentSteeringController.getSynthesizedLocationElements(manifestLocations);
    return manifestLocations.concat(synthesizedElements);
  } //***********************************
  // PRIVATE METHODS
  //***********************************


  function _resetPlaybackControllers() {
    playbackInitialized = false;
    streamingInitialized = false;
    adapter.reset();
    streamController.reset();
    gapController.reset();
    catchupController.reset();
    playbackController.reset();
    serviceDescriptionController.reset();
    contentSteeringController.reset();
    abrController.reset();
    mediaController.reset();
    segmentBaseController.reset();

    if (protectionController) {
      if (settings.get().streaming.protection.keepProtectionMediaKeys) {
        protectionController.stop();
      } else {
        protectionController.reset();
        protectionController = null;

        _detectProtection();
      }
    }

    textController.reset();
    cmcdModel.reset();
    cmsdModel.reset();
  }

  function _createPlaybackControllers() {
    // creates or get objects instances
    var manifestLoader = _createManifestLoader();

    if (!streamController) {
      streamController = (0,_controllers_StreamController__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
    }

    if (!textController) {
      textController = (0,_text_TextController__WEBPACK_IMPORTED_MODULE_46__["default"])(context).create({
        errHandler: errHandler,
        manifestModel: manifestModel,
        adapter: adapter,
        mediaController: mediaController,
        baseURLController: baseURLController,
        videoModel: videoModel,
        settings: settings
      });
    }

    capabilitiesFilter.setConfig({
      capabilities: capabilities,
      customParametersModel: customParametersModel,
      adapter: adapter,
      settings: settings,
      manifestModel: manifestModel,
      errHandler: errHandler
    });
    streamController.setConfig({
      capabilities: capabilities,
      capabilitiesFilter: capabilitiesFilter,
      manifestLoader: manifestLoader,
      manifestModel: manifestModel,
      mediaPlayerModel: mediaPlayerModel,
      customParametersModel: customParametersModel,
      protectionController: protectionController,
      textController: textController,
      adapter: adapter,
      dashMetrics: dashMetrics,
      errHandler: errHandler,
      timelineConverter: timelineConverter,
      videoModel: videoModel,
      playbackController: playbackController,
      serviceDescriptionController: serviceDescriptionController,
      contentSteeringController: contentSteeringController,
      abrController: abrController,
      mediaController: mediaController,
      settings: settings,
      baseURLController: baseURLController,
      uriFragmentModel: uriFragmentModel,
      segmentBaseController: segmentBaseController
    });
    gapController.setConfig({
      settings: settings,
      playbackController: playbackController,
      streamController: streamController,
      videoModel: videoModel,
      timelineConverter: timelineConverter,
      adapter: adapter
    });
    playbackController.setConfig({
      streamController: streamController,
      serviceDescriptionController: serviceDescriptionController,
      dashMetrics: dashMetrics,
      adapter: adapter,
      videoModel: videoModel,
      timelineConverter: timelineConverter,
      settings: settings
    });
    catchupController.setConfig({
      streamController: streamController,
      playbackController: playbackController,
      mediaPlayerModel: mediaPlayerModel,
      videoModel: videoModel,
      settings: settings
    });
    abrController.setConfig({
      streamController: streamController,
      domStorage: domStorage,
      mediaPlayerModel: mediaPlayerModel,
      customParametersModel: customParametersModel,
      cmsdModel: cmsdModel,
      dashMetrics: dashMetrics,
      adapter: adapter,
      videoModel: videoModel,
      settings: settings
    });
    cmcdModel.setConfig({
      abrController: abrController,
      dashMetrics: dashMetrics,
      playbackController: playbackController
    });
    cmsdModel.setConfig({}); // initializes controller

    abrController.initialize();
    streamController.initialize(autoPlay, protectionData);
    textController.initialize();
    gapController.initialize();
    catchupController.initialize();
    cmcdModel.initialize();
    cmsdModel.initialize();
    contentSteeringController.initialize();
    segmentBaseController.initialize();
  }

  function _createManifestLoader() {
    return (0,_ManifestLoader__WEBPACK_IMPORTED_MODULE_12__["default"])(context).create({
      debug: debug,
      errHandler: errHandler,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      requestModifier: (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance(),
      mssHandler: mssHandler,
      settings: settings
    });
  }

  function _detectProtection() {
    if (protectionController) {
      return protectionController;
    } // do not require Protection as dependencies as this is optional and intended to be loaded separately


    var Protection = dashjs.Protection;
    /* jshint ignore:line */

    if (typeof Protection === 'function') {
      //TODO need a better way to register/detect plugin components
      var protection = Protection(context).create();
      _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].extend(Protection.events);
      _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_30__["default"].extend(Protection.events, {
        publicOnly: true
      });
      _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"].extend(Protection.errors);

      if (!capabilities) {
        capabilities = (0,_utils_Capabilities__WEBPACK_IMPORTED_MODULE_14__["default"])(context).getInstance();
      }

      protectionController = protection.createProtectionSystem({
        debug: debug,
        errHandler: errHandler,
        videoModel: videoModel,
        customParametersModel: customParametersModel,
        capabilities: capabilities,
        eventBus: eventBus,
        events: _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"],
        BASE64: _externals_base64__WEBPACK_IMPORTED_MODULE_39__,
        constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"],
        cmcdModel: cmcdModel,
        settings: settings
      });
      return protectionController;
    }

    return null;
  }

  function _detectMetricsReporting() {
    if (metricsReportingController) {
      return;
    } // do not require MetricsReporting as dependencies as this is optional and intended to be loaded separately


    var MetricsReporting = dashjs.MetricsReporting;
    /* jshint ignore:line */

    if (typeof MetricsReporting === 'function') {
      //TODO need a better way to register/detect plugin components
      var metricsReporting = MetricsReporting(context).create();
      metricsReportingController = metricsReporting.createMetricsReporting({
        debug: debug,
        eventBus: eventBus,
        mediaElement: getVideoElement(),
        adapter: adapter,
        dashMetrics: dashMetrics,
        mediaPlayerModel: mediaPlayerModel,
        events: _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"],
        constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"],
        metricsConstants: _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_3__["default"]
      });
    }
  }

  function _detectMss() {
    if (mssHandler) {
      return;
    } // do not require MssHandler as dependencies as this is optional and intended to be loaded separately


    var MssHandler = dashjs.MssHandler;
    /* jshint ignore:line */

    if (typeof MssHandler === 'function') {
      //TODO need a better way to register/detect plugin components
      _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"].extend(MssHandler.errors);
      mssHandler = MssHandler(context).create({
        eventBus: eventBus,
        mediaPlayerModel: mediaPlayerModel,
        dashMetrics: dashMetrics,
        manifestModel: manifestModel,
        playbackController: playbackController,
        streamController: streamController,
        protectionController: protectionController,
        baseURLController: baseURLController,
        errHandler: errHandler,
        events: _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"],
        constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"],
        debug: debug,
        initSegmentType: _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_38__.HTTPRequest.INIT_SEGMENT_TYPE,
        BASE64: _externals_base64__WEBPACK_IMPORTED_MODULE_39__,
        ISOBoxer: codem_isoboxer__WEBPACK_IMPORTED_MODULE_40__,
        settings: settings
      });
    }
  }

  function _detectOffline() {
    if (!mediaPlayerInitialized) {
      throw MEDIA_PLAYER_NOT_INITIALIZED_ERROR;
    }

    if (offlineController) {
      return offlineController;
    } // do not require Offline as dependencies as this is optional and intended to be loaded separately


    var OfflineController = dashjs.OfflineController;
    /* jshint ignore:line */

    if (typeof OfflineController === 'function') {
      //TODO need a better way to register/detect plugin components
      _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"].extend(OfflineController.events);
      _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_30__["default"].extend(OfflineController.events, {
        publicOnly: true
      });
      _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"].extend(OfflineController.errors);

      var manifestLoader = _createManifestLoader();

      var manifestUpdater = (0,_ManifestUpdater__WEBPACK_IMPORTED_MODULE_43__["default"])(context).create();
      manifestUpdater.setConfig({
        manifestModel: manifestModel,
        adapter: adapter,
        manifestLoader: manifestLoader,
        errHandler: errHandler,
        contentSteeringController: contentSteeringController
      });
      offlineController = OfflineController(context).create({
        debug: debug,
        manifestUpdater: manifestUpdater,
        baseURLController: baseURLController,
        manifestLoader: manifestLoader,
        manifestModel: manifestModel,
        mediaPlayerModel: mediaPlayerModel,
        abrController: abrController,
        playbackController: playbackController,
        adapter: adapter,
        errHandler: errHandler,
        dashMetrics: dashMetrics,
        timelineConverter: timelineConverter,
        segmentBaseController: segmentBaseController,
        schemeLoaderFactory: schemeLoaderFactory,
        eventBus: eventBus,
        events: _core_events_Events__WEBPACK_IMPORTED_MODULE_29__["default"],
        errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"],
        constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"],
        settings: settings,
        dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_2__["default"],
        urlUtils: (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_44__["default"])(context).getInstance()
      });
      return offlineController;
    }

    return null;
  }

  function _getAsUTC(valToConvert) {
    var type = streamController && streamController.hasVideoTrack() ? _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO : _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].AUDIO;
    var metric = dashMetrics.getCurrentDVRInfo(type);
    var availableFrom, utcValue;

    if (!metric) {
      return 0;
    }

    availableFrom = metric.manifestInfo.availableFrom.getTime() / 1000;
    utcValue = valToConvert + (availableFrom + metric.range.start);
    return utcValue;
  }
  /**
   *
   * @private
   */


  function _initializePlayback() {
    var startTime = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : NaN;

    if (offlineController) {
      offlineController.resetRecords();
    }

    if (!streamingInitialized && source) {
      streamingInitialized = true;
      logger.info('Streaming Initialized');

      _createPlaybackControllers();

      if (typeof source === 'string') {
        streamController.load(source, startTime);
      } else {
        streamController.loadWithManifest(source, startTime);
      }
    }

    if (!playbackInitialized && isReady()) {
      playbackInitialized = true;
      logger.info('Playback Initialized');
    }
  }

  instance = {
    initialize: initialize,
    setConfig: setConfig,
    on: on,
    off: off,
    extend: extend,
    attachView: attachView,
    attachSource: attachSource,
    refreshManifest: refreshManifest,
    isReady: isReady,
    preload: preload,
    play: play,
    isPaused: isPaused,
    pause: pause,
    isSeeking: isSeeking,
    isDynamic: isDynamic,
    getLowLatencyModeEnabled: getLowLatencyModeEnabled,
    seek: seek,
    seekToOriginalLive: seekToOriginalLive,
    setPlaybackRate: setPlaybackRate,
    getPlaybackRate: getPlaybackRate,
    setMute: setMute,
    isMuted: isMuted,
    setVolume: setVolume,
    getVolume: getVolume,
    time: time,
    duration: duration,
    timeAsUTC: timeAsUTC,
    durationAsUTC: durationAsUTC,
    getActiveStream: getActiveStream,
    getDVRWindowSize: getDVRWindowSize,
    getDVRSeekOffset: getDVRSeekOffset,
    getAvailableBaseUrls: getAvailableBaseUrls,
    getAvailableLocations: getAvailableLocations,
    getTargetLiveDelay: getTargetLiveDelay,
    convertToTimeCode: convertToTimeCode,
    formatUTC: formatUTC,
    getVersion: getVersion,
    getDebug: getDebug,
    getBufferLength: getBufferLength,
    getTTMLRenderingDiv: getTTMLRenderingDiv,
    getVideoElement: getVideoElement,
    getSource: getSource,
    updateSource: updateSource,
    getCurrentLiveLatency: getCurrentLiveLatency,
    getTopBitrateInfoFor: getTopBitrateInfoFor,
    setAutoPlay: setAutoPlay,
    getAutoPlay: getAutoPlay,
    getDashMetrics: getDashMetrics,
    getQualityFor: getQualityFor,
    setQualityFor: setQualityFor,
    updatePortalSize: updatePortalSize,
    enableText: enableText,
    enableForcedTextStreaming: enableForcedTextStreaming,
    isTextEnabled: isTextEnabled,
    setTextTrack: setTextTrack,
    getBitrateInfoListFor: getBitrateInfoListFor,
    getStreamsFromManifest: getStreamsFromManifest,
    getTracksFor: getTracksFor,
    getTracksForTypeFromManifest: getTracksForTypeFromManifest,
    getCurrentTrackFor: getCurrentTrackFor,
    setInitialMediaSettingsFor: setInitialMediaSettingsFor,
    getInitialMediaSettingsFor: getInitialMediaSettingsFor,
    setCurrentTrack: setCurrentTrack,
    addABRCustomRule: addABRCustomRule,
    removeABRCustomRule: removeABRCustomRule,
    removeAllABRCustomRule: removeAllABRCustomRule,
    getABRCustomRules: getABRCustomRules,
    getAverageThroughput: getAverageThroughput,
    retrieveManifest: retrieveManifest,
    addUTCTimingSource: addUTCTimingSource,
    removeUTCTimingSource: removeUTCTimingSource,
    clearDefaultUTCTimingSources: clearDefaultUTCTimingSources,
    restoreDefaultUTCTimingSources: restoreDefaultUTCTimingSources,
    setXHRWithCredentialsForType: setXHRWithCredentialsForType,
    getXHRWithCredentialsForType: getXHRWithCredentialsForType,
    getProtectionController: getProtectionController,
    attachProtectionController: attachProtectionController,
    setProtectionData: setProtectionData,
    registerLicenseRequestFilter: registerLicenseRequestFilter,
    registerLicenseResponseFilter: registerLicenseResponseFilter,
    unregisterLicenseRequestFilter: unregisterLicenseRequestFilter,
    unregisterLicenseResponseFilter: unregisterLicenseResponseFilter,
    registerCustomCapabilitiesFilter: registerCustomCapabilitiesFilter,
    unregisterCustomCapabilitiesFilter: unregisterCustomCapabilitiesFilter,
    setCustomInitialTrackSelectionFunction: setCustomInitialTrackSelectionFunction,
    resetCustomInitialTrackSelectionFunction: resetCustomInitialTrackSelectionFunction,
    attachTTMLRenderingDiv: attachTTMLRenderingDiv,
    attachVttRenderingDiv: attachVttRenderingDiv,
    getCurrentTextTrackIndex: getCurrentTextTrackIndex,
    provideThumbnail: provideThumbnail,
    getDashAdapter: getDashAdapter,
    getOfflineController: getOfflineController,
    triggerSteeringRequest: triggerSteeringRequest,
    getCurrentSteeringResponseData: getCurrentSteeringResponseData,
    getSettings: getSettings,
    updateSettings: updateSettings,
    resetSettings: resetSettings,
    reset: reset,
    destroy: destroy
  };
  setup();
  return instance;
}

MediaPlayer.__dashjs_factory_name = 'MediaPlayer';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_31__["default"].getClassFactory(MediaPlayer);
factory.events = _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_30__["default"];
factory.errors = _core_errors_Errors__WEBPACK_IMPORTED_MODULE_27__["default"];
_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_31__["default"].updateClassFactory(MediaPlayer.__dashjs_factory_name, factory);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/streaming/MediaPlayerEvents.js":
/*!********************************************!*\
  !*** ./src/streaming/MediaPlayerEvents.js ***!
  \********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/events/EventsBase */ "./src/core/events/EventsBase.js");
function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function"); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } }); if (superClass) _setPrototypeOf(subClass, superClass); }

function _setPrototypeOf(o, p) { _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) { o.__proto__ = p; return o; }; return _setPrototypeOf(o, p); }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _possibleConstructorReturn(self, call) { if (call && (_typeof(call) === "object" || typeof call === "function")) { return call; } return _assertThisInitialized(self); }

function _assertThisInitialized(self) { if (self === void 0) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return self; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function _getPrototypeOf(o) { _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) { return o.__proto__ || Object.getPrototypeOf(o); }; return _getPrototypeOf(o); }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * @class
 * @implements EventsBase
 */

var MediaPlayerEvents = /*#__PURE__*/function (_EventsBase) {
  _inherits(MediaPlayerEvents, _EventsBase);

  var _super = _createSuper(MediaPlayerEvents);

  /**
   * @description Public facing external events to be used when developing a player that implements dash.js.
   */
  function MediaPlayerEvents() {
    var _this;

    _classCallCheck(this, MediaPlayerEvents);

    _this = _super.call(this);
    /**
     * Triggered when playback will not start yet
     * as the MPD's availabilityStartTime is in the future.
     * Check delay property in payload to determine time before playback will start.
     * @event MediaPlayerEvents#AST_IN_FUTURE
     */

    _this.AST_IN_FUTURE = 'astInFuture';
    /**
     * Triggered when the BaseURLs have been updated.
     * @event MediaPlayerEvents#BASE_URLS_UPDATED
     */

    _this.BASE_URLS_UPDATED = 'baseUrlsUpdated';
    /**
     * Triggered when the video element's buffer state changes to stalled.
     * Check mediaType in payload to determine type (Video, Audio, FragmentedText).
     * @event MediaPlayerEvents#BUFFER_EMPTY
     */

    _this.BUFFER_EMPTY = 'bufferStalled';
    /**
     * Triggered when the video element's buffer state changes to loaded.
     * Check mediaType in payload to determine type (Video, Audio, FragmentedText).
     * @event MediaPlayerEvents#BUFFER_LOADED
     */

    _this.BUFFER_LOADED = 'bufferLoaded';
    /**
     * Triggered when the video element's buffer state changes, either stalled or loaded. Check payload for state.
     * @event MediaPlayerEvents#BUFFER_LEVEL_STATE_CHANGED
     */

    _this.BUFFER_LEVEL_STATE_CHANGED = 'bufferStateChanged';
    /**
     * Triggered when the buffer level of a media type has been updated
     * @event MediaPlayerEvents#BUFFER_LEVEL_UPDATED
     */

    _this.BUFFER_LEVEL_UPDATED = 'bufferLevelUpdated';
    /**
     * Triggered when a font signalled by a DVB Font Download has been added to the document FontFaceSet interface.
     * @event MediaPlayerEvents#DVB_FONT_DOWNLOAD_ADDED
     */

    _this.DVB_FONT_DOWNLOAD_ADDED = 'dvbFontDownloadAdded';
    /**
     * Triggered when a font signalled by a DVB Font Download has successfully downloaded and the FontFace can be used.
     * @event MediaPlayerEvents#DVB_FONT_DOWNLOAD_COMPLETE
     */

    _this.DVB_FONT_DOWNLOAD_COMPLETE = 'dvbFontDownloadComplete';
    /**
     * Triggered when a font signalled by a DVB Font Download could not be successfully downloaded, so the FontFace will not be used.
     * @event MediaPlayerEvents#DVB_FONT_DOWNLOAD_FAILED
     */

    _this.DVB_FONT_DOWNLOAD_FAILED = 'dvbFontDownloadFailed';
    /**
     * Triggered when a dynamic stream changed to static (transition phase between Live and On-Demand).
     * @event MediaPlayerEvents#DYNAMIC_TO_STATIC
     */

    _this.DYNAMIC_TO_STATIC = 'dynamicToStatic';
    /**
     * Triggered when there is an error from the element or MSE source buffer.
     * @event MediaPlayerEvents#ERROR
     */

    _this.ERROR = 'error';
    /**
     * Triggered when a fragment download has completed.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_COMPLETED
     */

    _this.FRAGMENT_LOADING_COMPLETED = 'fragmentLoadingCompleted';
    /**
     * Triggered when a partial fragment download has completed.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_PROGRESS
     */

    _this.FRAGMENT_LOADING_PROGRESS = 'fragmentLoadingProgress';
    /**
     * Triggered when a fragment download has started.
     * @event MediaPlayerEvents#FRAGMENT_LOADING_STARTED
     */

    _this.FRAGMENT_LOADING_STARTED = 'fragmentLoadingStarted';
    /**
     * Triggered when a fragment download is abandoned due to detection of slow download base on the ABR abandon rule..
     * @event MediaPlayerEvents#FRAGMENT_LOADING_ABANDONED
     */

    _this.FRAGMENT_LOADING_ABANDONED = 'fragmentLoadingAbandoned';
    /**
     * Triggered when {@link module:Debug} logger methods are called.
     * @event MediaPlayerEvents#LOG
     */

    _this.LOG = 'log';
    /**
     * Triggered when the manifest load is started
     * @event MediaPlayerEvents#MANIFEST_LOADING_STARTED
     */

    _this.MANIFEST_LOADING_STARTED = 'manifestLoadingStarted';
    /**
     * Triggered when the manifest loading is finished, providing the request object information
     * @event MediaPlayerEvents#MANIFEST_LOADING_FINISHED
     */

    _this.MANIFEST_LOADING_FINISHED = 'manifestLoadingFinished';
    /**
     * Triggered when the manifest load is complete, providing the payload
     * @event MediaPlayerEvents#MANIFEST_LOADED
     */

    _this.MANIFEST_LOADED = 'manifestLoaded';
    /**
     * Triggered anytime there is a change to the overall metrics.
     * @event MediaPlayerEvents#METRICS_CHANGED
     */

    _this.METRICS_CHANGED = 'metricsChanged';
    /**
     * Triggered when an individual metric is added, updated or cleared.
     * @event MediaPlayerEvents#METRIC_CHANGED
     */

    _this.METRIC_CHANGED = 'metricChanged';
    /**
     * Triggered every time a new metric is added.
     * @event MediaPlayerEvents#METRIC_ADDED
     */

    _this.METRIC_ADDED = 'metricAdded';
    /**
     * Triggered every time a metric is updated.
     * @event MediaPlayerEvents#METRIC_UPDATED
     */

    _this.METRIC_UPDATED = 'metricUpdated';
    /**
     * Triggered when a new stream (period) starts.
     * @event MediaPlayerEvents#PERIOD_SWITCH_STARTED
     */

    _this.PERIOD_SWITCH_STARTED = 'periodSwitchStarted';
    /**
     * Triggered at the stream end of a period.
     * @event MediaPlayerEvents#PERIOD_SWITCH_COMPLETED
     */

    _this.PERIOD_SWITCH_COMPLETED = 'periodSwitchCompleted';
    /**
     * Triggered when an ABR up /down switch is initiated; either by user in manual mode or auto mode via ABR rules.
     * @event MediaPlayerEvents#QUALITY_CHANGE_REQUESTED
     */

    _this.QUALITY_CHANGE_REQUESTED = 'qualityChangeRequested';
    /**
     * Triggered when the new ABR quality is being rendered on-screen.
     * @event MediaPlayerEvents#QUALITY_CHANGE_RENDERED
     */

    _this.QUALITY_CHANGE_RENDERED = 'qualityChangeRendered';
    /**
     * Triggered when the new track is being rendered.
     * @event MediaPlayerEvents#TRACK_CHANGE_RENDERED
     */

    _this.TRACK_CHANGE_RENDERED = 'trackChangeRendered';
    /**
     * Triggered when a stream (period) is being loaded
     * @event MediaPlayerEvents#STREAM_INITIALIZING
     */

    _this.STREAM_INITIALIZING = 'streamInitializing';
    /**
     * Triggered when a stream (period) is loaded
     * @event MediaPlayerEvents#STREAM_UPDATED
     */

    _this.STREAM_UPDATED = 'streamUpdated';
    /**
     * Triggered when a stream (period) is activated
     * @event MediaPlayerEvents#STREAM_ACTIVATED
     */

    _this.STREAM_ACTIVATED = 'streamActivated';
    /**
     * Triggered when a stream (period) is deactivated
     * @event MediaPlayerEvents#STREAM_DEACTIVATED
     */

    _this.STREAM_DEACTIVATED = 'streamDeactivated';
    /**
     * Triggered when a stream (period) is activated
     * @event MediaPlayerEvents#STREAM_INITIALIZED
     */

    _this.STREAM_INITIALIZED = 'streamInitialized';
    /**
     * Triggered when the player has been reset.
     * @event MediaPlayerEvents#STREAM_TEARDOWN_COMPLETE
     */

    _this.STREAM_TEARDOWN_COMPLETE = 'streamTeardownComplete';
    /**
     * Triggered once all text tracks detected in the MPD are added to the video element.
     * @event MediaPlayerEvents#TEXT_TRACKS_ADDED
     */

    _this.TEXT_TRACKS_ADDED = 'allTextTracksAdded';
    /**
     * Triggered when a text track is added to the video element's TextTrackList
     * @event MediaPlayerEvents#TEXT_TRACK_ADDED
     */

    _this.TEXT_TRACK_ADDED = 'textTrackAdded';
    /**
     * Triggered when a text track should be shown
     * @event MediaPlayerEvents#CUE_ENTER
     */

    _this.CUE_ENTER = 'cueEnter';
    /**
     * Triggered when a text track should be hidden
     * @event MediaPlayerEvents#CUE_ENTER
     */

    _this.CUE_EXIT = 'cueExit';
    /**
     * Triggered when a throughput measurement based on the last segment request has been stored
     * @event MediaPlayerEvents#THROUGHPUT_MEASUREMENT_STORED
     */

    _this.THROUGHPUT_MEASUREMENT_STORED = 'throughputMeasurementStored';
    /**
     * Triggered when a ttml chunk is parsed.
     * @event MediaPlayerEvents#TTML_PARSED
     */

    _this.TTML_PARSED = 'ttmlParsed';
    /**
     * Triggered when a ttml chunk has to be parsed.
     * @event MediaPlayerEvents#TTML_TO_PARSE
     */

    _this.TTML_TO_PARSE = 'ttmlToParse';
    /**
     * Triggered when a caption is rendered.
     * @event MediaPlayerEvents#CAPTION_RENDERED
     */

    _this.CAPTION_RENDERED = 'captionRendered';
    /**
     * Triggered when the caption container is resized.
     * @event MediaPlayerEvents#CAPTION_CONTAINER_RESIZE
     */

    _this.CAPTION_CONTAINER_RESIZE = 'captionContainerResize';
    /**
     * Sent when enough data is available that the media can be played,
     * at least for a couple of frames.  This corresponds to the
     * HAVE_ENOUGH_DATA readyState.
     * @event MediaPlayerEvents#CAN_PLAY
     */

    _this.CAN_PLAY = 'canPlay';
    /**
     * This corresponds to the CAN_PLAY_THROUGH readyState.
     * @event MediaPlayerEvents#CAN_PLAY_THROUGH
     */

    _this.CAN_PLAY_THROUGH = 'canPlayThrough';
    /**
     * Sent when playback completes.
     * @event MediaPlayerEvents#PLAYBACK_ENDED
     */

    _this.PLAYBACK_ENDED = 'playbackEnded';
    /**
     * Sent when an error occurs.  The element's error
     * attribute contains more information.
     * @event MediaPlayerEvents#PLAYBACK_ERROR
     */

    _this.PLAYBACK_ERROR = 'playbackError';
    /**
     * Sent when playback is not allowed (for example if user gesture is needed).
     * @event MediaPlayerEvents#PLAYBACK_NOT_ALLOWED
     */

    _this.PLAYBACK_NOT_ALLOWED = 'playbackNotAllowed';
    /**
     * The media's metadata has finished loading; all attributes now
     * contain as much useful information as they're going to.
     * @event MediaPlayerEvents#PLAYBACK_METADATA_LOADED
     */

    _this.PLAYBACK_METADATA_LOADED = 'playbackMetaDataLoaded';
    /**
     * The event is fired when the frame at the current playback position of the media has finished loading;
     * often the first frame
     * @event MediaPlayerEvents#PLAYBACK_LOADED_DATA
     */

    _this.PLAYBACK_LOADED_DATA = 'playbackLoadedData';
    /**
     * Sent when playback is paused.
     * @event MediaPlayerEvents#PLAYBACK_PAUSED
     */

    _this.PLAYBACK_PAUSED = 'playbackPaused';
    /**
     * Sent when the media begins to play (either for the first time, after having been paused,
     * or after ending and then restarting).
     *
     * @event MediaPlayerEvents#PLAYBACK_PLAYING
     */

    _this.PLAYBACK_PLAYING = 'playbackPlaying';
    /**
     * Sent periodically to inform interested parties of progress downloading
     * the media. Information about the current amount of the media that has
     * been downloaded is available in the media element's buffered attribute.
     * @event MediaPlayerEvents#PLAYBACK_PROGRESS
     */

    _this.PLAYBACK_PROGRESS = 'playbackProgress';
    /**
     * Sent when the playback speed changes.
     * @event MediaPlayerEvents#PLAYBACK_RATE_CHANGED
     */

    _this.PLAYBACK_RATE_CHANGED = 'playbackRateChanged';
    /**
     * Sent when a seek operation completes.
     * @event MediaPlayerEvents#PLAYBACK_SEEKED
     */

    _this.PLAYBACK_SEEKED = 'playbackSeeked';
    /**
     * Sent when a seek operation begins.
     * @event MediaPlayerEvents#PLAYBACK_SEEKING
     */

    _this.PLAYBACK_SEEKING = 'playbackSeeking';
    /**
     * Sent when the video element reports stalled
     * @event MediaPlayerEvents#PLAYBACK_STALLED
     */

    _this.PLAYBACK_STALLED = 'playbackStalled';
    /**
     * Sent when playback of the media starts after having been paused;
     * that is, when playback is resumed after a prior pause event.
     *
     * @event MediaPlayerEvents#PLAYBACK_STARTED
     */

    _this.PLAYBACK_STARTED = 'playbackStarted';
    /**
     * The time indicated by the element's currentTime attribute has changed.
     * @event MediaPlayerEvents#PLAYBACK_TIME_UPDATED
     */

    _this.PLAYBACK_TIME_UPDATED = 'playbackTimeUpdated';
    /**
     * Sent when the video element reports that the volume has changed
     * @event MediaPlayerEvents#PLAYBACK_VOLUME_CHANGED
     */

    _this.PLAYBACK_VOLUME_CHANGED = 'playbackVolumeChanged';
    /**
     * Sent when the media playback has stopped because of a temporary lack of data.
     *
     * @event MediaPlayerEvents#PLAYBACK_WAITING
     */

    _this.PLAYBACK_WAITING = 'playbackWaiting';
    /**
     * Manifest validity changed - As a result of an MPD validity expiration event.
     * @event MediaPlayerEvents#MANIFEST_VALIDITY_CHANGED
     */

    _this.MANIFEST_VALIDITY_CHANGED = 'manifestValidityChanged';
    /**
     * Dash events are triggered at their respective start points on the timeline.
     * @event MediaPlayerEvents#EVENT_MODE_ON_START
     */

    _this.EVENT_MODE_ON_START = 'eventModeOnStart';
    /**
     * Dash events are triggered as soon as they were parsed.
     * @event MediaPlayerEvents#EVENT_MODE_ON_RECEIVE
     */

    _this.EVENT_MODE_ON_RECEIVE = 'eventModeOnReceive';
    /**
     * Event that is dispatched whenever the player encounters a potential conformance validation that might lead to unexpected/not optimal behavior
     * @event MediaPlayerEvents#CONFORMANCE_VIOLATION
     */

    _this.CONFORMANCE_VIOLATION = 'conformanceViolation';
    /**
     * Event that is dispatched whenever the player switches to a different representation
     * @event MediaPlayerEvents#REPRESENTATION_SWITCH
     */

    _this.REPRESENTATION_SWITCH = 'representationSwitch';
    /**
     * Event that is dispatched whenever an adaptation set is removed due to all representations not being supported.
     * @event MediaPlayerEvents#ADAPTATION_SET_REMOVED_NO_CAPABILITIES
     */

    _this.ADAPTATION_SET_REMOVED_NO_CAPABILITIES = 'adaptationSetRemovedNoCapabilities';
    /**
     * Triggered when a content steering request has completed.
     * @event MediaPlayerEvents#CONTENT_STEERING_REQUEST_COMPLETED
     */

    _this.CONTENT_STEERING_REQUEST_COMPLETED = 'contentSteeringRequestCompleted';
    /**
     * Triggered when an inband prft (ProducerReferenceTime) boxes has been received.
     * @event MediaPlayerEvents#INBAND_PRFT
     */

    _this.INBAND_PRFT = 'inbandPrft';
    /**
     * The streaming attribute of the Managed Media Source is true
     * @type {string}
     */

    _this.MANAGED_MEDIA_SOURCE_START_STREAMING = 'managedMediaSourceStartStreaming';
    /**
     * The streaming attribute of the Managed Media Source is false
     * @type {string}
     */

    _this.MANAGED_MEDIA_SOURCE_END_STREAMING = 'managedMediaSourceEndStreaming';
    return _this;
  }

  return MediaPlayerEvents;
}(_core_events_EventsBase__WEBPACK_IMPORTED_MODULE_0__["default"]);

var mediaPlayerEvents = new MediaPlayerEvents();
/* harmony default export */ __webpack_exports__["default"] = (mediaPlayerEvents);

/***/ }),

/***/ "./src/streaming/MediaPlayerFactory.js":
/*!*********************************************!*\
  !*** ./src/streaming/MediaPlayerFactory.js ***!
  \*********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _MediaPlayer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MediaPlayer */ "./src/streaming/MediaPlayer.js");


function MediaPlayerFactory() {
  /**
   * mime-type identifier for any source content to be accepted as a dash manifest by the create() method.
   * @type {string}
   */
  var SUPPORTED_MIME_TYPE = 'application/dash+xml';
  var logger;
  /**
   *  A new MediaPlayer is instantiated for the supplied videoElement and optional source and context.  If no context is provided,
   *  a default DashContext is used. If no source is provided, the videoElement is interrogated to extract the first source whose
   *  type is application/dash+xml.
   * The autoplay property of the videoElement is preserved. Any preload attribute is ignored. This method should be called after the page onLoad event is dispatched.
   * @param {HTMLMediaElement} video
   * @param {HTMLSourceElement} source
   * @param {Object} context
   * @returns {MediaPlayer|null}
   */

  function create(video, source, context) {
    if (!video || !/^VIDEO$/i.test(video.nodeName)) return null;
    if (video._dashjs_player) return video._dashjs_player;
    var player;
    var videoID = video.id || video.name || 'video element';
    source = source || [].slice.call(video.querySelectorAll('source')).filter(function (s) {
      return s.type == SUPPORTED_MIME_TYPE;
    })[0];

    if (!source && video.src) {
      source = document.createElement('source');
      source.src = video.src;
    } else if (!source && !video.src) {
      return null;
    }

    context = context || {};
    player = (0,_MediaPlayer__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create();
    player.initialize(video, source.src, video.autoplay);

    if (!logger) {
      logger = player.getDebug().getLogger();
    }

    logger.debug('Converted ' + videoID + ' to dash.js player and added content: ' + source.src); // Store a reference to the player on the video element so it can be gotten at for debugging and so we know its
    // already been setup.

    video._dashjs_player = player;
    return player;
  }
  /**
   * Searches the provided scope for all instances of the indicated selector. If no scope is provided, document is used. If no selector is
   * specified, [data-dashjs-player] is used. The declarative setup also looks for source elements with the type attribute set to 'application/dash+xml'.
   * It then looks for those video elements which have a source element defined with a type matching 'application/dash+xml'.
   * A new MediaPlayer is instantiated for each matching video element and the appropriate source is assigned.
   * The autoplay property of the video element is preserved. Any preload attribute is ignored. This method should be called after the page onLoad event is dispatched.
   * Returns an array holding all the MediaPlayer instances that were added by this method.
   * @param {string} selector - CSS selector
   * @param {Object} scope
   * @returns {Array} an array of MediaPlayer objects
   */


  function createAll(selector, scope) {
    var aPlayers = [];
    selector = selector || '[data-dashjs-player]';
    scope = scope || document;
    var videos = scope.querySelectorAll(selector);

    for (var i = 0; i < videos.length; i++) {
      var player = create(videos[i], null);
      aPlayers.push(player);
    }

    var sources = scope.querySelectorAll('source[type="' + SUPPORTED_MIME_TYPE + '"]');

    for (var _i = 0; _i < sources.length; _i++) {
      var video = findVideo(sources[_i]);

      var _player = create(video, null);

      aPlayers.push(_player);
    }

    return aPlayers;
  }

  function findVideo(el) {
    if (/^VIDEO$/i.test(el.nodeName)) {
      return el;
    } else {
      return findVideo(el.parentNode);
    }
  }

  return {
    create: create,
    createAll: createAll
  };
}

var instance = MediaPlayerFactory();
var loadInterval;

function loadHandler() {
  window.removeEventListener('load', loadHandler);
  instance.createAll();
}

function loadIntervalHandler() {
  if (window.dashjs) {
    window.clearInterval(loadInterval);
    instance.createAll();
  }
}

var avoidAutoCreate = typeof window !== 'undefined' && window && window.dashjs && window.dashjs.skipAutoCreate;

if (!avoidAutoCreate && typeof window !== 'undefined' && window && window.addEventListener) {
  if (window.document.readyState === 'complete') {
    if (window.dashjs) {
      instance.createAll();
    } else {
      // If loaded asynchronously, window.readyState may be 'complete' even if dashjs hasn't loaded yet
      loadInterval = window.setInterval(loadIntervalHandler, 500);
    }
  } else {
    window.addEventListener('load', loadHandler);
  }
}

/* harmony default export */ __webpack_exports__["default"] = (instance);

/***/ }),

/***/ "./src/streaming/PreBufferSink.js":
/*!****************************************!*\
  !*** ./src/streaming/PreBufferSink.js ***!
  \****************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */


/**
 * This is a sink that is used to temporarily hold onto media chunks before a video element is added.
 * The discharge() function is used to get the chunks out of the PreBuffer for adding to a real SourceBuffer.
 *
 * @class PreBufferSink
 * @ignore
 * @implements FragmentSink
 */

function PreBufferSink(onAppendedCallback) {
  var context = this.context;
  var instance, logger, outstandingInit;
  var chunks = [];
  var onAppended = onAppendedCallback;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance().getLogger(instance);
  }

  function reset() {
    chunks = [];
    outstandingInit = null;
    onAppended = null;
  }

  function append(chunk) {
    if (chunk.segmentType !== 'InitializationSegment') {
      //Init segments are stored in the initCache.
      chunks.push(chunk);
      chunks.sort(function (a, b) {
        return a.start - b.start;
      });
      outstandingInit = null;
    } else {
      //We need to hold an init chunk for when a corresponding media segment is being downloaded when the discharge happens.
      outstandingInit = chunk;
    }

    logger.debug('PreBufferSink appended chunk s: ' + chunk.start + '; e: ' + chunk.end);

    if (onAppended) {
      onAppended({
        chunk: chunk
      });
    }

    return Promise.resolve();
  }

  function remove(start, end) {
    chunks = chunks.filter(function (a) {
      return !((isNaN(end) || a.start < end) && (isNaN(start) || a.end > start));
    }); //The opposite of the getChunks predicate.

    return Promise.resolve();
  } //Nothing async, nothing to abort.


  function abort() {
    return Promise.resolve();
  }

  function getAllBufferRanges() {
    var ranges = [];

    for (var i = 0; i < chunks.length; i++) {
      var chunk = chunks[i];

      if (ranges.length === 0 || chunk.start > ranges[ranges.length - 1].end) {
        ranges.push({
          start: chunk.start,
          end: chunk.end
        });
      } else {
        ranges[ranges.length - 1].end = chunk.end;
      }
    } //Implements TimeRanges interface. So acts just like sourceBuffer.buffered.


    var timeranges = {
      start: function start(n) {
        return ranges[n].start;
      },
      end: function end(n) {
        return ranges[n].end;
      }
    };
    Object.defineProperty(timeranges, 'length', {
      get: function get() {
        return ranges.length;
      }
    });
    return timeranges;
  }

  function updateTimestampOffset() {
    return Promise.resolve();
  }

  function getBuffer() {
    return this;
  }
  /**
   * Return the all chunks in the buffer the lie between times start and end.
   * Because a chunk cannot be split, this returns the full chunk if any part of its time lies in the requested range.
   * Chunks are removed from the buffer when they are discharged.
   * @function PreBufferSink#discharge
   * @param {?Number} start The start time from which to discharge from the buffer. If NaN, it is regarded as unbounded.
   * @param {?Number} end The end time from which to discharge from the buffer. If NaN, it is regarded as unbounded.
   * @returns {Array} The set of chunks from the buffer within the time ranges.
   */


  function discharge(start, end) {
    var result = getChunksAt(start, end);

    if (outstandingInit) {
      result.push(outstandingInit);
      outstandingInit = null;
    }

    remove(start, end);
    return result;
  }

  function getChunksAt(start, end) {
    return chunks.filter(function (a) {
      return (isNaN(end) || a.start < end) && (isNaN(start) || a.end > start);
    });
  }

  function waitForUpdateEnd(callback) {
    callback();
  }

  instance = {
    getAllBufferRanges: getAllBufferRanges,
    append: append,
    remove: remove,
    abort: abort,
    discharge: discharge,
    reset: reset,
    updateTimestampOffset: updateTimestampOffset,
    waitForUpdateEnd: waitForUpdateEnd,
    getBuffer: getBuffer
  };
  setup();
  return instance;
}

PreBufferSink.__dashjs_factory_name = 'PreBufferSink';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_1__["default"].getClassFactory(PreBufferSink);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/streaming/SourceBufferSink.js":
/*!*******************************************!*\
  !*** ./src/streaming/SourceBufferSink.js ***!
  \*******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _core_Settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/Settings */ "./src/core/Settings.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */








var APPEND_WINDOW_START_OFFSET = 0.1;
var APPEND_WINDOW_END_OFFSET = 0.01;
/**
 * @class SourceBufferSink
 * @ignore
 * @implements FragmentSink
 */

var CHECK_INTERVAL = 50;

function SourceBufferSink(config) {
  var context = this.context;
  var settings = (0,_core_Settings__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var textController = config.textController;
  var eventBus = config.eventBus;
  var instance, type, logger, buffer, mediaInfo, intervalId;
  var callbacks = [];
  var appendQueue = [];
  var isAppendingInProgress = false;
  var mediaSource = config.mediaSource;
  var lastRequestAppended = null;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_0__["default"])(context).getInstance().getLogger(instance);
  }

  function initializeForStreamSwitch(mInfo, selectedRepresentation, oldSourceBufferSink) {
    mediaInfo = mInfo;
    type = mediaInfo.type;
    var codec = mediaInfo.codec;

    _copyPreviousSinkData(oldSourceBufferSink);

    _addEventListeners();

    var promises = [];
    promises.push(_abortBeforeAppend());
    promises.push(updateAppendWindow(mediaInfo.streamInfo));

    if (settings.get().streaming.buffer.useChangeTypeForTrackSwitch) {
      promises.push(changeType(codec));
    }

    if (selectedRepresentation && selectedRepresentation.MSETimeOffset !== undefined) {
      promises.push(updateTimestampOffset(selectedRepresentation.MSETimeOffset));
    }

    return Promise.all(promises);
  }

  function changeType(codec) {
    return new Promise(function (resolve) {
      _waitForUpdateEnd(function () {
        if (buffer.changeType) {
          buffer.changeType(codec);
        }

        resolve();
      });
    });
  }

  function _copyPreviousSinkData(oldSourceBufferSink) {
    buffer = oldSourceBufferSink.getBuffer();
  }

  function initializeForFirstUse(streamInfo, mInfo, selectedRepresentation) {
    mediaInfo = mInfo;
    type = mediaInfo.type;
    var codec = mediaInfo.codec;

    try {
      // Safari claims to support anything starting 'application/mp4'.
      // it definitely doesn't understand 'application/mp4;codecs="stpp"'
      // - currently no browser does, so check for it and use our own
      // implementation. The same is true for codecs="wvtt".
      if (codec.match(/application\/mp4;\s*codecs="(stpp|wvtt).*"/i)) {
        return _initializeForText(streamInfo);
      }

      buffer = mediaSource.addSourceBuffer(codec);

      _addEventListeners();

      var promises = [];
      promises.push(updateAppendWindow(mediaInfo.streamInfo));

      if (selectedRepresentation && selectedRepresentation.MSETimeOffset !== undefined) {
        promises.push(updateTimestampOffset(selectedRepresentation.MSETimeOffset));
      }

      return Promise.all(promises);
    } catch (e) {
      // Note that in the following, the quotes are open to allow for extra text after stpp and wvtt
      if (mediaInfo.type == _constants_Constants__WEBPACK_IMPORTED_MODULE_5__["default"].TEXT && !mediaInfo.isFragmented || codec.indexOf('codecs="stpp') !== -1 || codec.indexOf('codecs="vtt') !== -1 || codec.indexOf('text/vtt') !== -1) {
        return _initializeForText(streamInfo);
      }

      return Promise.reject(e);
    }
  }

  function _initializeForText(streamInfo) {
    buffer = textController.getTextSourceBuffer(streamInfo);
    return Promise.resolve();
  }

  function _addEventListeners() {
    // use updateend event if possible
    if (typeof buffer.addEventListener === 'function') {
      try {
        buffer.addEventListener('updateend', _updateEndHandler, false);
        buffer.addEventListener('error', _errHandler, false);
        buffer.addEventListener('abort', _errHandler, false);
      } catch (err) {
        // use setInterval to periodically check if updating has been completed
        intervalId = setInterval(_updateEndHandler, CHECK_INTERVAL);
      }
    } else {
      // use setInterval to periodically check if updating has been completed
      intervalId = setInterval(_updateEndHandler, CHECK_INTERVAL);
    }
  }

  function getType() {
    return type;
  }

  function _removeEventListeners() {
    try {
      if (typeof buffer.removeEventListener === 'function') {
        buffer.removeEventListener('updateend', _updateEndHandler, false);
        buffer.removeEventListener('error', _errHandler, false);
        buffer.removeEventListener('abort', _errHandler, false);
      }

      clearInterval(intervalId);
    } catch (e) {
      logger.error(e);
    }
  }

  function updateAppendWindow(sInfo) {
    return new Promise(function (resolve) {
      if (!buffer || !settings.get().streaming.buffer.useAppendWindow) {
        resolve();
        return;
      }

      _waitForUpdateEnd(function () {
        try {
          if (!buffer) {
            resolve();
            return;
          }

          var appendWindowEnd = mediaSource.duration;
          var appendWindowStart = 0;

          if (sInfo && !isNaN(sInfo.start) && !isNaN(sInfo.duration) && isFinite(sInfo.duration)) {
            appendWindowEnd = sInfo.start + sInfo.duration;
          }

          if (sInfo && !isNaN(sInfo.start)) {
            appendWindowStart = sInfo.start;
          }

          if (buffer.appendWindowEnd !== appendWindowEnd || buffer.appendWindowStart !== appendWindowStart) {
            buffer.appendWindowStart = 0;
            buffer.appendWindowEnd = appendWindowEnd + APPEND_WINDOW_END_OFFSET;
            buffer.appendWindowStart = Math.max(appendWindowStart - APPEND_WINDOW_START_OFFSET, 0);
            logger.debug("Updated append window for ".concat(mediaInfo.type, ". Set start to ").concat(buffer.appendWindowStart, " and end to ").concat(buffer.appendWindowEnd));
          }

          resolve();
        } catch (e) {
          logger.warn("Failed to set append window");
          resolve();
        }
      });
    });
  }

  function updateTimestampOffset(MSETimeOffset) {
    return new Promise(function (resolve) {
      if (!buffer) {
        resolve();
        return;
      }

      _waitForUpdateEnd(function () {
        try {
          if (buffer.timestampOffset !== MSETimeOffset && !isNaN(MSETimeOffset)) {
            buffer.timestampOffset = MSETimeOffset;
            logger.debug("Set MSE timestamp offset to ".concat(MSETimeOffset));
          }

          resolve();
        } catch (e) {
          resolve();
        }
      });
    });
  }

  function reset() {
    if (buffer) {
      try {
        callbacks = [];

        _removeEventListeners();

        isAppendingInProgress = false;
        appendQueue = [];

        if (!buffer.getClassName || buffer.getClassName() !== 'TextSourceBuffer') {
          logger.debug("Removing sourcebuffer from media source");
          mediaSource.removeSourceBuffer(buffer);
        }
      } catch (e) {}

      buffer = null;
    }

    lastRequestAppended = null;
  }

  function getBuffer() {
    return buffer;
  }

  function getAllBufferRanges() {
    try {
      return buffer.buffered;
    } catch (e) {
      logger.error('getAllBufferRanges exception: ' + e.message);
      return null;
    }
  }

  function append(chunk) {
    var _this = this;

    var request = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return new Promise(function (resolve, reject) {
      if (!chunk) {
        reject({
          chunk: chunk,
          error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__["default"].APPEND_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__["default"].APPEND_ERROR_MESSAGE)
        });
        return;
      }

      appendQueue.push({
        data: chunk,
        promise: {
          resolve: resolve,
          reject: reject
        },
        request: request
      });

      _waitForUpdateEnd(_appendNextInQueue.bind(_this));
    });
  }

  function _abortBeforeAppend() {
    return new Promise(function (resolve) {
      _waitForUpdateEnd(function () {
        // Save the append window, which is reset on abort().
        var appendWindowStart = buffer.appendWindowStart;
        var appendWindowEnd = buffer.appendWindowEnd;

        if (buffer) {
          buffer.abort();
          buffer.appendWindowStart = appendWindowStart;
          buffer.appendWindowEnd = appendWindowEnd;
        }

        resolve();
      });
    });
  }

  function remove(range) {
    return new Promise(function (resolve, reject) {
      var start = range.start;
      var end = range.end; // make sure that the given time range is correct. Otherwise we will get InvalidAccessError

      if (!(start >= 0 && end > start)) {
        resolve();
        return;
      }

      _waitForUpdateEnd(function () {
        try {
          buffer.remove(start, end); // updating is in progress, we should wait for it to complete before signaling that this operation is done

          _waitForUpdateEnd(function () {
            resolve({
              from: start,
              to: end,
              unintended: false
            });

            if (range.resolve) {
              range.resolve();
            }
          });
        } catch (err) {
          reject({
            from: start,
            to: end,
            unintended: false,
            error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__["default"].REMOVE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_3__["default"].REMOVE_ERROR_MESSAGE)
          });

          if (range.reject) {
            range.reject(err);
          }
        }
      });
    });
  }

  function _appendNextInQueue() {
    if (isAppendingInProgress) {
      return;
    }

    if (appendQueue.length > 0) {
      isAppendingInProgress = true;
      var nextChunk = appendQueue[0];
      appendQueue.splice(0, 1);

      var afterSuccess = function afterSuccess() {
        isAppendingInProgress = false;

        if (appendQueue.length > 0) {
          _appendNextInQueue.call(this);
        } // Init segments are cached. In any other case we dont need the chunk bytes anymore and can free the memory


        if (nextChunk && nextChunk.data && nextChunk.data.segmentType && nextChunk.data.segmentType !== _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_6__.HTTPRequest.INIT_SEGMENT_TYPE) {
          delete nextChunk.data.bytes;
        }

        nextChunk.promise.resolve({
          chunk: nextChunk.data
        });
      };

      try {
        lastRequestAppended = nextChunk.request;

        if (nextChunk.data.bytes.byteLength === 0) {
          afterSuccess.call(this);
        } else {
          if (buffer.appendBuffer) {
            buffer.appendBuffer(nextChunk.data.bytes);
          } else {
            buffer.append(nextChunk.data.bytes, nextChunk.data);
          } // updating is in progress, we should wait for it to complete before signaling that this operation is done


          _waitForUpdateEnd(afterSuccess.bind(this));
        }
      } catch (err) {
        logger.fatal('SourceBuffer append failed "' + err + '"');

        if (appendQueue.length > 0) {
          _appendNextInQueue();
        } else {
          isAppendingInProgress = false;
        }

        delete nextChunk.data.bytes;
        nextChunk.promise.reject({
          chunk: nextChunk.data,
          error: new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_1__["default"](err.code, err.message)
        });
      }
    }
  }

  function abort() {
    return new Promise(function (resolve) {
      try {
        appendQueue = [];

        if (mediaSource.readyState === 'open') {
          _waitForUpdateEnd(function () {
            try {
              if (buffer) {
                buffer.abort();
              }

              resolve();
            } catch (e) {
              resolve();
            }
          });
        } else if (buffer && buffer.setTextTrack && mediaSource.readyState === 'ended') {
          buffer.abort(); //The cues need to be removed from the TextSourceBuffer via a call to abort()

          resolve();
        } else {
          resolve();
        }
      } catch (e) {
        resolve();
      }
    });
  }

  function _executeCallback() {
    if (callbacks.length > 0) {
      if (!buffer.updating) {
        var cb = callbacks.shift();
        cb(); // Try to execute next callback if still not updating

        _executeCallback();
      }
    }
  }

  function _updateEndHandler() {
    // if updating is still in progress do nothing and wait for the next check again.
    if (buffer.updating) {
      return;
    } // updating is completed, now we can stop checking and resolve the promise


    _executeCallback();
  }

  function _errHandler(e) {
    var error = e.target || {};

    _triggerEvent(_core_events_Events__WEBPACK_IMPORTED_MODULE_7__["default"].SOURCE_BUFFER_ERROR, {
      error: error,
      lastRequestAppended: lastRequestAppended
    });
  }

  function _triggerEvent(eventType, data) {
    var payload = data || {};
    eventBus.trigger(eventType, payload, {
      streamId: mediaInfo.streamInfo.id,
      mediaType: type
    });
  }

  function _waitForUpdateEnd(callback) {
    callbacks.push(callback);

    if (!buffer.updating) {
      _executeCallback();
    }
  }

  instance = {
    getType: getType,
    getAllBufferRanges: getAllBufferRanges,
    getBuffer: getBuffer,
    append: append,
    remove: remove,
    abort: abort,
    reset: reset,
    updateTimestampOffset: updateTimestampOffset,
    initializeForStreamSwitch: initializeForStreamSwitch,
    initializeForFirstUse: initializeForFirstUse,
    updateAppendWindow: updateAppendWindow,
    changeType: changeType
  };
  setup();
  return instance;
}

SourceBufferSink.__dashjs_factory_name = 'SourceBufferSink';
var factory = _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_2__["default"].getClassFactory(SourceBufferSink);
/* harmony default export */ __webpack_exports__["default"] = (factory);

/***/ }),

/***/ "./src/streaming/Stream.js":
/*!*********************************!*\
  !*** ./src/streaming/Stream.js ***!
  \*********************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _StreamProcessor__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./StreamProcessor */ "./src/streaming/StreamProcessor.js");
/* harmony import */ var _controllers_FragmentController__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./controllers/FragmentController */ "./src/streaming/controllers/FragmentController.js");
/* harmony import */ var _thumbnail_ThumbnailController__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./thumbnail/ThumbnailController */ "./src/streaming/thumbnail/ThumbnailController.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _utils_BoxParser__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./utils/BoxParser */ "./src/streaming/utils/BoxParser.js");
/* harmony import */ var _utils_URLUtils__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _controllers_BlacklistController__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./controllers/BlacklistController */ "./src/streaming/controllers/BlacklistController.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */














var MEDIA_TYPES = [_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE];

function Stream(config) {
  config = config || {};
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  var urlUtils = (0,_utils_URLUtils__WEBPACK_IMPORTED_MODULE_12__["default"])(context).getInstance();
  var manifestModel = config.manifestModel;
  var mediaPlayerModel = config.mediaPlayerModel;
  var dashMetrics = config.dashMetrics;
  var manifestUpdater = config.manifestUpdater;
  var adapter = config.adapter;
  var timelineConverter = config.timelineConverter;
  var capabilities = config.capabilities;
  var errHandler = config.errHandler;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var eventController = config.eventController;
  var mediaController = config.mediaController;
  var protectionController = config.protectionController;
  var textController = config.textController;
  var videoModel = config.videoModel;
  var streamInfo = config.streamInfo;
  var settings = config.settings;
  var instance, logger, streamProcessors, isInitialized, isActive, hasFinishedBuffering, hasVideoTrack, hasAudioTrack, updateError, isUpdating, fragmentController, thumbnailController, segmentBlacklistController, preloaded, boxParser, debug, isEndedEventSignaled, trackChangedEvents;
  /**
   * Setup the stream
   */

  function setup() {
    try {
      debug = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_7__["default"])(context).getInstance();
      logger = debug.getLogger(instance);
      resetInitialSettings();
      boxParser = (0,_utils_BoxParser__WEBPACK_IMPORTED_MODULE_11__["default"])(context).getInstance();
      segmentBlacklistController = (0,_controllers_BlacklistController__WEBPACK_IMPORTED_MODULE_13__["default"])(context).create({
        updateEventName: _core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SEGMENT_LOCATION_BLACKLIST_CHANGED,
        addBlacklistEventName: _core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SEGMENT_LOCATION_BLACKLIST_ADD
      });
      fragmentController = (0,_controllers_FragmentController__WEBPACK_IMPORTED_MODULE_3__["default"])(context).create({
        streamInfo: streamInfo,
        mediaPlayerModel: mediaPlayerModel,
        dashMetrics: dashMetrics,
        errHandler: errHandler,
        settings: settings,
        boxParser: boxParser,
        dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
        urlUtils: urlUtils
      });
    } catch (e) {
      throw e;
    }
  }
  /**
   * Initialize the events
   */


  function initialize() {
    registerEvents();
    registerProtectionEvents();
    textController.initializeForStream(streamInfo);
    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_UPDATED, {
      streamInfo: streamInfo
    });
  }
  /**
   * Register the streaming events
   */


  function registerEvents() {
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].BUFFERING_COMPLETED, onBufferingCompleted, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].DATA_UPDATE_COMPLETED, onDataUpdateCompleted, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].INBAND_EVENTS, onInbandEvents, instance);
  }
  /**
   * Unregister the streaming events
   */


  function unRegisterEvents() {
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].DATA_UPDATE_COMPLETED, onDataUpdateCompleted, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].BUFFERING_COMPLETED, onBufferingCompleted, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].INBAND_EVENTS, onInbandEvents, instance);
  }
  /**
   * Register the protection events
   */


  function registerProtectionEvents() {
    if (protectionController) {
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_ERROR, onProtectionError, instance);
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SERVER_CERTIFICATE_UPDATED, onProtectionError, instance);
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].LICENSE_REQUEST_COMPLETE, onProtectionError, instance);
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_SYSTEM_SELECTED, onProtectionError, instance);
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_SESSION_CREATED, onProtectionError, instance);
      eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_STATUSES_CHANGED, onProtectionError, instance);
    }
  }
  /**
   * Unregister the protection events
   */


  function unRegisterProtectionEvents() {
    if (protectionController) {
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_ERROR, onProtectionError, instance);
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].SERVER_CERTIFICATE_UPDATED, onProtectionError, instance);
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].LICENSE_REQUEST_COMPLETE, onProtectionError, instance);
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_SYSTEM_SELECTED, onProtectionError, instance);
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_SESSION_CREATED, onProtectionError, instance);
      eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].KEY_STATUSES_CHANGED, onProtectionError, instance);
    }
  }
  /**
   * Returns the stream id
   * @return {*|null}
   */


  function getStreamId() {
    return streamInfo ? streamInfo.id : null;
  }
  /**
   * Activates Stream by re-initializing some of its components
   * @param {MediaSource} mediaSource
   * @param {array} previousBufferSinks
   * @memberof Stream#
   */


  function activate(mediaSource, previousBufferSinks) {
    return new Promise(function (resolve, reject) {
      if (isActive) {
        resolve(previousBufferSinks);
        return;
      }

      if (getPreloaded()) {
        isActive = true;
        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_ACTIVATED, {
          streamInfo: streamInfo
        });
        resolve(previousBufferSinks);
        return;
      }

      _initializeMedia(mediaSource, previousBufferSinks).then(function (bufferSinks) {
        isActive = true;
        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_ACTIVATED, {
          streamInfo: streamInfo
        });
        resolve(bufferSinks);
      })["catch"](function (e) {
        reject(e);
      });
    });
  }

  function startPreloading(mediaSource, previousBuffers) {
    return new Promise(function (resolve, reject) {
      if (getPreloaded()) {
        reject();
        return;
      }

      logger.info("[startPreloading] Preloading next stream with id ".concat(getId()));
      setPreloaded(true);

      _commonMediaInitialization(mediaSource, previousBuffers).then(function () {
        for (var i = 0; i < streamProcessors.length && streamProcessors[i]; i++) {
          streamProcessors[i].setExplicitBufferingTime(getStartTime());
          streamProcessors[i].getScheduleController().startScheduleTimer();
        }

        resolve();
      })["catch"](function () {
        setPreloaded(false);
        reject();
      });
    });
  }
  /**
   *
   * @param {object} mediaSource
   * @param {array} previousBufferSinks
   * @return {Promise<Array>}
   * @private
   */


  function _initializeMedia(mediaSource, previousBufferSinks) {
    return _commonMediaInitialization(mediaSource, previousBufferSinks);
  }
  /**
   *
   * @param {object} mediaSource
   * @param {array} previousBufferSinks
   * @return {Promise<array>}
   * @private
   */


  function _commonMediaInitialization(mediaSource, previousBufferSinks) {
    return new Promise(function (resolve, reject) {
      checkConfig();
      isUpdating = true;

      _addInlineEvents();

      var element = videoModel.getElement();
      var promises = [];
      MEDIA_TYPES.forEach(function (mediaType) {
        // If we are preloading without a video element we can not start texttrack handling.
        if (!(mediaType === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT && !mediaSource) && (mediaType !== _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO || !element || element && /^VIDEO$/i.test(element.nodeName))) {
          promises.push(_initializeMediaForType(mediaType, mediaSource));
        }
      });
      Promise.all(promises).then(function () {
        return _createBufferSinks(previousBufferSinks);
      }).then(function (bufferSinks) {
        isUpdating = false;

        if (streamProcessors.length === 0) {
          var msg = 'No streams to play.';
          errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].MANIFEST_ERROR_ID_NOSTREAMS_CODE, msg, manifestModel.getValue()));
          logger.fatal(msg);
        } else {
          _checkIfInitializationCompleted();
        }

        if (mediaSource) {
          // All mediaInfos for texttracks are added to the TextSourceBuffer by now. We can start creating the tracks
          textController.createTracks(streamInfo);
        }

        resolve(bufferSinks);
      })["catch"](function (e) {
        reject(e);
      });
    });
  }
  /**
   * We call this function if segments have been preloaded without a video element. Once the video element is attached MSE is available
   * @param mediaSource
   * @returns {Promise<unknown>}
   */


  function initializeForTextWithMediaSource(mediaSource) {
    return new Promise(function (resolve, reject) {
      _initializeMediaForType(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT, mediaSource).then(function () {
        return createBufferSinkForText();
      }).then(function () {
        textController.createTracks(streamInfo);
        resolve();
      })["catch"](function (e) {
        reject(e);
      });
    });
  }
  /**
   * Initialize for a given media type. Creates a corresponding StreamProcessor
   * @param {string} type
   * @param {object} mediaSource
   * @private
   */


  function _initializeMediaForType(type, mediaSource) {
    var allMediaForType = adapter.getAllMediaInfoForType(streamInfo, type);
    var embeddedMediaInfos = [];
    var mediaInfo = null;
    var initialMediaInfo;

    if (!allMediaForType || allMediaForType.length === 0) {
      logger.info('No ' + type + ' data.');
      return Promise.resolve();
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO) {
      hasVideoTrack = true;
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO) {
      hasAudioTrack = true;
    }

    for (var i = 0, ln = allMediaForType.length; i < ln; i++) {
      mediaInfo = allMediaForType[i];

      if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT && !!mediaInfo.isEmbedded) {
        textController.addEmbeddedTrack(streamInfo, mediaInfo);
        embeddedMediaInfos.push(mediaInfo);
      }

      if (_isMediaSupported(mediaInfo)) {
        mediaController.addTrack(mediaInfo);
      }
    }

    if (embeddedMediaInfos.length > 0) {
      mediaController.setInitialMediaSettingsForType(type, streamInfo);
      textController.addMediaInfosToBuffer(streamInfo, type, embeddedMediaInfos);
    } // Filter out embedded text track before creating StreamProcessor


    allMediaForType = allMediaForType.filter(function (mediaInfo) {
      return !mediaInfo.isEmbedded;
    });

    if (allMediaForType.length === 0) {
      return Promise.resolve();
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE) {
      thumbnailController = (0,_thumbnail_ThumbnailController__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create({
        streamInfo: streamInfo,
        adapter: adapter,
        baseURLController: config.baseURLController,
        timelineConverter: config.timelineConverter,
        debug: debug,
        eventBus: eventBus,
        events: _core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"],
        dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
        dashMetrics: config.dashMetrics,
        segmentBaseController: config.segmentBaseController
      });
      thumbnailController.initialize();
      return Promise.resolve();
    }

    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_INITIALIZING, {
      streamInfo: streamInfo,
      mediaInfo: mediaInfo
    });
    mediaController.setInitialMediaSettingsForType(type, streamInfo);

    var streamProcessor = _createStreamProcessor(allMediaForType, mediaSource);

    initialMediaInfo = mediaController.getCurrentTrackFor(type, streamInfo.id);

    if (initialMediaInfo) {
      abrController.updateTopQualityIndex(initialMediaInfo); // In case of mixed fragmented and embedded text tracks, check if initial selected text track is not an embedded track

      return streamProcessor.selectMediaInfo(type !== _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || !initialMediaInfo.isEmbedded ? initialMediaInfo : allMediaForType[0]);
    }

    return Promise.resolve();
  }

  function _isMediaSupported(mediaInfo) {
    var type = mediaInfo ? mediaInfo.type : null;
    var msg;

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MUXED) {
      msg = 'Multiplexed representations are intentionally not supported, as they are not compliant with the DASH-AVC/264 guidelines';
      logger.fatal(msg);
      errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].MANIFEST_ERROR_ID_MULTIPLEXED_CODE, msg, manifestModel.getValue()));
      return false;
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE) {
      return true;
    }

    if (!!mediaInfo.contentProtection && !capabilities.supportsEncryptedMedia()) {
      errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].CAPABILITY_MEDIAKEYS_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].CAPABILITY_MEDIAKEYS_ERROR_MESSAGE));
      return false;
    }

    return true;
  }
  /**
   * Creates the StreamProcessor for a given media type.
   * @param {array} allMediaForType
   * @param {object} mediaSource
   * @private
   */


  function _createStreamProcessor(allMediaForType, mediaSource) {
    var mediaInfo = allMediaForType && allMediaForType.length > 0 ? allMediaForType[0] : null;
    var fragmentModel = fragmentController.getModel(mediaInfo ? mediaInfo.type : null);
    var type = mediaInfo ? mediaInfo.type : null;
    var mimeType = mediaInfo ? mediaInfo.mimeType : null;
    var isFragmented = mediaInfo ? mediaInfo.isFragmented : null;
    var streamProcessor = (0,_StreamProcessor__WEBPACK_IMPORTED_MODULE_2__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      mimeType: mimeType,
      timelineConverter: timelineConverter,
      adapter: adapter,
      manifestModel: manifestModel,
      mediaPlayerModel: mediaPlayerModel,
      fragmentModel: fragmentModel,
      dashMetrics: config.dashMetrics,
      baseURLController: config.baseURLController,
      segmentBaseController: config.segmentBaseController,
      abrController: abrController,
      playbackController: playbackController,
      mediaController: mediaController,
      textController: textController,
      errHandler: errHandler,
      settings: settings,
      boxParser: boxParser,
      segmentBlacklistController: segmentBlacklistController
    });
    streamProcessor.initialize(mediaSource, hasVideoTrack, isFragmented);
    streamProcessors.push(streamProcessor);

    for (var i = 0; i < allMediaForType.length; i++) {
      streamProcessor.addMediaInfo(allMediaForType[i]);
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT) {
      textController.addMediaInfosToBuffer(streamInfo, type, allMediaForType, fragmentModel);
    }

    return streamProcessor;
  }
  /**
   * Creates the SourceBufferSink objects for all StreamProcessors
   * @param {array} previousBuffersSinks
   * @return {Promise<object>}
   * @private
   */


  function _createBufferSinks(previousBuffersSinks) {
    return new Promise(function (resolve) {
      var buffers = {};
      var promises = streamProcessors.map(function (sp) {
        return sp.createBufferSinks(previousBuffersSinks);
      });
      Promise.all(promises).then(function (bufferSinks) {
        bufferSinks.forEach(function (sink) {
          if (sink) {
            buffers[sink.getType()] = sink;
          }
        });
        resolve(buffers);
      })["catch"](function () {
        resolve(buffers);
      });
    });
  }

  function createBufferSinkForText() {
    var sp = _getProcessorByType(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT);

    if (sp) {
      return sp.createBufferSinks();
    }

    return Promise.resolve();
  }
  /**
   * Partially resets some of the Stream elements. This function is called when preloading of streams is canceled or a stream switch occurs.
   * @memberof Stream#
   * @param {boolean} keepBuffers
   */


  function deactivate(keepBuffers) {
    var ln = streamProcessors ? streamProcessors.length : 0;
    var errored = false;

    for (var i = 0; i < ln; i++) {
      var fragmentModel = streamProcessors[i].getFragmentModel();
      fragmentModel.abortRequests();
      fragmentModel.resetInitialSettings();
      streamProcessors[i].reset(errored, keepBuffers);
    }

    if (textController) {
      textController.deactivateStream(streamInfo);
    }

    streamProcessors = [];
    isActive = false;
    hasFinishedBuffering = false;
    setPreloaded(false);
    setIsEndedEventSignaled(false);
    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_DEACTIVATED, {
      streamInfo: streamInfo
    });
  }

  function getIsActive() {
    return isActive;
  }

  function setMediaSource(mediaSource) {
    return new Promise(function (resolve, reject) {
      var promises = [];

      for (var i = 0; i < streamProcessors.length;) {
        if (_isMediaSupported(streamProcessors[i].getMediaInfo())) {
          promises.push(streamProcessors[i].setMediaSource(mediaSource));
          i++;
        } else {
          streamProcessors[i].reset();
          streamProcessors.splice(i, 1);
        }
      }

      Promise.all(promises).then(function () {
        for (var _i = 0; _i < streamProcessors.length; _i++) {
          //Adding of new tracks to a stream processor isn't guaranteed by the spec after the METADATA_LOADED state
          //so do this after the buffers are created above.
          streamProcessors[_i].dischargePreBuffer();
        }

        if (streamProcessors.length === 0) {
          var msg = 'No streams to play.';
          errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].MANIFEST_ERROR_ID_NOSTREAMS_CODE, msg + 'nostreams', manifestModel.getValue()));
          logger.fatal(msg);
        }

        resolve();
      })["catch"](function (e) {
        logger.error(e);
        reject(e);
      });
    });
  }

  function resetInitialSettings(keepBuffers) {
    deactivate(keepBuffers);
    isInitialized = false;
    hasVideoTrack = false;
    hasAudioTrack = false;
    updateError = {};
    isUpdating = false;
    isEndedEventSignaled = false;
    trackChangedEvents = [];
  }

  function reset(keepBuffers) {
    if (fragmentController) {
      fragmentController.reset();
      fragmentController = null;
    }

    if (abrController && streamInfo) {
      abrController.clearDataForStream(streamInfo.id);
    }

    if (segmentBlacklistController) {
      segmentBlacklistController.reset();
      segmentBlacklistController = null;
    }

    resetInitialSettings(keepBuffers);
    streamInfo = null;
    unRegisterEvents();
    unRegisterProtectionEvents();
  }

  function getDuration() {
    return streamInfo ? streamInfo.duration : NaN;
  }

  function getIsEndedEventSignaled() {
    return isEndedEventSignaled;
  }

  function setIsEndedEventSignaled(value) {
    isEndedEventSignaled = value;
  }

  function getStartTime() {
    return streamInfo ? streamInfo.start : NaN;
  }

  function getId() {
    return streamInfo ? streamInfo.id : null;
  }

  function getStreamInfo() {
    return streamInfo;
  }

  function getHasAudioTrack() {
    return hasAudioTrack;
  }

  function getHasVideoTrack() {
    return hasVideoTrack;
  }

  function getThumbnailController() {
    return thumbnailController;
  }

  function checkConfig() {
    if (!videoModel || !abrController) {
      throw new Error(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].MISSING_CONFIG_ERROR);
    }
  }
  /**
   * @param {string} type
   * @returns {Array}
   * @memberof Stream#
   */


  function getBitrateListFor(type) {
    checkConfig();

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].IMAGE) {
      if (!thumbnailController) {
        return [];
      }

      return thumbnailController.getBitrateList();
    }

    var mediaInfo = getMediaInfo(type);
    return abrController.getBitrateList(mediaInfo);
  }

  function onProtectionError(event) {
    if (event.error) {
      errHandler.error(event.error);
      logger.fatal(event.error.message);
    }
  }

  function prepareTrackChange(e) {
    if (!isActive || !streamInfo) {
      return;
    }

    hasFinishedBuffering = false;
    var mediaInfo = e.newMediaInfo;
    var manifest = manifestModel.getValue();
    adapter.setCurrentMediaInfo(streamInfo.id, mediaInfo.type, mediaInfo);
    var processor = getProcessorForMediaInfo(mediaInfo);
    if (!processor) return;
    var currentTime = playbackController.getTime();
    logger.info('Stream -  Process track changed at current time ' + currentTime); // Applies only for MSS streams

    if (manifest.refreshManifestOnSwitchTrack) {
      trackChangedEvents.push(e);

      if (!manifestUpdater.getIsUpdating()) {
        logger.debug('Stream -  Refreshing manifest for switch track');
        manifestUpdater.refreshManifest();
      }
    } else {
      processor.selectMediaInfo(mediaInfo).then(function () {
        if (mediaInfo.type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO || mediaInfo.type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO) {
          abrController.updateTopQualityIndex(mediaInfo);
        }

        processor.prepareTrackSwitch();
      });
    }
  }

  function prepareQualityChange(e) {
    var processor = _getProcessorByType(e.mediaType);

    if (processor) {
      processor.prepareQualityChange(e);
    }
  }

  function _addInlineEvents() {
    if (eventController) {
      var events = adapter.getEventsFor(streamInfo);

      if (events && events.length > 0) {
        eventController.addInlineEvents(events, streamInfo.id);
      }
    }
  }

  function _checkIfInitializationCompleted() {
    var ln = streamProcessors.length;
    var hasError = !!updateError.audio || !!updateError.video;
    var error = hasError ? new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_10__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].DATA_UPDATE_FAILED_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_8__["default"].DATA_UPDATE_FAILED_ERROR_MESSAGE) : null;

    for (var i = 0; i < ln; i++) {
      if (streamProcessors[i].isUpdating() || isUpdating) {
        return;
      }
    }

    if (protectionController) {
      // Need to check if streamProcessors exists because streamProcessors
      // could be cleared in case an error is detected while initializing DRM keysystem
      protectionController.clearMediaInfoArray();

      for (var _i2 = 0; _i2 < ln && streamProcessors[_i2]; _i2++) {
        var type = streamProcessors[_i2].getType();

        var mediaInfo = streamProcessors[_i2].getMediaInfo();

        if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO || type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO || type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT && mediaInfo.isFragmented) {
          var _mediaInfo = streamProcessors[_i2].getMediaInfo();

          if (_mediaInfo) {
            protectionController.initializeForMedia(_mediaInfo);
          }
        }
      }

      protectionController.handleKeySystemFromManifest();
    }

    if (error) {
      errHandler.error(error);
    } else if (!isInitialized) {
      isInitialized = true;
      videoModel.waitForReadyState(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO_ELEMENT_READY_STATES.HAVE_METADATA, function () {
        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_INITIALIZED, {
          streamInfo: streamInfo
        });
      });
    }
  }

  function getMediaInfo(type) {
    var streamProcessor = null;

    for (var i = 0; i < streamProcessors.length; i++) {
      streamProcessor = streamProcessors[i];

      if (streamProcessor.getType() === type) {
        return streamProcessor.getMediaInfo();
      }
    }

    return null;
  }

  function onBufferingCompleted() {
    var processors = getProcessors();
    var ln = processors.length;

    if (ln === 0) {
      logger.warn('onBufferingCompleted - can\'t trigger STREAM_BUFFERING_COMPLETED because no streamProcessor is defined');
      return;
    } // if there is at least one buffer controller that has not completed buffering yet do nothing


    for (var i = 0; i < ln; i++) {
      //if audio or video buffer is not buffering completed state, do not send STREAM_BUFFERING_COMPLETED
      if (!processors[i].isBufferingCompleted() && (processors[i].getType() === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO || processors[i].getType() === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO)) {
        logger.debug('onBufferingCompleted - One streamProcessor has finished but', processors[i].getType(), 'one is not buffering completed');
        return;
      }
    }

    logger.debug('onBufferingCompleted - trigger STREAM_BUFFERING_COMPLETED');
    hasFinishedBuffering = true;
    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_BUFFERING_COMPLETED, {
      streamInfo: streamInfo
    }, {
      streamInfo: streamInfo
    });
  }

  function onDataUpdateCompleted(e) {
    updateError[e.mediaType] = e.error;

    _checkIfInitializationCompleted();
  }

  function onInbandEvents(e) {
    if (eventController) {
      eventController.addInbandEvents(e.events, streamInfo.id);
    }
  }

  function getProcessorForMediaInfo(mediaInfo) {
    if (!mediaInfo || !mediaInfo.type) {
      return null;
    }

    return _getProcessorByType(mediaInfo.type);
  }

  function _getProcessorByType(type) {
    if (!type) {
      return null;
    }

    var processors = getProcessors();
    return processors.filter(function (processor) {
      return processor.getType() === type;
    })[0];
  }

  function getProcessors() {
    var arr = [];
    var type, streamProcessor;

    for (var i = 0; i < streamProcessors.length; i++) {
      streamProcessor = streamProcessors[i];
      type = streamProcessor.getType();

      if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO || type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO || type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT) {
        arr.push(streamProcessor);
      }
    }

    return arr;
  }

  function startScheduleControllers() {
    var ln = streamProcessors.length;

    for (var i = 0; i < ln && streamProcessors[i]; i++) {
      streamProcessors[i].getScheduleController().startScheduleTimer();
    }
  }

  function updateData(updatedStreamInfo) {
    return new Promise(function (resolve) {
      isUpdating = true;
      streamInfo = updatedStreamInfo;

      if (eventController) {
        _addInlineEvents();
      }

      var promises = [];

      for (var i = 0, ln = streamProcessors.length; i < ln; i++) {
        var streamProcessor = streamProcessors[i];
        var currentMediaInfo = streamProcessor.getMediaInfo();
        promises.push(streamProcessor.updateStreamInfo(streamInfo));
        var allMediaForType = adapter.getAllMediaInfoForType(streamInfo, streamProcessor.getType()); // Filter out embedded text track before updating media info in  StreamProcessor

        allMediaForType = allMediaForType.filter(function (mediaInfo) {
          return !mediaInfo.isEmbedded;
        }); // Check if AdaptationSet has not been removed in MPD update

        if (allMediaForType) {
          // Remove the current mediaInfo objects before adding the updated ones
          streamProcessor.clearMediaInfoArray();

          for (var j = 0; j < allMediaForType.length; j++) {
            var mInfo = allMediaForType[j];
            streamProcessor.addMediaInfo(allMediaForType[j]);

            if (adapter.areMediaInfosEqual(currentMediaInfo, mInfo)) {
              abrController.updateTopQualityIndex(mInfo);
              promises.push(streamProcessor.selectMediaInfo(mInfo));
            }
          }
        }
      }

      Promise.all(promises).then(function () {
        promises = [];

        while (trackChangedEvents.length > 0) {
          var trackChangedEvent = trackChangedEvents.pop();
          var mediaInfo = trackChangedEvent.newMediaInfo;
          var processor = getProcessorForMediaInfo(trackChangedEvent.oldMediaInfo);
          if (!processor) return;
          promises.push(processor.prepareTrackSwitch());
          promises.push(processor.selectMediaInfo(mediaInfo));
        }

        return Promise.all(promises);
      }).then(function () {
        isUpdating = false;

        _checkIfInitializationCompleted();

        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].STREAM_UPDATED, {
          streamInfo: streamInfo
        });
        resolve();
      });
    });
  }

  function isMediaCodecCompatible(newStream) {
    var previousStream = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
    return compareCodecs(newStream, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, previousStream) && compareCodecs(newStream, _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO, previousStream);
  }

  function isProtectionCompatible(newStream) {
    if (!newStream) {
      return true;
    }

    return _compareProtectionConfig(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].VIDEO, newStream) && _compareProtectionConfig(_constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].AUDIO, newStream);
  }

  function _compareProtectionConfig(type, newStream) {
    var currentStreamInfo = getStreamInfo();
    var newStreamInfo = newStream.getStreamInfo();

    if (!newStreamInfo || !currentStreamInfo) {
      return true;
    }

    var newAdaptation = adapter.getAdaptationForType(newStreamInfo.index, type, newStreamInfo);
    var currentAdaptation = adapter.getAdaptationForType(currentStreamInfo.index, type, currentStreamInfo);

    if (!newAdaptation || !currentAdaptation) {
      // If there is no adaptation for neither the old or the new stream they're compatible
      return !newAdaptation && !currentAdaptation;
    } // If the current period is unencrypted and the upcoming one is encrypted we need to reset sourcebuffers.


    return !(!_isAdaptationDrmProtected(currentAdaptation) && _isAdaptationDrmProtected(newAdaptation));
  }

  function _isAdaptationDrmProtected(adaptation) {
    if (!adaptation) {
      // If there is no adaptation for neither the old or the new stream they're compatible
      return false;
    } // If the current period is unencrypted and the upcoming one is encrypted we need to reset sourcebuffers.


    return !!(adaptation.ContentProtection || adaptation.Representation_asArray && adaptation.Representation_asArray.length > 0 && adaptation.Representation_asArray[0].ContentProtection);
  }

  function compareCodecs(newStream, type) {
    var previousStream = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

    if (!newStream || !newStream.hasOwnProperty('getStreamInfo')) {
      return false;
    }

    var newStreamInfo = newStream.getStreamInfo();
    var currentStreamInfo = previousStream ? previousStream.getStreamInfo() : getStreamInfo();

    if (!newStreamInfo || !currentStreamInfo) {
      return false;
    }

    var newAdaptation = adapter.getAdaptationForType(newStreamInfo.index, type, newStreamInfo);
    var currentAdaptation = adapter.getAdaptationForType(currentStreamInfo.index, type, currentStreamInfo);

    if (!newAdaptation || !currentAdaptation) {
      // If there is no adaptation for neither the old or the new stream they're compatible
      return !newAdaptation && !currentAdaptation;
    }

    var sameMimeType = newAdaptation && currentAdaptation && newAdaptation.mimeType === currentAdaptation.mimeType;
    var oldCodecs = currentAdaptation.Representation_asArray.map(function (representation) {
      return representation.codecs;
    });
    var newCodecs = newAdaptation.Representation_asArray.map(function (representation) {
      return representation.codecs;
    });
    var codecMatch = newCodecs.some(function (newCodec) {
      return oldCodecs.indexOf(newCodec) > -1;
    });
    var partialCodecMatch = newCodecs.some(function (newCodec) {
      return oldCodecs.some(function (oldCodec) {
        return capabilities.codecRootCompatibleWithCodec(oldCodec, newCodec);
      });
    });
    return codecMatch || partialCodecMatch && sameMimeType;
  }

  function setPreloaded(value) {
    preloaded = value;
  }

  function getPreloaded() {
    return preloaded;
  }

  function getHasFinishedBuffering() {
    return hasFinishedBuffering;
  }

  function getAdapter() {
    return adapter;
  }

  instance = {
    initialize: initialize,
    getStreamId: getStreamId,
    activate: activate,
    deactivate: deactivate,
    getIsActive: getIsActive,
    getDuration: getDuration,
    getStartTime: getStartTime,
    getId: getId,
    getStreamInfo: getStreamInfo,
    getHasAudioTrack: getHasAudioTrack,
    getHasVideoTrack: getHasVideoTrack,
    startPreloading: startPreloading,
    initializeForTextWithMediaSource: initializeForTextWithMediaSource,
    getThumbnailController: getThumbnailController,
    getBitrateListFor: getBitrateListFor,
    updateData: updateData,
    reset: reset,
    getProcessors: getProcessors,
    setMediaSource: setMediaSource,
    isMediaCodecCompatible: isMediaCodecCompatible,
    isProtectionCompatible: isProtectionCompatible,
    getPreloaded: getPreloaded,
    getIsEndedEventSignaled: getIsEndedEventSignaled,
    setIsEndedEventSignaled: setIsEndedEventSignaled,
    getAdapter: getAdapter,
    getHasFinishedBuffering: getHasFinishedBuffering,
    setPreloaded: setPreloaded,
    startScheduleControllers: startScheduleControllers,
    prepareTrackChange: prepareTrackChange,
    prepareQualityChange: prepareQualityChange
  };
  setup();
  return instance;
}

Stream.__dashjs_factory_name = 'Stream';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_9__["default"].getClassFactory(Stream));

/***/ }),

/***/ "./src/streaming/StreamProcessor.js":
/*!******************************************!*\
  !*** ./src/streaming/StreamProcessor.js ***!
  \******************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../dash/constants/DashConstants */ "./src/dash/constants/DashConstants.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _models_FragmentModel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./models/FragmentModel */ "./src/streaming/models/FragmentModel.js");
/* harmony import */ var _controllers_BufferController__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./controllers/BufferController */ "./src/streaming/controllers/BufferController.js");
/* harmony import */ var _text_NotFragmentedTextBufferController__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./text/NotFragmentedTextBufferController */ "./src/streaming/text/NotFragmentedTextBufferController.js");
/* harmony import */ var _controllers_ScheduleController__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./controllers/ScheduleController */ "./src/streaming/controllers/ScheduleController.js");
/* harmony import */ var _dash_controllers_RepresentationController__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../dash/controllers/RepresentationController */ "./src/dash/controllers/RepresentationController.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils/SupervisorTools */ "./src/streaming/utils/SupervisorTools.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/* harmony import */ var _dash_DashHandler__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../dash/DashHandler */ "./src/dash/DashHandler.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _utils_RequestModifier__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./utils/RequestModifier */ "./src/streaming/utils/RequestModifier.js");
/* harmony import */ var _streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../streaming/utils/URLUtils */ "./src/streaming/utils/URLUtils.js");
/* harmony import */ var _vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./vo/metrics/PlayList */ "./src/streaming/vo/metrics/PlayList.js");
/* harmony import */ var _dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../dash/controllers/SegmentsController */ "./src/dash/controllers/SegmentsController.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _utils_TimeUtils__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./utils/TimeUtils */ "./src/streaming/utils/TimeUtils.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
























function StreamProcessor(config) {
  config = config || {};
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_10__["default"])(context).getInstance();
  var streamInfo = config.streamInfo;
  var type = config.type;
  var errHandler = config.errHandler;
  var mimeType = config.mimeType;
  var timelineConverter = config.timelineConverter;
  var adapter = config.adapter;
  var manifestModel = config.manifestModel;
  var mediaPlayerModel = config.mediaPlayerModel;
  var fragmentModel = config.fragmentModel;
  var abrController = config.abrController;
  var playbackController = config.playbackController;
  var mediaController = config.mediaController;
  var textController = config.textController;
  var dashMetrics = config.dashMetrics;
  var settings = config.settings;
  var boxParser = config.boxParser;
  var segmentBlacklistController = config.segmentBlacklistController;
  var instance, logger, isDynamic, mediaInfo, mediaInfoArr, bufferController, scheduleController, representationController, shouldUseExplicitTimeForRequest, shouldRepeatRequest, qualityChangeInProgress, dashHandler, segmentsController, bufferingTime, pendingSwitchToRepresentationInfo;

  function setup() {
    logger = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance().getLogger(instance);
    resetInitialSettings();
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].DATA_UPDATE_COMPLETED, _onDataUpdateCompleted, instance, {
      priority: _core_EventBus__WEBPACK_IMPORTED_MODULE_10__["default"].EVENT_PRIORITY_HIGH
    }); // High priority to be notified before Stream

    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].INIT_FRAGMENT_NEEDED, _onInitFragmentNeeded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].MEDIA_FRAGMENT_NEEDED, _onMediaFragmentNeeded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].INIT_FRAGMENT_LOADED, _onInitFragmentLoaded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].MEDIA_FRAGMENT_LOADED, _onMediaFragmentLoaded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_LEVEL_STATE_CHANGED, _onBufferLevelStateChanged, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_CLEARED, _onBufferCleared, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SEEK_TARGET, _onSeekTarget, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].FRAGMENT_LOADING_ABANDONED, _onFragmentLoadingAbandoned, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].FRAGMENT_LOADING_COMPLETED, _onFragmentLoadingCompleted, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].QUOTA_EXCEEDED, _onQuotaExceeded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SET_FRAGMENTED_TEXT_AFTER_DISABLED, _onSetFragmentedTextAfterDisabled, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SET_NON_FRAGMENTED_TEXT, _onSetNonFragmentedText, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SOURCE_BUFFER_ERROR, _onSourceBufferError, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BYTES_APPENDED_END_FRAGMENT, _onBytesAppended, instance);
  }

  function initialize(mediaSource, hasVideoTrack, isFragmented) {
    segmentsController = (0,_dash_controllers_SegmentsController__WEBPACK_IMPORTED_MODULE_20__["default"])(context).create({
      events: _core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"],
      eventBus: eventBus,
      streamInfo: streamInfo,
      timelineConverter: timelineConverter,
      dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
      segmentBaseController: config.segmentBaseController,
      type: type
    });
    dashHandler = (0,_dash_DashHandler__WEBPACK_IMPORTED_MODULE_13__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      timelineConverter: timelineConverter,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      baseURLController: config.baseURLController,
      errHandler: errHandler,
      segmentsController: segmentsController,
      settings: settings,
      boxParser: boxParser,
      events: _core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"],
      eventBus: eventBus,
      errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_14__["default"],
      debug: (0,_core_Debug__WEBPACK_IMPORTED_MODULE_16__["default"])(context).getInstance(),
      requestModifier: (0,_utils_RequestModifier__WEBPACK_IMPORTED_MODULE_17__["default"])(context).getInstance(),
      dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
      constants: _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"],
      urlUtils: (0,_streaming_utils_URLUtils__WEBPACK_IMPORTED_MODULE_18__["default"])(context).getInstance()
    });
    isDynamic = streamInfo.manifestInfo.isDynamic; // Create/initialize controllers

    dashHandler.initialize(isDynamic);
    abrController.registerStreamType(type, instance);
    representationController = (0,_dash_controllers_RepresentationController__WEBPACK_IMPORTED_MODULE_7__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      abrController: abrController,
      dashMetrics: dashMetrics,
      playbackController: playbackController,
      timelineConverter: timelineConverter,
      dashConstants: _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"],
      events: _core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"],
      eventBus: eventBus,
      errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_14__["default"],
      isDynamic: isDynamic,
      adapter: adapter,
      segmentsController: segmentsController
    });
    bufferController = _createBufferControllerForType(type, isFragmented);

    if (bufferController) {
      bufferController.initialize(mediaSource);
    }

    scheduleController = (0,_controllers_ScheduleController__WEBPACK_IMPORTED_MODULE_6__["default"])(context).create({
      streamInfo: streamInfo,
      type: type,
      mimeType: mimeType,
      adapter: adapter,
      dashMetrics: dashMetrics,
      mediaPlayerModel: mediaPlayerModel,
      fragmentModel: fragmentModel,
      abrController: abrController,
      playbackController: playbackController,
      textController: textController,
      mediaController: mediaController,
      bufferController: bufferController,
      representationController: representationController,
      settings: settings
    });
    scheduleController.initialize(hasVideoTrack);
    bufferingTime = 0;
    shouldUseExplicitTimeForRequest = false;
    shouldRepeatRequest = false;
  }

  function getStreamId() {
    return streamInfo.id;
  }

  function getType() {
    return type;
  }

  function getIsTextTrack() {
    return adapter.getIsTextTrack(representationController.getData());
  }

  function resetInitialSettings() {
    mediaInfoArr = [];
    mediaInfo = null;
    bufferingTime = 0;
    shouldUseExplicitTimeForRequest = false;
    shouldRepeatRequest = false;
    qualityChangeInProgress = false;
    pendingSwitchToRepresentationInfo = null;
  }

  function reset(errored, keepBuffers) {
    if (dashHandler) {
      dashHandler.reset();
    }

    if (bufferController) {
      bufferController.reset(errored, keepBuffers);
      bufferController = null;
    }

    if (scheduleController) {
      scheduleController.reset();
      scheduleController = null;
    }

    if (representationController) {
      representationController.reset();
      representationController = null;
    }

    if (segmentsController) {
      segmentsController = null;
    }

    if (abrController) {
      abrController.unRegisterStreamType(getStreamId(), type);
    }

    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].DATA_UPDATE_COMPLETED, _onDataUpdateCompleted, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].INIT_FRAGMENT_NEEDED, _onInitFragmentNeeded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].MEDIA_FRAGMENT_NEEDED, _onMediaFragmentNeeded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].INIT_FRAGMENT_LOADED, _onInitFragmentLoaded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].MEDIA_FRAGMENT_LOADED, _onMediaFragmentLoaded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_LEVEL_STATE_CHANGED, _onBufferLevelStateChanged, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_CLEARED, _onBufferCleared, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SEEK_TARGET, _onSeekTarget, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].FRAGMENT_LOADING_ABANDONED, _onFragmentLoadingAbandoned, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].FRAGMENT_LOADING_COMPLETED, _onFragmentLoadingCompleted, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SET_FRAGMENTED_TEXT_AFTER_DISABLED, _onSetFragmentedTextAfterDisabled, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SET_NON_FRAGMENTED_TEXT, _onSetNonFragmentedText, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].QUOTA_EXCEEDED, _onQuotaExceeded, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].SOURCE_BUFFER_ERROR, _onSourceBufferError, instance);
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BYTES_APPENDED_END_FRAGMENT, _onBytesAppended, instance);
    resetInitialSettings();
    type = null;
    streamInfo = null;
  }

  function isUpdating() {
    return representationController ? representationController.isUpdating() : false;
  }
  /**
   * When a seek within the corresponding period occurs this function initiates the clearing of the buffer and sets the correct buffering time.
   * @param {object} e
   * @returns {Promise<any>}
   */


  function prepareInnerPeriodPlaybackSeeking(e) {
    return new Promise(function (resolve) {
      // If we seek to a buffered area we can keep requesting where we left before the seek
      // If we seek back then forwards buffering will stop until we are below our buffer goal
      // If we seek forwards then pruneBuffer() will make sure that the bufferToKeep setting is respected
      var hasBufferAtTargetTime = bufferController.hasBufferAtTime(e.seekTime);

      if (hasBufferAtTargetTime) {
        bufferController.pruneBuffer();
        var continuousBufferTime = bufferController.getContinuousBufferTimeForTargetTime(e.seekTime);

        if (_shouldSetBufferingComplete(continuousBufferTime)) {
          bufferController.setIsBufferingCompleted(true);
        }

        resolve();
        return;
      } // Stop segment requests until we have figured out for which time we need to request a segment. We don't want to replace existing segments.


      scheduleController.clearScheduleTimer();
      fragmentModel.abortRequests(); // Abort operations to the SourceBuffer Sink and reset the BufferControllers isBufferingCompleted state.

      bufferController.prepareForPlaybackSeek().then(function () {
        // Clear the buffer. We need to prune everything which is not in the target interval.
        var clearRanges = bufferController.getAllRangesWithSafetyFactor(e.seekTime); // When everything has been pruned go on

        return bufferController.clearBuffers(clearRanges);
      }).then(function () {
        // Figure out the correct segment request time.
        var continuousBufferTime = bufferController.getContinuousBufferTimeForTargetTime(e.seekTime); // If the buffer is continuous and exceeds the duration of the period we are still done buffering. We need to trigger the buffering completed event in order to start prebuffering upcoming periods again

        if (_shouldSetBufferingComplete(continuousBufferTime)) {
          bufferController.setIsBufferingCompleted(true);
          resolve();
        } else {
          var targetTime = isNaN(continuousBufferTime) ? e.seekTime : continuousBufferTime;
          setExplicitBufferingTime(targetTime);
          bufferController.setSeekTarget(targetTime);
          var promises = []; // append window has been reset by abort() operation. Set the correct values again

          promises.push(bufferController.updateAppendWindow()); // Timestamp offset couldve been changed by preloading period

          var representationInfo = getRepresentationInfo();
          promises.push(bufferController.updateBufferTimestampOffset(representationInfo));
          Promise.all(promises).then(function () {
            // We might have aborted the append operation of an init segment. Append init segment again.
            scheduleController.setInitSegmentRequired(true); // Right after a seek we should not immediately check the playback quality

            scheduleController.setCheckPlaybackQuality(false);
            scheduleController.startScheduleTimer();
            resolve();
          });
        }
      })["catch"](function (e) {
        logger.error(e);
      });
    });
  }

  function _shouldSetBufferingComplete(continuousBufferTime) {
    return !isNaN(continuousBufferTime) && !isNaN(streamInfo.duration) && isFinite(streamInfo.duration) && continuousBufferTime >= streamInfo.start + streamInfo.duration;
  }
  /**
   * Seek outside of the current period.
   * @return {Promise<unknown>}
   */


  function prepareOuterPeriodPlaybackSeeking() {
    return new Promise(function (resolve, reject) {
      try {
        // Stop scheduling
        scheduleController.clearScheduleTimer(); // Abort all ongoing requests

        fragmentModel.abortRequests(); // buffering not complete anymore and abort current append operation to SourceBuffer

        bufferController.prepareForPlaybackSeek().then(function () {
          // Clear the buffers completely.
          return bufferController.pruneAllSafely();
        }).then(function () {
          resolve();
        });
      } catch (e) {
        reject(e);
      }
    });
  }
  /**
   * ScheduleController indicates that an init segment needs to be fetched.
   * @param {object} e
   * @param {boolean} rescheduleIfNoRequest - Defines whether we reschedule in case no valid request could be generated
   * @private
   */


  function _onInitFragmentNeeded(e) {
    var rescheduleIfNoRequest = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
    // Event propagation may have been stopped (see MssHandler)
    if (!e.sender) return;

    if (playbackController.getIsManifestUpdateInProgress()) {
      _noValidRequest();

      return;
    }

    if (getIsTextTrack() && !textController.isTextEnabled()) return;

    if (bufferController && e.representationId) {
      if (!bufferController.appendInitSegmentFromCache(e.representationId)) {
        var rep = representationController.getCurrentRepresentation(); // Dummy init segment (fragmented tracks without initialization segment)

        if (rep.range === 0) {
          _onMediaFragmentNeeded();

          return;
        } // Init segment not in cache, send new request


        var request = dashHandler ? dashHandler.getInitRequest(mediaInfo, rep) : null;

        if (request) {
          fragmentModel.executeRequest(request);
        } else if (rescheduleIfNoRequest) {
          scheduleController.setInitSegmentRequired(true);

          _noValidRequest();
        }
      }
    }
  }
  /**
   * ScheduleController indicates that a media segment is needed
   * @param {object} e
   * @param {boolean} rescheduleIfNoRequest -  Defines whether we reschedule in case no valid request could be generated
   * @private
   */


  function _onMediaFragmentNeeded(e) {
    var rescheduleIfNoRequest = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;

    // Don't schedule next fragments while updating manifest or pruning to avoid buffer inconsistencies
    if (playbackController.getIsManifestUpdateInProgress() || bufferController.getIsPruningInProgress()) {
      _noValidRequest();

      return;
    }

    var request = _getFragmentRequest();

    if (request) {
      shouldUseExplicitTimeForRequest = false;
      shouldRepeatRequest = false;

      _mediaRequestGenerated(request);
    } else {
      _noMediaRequestGenerated(rescheduleIfNoRequest);
    }
  }
  /**
   * If we generated a valid media request we can execute the request. In some cases the segment might be blacklisted.
   * @param {object} request
   * @private
   */


  function _mediaRequestGenerated(request) {
    if (!isNaN(request.startTime + request.duration)) {
      bufferingTime = request.startTime + request.duration;
    }

    request.delayLoadingTime = new Date().getTime() + scheduleController.getTimeToLoadDelay();
    scheduleController.setTimeToLoadDelay(0);

    if (!_shouldIgnoreRequest(request)) {
      logger.debug("Next fragment request url for stream id ".concat(streamInfo.id, " and media type ").concat(type, " is ").concat(request.url));
      fragmentModel.executeRequest(request);
    } else {
      logger.warn("Fragment request url ".concat(request.url, " for stream id ").concat(streamInfo.id, " and media type ").concat(type, " is on the ignore list and will be skipped"));

      _noValidRequest();
    }
  }
  /**
   * We could not generate a valid request. Check if the media is finished, we are stuck in a gap or simply need to wait for the next segment to be available.
   * @param {boolean} rescheduleIfNoRequest
   * @private
   */


  function _noMediaRequestGenerated(rescheduleIfNoRequest) {
    var representation = representationController.getCurrentRepresentation(); // If  this statement is true we might be stuck. A static manifest does not change and we did not find a valid request for the target time
    // There is no point in trying again. We need to adjust the time in order to find a valid request. This can happen if the user/app seeked into a gap.
    // For dynamic manifests this can also happen especially if we jump over the gap in the previous period and are using SegmentTimeline and in case there is a positive eptDelta at the beginning of the period we are stuck.

    if (settings.get().streaming.gaps.enableSeekFix && (shouldUseExplicitTimeForRequest || playbackController.getTime() === 0)) {
      var adjustedTime;

      if (!isDynamic) {
        adjustedTime = dashHandler.getValidTimeAheadOfTargetTime(bufferingTime, mediaInfo, representation, settings.get().streaming.gaps.threshold);
      } else if (isDynamic && representation.segmentInfoType === _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].SEGMENT_TIMELINE) {
        // If we find a valid request ahead of the current time then we are in a gap. Segments are only added at the end of the timeline
        adjustedTime = dashHandler.getValidTimeAheadOfTargetTime(bufferingTime, mediaInfo, representation, settings.get().streaming.gaps.threshold);
      }

      if (!isNaN(adjustedTime) && adjustedTime !== bufferingTime) {
        if (playbackController.isSeeking() || playbackController.getTime() === 0) {
          // If we are seeking then playback is stalled. Do a seek to get out of this situation
          logger.warn("Adjusting playback time ".concat(adjustedTime, " because of gap in the manifest. Seeking by ").concat(adjustedTime - bufferingTime));
          playbackController.seek(adjustedTime, false, false);
        } else {
          // If we are not seeking we should still be playing but we cant find anything to buffer. So we adjust the buffering time and leave the gap jump to the GapController
          logger.warn("Adjusting buffering time ".concat(adjustedTime, " because of gap in the manifest. Adjusting time by ").concat(adjustedTime - bufferingTime));
          setExplicitBufferingTime(adjustedTime);

          if (rescheduleIfNoRequest) {
            _noValidRequest();
          }
        }

        return;
      }
    } // Check if the media is finished. If so, no need to schedule another request


    var isLastSegmentRequested = dashHandler.isLastSegmentRequested(representation, bufferingTime);

    if (isLastSegmentRequested) {
      var segmentIndex = dashHandler.getCurrentIndex();
      logger.debug("Segment requesting for stream ".concat(streamInfo.id, " has finished"));
      eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].STREAM_REQUESTING_COMPLETED, {
        segmentIndex: segmentIndex
      }, {
        streamId: streamInfo.id,
        mediaType: type
      });
      bufferController.segmentRequestingCompleted(segmentIndex);
      scheduleController.clearScheduleTimer();
      return;
    }

    if (rescheduleIfNoRequest) {
      _noValidRequest();
    }
  }
  /**
   * In certain situations we need to ignore a request. For instance, if a segment is blacklisted because it caused an MSE error.
   * @private
   */


  function _shouldIgnoreRequest(request) {
    var blacklistUrl = request.url;

    if (request.range) {
      blacklistUrl = blacklistUrl.concat('_', request.range);
    }

    return segmentBlacklistController.contains(blacklistUrl);
  }
  /**
   * Get the init or media segment request using the DashHandler.
   * @return {null|FragmentRequest|null}
   * @private
   */


  function _getFragmentRequest() {
    var representationInfo = getRepresentationInfo();
    var request;

    if (isNaN(bufferingTime) || getType() === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT && !textController.isTextEnabled()) {
      return null;
    }

    if (dashHandler) {
      var representation = representationController && representationInfo ? representationController.getRepresentationForQuality(representationInfo.quality) : null;

      if (shouldUseExplicitTimeForRequest) {
        request = dashHandler.getSegmentRequestForTime(mediaInfo, representation, bufferingTime);
      } else if (shouldRepeatRequest) {
        request = dashHandler.repeatSegmentRequest(mediaInfo, representation);
      } else {
        request = dashHandler.getNextSegmentRequest(mediaInfo, representation);
      }
    }

    return request;
  }
  /**
   * Whenever we can not generate a valid request we restart scheduling according to the timeouts defined in the settings.
   * @private
   */


  function _noValidRequest() {
    scheduleController.startScheduleTimer(playbackController.getLowLatencyModeEnabled() ? settings.get().streaming.scheduling.lowLatencyTimeout : settings.get().streaming.scheduling.defaultTimeout);
  }

  function _onDataUpdateCompleted(e) {
    if (!e.error) {
      if (!bufferController.getIsBufferingCompleted()) {
        bufferController.updateBufferTimestampOffset(e.currentRepresentation);
      }
    }
  }

  function _onBufferLevelStateChanged(e) {
    dashMetrics.addBufferState(type, e.state, scheduleController.getBufferTarget());

    if (e.state === _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_2__["default"].BUFFER_EMPTY && !playbackController.isSeeking()) {
      logger.info('Buffer is empty! Stalling!');
      dashMetrics.pushPlayListTraceMetrics(new Date(), _vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_19__.PlayListTrace.REBUFFERING_REASON);
    }
  }

  function _onBufferCleared(e) {
    // Remove executed requests not buffered anymore
    fragmentModel.syncExecutedRequestsWithBufferedRange(bufferController.getBuffer().getAllBufferRanges(), streamInfo.duration); // If buffer removed ahead current time (QuotaExceededError or automatic buffer pruning) then adjust current index handler time

    if (e.quotaExceeded && e.from > playbackController.getTime()) {
      setExplicitBufferingTime(e.from);
    } // (Re)start schedule once buffer has been pruned after a QuotaExceededError


    if (e.hasEnoughSpaceToAppend && e.quotaExceeded) {
      scheduleController.startScheduleTimer();
    }
  }
  /**
   * This function is called when the corresponding SourceBuffer encountered an error.
   * We blacklist the last segment assuming it caused the error
   * @param {object} e
   * @private
   */


  function _onSourceBufferError(e) {
    if (!e || !e.lastRequestAppended || !e.lastRequestAppended.url) {
      return;
    }

    var blacklistUrl = e.lastRequestAppended.url;

    if (e.lastRequestAppended.range) {
      blacklistUrl = blacklistUrl.concat('_', e.lastRequestAppended.range);
    }

    logger.warn("Blacklisting segment with url ".concat(blacklistUrl));
    segmentBlacklistController.add(blacklistUrl);
  }

  function _onBytesAppended(e) {
    logger.debug("Appended bytes for ".concat(e.mediaType, " and stream id ").concat(e.streamId)); // we save the last initialized quality. That way we make sure that the media fragments we are about to append match the init segment

    if (e.segmentType === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_21__.HTTPRequest.INIT_SEGMENT_TYPE) {
      var lastInitializedQuality = e.quality;
      scheduleController.setLastInitializedQuality(lastInitializedQuality);
      logger.info('[' + type + '] ' + 'lastInitializedRepresentationInfo changed to ' + e.quality);
    }

    if (pendingSwitchToRepresentationInfo) {
      _prepareForDefaultQualitySwitch(pendingSwitchToRepresentationInfo);
    } else {
      scheduleController.startScheduleTimer(0);
    }
  }
  /**
   * The quality has changed which means we have switched to a different representation.
   * If we want to aggressively replace existing parts in the buffer we need to make sure that the new quality is higher than the already buffered one.
   * @param {object} e
   */


  function prepareQualityChange(e) {
    if (pendingSwitchToRepresentationInfo) {
      logger.warn("Canceling queued representation switch to ".concat(pendingSwitchToRepresentationInfo.quality, " for ").concat(type));
    }

    logger.debug("Preparing quality switch for type ".concat(type));
    var newQuality = e.newQuality;
    qualityChangeInProgress = true; // Stop scheduling until we are done with preparing the quality switch

    scheduleController.clearScheduleTimer();
    representationController.prepareQualityChange(newQuality);
    var representationInfo = getRepresentationInfo(newQuality); // If the switch should occur immediately we need to replace existing stuff in the buffer

    if (e.reason && e.reason.forceReplace) {
      _prepareForForceReplacementQualitySwitch(representationInfo);
    } // We abandoned a current request
    else if (e && e.reason && e.reason.forceAbandon) {
      _prepareForAbandonQualitySwitch(representationInfo);
    } // If fast switch is enabled we check if we are supposed to replace existing stuff in the buffer
    else if (settings.get().streaming.buffer.fastSwitchEnabled) {
      _prepareForFastQualitySwitch(representationInfo);
    } // Default quality switch. We append the new quality to the already buffered stuff
    else {
      _prepareForDefaultQualitySwitch(representationInfo);
    }

    dashMetrics.pushPlayListTraceMetrics(new Date(), _vo_metrics_PlayList__WEBPACK_IMPORTED_MODULE_19__.PlayListTrace.REPRESENTATION_SWITCH_STOP_REASON);
    dashMetrics.createPlaylistTraceMetrics(representationInfo.id, playbackController.getTime() * 1000, playbackController.getPlaybackRate());
  }

  function _prepareForForceReplacementQualitySwitch(representationInfo) {
    // Abort the current request to avoid inconsistencies and in case a rule such as AbandonRequestRule has forced a quality switch. A quality switch can also be triggered manually by the application.
    // If we update the buffer values now, or initialize a request to the new init segment, the currently downloading media segment might "work" with wrong values.
    // Everything that is already in the buffer queue is ok and will be handled by the corresponding function below depending on the switch mode.
    fragmentModel.abortRequests(); // Inform other classes like the GapController that we are replacing existing stuff

    eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_REPLACEMENT_STARTED, {
      mediaType: type,
      streamId: streamInfo.id
    }, {
      mediaType: type,
      streamId: streamInfo.id
    }); // Abort appending segments to the buffer. Also adjust the appendWindow as we might have been in the progress of prebuffering stuff.

    scheduleController.setCheckPlaybackQuality(false);
    bufferController.prepareForForceReplacementQualitySwitch(representationInfo).then(function () {
      _bufferClearedForReplacement();

      pendingSwitchToRepresentationInfo = null;
      qualityChangeInProgress = false;
    })["catch"](function () {
      _bufferClearedForReplacement();

      pendingSwitchToRepresentationInfo = null;
      qualityChangeInProgress = false;
    });
  }

  function _prepareForAbandonQualitySwitch(representationInfo) {
    bufferController.updateBufferTimestampOffset(representationInfo).then(function () {
      fragmentModel.abortRequests();
      shouldRepeatRequest = true;
      scheduleController.setCheckPlaybackQuality(false);
      scheduleController.startScheduleTimer();
      qualityChangeInProgress = false;
      pendingSwitchToRepresentationInfo = null;
    })["catch"](function () {
      pendingSwitchToRepresentationInfo = null;
      qualityChangeInProgress = false;
    });
  }

  function _prepareForFastQualitySwitch(representationInfo) {
    // if we switch up in quality and need to replace existing parts in the buffer we need to adjust the buffer target
    var time = playbackController.getTime();
    var safeBufferLevel = 1.5 * (!isNaN(representationInfo.fragmentDuration) ? representationInfo.fragmentDuration : 1);
    var request = fragmentModel.getRequests({
      state: _models_FragmentModel__WEBPACK_IMPORTED_MODULE_3__["default"].FRAGMENT_MODEL_EXECUTED,
      time: time + safeBufferLevel,
      threshold: 0
    })[0];

    if (request && !getIsTextTrack()) {
      var bufferLevel = bufferController.getBufferLevel();
      var abandonmentState = abrController.getAbandonmentStateFor(streamInfo.id, type); // The quality we originally requested was lower than the new quality

      if (request.quality < representationInfo.quality && bufferLevel >= safeBufferLevel && abandonmentState !== _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_2__["default"].ABANDON_LOAD) {
        bufferController.updateBufferTimestampOffset(representationInfo).then(function () {
          // Abort the current request to avoid inconsistencies and in case a rule such as AbandonRequestRule has forced a quality switch. A quality switch can also be triggered manually by the application.
          // If we update the buffer values now, or initialize a request to the new init segment, the currently downloading media segment might "work" with wrong values.
          // Everything that is already in the buffer queue is ok
          fragmentModel.abortRequests();
          var targetTime = time + safeBufferLevel;
          setExplicitBufferingTime(targetTime);
          scheduleController.setCheckPlaybackQuality(false);
          scheduleController.startScheduleTimer();
          qualityChangeInProgress = false;
        })["catch"](function () {
          qualityChangeInProgress = false;
        });
      } // If we have buffered a higher quality do not replace anything
      else {
        _prepareForDefaultQualitySwitch(representationInfo);
      }
    } else {
      _prepareForDefaultQualitySwitch(representationInfo);
    }
  }

  function _prepareForDefaultQualitySwitch(representationInfo) {
    // We are not canceling the current request. Check if there is still an ongoing request.
    // If so we wait for the request to be finished and the media to be appended
    var ongoingRequests = fragmentModel.getRequests({
      state: _models_FragmentModel__WEBPACK_IMPORTED_MODULE_3__["default"].FRAGMENT_MODEL_LOADING
    });

    if (ongoingRequests && ongoingRequests.length > 0) {
      logger.debug('Preparing for default quality switch: Waiting for ongoing segment request to be finished before applying switch.');
      pendingSwitchToRepresentationInfo = representationInfo;
      return;
    }

    bufferController.updateBufferTimestampOffset(representationInfo).then(function () {
      scheduleController.setCheckPlaybackQuality(false);

      if (mediaInfo.segmentAlignment || mediaInfo.subSegmentAlignment) {
        scheduleController.startScheduleTimer();
      } else {
        _bufferClearedForNonReplacement();
      }

      pendingSwitchToRepresentationInfo = null;
      qualityChangeInProgress = false;
    })["catch"](function () {
      pendingSwitchToRepresentationInfo = null;
      qualityChangeInProgress = false;
    });
  }
  /**
   * We have canceled the download of a fragment and need to adjust the buffer time or reload an init segment
   * @param {object} e
   */


  function _onFragmentLoadingAbandoned(e) {
    logger.info('onFragmentLoadingAbandoned request: ' + e.request.url + ' has been aborted'); // we only need to handle this if we are not seeking, not switching the tracks and not switching the quality

    if (!playbackController.isSeeking() && !scheduleController.getSwitchTrack() && !qualityChangeInProgress) {
      logger.info('onFragmentLoadingAbandoned request: ' + e.request.url + ' has to be downloaded again, origin is not seeking process or switch track call'); // in case of an init segment we force the download of an init segment

      if (e.request && e.request.isInitializationRequest()) {
        scheduleController.setInitSegmentRequired(true);
      } // in case of a media segment we reset the buffering time
      else {
        setExplicitBufferingTime(e.request.startTime + e.request.duration / 2);
      } // In case of a seek the schedule controller was stopped and will be started once the buffer has been pruned.


      scheduleController.startScheduleTimer(0);
    }
  }
  /**
   * When a fragment has been loaded we need to start the schedule timer again in case of an error.
   * @param {object} e
   */


  function _onFragmentLoadingCompleted(e) {
    logger.info('OnFragmentLoadingCompleted for stream id ' + streamInfo.id + ' and media type ' + type + ' - Url:', e.request ? e.request.url : 'undefined', e.request.range ? ', Range:' + e.request.range : '');

    if (getIsTextTrack()) {
      scheduleController.startScheduleTimer(0);
    }

    if (e.error && e.request.serviceLocation) {
      _handleFragmentLoadingError(e);
    }
  }
  /**
   * If we encountered an error when loading the fragment we need to handle it according to the segment type
   * @private
   */


  function _handleFragmentLoadingError(e) {
    logger.info("Fragment loading completed with an error");

    if (!e || !e.request || !e.request.type) {
      return;
    } // In case there are baseUrls that can still be tried a valid request can be generated. If no valid request can be generated we ran out of baseUrls.
    // Consequently, we need to signal that we dont want to retry in case no valid request could be generated otherwise we keep trying with the same url infinitely.
    // Init segment could not be loaded. If we have multiple baseUrls we still have a chance to get a valid segment.


    if (e.request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_21__.HTTPRequest.INIT_SEGMENT_TYPE) {
      _onInitFragmentNeeded({
        representationId: e.request.representationId,
        sender: {}
      }, false);
    } // Media segment could not be loaded
    else if (e.request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_21__.HTTPRequest.MEDIA_SEGMENT_TYPE) {
      setExplicitBufferingTime(e.request.startTime + e.request.duration / 2);

      _onMediaFragmentNeeded({}, false);
    }
  }
  /**
   * Callback function triggered by the TextController whenever a track is changed for fragmented text. Will only be triggered if textracks have previously been disabled.
   * @private
   */


  function _onSetFragmentedTextAfterDisabled() {
    setExplicitBufferingTime(playbackController.getTime());
    getScheduleController().startScheduleTimer();
  }
  /**
   * Callback function triggered by the TextController whenever a track is changed for non fragmented text
   * @param {object} e
   * @private
   */


  function _onSetNonFragmentedText(e) {
    var currentTrackInfo = e.currentTrackInfo;

    if (!currentTrackInfo) {
      return;
    }

    var mInfo = mediaInfoArr.find(function (info) {
      return info.index === currentTrackInfo.index && info.lang === currentTrackInfo.lang;
    });

    if (mInfo) {
      selectMediaInfo(mInfo).then(function () {
        bufferController.setIsBufferingCompleted(false);
        setExplicitBufferingTime(playbackController.getTime());
        scheduleController.setInitSegmentRequired(true);
        scheduleController.startScheduleTimer();
      });
    }
  }

  function _onQuotaExceeded(e) {
    // Stop scheduler (will be restarted once buffer is pruned)
    setExplicitBufferingTime(e.quotaExceededTime);
    scheduleController.clearScheduleTimer();
  }

  function getRepresentationController() {
    return representationController;
  }

  function getBuffer() {
    return bufferController ? bufferController.getBuffer() : null;
  }

  function getBufferController() {
    return bufferController;
  }

  function dischargePreBuffer() {
    bufferController.dischargePreBuffer();
  }

  function getFragmentModel() {
    return fragmentModel;
  }

  function updateStreamInfo(newStreamInfo) {
    streamInfo = newStreamInfo;

    if (!isBufferingCompleted()) {
      return bufferController.updateAppendWindow();
    }

    return Promise.resolve();
  }

  function getStreamInfo() {
    return streamInfo;
  }
  /**
   * Called once the StreamProcessor is initialized and when the track is switched. We only have one StreamProcessor per media type. So we need to adjust the mediaInfo once we switch/select a track.
   * @param {object} newMediaInfo
   */


  function selectMediaInfo(newMediaInfo) {
    if (newMediaInfo !== mediaInfo && (!newMediaInfo || !mediaInfo || newMediaInfo.type === mediaInfo.type)) {
      mediaInfo = newMediaInfo;
    }

    var newRealAdaptation = adapter.getRealAdaptation(streamInfo, mediaInfo);
    var voRepresentations = adapter.getVoRepresentations(mediaInfo);

    if (representationController) {
      var realAdaptation = representationController.getData();
      var maxQuality = abrController.getMaxAllowedIndexFor(type, streamInfo.id);
      var minIdx = abrController.getMinAllowedIndexFor(type, streamInfo.id);
      var quality, averageThroughput;
      var bitrate = null;

      if ((realAdaptation === null || realAdaptation.id !== newRealAdaptation.id) && type !== _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT) {
        averageThroughput = abrController.getThroughputHistory().getAverageThroughput(type, isDynamic);
        bitrate = averageThroughput || abrController.getInitialBitrateFor(type, streamInfo.id);
        quality = abrController.getQualityForBitrate(mediaInfo, bitrate, streamInfo.id);
      } else {
        quality = abrController.getQualityFor(type, streamInfo.id);
      }

      if (minIdx !== undefined && quality < minIdx) {
        quality = minIdx;
      }

      if (quality > maxQuality) {
        quality = maxQuality;
      }

      return representationController.updateData(newRealAdaptation, voRepresentations, type, mediaInfo.isFragmented, quality);
    } else {
      return Promise.resolve();
    }
  }

  function addMediaInfo(newMediaInfo) {
    if (mediaInfoArr.indexOf(newMediaInfo) === -1) {
      mediaInfoArr.push(newMediaInfo);
    }
  }

  function clearMediaInfoArray() {
    mediaInfoArr = [];
  }

  function getMediaInfo() {
    return mediaInfo;
  }

  function getMediaSource() {
    return bufferController.getMediaSource();
  }

  function setMediaSource(mediaSource) {
    return bufferController.setMediaSource(mediaSource, mediaInfo);
  }

  function getScheduleController() {
    return scheduleController;
  }
  /**
   * Get a specific voRepresentation. If quality parameter is defined, this function will return the voRepresentation for this quality.
   * Otherwise, this function will return the current voRepresentation used by the representationController.
   * @param {number} quality - quality index of the voRepresentaion expected.
   */


  function getRepresentationInfo(quality) {
    var voRepresentation;

    if (quality !== undefined) {
      (0,_utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_9__.checkInteger)(quality);
      voRepresentation = representationController ? representationController.getRepresentationForQuality(quality) : null;
    } else {
      voRepresentation = representationController ? representationController.getCurrentRepresentation() : null;
    }

    return adapter.convertRepresentationToRepresentationInfo(voRepresentation);
  }

  function isBufferingCompleted() {
    return bufferController ? bufferController.getIsBufferingCompleted() : false;
  }

  function getBufferLevel() {
    return bufferController ? bufferController.getBufferLevel() : 0;
  }
  /**
   * Probe the next request. This is used in the CMCD model to get information about the upcoming request. Note: No actual request is performed here.
   * @return {FragmentRequest|null}
   */


  function probeNextRequest() {
    var representationInfo = getRepresentationInfo();
    var representation = representationController && representationInfo ? representationController.getRepresentationForQuality(representationInfo.quality) : null;
    return dashHandler.getNextSegmentRequestIdempotent(mediaInfo, representation);
  }

  function _onInitFragmentLoaded(e) {
    if (!settings.get().streaming.enableManifestTimescaleMismatchFix) {
      return;
    }

    var chunk = e.chunk;
    var bytes = chunk.bytes;
    var quality = chunk.quality;
    var currentRepresentation = getRepresentationInfo(quality);
    var voRepresentation = representationController && currentRepresentation ? representationController.getRepresentationForQuality(currentRepresentation.quality) : null;

    if (currentRepresentation && voRepresentation) {
      voRepresentation.timescale = boxParser.getMediaTimescaleFromMoov(bytes);
    }
  }

  function _onMediaFragmentLoaded(e) {
    var chunk = e.chunk;
    var bytes = chunk.bytes;
    var quality = chunk.quality;
    var currentRepresentation = getRepresentationInfo(quality);
    var voRepresentation = representationController && currentRepresentation ? representationController.getRepresentationForQuality(currentRepresentation.quality) : null; // If we switch tracks this event might be fired after the representations in the RepresentationController have been updated according to the new MediaInfo.
    // In this case there will be no currentRepresentation and voRepresentation matching the "old" quality

    if (currentRepresentation && voRepresentation) {
      var isoFile; // Check for inband prft on media segment (if enabled)

      if (settings.get().streaming.parseInbandPrft && e.request.type === _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_21__.HTTPRequest.MEDIA_SEGMENT_TYPE) {
        isoFile = isoFile ? isoFile : boxParser.parse(bytes);
        var timescale = voRepresentation.timescale;

        var prfts = _handleInbandPrfts(isoFile, timescale);

        if (prfts && prfts.length) {
          eventBus.trigger(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_12__["default"].INBAND_PRFT, {
            data: prfts
          }, {
            streamId: streamInfo.id,
            mediaType: type
          });
        }
      }

      var eventStreamMedia = adapter.getEventsFor(currentRepresentation.mediaInfo, null, streamInfo);
      var eventStreamTrack = adapter.getEventsFor(currentRepresentation, voRepresentation, streamInfo);

      if (eventStreamMedia && eventStreamMedia.length > 0 || eventStreamTrack && eventStreamTrack.length > 0) {
        var request = fragmentModel.getRequests({
          state: _models_FragmentModel__WEBPACK_IMPORTED_MODULE_3__["default"].FRAGMENT_MODEL_EXECUTED,
          quality: quality,
          index: chunk.index
        })[0];
        isoFile = isoFile ? isoFile : boxParser.parse(bytes);

        var events = _handleInbandEvents(isoFile, request, eventStreamMedia, eventStreamTrack);

        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].INBAND_EVENTS, {
          events: events
        }, {
          streamId: streamInfo.id
        });
      }
    }
  }

  function _handleInbandPrfts(isoFile, timescale) {
    var prftBoxes = isoFile.getBoxes('prft');
    var prfts = [];
    prftBoxes.forEach(function (prft) {
      prfts.push(_parsePrftBox(prft, timescale));
    });
    return prfts;
  }

  function _parsePrftBox(prft, timescale) {
    // Get prft type according to box flags
    var type = 'unknown';

    switch (prft.flags) {
      case 0:
        type = _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCER_REFERENCE_TIME_TYPE.ENCODER;
        break;

      case 16:
        type = _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCER_REFERENCE_TIME_TYPE.APPLICATION;
        break;

      case 24:
        type = _dash_constants_DashConstants__WEBPACK_IMPORTED_MODULE_1__["default"].PRODUCER_REFERENCE_TIME_TYPE.CAPTURED;
        break;

      default:
        break;
    } // Get NPT timestamp according to IETF RFC 5905, relative to 1/1/1900


    var ntpTimestamp = prft.ntp_timestamp_sec * 1000 + prft.ntp_timestamp_frac / Math.pow(2, 32) * 1000;
    ntpTimestamp = (0,_utils_TimeUtils__WEBPACK_IMPORTED_MODULE_22__["default"])(context).getInstance().ntpToUTC(ntpTimestamp);
    var mediaTime = prft.media_time / timescale;
    return {
      type: type,
      ntpTimestamp: ntpTimestamp,
      mediaTime: mediaTime
    };
  }

  function _handleInbandEvents(isoFile, request, mediaInbandEvents, trackInbandEvents) {
    try {
      var eventStreams = {};
      var events = [];
      /* Extract the possible schemeIdUri : If a DASH client detects an event message box with a scheme that is not defined in MPD, the client is expected to ignore it */

      var inbandEvents = mediaInbandEvents.concat(trackInbandEvents);

      for (var i = 0, ln = inbandEvents.length; i < ln; i++) {
        eventStreams[inbandEvents[i].schemeIdUri + '/' + inbandEvents[i].value] = inbandEvents[i];
      }

      var eventBoxes = isoFile.getBoxes('emsg');

      if (!eventBoxes || eventBoxes.length === 0) {
        return events;
      }

      var sidx = isoFile.getBox('sidx');
      var mediaAnchorTime = sidx && !isNaN(sidx.earliest_presentation_time) && !isNaN(sidx.timescale) ? sidx.earliest_presentation_time / sidx.timescale : request && !isNaN(request.mediaStartTime) ? request.mediaStartTime : 0;
      var fragmentMediaStartTime = Math.max(mediaAnchorTime, 0);
      var voRepresentation = representationController.getCurrentRepresentation();

      for (var _i = 0, _ln = eventBoxes.length; _i < _ln; _i++) {
        var event = adapter.getEvent(eventBoxes[_i], eventStreams, fragmentMediaStartTime, voRepresentation);

        if (event) {
          events.push(event);
        }
      }

      return events;
    } catch (e) {
      return [];
    }
  }

  function createBufferSinks(previousBufferSinks) {
    var buffer = getBuffer();

    if (buffer) {
      return Promise.resolve(buffer);
    }

    return bufferController ? bufferController.createBufferSink(mediaInfo, previousBufferSinks) : Promise.resolve(null);
  }

  function prepareTrackSwitch() {
    return new Promise(function (resolve) {
      logger.debug("Preparing track switch for type ".concat(type));
      var shouldReplace = type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT || settings.get().streaming.trackSwitchMode[type] === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TRACK_SWITCH_MODE_ALWAYS_REPLACE && playbackController.getTimeToStreamEnd(streamInfo) > settings.get().streaming.buffer.stallThreshold; // when buffering is completed and we are not supposed to replace anything do nothing.
      // Still we need to trigger preloading again and call change type in case user seeks back before transitioning to next period

      if (bufferController.getIsBufferingCompleted() && !shouldReplace) {
        bufferController.prepareForNonReplacementTrackSwitch(mediaInfo.codec).then(function () {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFERING_COMPLETED, {}, {
            streamId: streamInfo.id,
            mediaType: type
          });
        })["catch"](function () {
          eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFERING_COMPLETED, {}, {
            streamId: streamInfo.id,
            mediaType: type
          });
        });
        resolve();
        return;
      } // We stop the schedule controller and signal a track switch. That way we request a new init segment next


      scheduleController.clearScheduleTimer();
      scheduleController.setSwitchTrack(true); // when we are supposed to replace it does not matter if buffering is already completed

      if (shouldReplace) {
        // Inform other classes like the GapController that we are replacing existing stuff
        eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_11__["default"].BUFFER_REPLACEMENT_STARTED, {
          mediaType: type,
          streamId: streamInfo.id
        }, {
          mediaType: type,
          streamId: streamInfo.id
        }); // Abort the current request it will be removed from the buffer anyways

        fragmentModel.abortRequests(); // Abort appending segments to the buffer. Also adjust the appendWindow as we might have been in the progress of prebuffering stuff.

        bufferController.prepareForReplacementTrackSwitch(mediaInfo.codec).then(function () {
          // Timestamp offset couldve been changed by preloading period
          var representationInfo = getRepresentationInfo();
          return bufferController.updateBufferTimestampOffset(representationInfo);
        }).then(function () {
          _bufferClearedForReplacement();

          resolve();
        })["catch"](function () {
          _bufferClearedForReplacement();

          resolve();
        });
      } else {
        // We do not replace anything that is already in the buffer. Still we need to prepare the buffer for the track switch
        bufferController.prepareForNonReplacementTrackSwitch(mediaInfo.codec).then(function () {
          _bufferClearedForNonReplacement();

          resolve();
        })["catch"](function () {
          _bufferClearedForNonReplacement();

          resolve();
        });
      }
    });
  }
  /**
   * For an instant track switch we need to adjust the buffering time after the buffer has been pruned.
   * @private
   */


  function _bufferClearedForReplacement() {
    var targetTime = playbackController.getTime();

    if (settings.get().streaming.buffer.flushBufferAtTrackSwitch) {
      // For some devices (like chromecast) it is necessary to seek the video element to reset the internal decoding buffer,
      // otherwise audio track switch will be effective only once after previous buffered track is consumed
      playbackController.seek(targetTime + 0.001, false, true);
    }

    setExplicitBufferingTime(targetTime);
    bufferController.setSeekTarget(targetTime);
    scheduleController.startScheduleTimer();
  }

  function _bufferClearedForNonReplacement() {
    var time = playbackController.getTime();
    var continuousBufferTime = bufferController.getContinuousBufferTimeForTargetTime(time);
    var targetTime = isNaN(continuousBufferTime) ? time : continuousBufferTime;
    setExplicitBufferingTime(targetTime);
    scheduleController.startScheduleTimer();
  }

  function _createBufferControllerForType(type, isFragmented) {
    var controller = null;

    if (!type) {
      errHandler.error(new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_15__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_14__["default"].MEDIASOURCE_TYPE_UNSUPPORTED_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_14__["default"].MEDIASOURCE_TYPE_UNSUPPORTED_MESSAGE + 'not properly defined'));
      return null;
    }

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_0__["default"].TEXT && !isFragmented) {
      controller = (0,_text_NotFragmentedTextBufferController__WEBPACK_IMPORTED_MODULE_5__["default"])(context).create({
        streamInfo: streamInfo,
        type: type,
        mimeType: mimeType,
        fragmentModel: fragmentModel,
        textController: textController,
        errHandler: errHandler,
        settings: settings
      });
    } else {
      controller = (0,_controllers_BufferController__WEBPACK_IMPORTED_MODULE_4__["default"])(context).create({
        streamInfo: streamInfo,
        type: type,
        mediaPlayerModel: mediaPlayerModel,
        manifestModel: manifestModel,
        fragmentModel: fragmentModel,
        errHandler: errHandler,
        mediaController: mediaController,
        representationController: representationController,
        adapter: adapter,
        textController: textController,
        abrController: abrController,
        playbackController: playbackController,
        settings: settings
      });
    }

    return controller;
  }

  function _onSeekTarget(e) {
    if (e && !isNaN(e.time)) {
      setExplicitBufferingTime(e.time);
      bufferController.setSeekTarget(e.time);
    }
  }

  function setExplicitBufferingTime(value) {
    bufferingTime = value;
    shouldUseExplicitTimeForRequest = true;
  }

  function finalisePlayList(time, reason) {
    dashMetrics.pushPlayListTraceMetrics(time, reason);
  }

  instance = {
    initialize: initialize,
    getStreamId: getStreamId,
    getType: getType,
    isUpdating: isUpdating,
    getBufferController: getBufferController,
    dischargePreBuffer: dischargePreBuffer,
    getFragmentModel: getFragmentModel,
    getScheduleController: getScheduleController,
    getRepresentationController: getRepresentationController,
    getRepresentationInfo: getRepresentationInfo,
    getBufferLevel: getBufferLevel,
    isBufferingCompleted: isBufferingCompleted,
    createBufferSinks: createBufferSinks,
    updateStreamInfo: updateStreamInfo,
    getStreamInfo: getStreamInfo,
    selectMediaInfo: selectMediaInfo,
    clearMediaInfoArray: clearMediaInfoArray,
    addMediaInfo: addMediaInfo,
    prepareTrackSwitch: prepareTrackSwitch,
    prepareQualityChange: prepareQualityChange,
    getMediaInfo: getMediaInfo,
    getMediaSource: getMediaSource,
    setMediaSource: setMediaSource,
    getBuffer: getBuffer,
    setExplicitBufferingTime: setExplicitBufferingTime,
    finalisePlayList: finalisePlayList,
    probeNextRequest: probeNextRequest,
    prepareInnerPeriodPlaybackSeeking: prepareInnerPeriodPlaybackSeeking,
    prepareOuterPeriodPlaybackSeeking: prepareOuterPeriodPlaybackSeeking,
    reset: reset
  };
  setup();
  return instance;
}

StreamProcessor.__dashjs_factory_name = 'StreamProcessor';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_8__["default"].getClassFactory(StreamProcessor));

/***/ }),

/***/ "./src/streaming/XlinkLoader.js":
/*!**************************************!*\
  !*** ./src/streaming/XlinkLoader.js ***!
  \**************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _vo_DashJSError__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./vo/DashJSError */ "./src/streaming/vo/DashJSError.js");
/* harmony import */ var _net_URLLoader__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./net/URLLoader */ "./src/streaming/net/URLLoader.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _vo_TextRequest__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./vo/TextRequest */ "./src/streaming/vo/TextRequest.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _core_errors_Errors__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../core/errors/Errors */ "./src/core/errors/Errors.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */









function XlinkLoader(config) {
  config = config || {};
  var RESOLVE_TO_ZERO = 'urn:mpeg:dash:resolve-to-zero:2013';
  var context = this.context;
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_4__["default"])(context).getInstance();
  var urlLoader = (0,_net_URLLoader__WEBPACK_IMPORTED_MODULE_1__["default"])(context).create({
    errHandler: config.errHandler,
    dashMetrics: config.dashMetrics,
    mediaPlayerModel: config.mediaPlayerModel,
    requestModifier: config.requestModifier,
    errors: _core_errors_Errors__WEBPACK_IMPORTED_MODULE_7__["default"]
  });
  var instance;

  function load(url, element, resolveObject) {
    var report = function report(content, resolveToZero) {
      element.resolved = true;
      element.resolvedContent = content ? content : null;
      eventBus.trigger(_core_events_Events__WEBPACK_IMPORTED_MODULE_5__["default"].XLINK_ELEMENT_LOADED, {
        element: element,
        resolveObject: resolveObject,
        error: content || resolveToZero ? null : new _vo_DashJSError__WEBPACK_IMPORTED_MODULE_0__["default"](_core_errors_Errors__WEBPACK_IMPORTED_MODULE_7__["default"].XLINK_LOADER_LOADING_FAILURE_ERROR_CODE, _core_errors_Errors__WEBPACK_IMPORTED_MODULE_7__["default"].XLINK_LOADER_LOADING_FAILURE_ERROR_MESSAGE + url)
      });
    };

    if (url === RESOLVE_TO_ZERO) {
      report(null, true);
    } else {
      var request = new _vo_TextRequest__WEBPACK_IMPORTED_MODULE_3__["default"](url, _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_2__.HTTPRequest.XLINK_EXPANSION_TYPE);
      urlLoader.load({
        request: request,
        success: function success(data) {
          report(data);
        },
        error: function error() {
          report(null);
        }
      });
    }
  }

  function reset() {
    if (urlLoader) {
      urlLoader.abort();
      urlLoader = null;
    }
  }

  instance = {
    load: load,
    reset: reset
  };
  return instance;
}

XlinkLoader.__dashjs_factory_name = 'XlinkLoader';
/* harmony default export */ __webpack_exports__["default"] = (_core_FactoryMaker__WEBPACK_IMPORTED_MODULE_6__["default"].getClassFactory(XlinkLoader));

/***/ }),

/***/ "./src/streaming/constants/ConformanceViolationConstants.js":
/*!******************************************************************!*\
  !*** ./src/streaming/constants/ConformanceViolationConstants.js ***!
  \******************************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */
/* harmony default export */ __webpack_exports__["default"] = ({
  LEVELS: {
    SUGGESTION: 'Suggestion',
    WARNING: 'Warning',
    ERROR: 'Error'
  },
  EVENTS: {
    NO_UTC_TIMING_ELEMENT: {
      key: 'NO_UTC_TIMING_ELEMENT',
      message: 'No UTCTiming element is present in the manifest. You may experience playback failures. For a detailed validation use https://conformance.dashif.org/'
    },
    NON_COMPLIANT_SMPTE_IMAGE_ATTRIBUTE: {
      key: 'NON_COMPLIANT_SMPTE_IMAGE_ATTRIBUTE',
      message: 'SMPTE 2052-1:2013 defines the attribute name as "imageType" and does not define "imagetype"'
    },
    INVALID_DVR_WINDOW: {
      key: 'INVALID_DVR_WINDOW',
      message: 'No valid segment found when applying a specification compliant DVR window calculation. Using SegmentTimeline entries as a fallback.'
    }
  }
});

/***/ }),

/***/ "./src/streaming/constants/Constants.js":
/*!**********************************************!*\
  !*** ./src/streaming/constants/Constants.js ***!
  \**********************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Constants declaration
 * @class
 * @ignore
 * @hideconstructor
 */
var Constants = /*#__PURE__*/function () {
  function Constants() {
    _classCallCheck(this, Constants);

    this.init();
  }

  _createClass(Constants, [{
    key: "init",
    value: function init() {
      /**
       *  @constant {string} STREAM Stream media type. Mainly used to report metrics relative to the full stream
       *  @memberof Constants#
       *  @static
       */
      this.STREAM = 'stream';
      /**
       *  @constant {string} VIDEO Video media type
       *  @memberof Constants#
       *  @static
       */

      this.VIDEO = 'video';
      /**
       *  @constant {string} AUDIO Audio media type
       *  @memberof Constants#
       *  @static
       */

      this.AUDIO = 'audio';
      /**
       *  @constant {string} TEXT Text media type
       *  @memberof Constants#
       *  @static
       */

      this.TEXT = 'text';
      /**
       *  @constant {string} MUXED Muxed (video/audio in the same chunk) media type
       *  @memberof Constants#
       *  @static
       */

      this.MUXED = 'muxed';
      /**
       *  @constant {string} IMAGE Image media type
       *  @memberof Constants#
       *  @static
       */

      this.IMAGE = 'image';
      /**
       *  @constant {string} STPP STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.STPP = 'stpp';
      /**
       *  @constant {string} TTML STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.TTML = 'ttml';
      /**
       *  @constant {string} VTT STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.VTT = 'vtt';
      /**
       *  @constant {string} WVTT STTP Subtitles format
       *  @memberof Constants#
       *  @static
       */

      this.WVTT = 'wvtt';
      /**
       *  @constant {string} Content Steering
       *  @memberof Constants#
       *  @static
       */

      this.CONTENT_STEERING = 'contentSteering';
      /**
       *  @constant {string} ABR_STRATEGY_DYNAMIC Dynamic Adaptive bitrate algorithm
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_DYNAMIC = 'abrDynamic';
      /**
       *  @constant {string} ABR_STRATEGY_BOLA Adaptive bitrate algorithm based on Bola (buffer level)
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_BOLA = 'abrBola';
      /**
       *  @constant {string} ABR_STRATEGY_L2A Adaptive bitrate algorithm based on L2A (online learning)
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_L2A = 'abrL2A';
      /**
       *  @constant {string} ABR_STRATEGY_LoLP Adaptive bitrate algorithm based on LoL+
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_LoLP = 'abrLoLP';
      /**
       *  @constant {string} ABR_STRATEGY_THROUGHPUT Adaptive bitrate algorithm based on throughput
       *  @memberof Constants#
       *  @static
       */

      this.ABR_STRATEGY_THROUGHPUT = 'abrThroughput';
      /**
       *  @constant {string} ABR_FETCH_THROUGHPUT_CALUCUALTION_DOWNLOADED_DATA Throughput calculation based on downloaded data array
       *  @memberof Constants#
       *  @static
       */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_DOWNLOADED_DATA = 'abrFetchThroughputCalculationDownloadedData';
      /**
       *  @constant {string} ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_MOOF_PARSING = 'abrFetchThroughputCalculationMoofParsing';
      /**
      *  @constant {string} ABR_FETCH_THROUGHPUT_CALCULATION_AAST Throughput calculation based on adjusted availability start time in low latency mode
      *  @memberof Constants#
      *  @static
      */

      this.ABR_FETCH_THROUGHPUT_CALCULATION_AAST = 'abrFetchThroughputCalculationAAST';
      /**
       *  @constant {string} LIVE_CATCHUP_MODE_DEFAULT Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.LIVE_CATCHUP_MODE_DEFAULT = 'liveCatchupModeDefault';
      /**
       *  @constant {string} LIVE_CATCHUP_MODE_LOLP Throughput calculation based on moof parsing
       *  @memberof Constants#
       *  @static
       */

      this.LIVE_CATCHUP_MODE_LOLP = 'liveCatchupModeLoLP';
      /**
       *  @constant {string} MOVING_AVERAGE_SLIDING_WINDOW Moving average sliding window
       *  @memberof Constants#
       *  @static
       */

      this.MOVING_AVERAGE_SLIDING_WINDOW = 'slidingWindow';
      /**
       *  @constant {string} EWMA Exponential moving average
       *  @memberof Constants#
       *  @static
       */

      this.MOVING_AVERAGE_EWMA = 'ewma';
      /**
       *  @constant {string} BAD_ARGUMENT_ERROR Invalid Arguments type of error
       *  @memberof Constants#
       *  @static
       */

      this.BAD_ARGUMENT_ERROR = 'Invalid Arguments';
      /**
       *  @constant {string} MISSING_CONFIG_ERROR Missing configuration parameters type of error
       *  @memberof Constants#
       *  @static
       */

      this.MISSING_CONFIG_ERROR = 'Missing config parameter(s)';
      /**
       *  @constant {string} TRACK_SWITCH_MODE_ALWAYS_REPLACE used to clear the buffered data (prior to current playback position) after track switch. Default for audio
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SWITCH_MODE_ALWAYS_REPLACE = 'alwaysReplace';
      /**
       *  @constant {string} TRACK_SWITCH_MODE_NEVER_REPLACE used to forbid clearing the buffered data (prior to current playback position) after track switch. Defers to fastSwitchEnabled for placement of new data. Default for video
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SWITCH_MODE_NEVER_REPLACE = 'neverReplace';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_FIRST_TRACK makes the player select the first track found in the manifest.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_FIRST_TRACK = 'firstTrack';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_HIGHEST_BITRATE makes the player select the track with a highest bitrate. This mode is a default mode.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_BITRATE = 'highestBitrate';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY makes the player select the track with the lowest bitrate per pixel average.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_EFFICIENCY = 'highestEfficiency';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_WIDEST_RANGE makes the player select the track with a widest range of bitrates.
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_WIDEST_RANGE = 'widestRange';
      /**
       *  @constant {string} TRACK_SELECTION_MODE_WIDEST_RANGE makes the player select the track with the highest selectionPriority as defined in the manifest
       *  @memberof Constants#
       *  @static
       */

      this.TRACK_SELECTION_MODE_HIGHEST_SELECTION_PRIORITY = 'highestSelectionPriority';
      /**
       *  @constant {string} CMCD_MODE_QUERY specifies to attach CMCD metrics as query parameters.
       *  @memberof Constants#
       *  @static
       */

      this.CMCD_MODE_QUERY = 'query';
      /**
       *  @constant {string} CMCD_MODE_HEADER specifies to attach CMCD metrics as HTTP headers.
       *  @memberof Constants#
       *  @static
       */

      this.CMCD_MODE_HEADER = 'header';
      this.INITIALIZE = 'initialize';
      this.TEXT_SHOWING = 'showing';
      this.TEXT_HIDDEN = 'hidden';
      this.TEXT_DISABLED = 'disabled';
      this.CC1 = 'CC1';
      this.CC3 = 'CC3';
      this.UTF8 = 'utf-8';
      this.SCHEME_ID_URI = 'schemeIdUri';
      this.START_TIME = 'starttime';
      this.SERVICE_DESCRIPTION_DVB_LL_SCHEME = 'urn:dvb:dash:lowlatency:scope:2019';
      this.SUPPLEMENTAL_PROPERTY_DVB_LL_SCHEME = 'urn:dvb:dash:lowlatency:critical:2019';
      this.FONT_DOWNLOAD_DVB_SCHEME = 'urn:dvb:dash:fontdownload:2014';
      this.XML = 'XML';
      this.ARRAY_BUFFER = 'ArrayBuffer';
      this.DVB_REPORTING_URL = 'dvb:reportingUrl';
      this.DVB_PROBABILITY = 'dvb:probability';
      this.OFF_MIMETYPE = 'application/font-sfnt';
      this.WOFF_MIMETYPE = 'application/font-woff';
      this.VIDEO_ELEMENT_READY_STATES = {
        HAVE_NOTHING: 0,
        HAVE_METADATA: 1,
        HAVE_CURRENT_DATA: 2,
        HAVE_FUTURE_DATA: 3,
        HAVE_ENOUGH_DATA: 4
      };
      this.FILE_LOADER_TYPES = {
        FETCH: 'fetch_loader',
        XHR: 'xhr_loader'
      };
    }
  }]);

  return Constants;
}();

var constants = new Constants();
/* harmony default export */ __webpack_exports__["default"] = (constants);

/***/ }),

/***/ "./src/streaming/constants/MetricsConstants.js":
/*!*****************************************************!*\
  !*** ./src/streaming/constants/MetricsConstants.js ***!
  \*****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Metrics Constants declaration
 * @class
 * @ignore
 */
var MetricsConstants = /*#__PURE__*/function () {
  function MetricsConstants() {
    _classCallCheck(this, MetricsConstants);

    this.init();
  }

  _createClass(MetricsConstants, [{
    key: "init",
    value: function init() {
      this.TCP_CONNECTION = 'TcpList';
      this.HTTP_REQUEST = 'HttpList';
      this.TRACK_SWITCH = 'RepSwitchList';
      this.BUFFER_LEVEL = 'BufferLevel';
      this.BUFFER_LOADED = 'bufferLoaded';
      this.ABANDON_LOAD = 'abandonload';
      this.ALLOW_LOAD = 'allowload';
      this.BUFFER_EMPTY = 'bufferStalled';
      this.BUFFER_STATE = 'BufferState';
      this.DVR_INFO = 'DVRInfo';
      this.DROPPED_FRAMES = 'DroppedFrames';
      this.SCHEDULING_INFO = 'SchedulingInfo';
      this.REQUESTS_QUEUE = 'RequestsQueue';
      this.MANIFEST_UPDATE = 'ManifestUpdate';
      this.MANIFEST_UPDATE_STREAM_INFO = 'ManifestUpdatePeriodInfo';
      this.MANIFEST_UPDATE_TRACK_INFO = 'ManifestUpdateRepresentationInfo';
      this.PLAY_LIST = 'PlayList';
      this.DVB_ERRORS = 'DVBErrors';
      this.HTTP_REQUEST_DVB_REPORTING_TYPE = 'DVBReporting';
    }
  }]);

  return MetricsConstants;
}();

var constants = new MetricsConstants();
/* harmony default export */ __webpack_exports__["default"] = (constants);

/***/ }),

/***/ "./src/streaming/constants/ProtectionConstants.js":
/*!********************************************************!*\
  !*** ./src/streaming/constants/ProtectionConstants.js ***!
  \********************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } }

function _createClass(Constructor, protoProps, staticProps) { if (protoProps) _defineProperties(Constructor.prototype, protoProps); if (staticProps) _defineProperties(Constructor, staticProps); return Constructor; }

/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * Protection Constants declaration
 * @class
 * @ignore
 */
var ProtectionConstants = /*#__PURE__*/function () {
  function ProtectionConstants() {
    _classCallCheck(this, ProtectionConstants);

    this.init();
  }

  _createClass(ProtectionConstants, [{
    key: "init",
    value: function init() {
      this.CLEARKEY_KEYSTEM_STRING = 'org.w3.clearkey';
      this.WIDEVINE_KEYSTEM_STRING = 'com.widevine.alpha';
      this.PLAYREADY_KEYSTEM_STRING = 'com.microsoft.playready';
      this.PLAYREADY_RECOMMENDATION_KEYSTEM_STRING = 'com.microsoft.playready.recommendation';
      this.INITIALIZATION_DATA_TYPE_CENC = 'cenc';
      this.INITIALIZATION_DATA_TYPE_KEYIDS = 'keyids';
      this.INITIALIZATION_DATA_TYPE_WEBM = 'webm';
    }
  }]);

  return ProtectionConstants;
}();

var constants = new ProtectionConstants();
/* harmony default export */ __webpack_exports__["default"] = (constants);

/***/ }),

/***/ "./src/streaming/controllers/AbrController.js":
/*!****************************************************!*\
  !*** ./src/streaming/controllers/AbrController.js ***!
  \****************************************************/
/***/ (function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _rules_abr_ABRRulesCollection__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../rules/abr/ABRRulesCollection */ "./src/streaming/rules/abr/ABRRulesCollection.js");
/* harmony import */ var _constants_Constants__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../constants/Constants */ "./src/streaming/constants/Constants.js");
/* harmony import */ var _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../constants/MetricsConstants */ "./src/streaming/constants/MetricsConstants.js");
/* harmony import */ var _vo_BitrateInfo__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../vo/BitrateInfo */ "./src/streaming/vo/BitrateInfo.js");
/* harmony import */ var _models_FragmentModel__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../models/FragmentModel */ "./src/streaming/models/FragmentModel.js");
/* harmony import */ var _core_EventBus__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../core/EventBus */ "./src/core/EventBus.js");
/* harmony import */ var _core_events_Events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../core/events/Events */ "./src/core/events/Events.js");
/* harmony import */ var _core_FactoryMaker__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../core/FactoryMaker */ "./src/core/FactoryMaker.js");
/* harmony import */ var _rules_RulesContext__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../rules/RulesContext */ "./src/streaming/rules/RulesContext.js");
/* harmony import */ var _rules_SwitchRequest__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../rules/SwitchRequest */ "./src/streaming/rules/SwitchRequest.js");
/* harmony import */ var _rules_SwitchRequestHistory__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../rules/SwitchRequestHistory */ "./src/streaming/rules/SwitchRequestHistory.js");
/* harmony import */ var _rules_DroppedFramesHistory__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../rules/DroppedFramesHistory */ "./src/streaming/rules/DroppedFramesHistory.js");
/* harmony import */ var _rules_ThroughputHistory__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../rules/ThroughputHistory */ "./src/streaming/rules/ThroughputHistory.js");
/* harmony import */ var _core_Debug__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../core/Debug */ "./src/core/Debug.js");
/* harmony import */ var _vo_metrics_HTTPRequest__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../vo/metrics/HTTPRequest */ "./src/streaming/vo/metrics/HTTPRequest.js");
/* harmony import */ var _utils_SupervisorTools__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../utils/SupervisorTools */ "./src/streaming/utils/SupervisorTools.js");
/* harmony import */ var _MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../MediaPlayerEvents */ "./src/streaming/MediaPlayerEvents.js");
/**
 * The copyright in this software is being made available under the BSD License,
 * included below. This software may be subject to other third party and contributor
 * rights, including patent rights, and no such rights are granted under this license.
 *
 * Copyright (c) 2013, Dash Industry Forum.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this
 *  list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice,
 *  this list of conditions and the following disclaimer in the documentation and/or
 *  other materials provided with the distribution.
 *  * Neither the name of Dash Industry Forum nor the names of its
 *  contributors may be used to endorse or promote products derived from this software
 *  without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS AS IS AND ANY
 *  EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 *  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 *  NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR
 *  PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 *  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 *  POSSIBILITY OF SUCH DAMAGE.
 */

















var DEFAULT_VIDEO_BITRATE = 1000;
var DEFAULT_AUDIO_BITRATE = 100;
var QUALITY_DEFAULT = 0;

function AbrController() {
  var context = this.context;
  var debug = (0,_core_Debug__WEBPACK_IMPORTED_MODULE_13__["default"])(context).getInstance();
  var eventBus = (0,_core_EventBus__WEBPACK_IMPORTED_MODULE_5__["default"])(context).getInstance();
  var instance, logger, abrRulesCollection, streamController, topQualities, qualityDict, streamProcessorDict, abandonmentStateDict, abandonmentTimeout, windowResizeEventCalled, elementWidth, elementHeight, adapter, videoModel, mediaPlayerModel, customParametersModel, cmsdModel, domStorage, playbackIndex, switchHistoryDict, droppedFramesHistory, throughputHistory, isUsingBufferOccupancyAbrDict, isUsingL2AAbrDict, isUsingLoLPAbrDict, dashMetrics, settings;

  function setup() {
    logger = debug.getLogger(instance);
    resetInitialSettings();
  }
  /**
   * Initialize everything that is not Stream specific. We only have one instance of the ABR Controller for all periods.
   */


  function initialize() {
    droppedFramesHistory = (0,_rules_DroppedFramesHistory__WEBPACK_IMPORTED_MODULE_11__["default"])(context).create();
    throughputHistory = (0,_rules_ThroughputHistory__WEBPACK_IMPORTED_MODULE_12__["default"])(context).create({
      settings: settings
    });
    abrRulesCollection = (0,_rules_abr_ABRRulesCollection__WEBPACK_IMPORTED_MODULE_0__["default"])(context).create({
      dashMetrics: dashMetrics,
      customParametersModel: customParametersModel,
      mediaPlayerModel: mediaPlayerModel,
      settings: settings
    });
    abrRulesCollection.initialize();
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_16__["default"].QUALITY_CHANGE_RENDERED, _onQualityChangeRendered, instance);
    eventBus.on(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_16__["default"].METRIC_ADDED, _onMetricAdded, instance);
    eventBus.on(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].LOADING_PROGRESS, _onFragmentLoadProgress, instance);
  }
  /**
   * Whenever a StreamProcessor is created it is added to the list of streamProcessorDict
   * In addition, the corresponding objects for this object and its stream id are created
   * @param {object} type
   * @param {object} streamProcessor
   */


  function registerStreamType(type, streamProcessor) {
    var streamId = streamProcessor.getStreamInfo().id;

    if (!streamProcessorDict[streamId]) {
      streamProcessorDict[streamId] = {};
    }

    if (!switchHistoryDict[streamId]) {
      switchHistoryDict[streamId] = {};
    }

    if (!abandonmentStateDict[streamId]) {
      abandonmentStateDict[streamId] = {};
    }

    switchHistoryDict[streamId][type] = (0,_rules_SwitchRequestHistory__WEBPACK_IMPORTED_MODULE_10__["default"])(context).create();
    streamProcessorDict[streamId][type] = streamProcessor;
    abandonmentStateDict[streamId][type] = {};
    abandonmentStateDict[streamId][type].state = _constants_MetricsConstants__WEBPACK_IMPORTED_MODULE_2__["default"].ALLOW_LOAD;

    _initializeAbrStrategy(type);

    if (type === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].VIDEO) {
      setElementSize();
    }
  }

  function _initializeAbrStrategy(type) {
    var strategy = settings.get().streaming.abr.ABRStrategy;

    if (strategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].ABR_STRATEGY_L2A) {
      isUsingBufferOccupancyAbrDict[type] = false;
      isUsingLoLPAbrDict[type] = false;
      isUsingL2AAbrDict[type] = true;
    } else if (strategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].ABR_STRATEGY_LoLP) {
      isUsingBufferOccupancyAbrDict[type] = false;
      isUsingLoLPAbrDict[type] = true;
      isUsingL2AAbrDict[type] = false;
    } else if (strategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].ABR_STRATEGY_BOLA) {
      isUsingBufferOccupancyAbrDict[type] = true;
      isUsingLoLPAbrDict[type] = false;
      isUsingL2AAbrDict[type] = false;
    } else if (strategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].ABR_STRATEGY_THROUGHPUT) {
      isUsingBufferOccupancyAbrDict[type] = false;
      isUsingLoLPAbrDict[type] = false;
      isUsingL2AAbrDict[type] = false;
    } else if (strategy === _constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].ABR_STRATEGY_DYNAMIC) {
      isUsingBufferOccupancyAbrDict[type] = isUsingBufferOccupancyAbrDict && isUsingBufferOccupancyAbrDict[type] ? isUsingBufferOccupancyAbrDict[type] : false;
      isUsingLoLPAbrDict[type] = false;
      isUsingL2AAbrDict[type] = false;
    }
  }

  function unRegisterStreamType(streamId, type) {
    try {
      if (streamProcessorDict[streamId] && streamProcessorDict[streamId][type]) {
        delete streamProcessorDict[streamId][type];
      }

      if (switchHistoryDict[streamId] && switchHistoryDict[streamId][type]) {
        delete switchHistoryDict[streamId][type];
      }

      if (abandonmentStateDict[streamId] && abandonmentStateDict[streamId][type]) {
        delete abandonmentStateDict[streamId][type];
      }
    } catch (e) {}
  }

  function resetInitialSettings() {
    topQualities = {};
    qualityDict = {};
    abandonmentStateDict = {};
    streamProcessorDict = {};
    switchHistoryDict = {};
    isUsingBufferOccupancyAbrDict = {};
    isUsingL2AAbrDict = {};
    isUsingLoLPAbrDict = {};

    if (windowResizeEventCalled === undefined) {
      windowResizeEventCalled = false;
    }

    if (droppedFramesHistory) {
      droppedFramesHistory.reset();
    }

    playbackIndex = undefined;
    droppedFramesHistory = undefined;
    throughputHistory = undefined;
    clearTimeout(abandonmentTimeout);
    abandonmentTimeout = null;
  }

  function reset() {
    resetInitialSettings();
    eventBus.off(_core_events_Events__WEBPACK_IMPORTED_MODULE_6__["default"].LOADING_PROGRESS, _onFragmentLoadProgress, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_16__["default"].QUALITY_CHANGE_RENDERED, _onQualityChangeRendered, instance);
    eventBus.off(_MediaPlayerEvents__WEBPACK_IMPORTED_MODULE_16__["default"].METRIC_ADDED, _onMetricAdded, instance);

    if (abrRulesCollection) {
      abrRulesCollection.reset();
    }
  }

  function setConfig(config) {
    if (!config) return;

    if (config.streamController) {
      streamController = config.streamController;
    }

    if (config.domStorage) {
      domStorage = config.domStorage;
    }

    if (config.mediaPlayerModel) {
      mediaPlayerModel = config.mediaPlayerModel;
    }

    if (config.customParametersModel) {
      customParametersModel = config.customParametersModel;
    }

    if (config.cmsdModel) {
      cmsdModel = config.cmsdModel;
    }

    if (config.dashMetrics) {
      dashMetrics = config.dashMetrics;
    }

    if (config.adapter) {
      adapter = config.adapter;
    }

    if (config.videoModel) {
      videoModel = config.videoModel;
    }

    if (config.settings) {
      settings = config.settings;
    }
  }

  function checkConfig() {
    if (!domStorage || !domStorage.hasOwnProperty('getSavedBitrateSettings')) {
      throw new Error(_constants_Constants__WEBPACK_IMPORTED_MODULE_1__["default"].MISSING_CONFIG_ERROR);
    }
  }
  /**
   * While fragment loading is in progress we check if we might need to abort the request
   * @param {object} e
   * @private
   */


  function _onFragmentLoadProgress(e) {
    var type = e.request.mediaType;
    var streamId = e.streamId;

    if (!type || !streamId || !streamProcessorDict[streamId] || !settings.get().streaming.abr.autoSwitchBitrate[type]) {
      return;
    }

    var streamProcessor = streamPro