jQuery(function ($) {
  $(document).ready(function () {
    // DARK/LIGHT MODE --------------- START
    // Switching the footer video
    const preFooterVideo = $('.video_switch'),
      srcLight = preFooterVideo.data('light-src'),
      srcDark = preFooterVideo.data('dark-src');

    // Video loop color change
    let modeClick = false;
    $('.dark-mode-toggle').on('click', function () {
      if (modeClick == false) {
        modeClick = true;

        console.log('clicked');
        var darkTheme = $('body').hasClass('darkmode__theme');
        var newTheme = 'light';
        console.log(darkTheme + ' lel');

        if (!darkTheme) {
          $('body').addClass('darkmode__theme');
          newTheme = 'dark';

          // Switch footer video to darkmode
          preFooterVideo.attr('src', srcDark);

          // Hero color
          // heroLoop.attr('src', heroLoopSrcDark);
        } else {
          $('body').removeClass('darkmode__theme');
          // Switch footer video to lightmode
          preFooterVideo.attr('src', srcLight);

          // Hero color
          // heroLoop.attr('src', heroLoopSrcLight);
        }

        document.cookie = 'themeMode=' + newTheme + ';path=/';

        setTimeout(function () {
          modeClick = false;
        }, 100);
      } else {
        modeClick = false;
      }
    });

    // Switch prefooter to dark when lightmode is saved
    if (!$('body').hasClass('darkmode__theme')) {
      preFooterVideo.attr('src', srcLight);
    }

    // DARK/LIGHT MODE --------------- END
    // AOS --------------- START
    function ismatch(str) {
      var ret = null;
      var tab = [
        'data-aos_',
        'data-aos-delay_',
        'data-aos-duration_',
        'data-aos-easing_',
      ];
      Object.values(tab).forEach(function (value) {
        if (String(str).match(value)) {
          ret = str.split('_');
          return false;
        }
      });
      return ret;
    }
    $('.iAos').each(function () {
      var $this = $(this);
      var tab = $this.attr('class').split(' ');
      var keep;
      Object.values(tab).forEach(function (item) {
        var ello = ismatch(item);
        if (ello !== null) $this.attr(ello[0], ello[1]);
      });
    });

    if ($('.iAos').length) {
      AOS.init({
        once: true,
        duration: 300,
      });
    }

    // AOS --------------- END

    // Anchor behaviour
    $('#navOverlayContainer ul li a').on('click', function () {
      $('body').removeClass('modal-open navOpen');
      $('#navOverlayContainer').slideUp();
      $('#navBurger').removeClass('active');
      $('.navBurgerContainer').removeClass('active');
      $('#navOverlayContainer').removeClass('openOverlay');
      if ($('a').hasClass('menuApplyNow')) {
        $('.menuApplyNow').removeClass('active');
      }
      // Offset for links on page
      if ($(this.hash)) {
        var id = $(this.hash);
        $('html, body').animate({ scrollTop: id.offset().top - 110 }, 'slow');
      }
    });

    // Navigation --------------- END

    // Modal FIX --------------- START

    if ($('.modal')) {
      $('.modal').each(function () {
        $(this).appendTo('#colophon');
      });
    }

    // Modal FIX --------------- END

    // Preview Mode --------------- START

    if (window.location.hash == '#sp') {
      $('.isPrev').each(function () {
        $(this).removeClass('isPrev');
      });
    }

    // Preview Mode --------------- END

    // * Rework ---------------------------------------------

    // * Menu ------------------
    const body = $('body');
    const menu_burger = $('#menu_burger');
    const menu_burger__text = $('.menu_burger__text');
    const navigation_overlay = $('#navigation_overlay');
    const site_header = $('#masthead');

    // Menu Burger
    menu_burger.on('click', function () {
      const isOpen = $(this).attr('aria-expanded') === 'true';
      // Body
      body.toggleClass('nav__open', !isOpen);
      // Menu Burger
      $(this).attr('aria-expanded', !isOpen);
      $(this).toggleClass('active', !isOpen);
      menu_burger__text.text(!isOpen ? 'Schließen' : 'Menu');
      // Navigation Overlay
      navigation_overlay.attr('aria-expanded', !isOpen);
      navigation_overlay.toggleClass('active', !isOpen);
    });

    // Scroll behaviour
    const scroll_threshold = 60;
    function showNav() {
      const st = $(this).scrollTop();
      site_header.toggleClass('scrolling', st > scroll_threshold);
    }

    showNav();
    $(window).on('scroll', showNav);
  });
});
