document.addEventListener("DOMContentLoaded", function () {
  const altTextInputs = document.querySelectorAll('input[type="text"]');

  altTextInputs.forEach(function (input) {
    input.addEventListener("keypress", function (event) {
      if (event.key === "Enter") {
        event.preventDefault();

        const postId = this.getAttribute("data-post-id");
        const altText = this.value;

        if (postId) {
          updateAltText(postId, altText);
        }
      }
    });
  });

  function updateAltText(postId, altText) {
    const data = {
      action: "update_alt_text",
      post_id: postId,
      alt_text: altText,
    };

    jQuery.post(ajaxurl, data, function (response) {
      alert("Alt text updated: " + response);
    });
  }
});
