<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package bsTheme
 */

?>

<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="https://gmpg.org/xfn/11">
    <?php wp_head(); ?>
    <!-- Fonts via CDN (Theme Global) ------------------ -->
    <?php fontsViaCDNRepeater(); ?>
    <!-- CSS Variables Output ------------------ -->
    <style>
        <?php require get_template_directory() . '/gb-custom/blockcss.php'; ?>
    </style>
</head>

<body <?php body_class(); ?>>

    <?php wp_body_open(); ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'bsTheme'); ?></a>

        <!-- Header ------------------ -->
        <header id="masthead" class="site__header">
            <?php coreHTMLOutput('header'); ?>
        </header>

        <!-- Navigation Overlay ------------------ -->
        <nav id="navigation_overlay" class="navigation_overlay" role="navigation" aria-hidden="true" aria-label="Main Navigation">
            <?php coreHTMLOutput('overlay_navigation'); ?>
        </nav>