<?php

/**
 * Enqueue Block Styles Javascript
 */
function custom_gutenberg_scripts()
{
	wp_enqueue_script(
		'block-styles-script',
		get_template_directory_uri() . '/gb-custom/block.js',
		array('wp-blocks', 'wp-dom-ready', 'wp-edit-post')
	);
}

add_action('enqueue_block_editor_assets', 'custom_gutenberg_scripts');


/**
 * Enqueue Global Styles Stylesheet
 */
function custom_gutenberg_styles()
{
	wp_enqueue_style(
		'global-styles-css',
		get_template_directory_uri() . '/global.css'
	);
}
add_action('enqueue_block_assets', 'custom_gutenberg_styles');




/**
 * Add Adobe Fonts
 */
function my_custom_admin_head()
{
	ob_start(); // begin collecting output

	include get_template_directory() . '/gb-custom/blockcss.php';
	$result = ob_get_clean();
	echo '<style>' . $result . '</style>';
}
add_action('admin_head', 'my_custom_admin_head');




// add_action( 'enqueue_block_editor_assets', function(){

// 	wp_enqueue_script(
//         'myplugin-rel',
// 		get_template_directory_uri() . '/gb-custom/panel.js',
// 		'wp-blocks',
// 		'wp-components',
// 		'wp-compose',
// 		'wp-dom-ready',
// 		'wp-editor',
// 		'wp-element',
// 		'wp-hooks',
// 	);

// });