"use strict";


function ownKeys(object, enumerableOnly) {
  var keys = Object.keys(object);
  if (Object.getOwnPropertySymbols) {
    keys.push.apply(keys, Object.getOwnPropertySymbols(object));
  }
  if (enumerableOnly)
    keys = keys.filter(function(sym) {
      return Object.getOwnPropertyDescriptor(object, sym).enumerable;
    });
  return keys;
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    if (i % 2) {
      ownKeys(source, true).forEach(function(key) {
        _defineProperty(target, key, source[key]);
      });
    } else if (Object.getOwnPropertyDescriptors) {
      Object.defineProperties(target, Object.getOwnPropertyDescriptors(source));
    } else {
      ownKeys(source).forEach(function(key) {
        Object.defineProperty(
          target,
          key,
          Object.getOwnPropertyDescriptor(source, key)
        );
      });
    }
  }
  return target;
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }
  return obj;
}

wp.domReady(function() {

  wp.hooks.addFilter(
    "blocks.registerBlockType",
    "bsTheme/getAos",
    function(settings) {
      if (settings.name === "core/group") {
        settings.attributes = _objectSpread({}, settings.attributes, {
          showAos: {
            type: "string",
            default: "iAos"
          }
        });
      }

      return settings;
    }
  );
  wp.hooks.addFilter(
    "editor.BlockEdit",
    "myPlugin/relInput",
    wp.compose.createHigherOrderComponent(function(BlockEdit) {
      return function(props) {
        if (props.name === "core/group") {
          return React.createElement(
            wp.element.Fragment,
            null,
            React.createElement(BlockEdit, props),
              React.createElement(
                wp.blockEditor.InspectorControls,
                null,
                React.createElement(
                  wp.components.PanelBody,
                  {
                    title: "Animate Group"
                  },
                  React.createElement(wp.components.Button, {
                    label: "Anbimate",
                    value: props.attributes.showAos,
                    onChange: function onChange(nextRel) {
                      return props.setAttributes({
                        showAos: nextRel
                      });
                    }
                  })
                )
              )
          );
        }

        return React.createElement(BlockEdit, props);
      };
    }, "withshowAosInput")
  );
  wp.hooks.addFilter("blocks.getSaveElement", "myPlugin/rel", function(
    element,
    block,
    attributes
  ) {
    if (block.name === "core/group") {
      if (attributes.showAos && attributes.url) {
        return wp.element.cloneElement(
          element,
          {},
          wp.element.cloneElement(element.props.children, {
            rel: attributes.showAos
          })
        );
      }
    }

    return element;
  });
});