<?php
// Theme Styles
// Used in gb-custom > block.css

$var = '';
$var__dark = '';
$var__dark_preset = '';
$classDef = '';
$classDarkMode = '';
$bgHeaderLight = '--transparent: transparent;';
$cHeaderLight = '';
$cNavDown = '';
$bgNavDown = '';
$bgLogin = '';
$bgSidebar = '';
$i = 1;
$hasDarkmode = get_field('dark_mode_active', 'option');
if (have_rows('site_colors', 'option')) :
    while (have_rows('site_colors', 'option')) : the_row();
        $class = get_sub_field('class');
        $color = get_sub_field('color');
        $var .= '--c' . $class . ': ' . $color . '; --c' . $i . ': ' . $color . ';';
        $classDef .= '.c' . $class . ' { color: ' . $color . ';}' . ' .c' . $i . ' { color: ' . $color . ';}' . ' .bg' . $class . ' { background-color: ' . $color . ';}' . ' .bgC' . $i . ' { background-color: ' . $color . ';}' . ' .b' . $class . ' { border-color: ' . $color . ';} ' . ' .bC' . $i . ' { border-color: ' . $color . ';} ';

        $i++;
    endwhile;
endif;


?>

/* Colors as Variables */
:root,
body {
<?php echo $var;  ?>
<?php echo $bgLogin; ?>
<?php echo $bgSidebar; ?>
<?php echo $bgHeaderLight; ?>
<?php echo $bgHeaderDark; ?>
<?php echo $cHeaderLight; ?>
<?php echo $cHeaderDark; ?>
<?php echo $cNavDown; ?>
<?php echo $bgNavDown; ?>

/* Colors as Classes */
<?php echo $classDef; ?>
}


<?php // Fonts --------------------------------------------- 
?>

<?php
// Font-Weights ********* *********
if (have_rows('f-weights', 'option')) {
    while (have_rows('f-weights', 'option')) {
        the_row();
        $weightLight = get_sub_field('f-weight-light');
        $weightRegular = get_sub_field('f-weight-regular');
        $weightMedium = get_sub_field('f-weight-medium');
        $weightSemiBold = get_sub_field('f-weight-semibold');
        $weightBold = get_sub_field('f-weight-bold');
        $weightBlack = get_sub_field('f-weight-black');
    }
}
?>

:root,
body {
--fw-light: <?php echo $weightLight; ?>;
--fw-regular: <?php echo $weightRegular; ?>;
--fw-medium: <?php echo $weightMedium; ?>;
--fw-semibold: <?php echo $weightSemiBold; ?>;
--fw-bold: <?php echo $weightBold; ?>;
--fw-black: <?php echo $weightBlack; ?>;
}

<?php
// Line-Height ********* *********
if (have_rows('line-heights', 'option')) {
    while (have_rows('line-heights', 'option')) {
        the_row();
        $lhBody = get_sub_field('lh-body');
        $lhHeadline = get_sub_field('lh-headline');
    }
}
?>

:root,
body {
--l-height-one: 1;
--l-height-body: <?php echo $lhBody; ?>;
--l-height-headline: <?php echo $lhHeadline; ?>;
}

<?php
// Font-Sizes ********* *********
// Font-Size - 4xl
if (have_rows('f-4xl', 'option')) {
    while (have_rows('f-4xl', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $ideal = get_sub_field('ideal');
        $max = get_sub_field('max');
    }
}
?>

:root,
body {
--f-4xl-min: <?php echo $min; ?>rem;
--f-4xl-ideal: <?php echo $ideal; ?>vw;
--f-4xl-max: <?php echo $max; ?>rem;
}

<?php
// Font-Size - 3xl
if (have_rows('f-3xl', 'option')) {
    while (have_rows('f-3xl', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $ideal = get_sub_field('ideal');
        $max = get_sub_field('max');
    }
}
?>

:root,
body {
--f-3xl-min: <?php echo $min; ?>rem;
--f-3xl-ideal: <?php echo $ideal; ?>vw;
--f-3xl-max: <?php echo $max; ?>rem;
}

<?php
// Font-Size - 2xl
if (have_rows('f-2xl', 'option')) {
    while (have_rows('f-2xl', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $ideal = get_sub_field('ideal');
        $max = get_sub_field('max');
    }
}
?>

:root,
body {
--f-2xl-min: <?php echo $min; ?>rem;
--f-2xl-ideal: <?php echo $ideal; ?>vw;
--f-2xl-max: <?php echo $max; ?>rem;
}

<?php
// Font-Size - xl
if (have_rows('f-xl', 'option')) {
    while (have_rows('f-xl', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $ideal = get_sub_field('ideal');
        $max = get_sub_field('max');
    }
}
?>

:root,
body {
--f-xl-min: <?php echo $min; ?>rem;
--f-xl-ideal: <?php echo $ideal; ?>vw;
--f-xl-max: <?php echo $max; ?>rem;
}

<?php
// Font-Size - lg
if (have_rows('f-lg', 'option')) {
    while (have_rows('f-lg', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $ideal = get_sub_field('ideal');
        $max = get_sub_field('max');
    }
}
?>

:root,
body {
--f-lg-min: <?php echo $min; ?>rem;
--f-lg-ideal: <?php echo $ideal; ?>vw;
--f-lg-max: <?php echo $max; ?>rem;
}

<?php
// Font-Size - reg
if (have_rows('f-reg', 'option')) {
    while (have_rows('f-reg', 'option')) {
        the_row();
        $min = get_sub_field('min');
        $max = get_sub_field('max');
    }
}
?>

@media (min-width: 300px) {
:root,
body {
--f-reg: <?php echo $min; ?>px;
}
}

@media (min-width: 993px) {
:root,
body {
--f-reg: <?php echo $max; ?>px;
}
}

<?php
// Font-Families ********* *********
$fontDefaults = "-apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto,
Oxygen-Sans, Ubuntu, Cantarell, 'Helvetica Neue', sans-serif";

if (have_rows('f-families', 'option')) {
    while (have_rows('f-families', 'option')) {
        the_row();
        $familyBody = get_sub_field('family-body');
        $familyHeadline = get_sub_field('family-headline');
        $familyAlternative = get_sub_field('family-alternative');

        if (!empty($familyBody)) {
            $familyBody = $familyBody . ', ' . $fontDefaults;
        } else {
            $familyBody = $fontDefaults;
        }

        if (!empty($familyHeadline)) {
            $familyHeadline = $familyHeadline . ', ' . $fontDefaults;
        } else {
            $familyHeadline = $fontDefaults;
        }

        if (!empty($familyAlternative)) {
            $familyAlternative = $familyAlternative . ', ' . $fontDefaults;
        } else {
            $familyAlternative = $fontDefaults;
        }
    }
}



?>

:root,
body {
--family-body: <?php echo $familyBody; ?>;
--family-headline: <?php echo $familyHeadline; ?>;
--family-alternative: <?php echo $familyAlternative; ?>;
--ff-body: <?php echo $familyBody; ?>;
--ff-head: <?php echo $familyHeadline; ?>;
--ff-alt: <?php echo $familyAlternative; ?>;
}


<?php // Layout --------------------------------------------- 
?>

<?php
// Border-Radii ********* *********
if (have_rows('b-radii', 'option')) {
    while (have_rows('b-radii', 'option')) {
        the_row();
        $borderRadiusRegular = get_sub_field('br-regular');
        $borderRadiusLG = get_sub_field('br-lg');
        $borderRadiusXL = get_sub_field('br-xl');
    }
}

?>

:root,
body {
--b-radius-xl: <?php echo $borderRadiusXL; ?>px;
--b-radius-lg: <?php echo $borderRadiusLG; ?>px;
--b-radius-reg: <?php echo $borderRadiusRegular; ?>px;
}

<?php
// Border-Widths ********* *********
if (have_rows('b-width', 'option')) {
    while (have_rows('b-width', 'option')) {
        the_row();
        $borderWidthRegular = get_sub_field('bw-regular');
        $borderWidthLG = get_sub_field('bw-lg');
        $borderWidthXL = get_sub_field('bw-xl');
    }
}

?>

:root,
body {
--b-width-xl: <?php echo $borderWidthRegular; ?>px;
--b-width-lg: <?php echo $borderWidthLG; ?>px;
--b-width-reg: <?php echo $borderWidthXL; ?>px;
}

<?php
// Max-Widths (Bootstrap) ********* *********
if (have_rows('mw-boostrap', 'option')) {
    while (have_rows('mw-boostrap', 'option')) {
        the_row();
        $mwBootstrapXL = get_sub_field('mw-bootstrap-xl');
        $mwBootstrapXXL = get_sub_field('mw-bootstrap-xxl');
    }
}

?>

@media (min-width: 1200px) {
body :is(.container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl) {
max-width: <?php echo $mwBootstrapXL; ?>px;
}
}

@media (min-width: 1400px) {
body :is(.container, .container-lg, .container-md, .container-sm, .container-xl, .container-xxl) {
max-width: <?php echo $mwBootstrapXXL; ?>px;
}
}


<?php
// Custom Styles
if (have_rows('variables', 'option')) { ?>

    :root,
    body {
<?php
    while (have_rows('variables', 'option')) {
        the_row();
        $label = get_sub_field('definition');
        $val = get_sub_field('value');
        echo '--' . $label . ': ' . $val . ';';
    }
} ?>

}