// Heading ************************************
// Headlines
wp.blocks.registerBlockStyle('core/heading', {
  name: 'h-4xl',
  label: 'Titel (4XL)',
});

wp.blocks.registerBlockStyle('core/heading', {
  name: 'h-3xl',
  label: 'Titel (3XL)',
});

wp.blocks.registerBlockStyle('core/heading', {
  name: 'h-2xl',
  label: 'Titel (2XL)',
});

wp.blocks.registerBlockStyle('core/heading', {
  name: 'h-xl',
  label: 'Titel (XL)',
});

wp.blocks.registerBlockStyle('core/heading', {
  name: 'h-lg',
  label: 'Titel (LG)',
});

// Section Indicator
wp.blocks.registerBlockStyle('core/heading', {
  name: 'secInd',
  label: 'Sektion-Indikator',
});

// Paragraph ************************************
// Headlines
wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'h-4xl',
  label: 'Titel (4XL)',
});

wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'h-3xl',
  label: 'Titel (3XL)',
});

wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'h-2xl',
  label: 'Titel (2XL)',
});

wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'h-xl',
  label: 'Titel (XL)',
});

wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'h-lg',
  label: 'Titel (LG)',
});

// Section Indicator
wp.blocks.registerBlockStyle('core/paragraph', {
  name: 'secInd',
  label: 'Sektion-Indikator',
});

const { addFilter } = wp.hooks;
const { createElement } = wp.element;
const { InspectorControls } = wp.blockEditor;
const { PanelBody } = wp.components;

const addFontControlToBlocks = (settings, name) => {
  if (name === 'core/paragraph' || name === 'core/heading') {
    const existingControls = settings.edit;

    settings.edit = (props) => {
      const { attributes, setAttributes } = props;
      const { className } = attributes;
      const fontStyleClass = className
        ?.split(' ')
        .find((c) => c.startsWith('ff-'));

      const onChangeFontStyle = (newStyle) => {
        let newClassName = className
          ?.split(' ')
          .filter((c) => !c.startsWith('ff-'))
          .join(' ');
        newClassName =
          newStyle !== 'default'
            ? `${newClassName} ${newStyle}`.trim()
            : newClassName;
        setAttributes({ className: newClassName });
      };

      const createButton = (label, styleValue) => {
        const isActive = fontStyleClass === styleValue;
        return createElement(
          'button',
          {
            type: 'button',
            'aria-current': isActive ? 'true' : 'false',
            className: `components-button block-editor-block-styles__item ${
              isActive ? 'is-active' : ''
            } is-next-40px-default-size is-secondary`,
            'aria-label': label,
            onClick: () => onChangeFontStyle(styleValue),
          },
          createElement(
            'span',
            {
              className:
                'components-truncate block-editor-block-styles__item-text css-19ok06l e19lxcc00',
            },
            label
          )
        );
      };

      return createElement(
        wp.element.Fragment,
        {},
        existingControls(props),
        createElement(
          InspectorControls,
          null,
          createElement(
            PanelBody,
            { title: 'Font Style' },
            createElement(
              'div',
              { className: 'block-editor-block-styles' },
              createElement(
                'div',
                { className: 'block-editor-block-styles__variants' },
                createButton('Default', 'default'),
                createButton('Family Headline', 'ff-headline'),
                createButton('Family Alternative', 'ff-alt')
              )
            )
          )
        )
      );
    };
  }

  return settings;
};

addFilter(
  'blocks.registerBlockType',
  'my-custom-plugin/add-font-control',
  addFontControlToBlocks
);
