<?php
/* CUSTOM POST TYPE: GLOBAL TEMPLATES */

function custom_post_type_global_templates()
{
	// Set UI labels for Custom Post Type
	$labels = array(
		'name'                => _x('Framework', 'Post Type General Name'),
		'singular_name'       => _x('Framework', 'Post Type Singular Name'),
		'menu_name'           => __('Framework'),
		'all_items'           => __('Alle Templates'),
		'view_item'           => __('Template anzeigen'),
		'add_new_item'        => __('Template hinzufügen'),
		'add_new'             => __('Template hinzufügen'),
		'edit_item'           => __('Template bearbeiten'),
		'update_item'         => __('Update Template'),
		'search_items'        => __('Suche Template'),
		'not_found'           => __('No Templates found'),
		'not_found_in_trash'  => __('No Templates found in Trash'),
	);
	// Set other options for Custom Post Type
	$args = array(
		'label'               => __('global-template'),
		'description'         => __('Global Templates like Footer or 404 Page'),
		'labels'              => $labels,
		// Features this CPT supports in Post Editor
		'supports'            => array('title', 'custom-fields', 'editor'),
		// You can associate this CPT with a taxonomy or custom taxonomy. 
		/* A hierarchical CPT is like Pages and can have
			* Parent and child items. A non-hierarchical CPT
			* is like Posts.
			*/
		'show_in_rest' 		  => true,
		'hierarchical'        => false,
		'public'              => false,
		'show_ui'             => true,
		'show_in_menu'        => true,
		'show_in_nav_menus'   => true,
		'show_in_admin_bar'   => true,
		'menu_position'       => 91,
		'menu_icon'           => 'dashicons-editor-kitchensink',
		'can_export'          => true,
		'has_archive'         => false,
		'exclude_from_search' => true,
		'publicly_queryable'  => false,
		'rewrite'             => array('slug' => 'bs-frameworks')
	);
	// Registering Custom Post Type
	register_post_type('bs-frameworks', $args);
}
/* Hook into the 'init' action so that the function
	* Containing our post type registration is not 
	* unnecessarily executed. 
	*/
add_action('init', 'custom_post_type_global_templates', 0);

add_action('admin_init', 'createGlobalTemplates');

function createGlobalTemplates()
{
	// Footer ------------------
	$footerTemp = get_field('footer', 'option');
	if ($footerTemp === false || $footerTemp === NULL) {
		$postData = array(
			"post_type" => "bs-frameworks",
			"post_title" => 'Footer',
			'post_status' => 'publish'
		);
		$postid = wp_insert_post($postData);
		update_field('footer', $postid, 'option');
	}
	// Nav ------------------
	$navTemp = get_field('overlay_navigation', 'option');
	if ($navTemp === false || $navTemp === NULL) {
		$postData = array(
			"post_type" => "bs-frameworks",
			"post_title" => 'Navigation Overlay',
			'post_status' => 'publish'
		);
		$postid = wp_insert_post($postData);
		update_field('overlay_navigation', $postid, 'option');
	}
	// Header ------------------
	$headerTemp = get_field('header', 'option');
	if ($headerTemp === false || $headerTemp === NULL) {
		$postData = array(
			"post_type" => "bs-frameworks",
			"post_title" => 'Header',
			'post_status' => 'publish'
		);
		$postid = wp_insert_post($postData);
		update_field('header', $postid, 'option');
	}
}
