<?php

/**
 * Default Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */


/**
 * Create id attribute allowing for custom "anchor" value.
 *  */

$id = '' . $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}

/**
 *  Create class attribute allowing for custom "className" and "align" values.
 *  */

$className = 'blockWrapper';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

$items = '';

$args = array(
    'post_type' => 'post',
    'posts_per_page' => -1,
    // 'order' => DESC,
    // 'post_status' => 'publish',
    // 'category_name' => '',
);

$query = new WP_Query($args);
if ($query->have_posts()) {
    while ($query->have_posts()) {
        $query->the_post();
        $post_id = get_the_ID();

        $items .= '<div>
                    <h2>' . get_the_title() . '</h2>
                </div>';
    }
}

wp_reset_postdata();

/**createdwithblockautomation*/
