<?php

/**
 * pageHero Default Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */


/**
 * Create id attribute allowing for custom "anchor" value.
 *  */

$id = '' . $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}

/**
 *  Create class attribute allowing for custom "className" and "align" values.
 *  */

$className = 'accBasicWrapper';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

?>

<?php if (have_rows('basicAcc')) : ?>
    <div class="<?php echo $className; ?>">
        <!-- Accordion-Repeater -->
        <?php $i = 0; ?>
        <div id='accordion-<?php echo $id; ?>' class='accordion'>
            <?php while (have_rows('basicAcc')) : the_row();
                $title = get_sub_field('baTitle');
                $content = get_sub_field('baContent');

                if ($i < 1) {
                    $ariaExpanded = 'true';
                    $collapsed = '';
                    $show = 'show';
                } else {
                    $ariaExpanded = 'false';
                    $collapsed = 'collapsed';
                    $show = '';
                }
            ?>
                <div class='accordion-item mb-3'>
                    <h3 id='heading-<?php echo $i . '-' . $id; ?>' class='accordion-header'>
                        <button class='accordion-button <?php echo $collapsed; ?> px-3 px-lg-4' type='button' data-bs-toggle='collapse' data-bs-target='#collapse-<?php echo $i . '-' . $id; ?>' aria-expanded='<?php echo $ariaExpanded; ?>' aria-controls='collapse-<?php echo $i . '-' . $id; ?>'>
                            <?php echo $title; ?>
                        </button>
                    </h3>
                    <div id='collapse-<?php echo $i . '-' . $id; ?>' class='accordion-collapse collapse <?php echo $show; ?>' aria-labelledby='heading-<?php echo $i . '-' . $id; ?>' data-bs-parent='#accordion-<?php echo $id; ?>'>
                        <div class='accordion-body bgLightGrey px-3 px-lg-4 pt-4 pb-3 pdfList'>
                            <?php echo $content; ?>
                        </div>
                    </div>
                </div>
                <?php $i++; ?>
            <?php endwhile; ?>
        </div>
    </div>
<?php endif; ?>