<?php

/**
 * Default Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */


/**
 * Create id attribute allowing for custom "anchor" value.
 *  */

$id = '' . $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}

/**
 *  Create class attribute allowing for custom "className" and "align" values.
 *  */

$className = 'blockWrapper';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

$index = 1;
$index_content = 1;

// Tab setup
$tab_setup = get_field('default_tab_setup');

// Use a custom indicator if provided, otherwise use the default SVG
$indicator =    '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
                </svg>';
$use_custom_indicator = $tab_setup['default_tab_custom_indicator'];
$custom_indicator = $tab_setup['default_tab_custom_indicator_upload'];
if ($use_custom_indicator == true && !empty($custom_indicator)) {
    // Check if the custom indicator is an SVG
    // If it's an SVG, use it directly; otherwise, use it as an image
    $custom_indicator_svg = file_get_contents($custom_indicator['url']);
    if ($custom_indicator_svg !== false && strpos($custom_indicator_svg, '<svg') !== false) {
        $indicator = $custom_indicator_svg;
    } else {
        $indicator = '<img src="' . $custom_indicator['url'] . '" alt="" />';
    }
}

// Indicator colors
$indicator_color_closed = $tab_setup['default_tab_color_indicator_closed'];
$indicator_color_open = $tab_setup['default_tab_color_indicator_open'];
$indicator_background_color_closed = $tab_setup['default_tab_color_indicator_closed_background'];
$indicator_background_color_open = $tab_setup['default_tab_color_indicator_open_background'];

// Index
$show_index = $tab_setup['default_tab_index'];
$index_color_closed = $tab_setup['default_tab_color_index_closed'];
$index_color_open = $tab_setup['default_tab_color_index_open'];

// Title colors
$title_color_closed = $tab_setup['default_tab_color_title_closed'];
$title_color_open = $tab_setup['default_tab_color_title_open'];
$title_background_color_closed = $tab_setup['default_tab_color_title_closed_background'];
$title_background_color_open = $tab_setup['default_tab_color_title_open_background'];

// Title formatting
$use_title_uppercase = $tab_setup['default_tab_title_uppercase'];
$title_text_transform = 'initial';
if ($use_title_uppercase == true) {
    $title_text_transform = 'uppercase';
}

$title_sizing = $tab_setup['default_tab_title_sizing'];

// Title shadow
$use_title_shadow = $tab_setup['default_tab_shadow'];
$title_shadow_output = '';
if ($use_title_shadow == true) {
    $title_shadow_hex = $tab_setup['default_tab_shadow_color'];

    // Convert HEX to RGBA
    if (preg_match('/^#?([a-fA-F0-9]{6})$/', $title_shadow_hex, $matches)) {
        list($r, $g, $b) = sscanf($matches[1], "%02x%02x%02x");
        $title_shadow = "rgba($r, $g, $b, 0.15)";
    }

    $title_shadow_output .= 'box-shadow: 10px 10px 5px 0px ' . $title_shadow . ';';
    $title_shadow_output .= '-webkit-box-shadow: 10px 10px 5px 0px ' . $title_shadow . ';';
    $title_shadow_output .= '-moz-box-shadow: 10px 10px 5px 0px ' . $title_shadow . ';';
}

// Title border radius
$use_title_border_radius = $tab_setup['default_tab_rounded'];
$title_border_radius = 0;
if ($use_title_border_radius == true) {
    $title_border_radius = $tab_setup['default_tab_rounded_strength'];
}

// Title border
$use_title_border = $tab_setup['default_tab_border'];
$title_border = '';
if ($use_title_border == true) {
    $title_border_width = $tab_setup['default_tab_border_width'];
    $title_border_color = $tab_setup['default_tab_border_color'];
    $title_border_position = $tab_setup['default_tab_border_position'];

    foreach ($title_border_position as $position) {
        if ($position == 'all') {
            $title_border .= 'border: ' . $title_border_width . 'px solid ' . $title_border_color . ';';
        } else {
            $title_border .= 'border-' . $position . ': ' . $title_border_width . 'px solid ' . $title_border_color . ';';
        }
    }
}

// Content colors
$content_color = $tab_setup['default_tab_color_content'];
$content_background_color = $tab_setup['default_tab_color_content_background'];
// If title has border radius, add margin-top to content
$content_margin_top = '';
if ($use_title_border_radius == true) {
    $content_margin_top = min($title_border_radius, 1);
}

?>

<style>
    .bs_default_tab {
        --bs_default__title_color_closed: <?php echo $title_color_closed; ?>;
        --bs_default__title_color_open: <?php echo $title_color_open; ?>;
        --bs_default__title_background_color_closed: <?php echo $title_background_color_closed; ?>;
        --bs_default__title_background_color_open: <?php echo $title_background_color_open; ?>;
        --bs_default__index_color_closed: <?php echo $index_color_closed; ?>;
        --bs_default__index_color_open: <?php echo $index_color_open; ?>;
        --bs_default__title_text_transform: <?php echo $title_text_transform; ?>;
        --bs_default__title_border_radius: <?php echo $title_border_radius; ?>px;
        --bs_default__indicator_color_closed: <?php echo $indicator_color_closed; ?>;
        --bs_default__indicator_color_open: <?php echo $indicator_color_open; ?>;
        --bs_default__indicator_background_color_closed: <?php echo $indicator_background_color_closed; ?>;
        --bs_default__indicator_background_color_open: <?php echo $indicator_background_color_open; ?>;
        --bs_default__content_color: <?php echo $content_color; ?>;
        --bs_default__content_background_color: <?php echo $content_background_color; ?>;
        --bs_default__content_margin_top: <?php echo $content_margin_top; ?>rem;
    }

    /* Accordion item ------------------ */
    .bs_default_tab .accordion-item {
        border: none;
        margin-bottom: 1rem;
    }

    /* Button ------------------ */
    .bs_default_tab .accordion-button {
        padding: 0;
        transition: .3s all ease;
        background-color: var(--bs_default__title_background_color_closed);
        align-items: stretch;
        border-radius: var(--bs_default__title_border_radius) !important;
        overflow: hidden;
        box-shadow: none;
        <?php echo $title_shadow_output; ?><?php echo $title_border; ?>
    }

    .bs_default_tab .accordion-button:not(.collapsed) {
        background-color: var(--bs_default__title_background_color_open);
    }

    /* Title ------------------ */
    .bs_default_tab .tab__title {
        padding: 1rem;
        color: var(--bs_default__title_color_closed);
        text-transform: var(--bs_default__title_text_transform);
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .bs_default_tab .accordion-button:not(.collapsed) .accordion__title {
        color: var(--bs_default__title_color_open);
    }

    /* Content ------------------ */
    .bs_default_tab .accordion-body {
        padding: 1rem;
        border-radius: var(--bs_default__title_border_radius) !important;
        color: var(--bs_default__content_color);
        background-color: var(--bs_default__content_background_color);
        margin-top: var(--bs_default__content_margin_top);
    }

    /* Index ------------------ */
    .bs_default_tab .tab__index {
        flex: 0 0 3rem;
        transition: .3s all ease;
        color: var(--bs_default__index_color_open);
        background-color: var(--bs_default__index_color_closed);
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .bs_default_tab .accordion-button:not(.collapsed) .accordion__index {
        color: var(--bs_default__index_color_closed);
        background-color: var(--bs_default__index_color_open);
    }

    /* Indicator ------------------ */
    .bs_default_tab .accordion-button::after {
        display: none;
        /* Turns off bootstrap indicator */
    }

    .bs_default_tab .accordion__indicator {
        flex: 0 0 3rem;
        padding: 1rem;
        margin-left: auto;
        display: flex;
        justify-content: center;
        align-items: center;
        transition: .3s all ease;
        background-color: var(--bs_default__indicator_background_color_closed);
    }

    .bs_default_tab .accordion-button:not(.collapsed) .accordion__indicator {
        background-color: var(--bs_default__indicator_background_color_open);
    }

    .bs_default_tab .accordion__indicator :is(img, svg) {
        width: 1rem;
        height: auto;
        transition: .3s all ease;
    }

    .bs_default_tab .accordion-button:not(.collapsed) .accordion__indicator :is(img, svg) {
        transform: rotate(-180deg);
    }

    .bs_default_tab .accordion__indicator svg path {
        stroke: var(--bs_default__indicator_color_closed);
    }

    .bs_default_tab .accordion-button:not(.collapsed) .accordion__indicator svg path {
        stroke: var(--bs_default__indicator_color_open);
    }
</style>

<?php if (have_rows('default_tab_repeater')): ?>
    <div class="tabs bs_default_tab" id="tab__<?php echo $id; ?>">
        <!-- Navigation --------------------------------------------- -->
        <ul class="nav nav-tabs" id="tab__nav_<?php echo $id; ?>" role="tablist">
            <?php while (have_rows('default_tab_repeater')):
                the_row();
                $post_id = get_the_ID();

                $item_title = get_sub_field('default_tab_repeater_item_title', $post_id);
                // Shorten the title to 20 characters and sanitize it for use in IDs
                $item_title_shortened = (strlen($item_title) > 20) ? substr($item_title, 0, 20) : $item_title;
                $item_title_sanitized = sanitize_title($item_title_shortened);

                // Accordion states
                if ($index == 1) {
                    $active = 'active';
                    $selected = 'true';
                } else {
                    $active = '';
                    $selected = 'false';
                }

                if ($index < 10) {
                    $index = '0' . $index;
                }
            ?>

                <li class="nav-item" role="presentation">
                    <button class="nav-link <?php echo $active; ?>" id="tab_nav_<?php echo $index . '__' . $item_title_sanitized; ?>" data-bs-toggle="tab" data-bs-target="#tab_pane_<?php echo $index . '__' . $item_title_sanitized; ?>" type="button" role="tab" aria-controls="tab_pane_<?php echo $index . '__' . $item_title_sanitized; ?>" aria-selected="<?php echo $selected; ?>">
                        <?php if ($show_index == true) {  ?>
                            <div class="tab__index <?php echo $title_sizing; ?>">
                                <?php echo $index; ?>
                            </div>
                        <?php }  ?>
                        <div class="tab__title <?php echo $title_sizing; ?>">
                            <?php echo $item_title; ?>
                        </div>
                        <!-- <div class="tab__indicator">
                            <?php echo $indicator; ?>
                        </div> -->
                    </button>
                </li>
                <?php $index++; ?>
            <?php endwhile; ?>
        </ul>
        <!-- Content --------------------------------------------- -->
        <div class="tab-content" id="tab__content_<?php echo $id; ?>">
            <?php while (have_rows('default_tab_repeater')):
                the_row();
                $post_id = get_the_ID();

                $item_title = get_sub_field('default_tab_repeater_item_title', $post_id);
                // Shorten the title to 20 characters and sanitize it for use in IDs
                $item_title_shortened = (strlen($item_title) > 20) ? substr($item_title, 0, 20) : $item_title;
                $item_title_sanitized = sanitize_title($item_title_shortened);

                $item_content = get_sub_field('default_tab_repeater_item_content', $post_id);

                // Accordion states
                if ($index_content == 1) {
                    $active = 'active';
                    $show = 'show';
                } else {
                    $active = '';
                    $show = '';
                }

                if ($index_content < 10) {
                    $index_content = '0' . $index_content;
                }
            ?>
                <div class="tab-pane fade <?php echo $show . ' ' . $active; ?>" id="tab_pane_<?php echo $index_content . '__' . $item_title_sanitized; ?>" role="tabpanel" aria-labelledby="tab_nav_<?php echo $index_content . '__' . $item_title_sanitized; ?>" tabindex="0">
                    <?php echo $item_content; ?>
                </div>
                <?php $index_content++; ?>
            <?php endwhile; ?>
        </div>
    </div>
<?php endif; ?>