<?php

/**
 * Default Block Template.
 *
 * @param   array $block The block settings and attributes.
 * @param   string $content The block inner HTML (empty).
 * @param   bool $is_preview True during AJAX preview.
 * @param   (int|string) $post_id The post ID this block is saved to.
 */


/**
 * Create id attribute allowing for custom "anchor" value.
 *  */

$id = '' . $block['id'];
if (!empty($block['anchor'])) {
    $id = $block['anchor'];
}

/**
 *  Create class attribute allowing for custom "className" and "align" values.
 *  */

$className = 'blockWrapper';
if (!empty($block['className'])) {
    $className .= ' ' . $block['className'];
}
if (!empty($block['align'])) {
    $className .= ' align' . $block['align'];
}

$index = 1;

// Accordion setup
$accordion_setup = get_field('default_accordion_setup');

// Use a custom indicator if provided, otherwise use the default SVG
$indicator =    '<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
                    <path stroke-linecap="round" stroke-linejoin="round" d="m19.5 8.25-7.5 7.5-7.5-7.5" />
                </svg>';
$use_custom_indicator = $accordion_setup['default_accordion_custom_indicator'];
$custom_indicator = $accordion_setup['default_accordion_custom_indicator_upload'];
if ($use_custom_indicator == true && !empty($custom_indicator)) {
    // Check if the custom indicator is an SVG
    // If it's an SVG, use it directly; otherwise, use it as an image
    $custom_indicator_svg = file_get_contents($custom_indicator['url']);
    if ($custom_indicator_svg !== false && strpos($custom_indicator_svg, '<svg') !== false) {
        $indicator = $custom_indicator_svg;
    } else {
        $indicator = '<img src="' . $custom_indicator['url'] . '" alt="" />';
    }
}

// Indicator colors
$indicator_color_closed = $accordion_setup['default_accordion_color_indicator_closed'];
$indicator_color_open = $accordion_setup['default_accordion_color_indicator_open'];
$indicator_background_color_closed = $accordion_setup['default_accordion_color_indicator_closed_background'];
$indicator_background_color_open = $accordion_setup['default_accordion_color_indicator_open_background'];

// Indicator orientation
$indicator_orientation_closed = $accordion_setup['default_accordion_indicator_orientation_closed'];
$indicator_orientation_open = $accordion_setup['default_accordion_indicator_orientation_open'];

// Index
$show_index = $accordion_setup['default_accordion_index'];
$index_color_closed = $accordion_setup['default_accordion_color_index_closed'];
$index_color_open = $accordion_setup['default_accordion_color_index_open'];

// Title colors
$title_color_closed = $accordion_setup['default_accordion_color_title_closed'];
$title_color_open = $accordion_setup['default_accordion_color_title_open'];
$title_background_color_closed = $accordion_setup['default_accordion_color_title_closed_background'];
$title_background_color_open = $accordion_setup['default_accordion_color_title_open_background'];

// Title formatting
$use_title_uppercase = $accordion_setup['default_accordion_title_uppercase'];
$title_text_transform = 'initial';
if ($use_title_uppercase == true) {
    $title_text_transform = 'uppercase';
}

$title_sizing = $accordion_setup['default_accordion_title_sizing'];

// Title shadow
$use_title_shadow = $accordion_setup['default_accordion_shadow'];
$title_shadow_output = '';
if ($use_title_shadow == true) {
    $title_shadow_hex = $accordion_setup['default_accordion_shadow_color'];
    $title_shadow_meta = $accordion_setup['default_accordion_shadow_meta'];
    $title_shadow_show_when_open = $accordion_setup['default_accordion_shadow_open'];

    // If the shadow should not be shown when open, set the state to none
    $title_shadow_state = '';
    if ($title_shadow_show_when_open == false) {
        $title_shadow_state = 'box-shadow: none;';
    }

    // Convert HEX to RGBA
    if (preg_match('/^#?([a-fA-F0-9]{6})$/', $title_shadow_hex, $matches)) {
        $o = $title_shadow_meta['default_accordion_shadow_meta_opacity'] ?? 0.15;
        list($r, $g, $b) = sscanf($matches[1], "%02x%02x%02x");
        $title_shadow = "rgba($r, $g, $b, $o)";
    }

    $x_offset = $title_shadow_meta['default_accordion_shadow_meta_x'] ?? 10;
    $y_offset = $title_shadow_meta['default_accordion_shadow_meta_y'] ?? 10;
    $blur = $title_shadow_meta['default_accordion_shadow_meta_blur'] ?? 5;
    $spread = $title_shadow_meta['default_accordion_shadow_meta_spread'] ?? 0;

    $title_shadow_output .= 'box-shadow: ' . $x_offset . 'px ' . $y_offset . 'px ' . $blur . 'px ' . $spread .  'px ' . $title_shadow . ';';
    $title_shadow_output .= '-webkit-box-shadow: ' . $x_offset . 'px ' . $y_offset . 'px ' . $blur . 'px ' . $spread .  'px ' . $title_shadow . ';';
    $title_shadow_output .= '-moz-box-shadow: ' . $x_offset . 'px ' . $y_offset . 'px ' . $blur . 'px ' . $spread .  'px ' . $title_shadow . ';';
}

// Title border
$use_title_border = $accordion_setup['default_accordion_border'];
$title_border = '';
if ($use_title_border == true) {
    $title_border_width = $accordion_setup['default_accordion_border_width'];
    $title_border_color = $accordion_setup['default_accordion_border_color'];
    $title_border_position = $accordion_setup['default_accordion_border_position'];

    foreach ($title_border_position as $position) {
        if ($position == 'all') {
            $title_border .= 'border: ' . $title_border_width . 'px solid ' . $title_border_color . ';';
        } else {
            $title_border .= 'border-' . $position . ': ' . $title_border_width . 'px solid ' . $title_border_color . ';';
        }
    }
}

// Title border radius
$use_title_border_radius = $accordion_setup['default_accordion_title_rounded'];
$radius_top_left = 0;
$radius_top_right = 0;
$radius_bottom_right = 0;
$radius_bottom_left = 0;
if ($use_title_border_radius == true) {
    $border_radius = $accordion_setup['default_accordion_title_rounded_strength'];
    $radius_top_left = $border_radius['default_accordion_title_rounded_strength_top_left'];
    $radius_top_right = $border_radius['default_accordion_title_rounded_strength_top_right'];
    $radius_bottom_right = $border_radius['default_accordion_title_rounded_strength_bottom_right'];
    $radius_bottom_left = $border_radius['default_accordion_title_rounded_strength_bottom_left'];
}
$title_border_radius = $radius_top_left . 'px ' . $radius_top_right . 'px ' . $radius_bottom_right . 'px ' . $radius_bottom_left . 'px';

// Content border radius
$use_content_border_radius = $accordion_setup['default_accordion_content_rounded'];
$content_radius_top_left = 0;
$content_radius_top_right = 0;
$content_radius_bottom_right = 0;
$content_radius_bottom_left = 0;
if ($use_content_border_radius == true) {
    $content_border_radius_values = $accordion_setup['default_accordion_content_rounded_strength'];
    $content_radius_top_left = $content_border_radius_values['default_accordion_content_rounded_strength_top_left'];
    $content_radius_top_right = $content_border_radius_values['default_accordion_content_rounded_strength_top_right'];
    $content_radius_bottom_right = $content_border_radius_values['default_accordion_content_rounded_strength_bottom_right'];
    $content_radius_bottom_left = $content_border_radius_values['default_accordion_content_rounded_strength_bottom_left'];
}
$content_border_radius = $content_radius_top_left . 'px ' . $content_radius_top_right . 'px ' . $content_radius_bottom_right . 'px ' . $content_radius_bottom_left . 'px';

// Content spacing
$content_spacing = $accordion_setup['default_accordion_title_body_spacing'];
// If title has border radius, add margin-top to content
$content_margin_top = '';
if ($content_spacing == true) {
    $content_margin_top = 1;
    $title_border_radius_bottom = '';
    $content_border_radius_top = '';
} else {
    $title_border_radius_bottom = 'border-bottom-left-radius: 0px !important; border-bottom-right-radius: 0px !important;';
    $content_border_radius_top = 'border-top-left-radius: 0px !important; border-top-right-radius: 0px !important;';
}

// Content colors
$content_color = $accordion_setup['default_accordion_color_content'];
$content_background_color = $accordion_setup['default_accordion_color_content_background'];

$content_gradient = $accordion_setup['default_accordion_color_content_background_gradient'];
if ($content_gradient == true) {
    $content_gradient_color = $accordion_setup['default_accordion_color_content_background_gradient_color'];

    // Create a linear gradient from $content_color to $content_gradient_color (top to bottom)
    $content_background_color = "linear-gradient(to bottom, $content_background_color, $content_gradient_color)";
}

// Accordion padding inline
$accordion_padding_inline = $accordion_setup['default_accordion_padding_inline'];

// Column gap 
$column_gap = $accordion_setup['default_accordion_column_gap'];

?>

<style>
    .bs_default_accordion {
        --bs_default__title_color_closed: <?php echo $title_color_closed; ?>;
        --bs_default__title_color_open: <?php echo $title_color_open; ?>;
        --bs_default__title_background_color_closed: <?php echo $title_background_color_closed; ?>;
        --bs_default__title_background_color_open: <?php echo $title_background_color_open; ?>;
        --bs_default__index_color_closed: <?php echo $index_color_closed; ?>;
        --bs_default__index_color_open: <?php echo $index_color_open; ?>;
        --bs_default__indicator_orientation_closed: <?php echo $indicator_orientation_closed; ?>deg;
        --bs_default__indicator_orientation_open: <?php echo $indicator_orientation_open; ?>deg;
        --bs_default__title_text_transform: <?php echo $title_text_transform; ?>;
        --bs_default__title_border_radius: <?php echo $title_border_radius; ?>;
        --bs_default__indicator_color_closed: <?php echo $indicator_color_closed; ?>;
        --bs_default__indicator_color_open: <?php echo $indicator_color_open; ?>;
        --bs_default__indicator_background_color_closed: <?php echo $indicator_background_color_closed; ?>;
        --bs_default__indicator_background_color_open: <?php echo $indicator_background_color_open; ?>;
        --bs_default__content_color: <?php echo $content_color; ?>;
        --bs_default__content_background_color: <?php echo $content_background_color; ?>;
        --bs_default__content_margin_top: <?php echo $content_margin_top; ?>rem;
        --bs_default__content_border_radius: <?php echo $content_border_radius; ?>;
        --bs_default__accordion_padding_inline: <?php echo $accordion_padding_inline; ?>rem;
        --bs_default__accordion_column_gap: <?php echo $column_gap; ?>rem;
    }

    /* Accordion item ------------------ */
    .bs_default_accordion .accordion-item {
        border: none;
        margin-bottom: 1rem;
    }

    /* Button ------------------ */
    .bs_default_accordion .accordion-button {
        padding: 0;
        padding-inline: var(--bs_default__accordion_padding_inline);
        transition: .3s all ease;
        background-color: var(--bs_default__title_background_color_closed);
        align-items: stretch;
        border-radius: var(--bs_default__title_border_radius) !important;
        overflow: hidden;
        <?php echo $title_shadow_output; ?><?php echo $title_border; ?>
    }

    .bs_default_accordion .accordion-button:not(.collapsed) {
        background-color: var(--bs_default__title_background_color_open);
        <?php echo $title_border_radius_bottom; ?><?php echo $title_shadow_state; ?>
    }

    @media (max-width: 768px) {
        .bs_default_accordion .accordion-button {
            padding-inline: 0.5rem;
        }
    }

    /* Title ------------------ */
    .bs_default_accordion .accordion__title {
        padding: 1rem;
        color: var(--bs_default__title_color_closed);
        text-transform: var(--bs_default__title_text_transform);
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .bs_default_accordion .accordion-button:not(.collapsed) .accordion__title {
        color: var(--bs_default__title_color_open);
    }

    /* Content ------------------ */
    .bs_default_accordion .accordion-body {
        padding: 1rem;
        padding-inline: calc(var(--bs_default__accordion_padding_inline) + 1rem);
        border-radius: var(--bs_default__content_border_radius) !important;
        color: var(--bs_default__content_color);
        background: var(--bs_default__content_background_color);
        margin-top: var(--bs_default__content_margin_top);
        column-gap: var(--bs_default__accordion_column_gap);
        <?php echo $content_border_radius_top; ?>
    }

    @media (max-width: 768px) {
        .bs_default_accordion .accordion-body {
            column-count: 1 !important;
        }
    }

    @media (max-width: 768px) {
        .bs_default_accordion .accordion-body {
            padding-inline: 1.5rem;
        }
    }

    /* Index ------------------ */
    .bs_default_accordion .accordion__index {
        flex: 0 0 3rem;
        transition: .3s all ease;
        color: var(--bs_default__index_color_open);
        background-color: var(--bs_default__index_color_closed);
        display: flex;
        justify-content: center;
        align-items: center;
    }

    .bs_default_accordion .accordion-button:not(.collapsed) .accordion__index {
        color: var(--bs_default__index_color_closed);
        background-color: var(--bs_default__index_color_open);
    }

    /* Indicator ------------------ */
    .bs_default_accordion .accordion-button::after {
        display: none;
        /* Turns off bootstrap indicator */
    }

    .bs_default_accordion .accordion__indicator {
        flex: 0 0 3rem;
        padding: 1rem;
        margin-left: auto;
        display: flex;
        justify-content: center;
        align-items: center;
        transition: .3s all ease;
        background-color: var(--bs_default__indicator_background_color_closed);
    }

    .bs_default_accordion .accordion-button:not(.collapsed) .accordion__indicator {
        background-color: var(--bs_default__indicator_background_color_open);
        <?php echo $title_border_radius_bottom; ?>
    }

    .bs_default_accordion .accordion__indicator :is(img, svg) {
        width: 1rem;
        height: auto;
        transition: .3s all ease;
        transform: rotate(var(--bs_default__indicator_orientation_closed));
    }

    .bs_default_accordion .accordion-button:not(.collapsed) .accordion__indicator :is(img, svg) {
        transform: rotate(var(--bs_default__indicator_orientation_open));
    }

    .bs_default_accordion .accordion__indicator svg path {
        stroke: var(--bs_default__indicator_color_closed);
    }

    .bs_default_accordion .accordion-button:not(.collapsed) .accordion__indicator svg path {
        stroke: var(--bs_default__indicator_color_open);
    }
</style>

<?php if (have_rows('default_accordion_repeater')): ?>
    <div class="accordion accordion-flush bs_default_accordion" id="accordion__<?php echo $id; ?>">
        <?php while (have_rows('default_accordion_repeater')):
            the_row();
            $post_id = get_the_ID();

            $item_title = get_sub_field('default_accordion_repeater_item_title', $post_id);
            // Shorten the title to 20 characters and sanitize it for use in IDs
            $item_title_shortened = (strlen($item_title) > 20) ? substr($item_title, 0, 20) : $item_title;
            $item_title_sanitized = sanitize_title($item_title_shortened);

            $item_content = get_sub_field('default_accordion_repeater_item_content', $post_id);

            $column_count = get_sub_field('default_accordion_repeater_item_column_count', $post_id);

            // Accordion states
            if ($index == 1) {
                $collapsed = '';
                $show = 'show';
                $expanded = 'true';
            } else {
                $show = '';
                $collapsed = 'collapsed';
                $expanded = 'false';
            }

            if ($index < 10) {
                $index = '0' . $index;
            }
        ?>
            <div class="accordion-item">
                <h2 class="accordion-header" id="accordion_heading_<?php echo $index . '__' . $item_title_sanitized; ?>">
                    <button class="accordion-button <?php echo $collapsed; ?>" type="button" data-bs-toggle="collapse" data-bs-target="#accordion_body_<?php echo $index . '__' . $item_title_sanitized; ?>" aria-expanded="<?php echo $expanded; ?>" aria-controls="accordion_body_<?php echo $index . '__' . $item_title_sanitized; ?>">
                        <?php if ($show_index == true) {  ?>
                            <div class="accordion__index <?php echo $title_sizing; ?>">
                                <?php echo $index; ?>
                            </div>
                        <?php }  ?>
                        <div class="accordion__title <?php echo $title_sizing; ?>">
                            <?php echo $item_title; ?>
                        </div>
                        <div class="accordion__indicator">
                            <?php echo $indicator; ?>
                        </div>
                    </button>
                </h2>
                <div id="accordion_body_<?php echo $index . '__' . $item_title_sanitized; ?>" class="accordion-collapse collapse <?php echo $show; ?>" aria-labelledby="accordion_heading_<?php echo $index . '__' . $item_title_sanitized; ?>" data-bs-parent="#accordion__<?php echo $id; ?>">
                    <div class="accordion-body" style="column-count: <?php echo $column_count; ?>;">
                        <?php echo $item_content; ?>
                    </div>
                </div>
            </div>
            <?php $index++; ?>
        <?php endwhile; ?>
    </div>
<?php endif; ?>