<?php

require get_template_directory() . '/backend/devarea/blockcreate.php';
require get_template_directory() . '/backend/devarea/entitycreate.php';

function create_developer_menu()
{
    // Get the current user ID
    $current_user_id = get_current_user_id();

    // Check if the user has the 'developer' field set to true
    if (get_field('developer', 'user_' . $current_user_id)) {
        // Add the Developer parent menu
        add_menu_page(
            'Developer',           // Page title
            'Developer',           // Menu title
            'manage_options',      // Capability
            'developer-options',   // Menu slug
            'createdevov_function',                    // Callback function (none for parent menu)
            'dashicons-admin-generic', // Icon
            150                    // Position
        );

        // Add the Create Blockfiles submenu under the Developer menu
        add_submenu_page(
            'developer-options',      // Parent slug
            'Create Blockfiles',      // Page title
            'Create Blockfiles',      // Menu title
            'manage_options',         // Capability
            'create-blockfile-options', // Menu slug
            'createblockfile_function'  // Callback function
        );


        // Add the Create Entity submenu under the Developer menu
        add_submenu_page(
            'developer-options',      // Parent slug
            'Create Entity',          // Page title
            'Create Entity',          // Menu title
            'manage_options',         // Capability
            'create-entity-options',  // Menu slug
            'createentity_function'   // Callback function
        );
    }
}
add_action('admin_menu', 'create_developer_menu');


function createdevov_function()
{
    // need container, row and then to boxes with links to "create block" and "create post type"
    // include bootstrap

?>
    <style>
        .container {
            max-width: 1200px !important;
            margin: 0;
            padding-inline: 15px;
        }

        .row {
            margin-top: 30px;
            margin-inline: -15px;
            display: flex;

        }

        .col-6 {
            flex: 0 0 auto;
            width: 50%;
            display: flex;
            padding-inline: 15px;
        }

        .col-3 {
            flex: 0 0 auto;
            width: 25%;
            display: flex;
            padding-inline: 15px;
        }

        .boxShadowed {
            padding: 20px;
            width: 100%;
            border-radius: 10px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
            background-color: #FFF;
            aspect-ratio: 1;
            display: flex;
            justify-content: center;
            align-items: center;
            font-size: 30px;
            color: #000;
            text-decoration: none;
            transition: .12s ease-in;
        }

        .boxShadowed:hover {
            transform: scale(1.01);
            color: #000;
        }

        .notice-warning-wrapper {
            background-color: rgb(239 68 68);
            color: #FFF;
            padding: 10px;

            border-bottom-left-radius: 10px;
            border-bottom-right-radius: 10px;

            margin-bottom: 20px;
        }

        .notice-warning-wrapper h1 {
            font-size: 20px;
            color: #FFF;
        }
    </style>
    <div class="notice-warning-wrapper">
        <h1><?php _e('This page is for developers only. Do not use this page if you are not a developer!', 'textdomain'); ?></h1>
    </div>
    <div class="container">
        <div class="row">
            <div class="col-3">
                <a class="boxShadowed" href="<?php echo admin_url('admin.php?page=create-blockfile-options'); ?>">Create Block</a>
            </div>
            <div class="col-3">
                <a class="boxShadowed" href="<?php echo admin_url('admin.php?page=create-entity-options'); ?>">Create Post Type</a>
            </div>
        </div>
    </div>
<?php
}
