<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package bsTheme
 */

get_header();
?>

<style>
    .darkmode__theme .error__light {
        display: none;
    }

    body:not(.darkmode__theme) .error__light {
        display: block;
    }

    .darkmode__theme .error__dark {
        display: block;
    }

    body:not(.darkmode__theme) .error__dark {
        display: none;
    }
</style>

<main id="primary" class="site-main">
    <section class="error-404 not-found">
        <div class='container-fluid'>
            <div class='container-xl py-5'>
                <div class='row py-5'>
                    <div class='col-12 fCenter'>
                        <img class="error__light" src="/wp-content/uploads/404-light.svg" alt="">
                        <img class="error__dark" src="/wp-content/uploads/404-dark.svg" alt="">
                    </div>
                    <div class='col-12 fCenter flex-column pt-4 text-center'>
                        <h1 class="h-xl mb-3">Die Seite existiert <br>anscheinend nicht.</h1>
                        <p class="h-lg mb-0 mw-md">Bitte versuche es erneut oder kontaktiere uns,
                            wenn du denkst, dass etwas nicht stimmt.</p>
                    </div>
                </div>
            </div>
        </div>
    </section><!-- .error-404 -->
</main><!-- #main -->

<?php
get_footer();
